/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: trbPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the trbPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=trb.class)
public class trbPointer extends StructurePointer {

	// NULL
	public static final trbPointer NULL = new trbPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected trbPointer(long address) {
		super(address);
	}

	public static trbPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static trbPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static trbPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new trbPointer(address);
	}

	public trbPointer add(long count) {
		return trbPointer.cast(address + (trb.SIZEOF * count));
	}

	public trbPointer add(Scalar count) {
		return add(count.longValue());
	}

	public trbPointer addOffset(long offset) {
		return trbPointer.cast(address + offset);
	}

	public trbPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public trbPointer sub(long count) {
		return trbPointer.cast(address - (trb.SIZEOF * count));
	}

	public trbPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public trbPointer subOffset(long offset) {
		return trbPointer.cast(address - offset);
	}

	public trbPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public trbPointer untag(long mask) {
		return trbPointer.cast(address & ~mask);
	}

	public trbPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return trb.SIZEOF;
	}

	// Implementation methods

	// volatile cpu_t cpunum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpunumOffset_", declaredType="volatile cpu_t")
	public I16 cpunum() throws CorruptDataException {
		return new I16(getShortAtOffset(trb._cpunumOffset_));
	}

	// volatile cpu_t cpunum
	public I16Pointer cpunumEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(trb._cpunumOffset_));
	}

	// tid_t eventlist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eventlistOffset_", declaredType="tid_t")
	public IDATA eventlist() throws CorruptDataException {
		return new I64(getLongAtOffset(trb._eventlistOffset_));
	}

	// tid_t eventlist
	public IDATAPointer eventlistEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(trb._eventlistOffset_));
	}

	// U16 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U16")
	public U16 flags() throws CorruptDataException {
		return new U16(getShortAtOffset(trb._flagsOffset_));
	}

	// U16 flags
	public U16Pointer flagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(trb._flagsOffset_));
	}

	// void* func
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_funcOffset_", declaredType="void*")
	public VoidPointer func() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(trb._funcOffset_));
	}

	// void* func
	public PointerPointer funcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(trb._funcOffset_));
	}

	// ulong id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idOffset_", declaredType="ulong")
	public UDATA id() throws CorruptDataException {
		return new U64(getLongAtOffset(trb._idOffset_));
	}

	// ulong id
	public UDATAPointer idEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(trb._idOffset_));
	}

	// I32 ipri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ipriOffset_", declaredType="I32")
	public IDATA ipri() throws CorruptDataException {
		return new I32(getIntAtOffset(trb._ipriOffset_));
	}

	// I32 ipri
	public IDATAPointer ipriEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(trb._ipriOffset_));
	}

	// trb* knext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_knextOffset_", declaredType="trb*")
	public trbPointer knext() throws CorruptDataException {
		return trbPointer.cast(getPointerAtOffset(trb._knextOffset_));
	}

	// trb* knext
	public PointerPointer knextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(trb._knextOffset_));
	}

	// trb* kprev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_kprevOffset_", declaredType="trb*")
	public trbPointer kprev() throws CorruptDataException {
		return trbPointer.cast(getPointerAtOffset(trb._kprevOffset_));
	}

	// trb* kprev
	public PointerPointer kprevEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(trb._kprevOffset_));
	}

	// trb$parmunion t_union
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_unionOffset_", declaredType="trb$parmunion")
	public trb$parmunionPointer t_union() throws CorruptDataException {
		return trb$parmunionPointer.cast(nonNullFieldEA(trb._t_unionOffset_));
	}

	// trb$parmunion t_union
	public PointerPointer t_unionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(trb._t_unionOffset_));
	}

	// itimerstruc_t timeout
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timeoutOffset_", declaredType="itimerstruc_t")
	public itimerstruc_tPointer timeout() throws CorruptDataException {
		return itimerstruc_tPointer.cast(nonNullFieldEA(trb._timeoutOffset_));
	}

	// itimerstruc_t timeout
	public PointerPointer timeoutEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(trb._timeoutOffset_));
	}

	// ulong timerid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timeridOffset_", declaredType="ulong")
	public UDATA timerid() throws CorruptDataException {
		return new U64(getLongAtOffset(trb._timeridOffset_));
	}

	// ulong timerid
	public UDATAPointer timeridEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(trb._timeridOffset_));
	}

	// trb* to_next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_to_nextOffset_", declaredType="trb*")
	public trbPointer to_next() throws CorruptDataException {
		return trbPointer.cast(getPointerAtOffset(trb._to_nextOffset_));
	}

	// trb* to_next
	public PointerPointer to_nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(trb._to_nextOffset_));
	}

	// void* tof
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tofOffset_", declaredType="void*")
	public VoidPointer tof() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(trb._tofOffset_));
	}

	// void* tof
	public PointerPointer tofEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(trb._tofOffset_));
	}

}
