/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: lock_data_instrumented
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class lock_data_instrumented {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __lockname$_lock_id$_idOffset_;
	public static final int __lockname$_lock_id$occurrenceOffset_;
	public static final int __lockname$nameOffset_;
	public static final int _li_flagsOffset_;
	public static final int _lock_control_word$c_lockOffset_;
	public static final int _lock_control_word$drw_lockOffset_;
	public static final int _lock_control_word$lock_nextOffset_;
	public static final int _lock_control_word$s_lockOffset_;
	public static final int _reservedOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__lockname$_lock_id$_idOffset_ = 0;
		__lockname$_lock_id$occurrenceOffset_ = 0;
		__lockname$nameOffset_ = 0;
		_li_flagsOffset_ = 0;
		_lock_control_word$c_lockOffset_ = 0;
		_lock_control_word$drw_lockOffset_ = 0;
		_lock_control_word$lock_nextOffset_ = 0;
		_lock_control_word$s_lockOffset_ = 0;
		_reservedOffset_ = 0;
	}

}
