/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: mstsave32
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class mstsave32 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _asOffset_;
	public static final int _backtOffset_;
	public static final int _cachealignOffset_;
	public static final int _crOffset_;
	public static final int _ctrOffset_;
	public static final int _curidOffset_;
	public static final int _excbranchOffset_;
	public static final int _exceptOffset_;
	public static final int _excp_typeOffset_;
	public static final int _fpeuOffset_;
	public static final int _fpinfoOffset_;
	public static final int _fprOffset_;
	public static final int _fpscrOffset_;
	public static final int _fpscr24_31Offset_;
	public static final int _fpscrxOffset_;
	public static final int _gprOffset_;
	public static final int _iarOffset_;
	public static final int _intpriOffset_;
	public static final int _kjmpbufOffset_;
	public static final int _lrOffset_;
	public static final int _mqOffset_;
	public static final int _msrOffset_;
	public static final int _o_arg1Offset_;
	public static final int _o_iarOffset_;
	public static final int _o_tocOffset_;
	public static final int _o_vaddrOffset_;
	public static final int _padOffset_;
	public static final int _pad1Offset_;
	public static final int _prevOffset_;
	public static final int _rsvdOffset_;
	public static final int _stackfixOffset_;
	public static final int _tidOffset_;
	public static final int _xerOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_asOffset_ = 0;
		_backtOffset_ = 0;
		_cachealignOffset_ = 0;
		_crOffset_ = 0;
		_ctrOffset_ = 0;
		_curidOffset_ = 0;
		_excbranchOffset_ = 0;
		_exceptOffset_ = 0;
		_excp_typeOffset_ = 0;
		_fpeuOffset_ = 0;
		_fpinfoOffset_ = 0;
		_fprOffset_ = 0;
		_fpscrOffset_ = 0;
		_fpscr24_31Offset_ = 0;
		_fpscrxOffset_ = 0;
		_gprOffset_ = 0;
		_iarOffset_ = 0;
		_intpriOffset_ = 0;
		_kjmpbufOffset_ = 0;
		_lrOffset_ = 0;
		_mqOffset_ = 0;
		_msrOffset_ = 0;
		_o_arg1Offset_ = 0;
		_o_iarOffset_ = 0;
		_o_tocOffset_ = 0;
		_o_vaddrOffset_ = 0;
		_padOffset_ = 0;
		_pad1Offset_ = 0;
		_prevOffset_ = 0;
		_rsvdOffset_ = 0;
		_stackfixOffset_ = 0;
		_tidOffset_ = 0;
		_xerOffset_ = 0;
	}

}
