/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ClassLoaderStatisticsEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ClassLoaderStatisticsEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ClassLoaderStatisticsEntry.class)
public class ClassLoaderStatisticsEntryPointer extends StructurePointer {

	// NULL
	public static final ClassLoaderStatisticsEntryPointer NULL = new ClassLoaderStatisticsEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ClassLoaderStatisticsEntryPointer(long address) {
		super(address);
	}

	public static ClassLoaderStatisticsEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ClassLoaderStatisticsEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ClassLoaderStatisticsEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ClassLoaderStatisticsEntryPointer(address);
	}

	public ClassLoaderStatisticsEntryPointer add(long count) {
		return ClassLoaderStatisticsEntryPointer.cast(address + (ClassLoaderStatisticsEntry.SIZEOF * count));
	}

	public ClassLoaderStatisticsEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ClassLoaderStatisticsEntryPointer addOffset(long offset) {
		return ClassLoaderStatisticsEntryPointer.cast(address + offset);
	}

	public ClassLoaderStatisticsEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ClassLoaderStatisticsEntryPointer sub(long count) {
		return ClassLoaderStatisticsEntryPointer.cast(address - (ClassLoaderStatisticsEntry.SIZEOF * count));
	}

	public ClassLoaderStatisticsEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ClassLoaderStatisticsEntryPointer subOffset(long offset) {
		return ClassLoaderStatisticsEntryPointer.cast(address - offset);
	}

	public ClassLoaderStatisticsEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ClassLoaderStatisticsEntryPointer untag(long mask) {
		return ClassLoaderStatisticsEntryPointer.cast(address & ~mask);
	}

	public ClassLoaderStatisticsEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ClassLoaderStatisticsEntry.SIZEOF;
	}

	// Implementation methods

	// I64 blockSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_blockSizeOffset_", declaredType="I64")
	public IDATA blockSize() throws CorruptDataException {
		return new I64(getLongAtOffset(ClassLoaderStatisticsEntry._blockSizeOffset_));
	}

	// I64 blockSize
	public IDATAPointer blockSizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._blockSizeOffset_));
	}

	// U64 chunkSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_chunkSizeOffset_", declaredType="U64")
	public UDATA chunkSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ClassLoaderStatisticsEntry._chunkSizeOffset_));
	}

	// U64 chunkSize
	public UDATAPointer chunkSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._chunkSizeOffset_));
	}

	// I64 classCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classCountOffset_", declaredType="I64")
	public IDATA classCount() throws CorruptDataException {
		return new I64(getLongAtOffset(ClassLoaderStatisticsEntry._classCountOffset_));
	}

	// I64 classCount
	public IDATAPointer classCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._classCountOffset_));
	}

	// U64 classLoaderData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classLoaderDataOffset_", declaredType="U64")
	public UDATA classLoaderData() throws CorruptDataException {
		return new U64(getLongAtOffset(ClassLoaderStatisticsEntry._classLoaderDataOffset_));
	}

	// U64 classLoaderData
	public UDATAPointer classLoaderDataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._classLoaderDataOffset_));
	}

	// U32 classLoaderIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classLoaderIndexOffset_", declaredType="U32")
	public UDATA classLoaderIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ClassLoaderStatisticsEntry._classLoaderIndexOffset_));
	}

	// U32 classLoaderIndex
	public UDATAPointer classLoaderIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._classLoaderIndexOffset_));
	}

	// U64 hiddenBlockSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hiddenBlockSizeOffset_", declaredType="U64")
	public UDATA hiddenBlockSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ClassLoaderStatisticsEntry._hiddenBlockSizeOffset_));
	}

	// U64 hiddenBlockSize
	public UDATAPointer hiddenBlockSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._hiddenBlockSizeOffset_));
	}

	// U64 hiddenChunkSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hiddenChunkSizeOffset_", declaredType="U64")
	public UDATA hiddenChunkSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ClassLoaderStatisticsEntry._hiddenChunkSizeOffset_));
	}

	// U64 hiddenChunkSize
	public UDATAPointer hiddenChunkSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._hiddenChunkSizeOffset_));
	}

	// I64 hiddenClassCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hiddenClassCountOffset_", declaredType="I64")
	public IDATA hiddenClassCount() throws CorruptDataException {
		return new I64(getLongAtOffset(ClassLoaderStatisticsEntry._hiddenClassCountOffset_));
	}

	// I64 hiddenClassCount
	public IDATAPointer hiddenClassCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._hiddenClassCountOffset_));
	}

	// U32 parentClassLoaderIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_parentClassLoaderIndexOffset_", declaredType="U32")
	public UDATA parentClassLoaderIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ClassLoaderStatisticsEntry._parentClassLoaderIndexOffset_));
	}

	// U32 parentClassLoaderIndex
	public UDATAPointer parentClassLoaderIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._parentClassLoaderIndexOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(ClassLoaderStatisticsEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ClassLoaderStatisticsEntry._ticksOffset_));
	}

}
