/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GC_SurvivorMemoryIteratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GC_SurvivorMemoryIteratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GC_SurvivorMemoryIterator.class)
public class GC_SurvivorMemoryIteratorPointer extends StructurePointer {

	// NULL
	public static final GC_SurvivorMemoryIteratorPointer NULL = new GC_SurvivorMemoryIteratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GC_SurvivorMemoryIteratorPointer(long address) {
		super(address);
	}

	public static GC_SurvivorMemoryIteratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GC_SurvivorMemoryIteratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GC_SurvivorMemoryIteratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new GC_SurvivorMemoryIteratorPointer(address);
	}

	public GC_SurvivorMemoryIteratorPointer add(long count) {
		return GC_SurvivorMemoryIteratorPointer.cast(address + (GC_SurvivorMemoryIterator.SIZEOF * count));
	}

	public GC_SurvivorMemoryIteratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GC_SurvivorMemoryIteratorPointer addOffset(long offset) {
		return GC_SurvivorMemoryIteratorPointer.cast(address + offset);
	}

	public GC_SurvivorMemoryIteratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GC_SurvivorMemoryIteratorPointer sub(long count) {
		return GC_SurvivorMemoryIteratorPointer.cast(address - (GC_SurvivorMemoryIterator.SIZEOF * count));
	}

	public GC_SurvivorMemoryIteratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GC_SurvivorMemoryIteratorPointer subOffset(long offset) {
		return GC_SurvivorMemoryIteratorPointer.cast(address - offset);
	}

	public GC_SurvivorMemoryIteratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GC_SurvivorMemoryIteratorPointer untag(long mask) {
		return GC_SurvivorMemoryIteratorPointer.cast(address & ~mask);
	}

	public GC_SurvivorMemoryIteratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GC_SurvivorMemoryIterator.SIZEOF;
	}

	// Implementation methods

	// U64* _compressedSurvivorTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__compressedSurvivorTableOffset_", declaredType="U64*")
	public UDATAPointer _compressedSurvivorTable() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(GC_SurvivorMemoryIterator.__compressedSurvivorTableOffset_));
	}

	// U64* _compressedSurvivorTable
	public PointerPointer _compressedSurvivorTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__compressedSurvivorTableOffset_));
	}

	// void* _currentHigh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentHighOffset_", declaredType="void*")
	public VoidPointer _currentHigh() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(GC_SurvivorMemoryIterator.__currentHighOffset_));
	}

	// void* _currentHigh
	public PointerPointer _currentHighEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__currentHighOffset_));
	}

	// void* _currentLow
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentLowOffset_", declaredType="void*")
	public VoidPointer _currentLow() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(GC_SurvivorMemoryIterator.__currentLowOffset_));
	}

	// void* _currentLow
	public PointerPointer _currentLowEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__currentLowOffset_));
	}

	// U64 _heapBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapBaseOffset_", declaredType="U64")
	public UDATA _heapBase() throws CorruptDataException {
		return new U64(getLongAtOffset(GC_SurvivorMemoryIterator.__heapBaseOffset_));
	}

	// U64 _heapBase
	public UDATAPointer _heapBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__heapBaseOffset_));
	}

	// U64 _index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__indexOffset_", declaredType="U64")
	public UDATA _index() throws CorruptDataException {
		return new U64(getLongAtOffset(GC_SurvivorMemoryIterator.__indexOffset_));
	}

	// U64 _index
	public UDATAPointer _indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__indexOffset_));
	}

	// U64 _indexRegionBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__indexRegionBaseOffset_", declaredType="U64")
	public UDATA _indexRegionBase() throws CorruptDataException {
		return new U64(getLongAtOffset(GC_SurvivorMemoryIterator.__indexRegionBaseOffset_));
	}

	// U64 _indexRegionBase
	public UDATAPointer _indexRegionBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__indexRegionBaseOffset_));
	}

	// U64 _indexRegionTop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__indexRegionTopOffset_", declaredType="U64")
	public UDATA _indexRegionTop() throws CorruptDataException {
		return new U64(getLongAtOffset(GC_SurvivorMemoryIterator.__indexRegionTopOffset_));
	}

	// U64 _indexRegionTop
	public UDATAPointer _indexRegionTopEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__indexRegionTopOffset_));
	}

	// MM_HeapRegionDescriptorVLHGC* _region
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__regionOffset_", declaredType="MM_HeapRegionDescriptorVLHGC*")
	public MM_HeapRegionDescriptorVLHGCPointer _region() throws CorruptDataException {
		return MM_HeapRegionDescriptorVLHGCPointer.cast(getPointerAtOffset(GC_SurvivorMemoryIterator.__regionOffset_));
	}

	// MM_HeapRegionDescriptorVLHGC* _region
	public PointerPointer _regionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__regionOffset_));
	}

	// bool _survivor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__survivorOffset_", declaredType="bool")
	public boolean _survivor() throws CorruptDataException {
		return getBoolAtOffset(GC_SurvivorMemoryIterator.__survivorOffset_);
	}

	// bool _survivor
	public BoolPointer _survivorEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(GC_SurvivorMemoryIterator.__survivorOffset_));
	}

}
