/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ROMClassCreationContext
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ROMClassCreationContext {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocationStrategyOffset_;
	public static final int __bctFlagsOffset_;
	public static final int __bcuFlagsOffset_;
	public static final int __buildResultOffset_;
	public static final int __classFileBytesOffset_;
	public static final int __classFileBytesReplacedOffset_;
	public static final int __classFileSizeOffset_;
	public static final int __classLoaderOffset_;
	public static final int __classNameOffset_;
	public static final int __classNameLengthOffset_;
	public static final int __clazzOffset_;
	public static final int __cpIndexOffset_;
	public static final int __creatingIntermediateROMClassOffset_;
	public static final int __doDebugCompareOffset_;
	public static final int __dynamicLoadStatsOffset_;
	public static final int __existingRomMethodOffset_;
	public static final int __findClassFlagsOffset_;
	public static final int __forceDebugDataInLineOffset_;
	public static final int __hostPackageLengthOffset_;
	public static final int __hostPackageNameOffset_;
	public static final int __intermediateClassDataOffset_;
	public static final int __intermediateClassDataLengthOffset_;
	public static final int __interningEnabledOffset_;
	public static final int __javaVMOffset_;
	public static final int __loadLocationOffset_;
	public static final int __patchMapOffset_;
	public static final int __portLibraryOffset_;
	public static final int __retransformAllowedOffset_;
	public static final int __reusingIntermediateClassDataOffset_;
	public static final int __romClassOffset_;
	public static final int __sharedStringInternTableOffset_;
	public static final int __verboseCurrentPhaseOffset_;
	public static final int __verboseLastBufferSizeExceededOffset_;
	public static final int __verboseOutOfMemoryCountOffset_;
	public static final int __verboseROMClassOffset_;
	public static final int __verboseRecordsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocationStrategyOffset_ = 0;
		__bctFlagsOffset_ = 0;
		__bcuFlagsOffset_ = 0;
		__buildResultOffset_ = 0;
		__classFileBytesOffset_ = 0;
		__classFileBytesReplacedOffset_ = 0;
		__classFileSizeOffset_ = 0;
		__classLoaderOffset_ = 0;
		__classNameOffset_ = 0;
		__classNameLengthOffset_ = 0;
		__clazzOffset_ = 0;
		__cpIndexOffset_ = 0;
		__creatingIntermediateROMClassOffset_ = 0;
		__doDebugCompareOffset_ = 0;
		__dynamicLoadStatsOffset_ = 0;
		__existingRomMethodOffset_ = 0;
		__findClassFlagsOffset_ = 0;
		__forceDebugDataInLineOffset_ = 0;
		__hostPackageLengthOffset_ = 0;
		__hostPackageNameOffset_ = 0;
		__intermediateClassDataOffset_ = 0;
		__intermediateClassDataLengthOffset_ = 0;
		__interningEnabledOffset_ = 0;
		__javaVMOffset_ = 0;
		__loadLocationOffset_ = 0;
		__patchMapOffset_ = 0;
		__portLibraryOffset_ = 0;
		__retransformAllowedOffset_ = 0;
		__reusingIntermediateClassDataOffset_ = 0;
		__romClassOffset_ = 0;
		__sharedStringInternTableOffset_ = 0;
		__verboseCurrentPhaseOffset_ = 0;
		__verboseLastBufferSizeExceededOffset_ = 0;
		__verboseOutOfMemoryCountOffset_ = 0;
		__verboseROMClassOffset_ = 0;
		__verboseRecordsOffset_ = 0;
	}

}
