/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.AnimatingSurface;
import java2d.DemoImages;
import java2d.DemoInstVarsAccessor;
import java2d.GlobalControls;
import java2d.Surface;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Tools
extends JPanel
implements ActionListener,
ChangeListener,
Runnable {
    private final DemoInstVarsAccessor demoInstVars;
    private ImageIcon stopIcon;
    private ImageIcon startIcon;
    private Font font = new Font("Serif", 0, 10);
    private Color roColor = new Color(187, 213, 238);
    private Surface surface;
    private Thread thread;
    private JPanel toolbarPanel;
    private JPanel sliderPanel;
    private JLabel label;
    private ToggleIcon bumpyIcon;
    private ToggleIcon rolloverIcon;
    private DecimalFormat decimalFormat = new DecimalFormat("000");
    protected boolean focus;
    public JToggleButton toggleB;
    public JButton printB;
    public JComboBox<String> screenCombo;
    public JToggleButton renderB;
    public JToggleButton aliasB;
    public JToggleButton textureB;
    public JToggleButton compositeB;
    public JButton startStopB;
    public JButton cloneB;
    public boolean issueRepaint = true;
    public JToolBar toolbar;
    public JSlider slider;
    public boolean doSlider;
    public boolean isExpanded;

    public Tools(Surface surface, DemoInstVarsAccessor demoInstVars) {
        this.surface = surface;
        this.demoInstVars = demoInstVars;
        this.setLayout(new BorderLayout());
        this.stopIcon = new ImageIcon(DemoImages.getImage("stop.gif", this));
        this.startIcon = new ImageIcon(DemoImages.getImage("start.gif", this));
        this.bumpyIcon = new ToggleIcon(this, Color.LIGHT_GRAY);
        this.rolloverIcon = new ToggleIcon(this, this.roColor);
        this.toggleB = new JToggleButton(this.bumpyIcon);
        this.toggleB.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ Tools this$0;
            {
                Tools tools = this$0;
                Objects.requireNonNull(tools);
                this.this$0 = tools;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.this$0.focus = true;
                this.this$0.bumpyIcon.start();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.this$0.focus = false;
                this.this$0.bumpyIcon.stop();
            }
        });
        this.isExpanded = false;
        this.toggleB.addActionListener(this);
        this.toggleB.setMargin(new Insets(0, 0, -4, 0));
        this.toggleB.setBorderPainted(false);
        this.toggleB.setFocusPainted(false);
        this.toggleB.setContentAreaFilled(false);
        this.toggleB.setRolloverIcon(this.rolloverIcon);
        this.add("North", this.toggleB);
        this.toolbar = new JToolBar();
        this.toolbar.setPreferredSize(new Dimension(125, 26));
        this.toolbar.setFloatable(false);
        String s = surface.AntiAlias == RenderingHints.VALUE_ANTIALIAS_ON ? "On" : "Off";
        this.aliasB = this.addTool("A", "Antialiasing " + s, (ActionListener)this);
        s = surface.Rendering == RenderingHints.VALUE_RENDER_SPEED ? "Speed" : "Quality";
        this.renderB = this.addTool("R", "Rendering " + s, (ActionListener)this);
        s = surface.texture != null ? "On" : "Off";
        this.textureB = this.addTool("T", "Texture " + s, (ActionListener)this);
        s = surface.composite != null ? "On" : "Off";
        this.compositeB = this.addTool("C", "Composite " + s, (ActionListener)this);
        Image printBImg = DemoImages.getImage("print.gif", this);
        this.printB = this.addTool(printBImg, "Print the Surface", (ActionListener)this);
        if (surface instanceof AnimatingSurface) {
            Image stopImg = DemoImages.getImage("stop.gif", this);
            this.startStopB = this.addTool(stopImg, "Stop Animation", (ActionListener)this);
            this.toolbar.setPreferredSize(new Dimension(150, 26));
        }
        this.screenCombo = new JComboBox();
        this.screenCombo.setPreferredSize(new Dimension(100, 18));
        this.screenCombo.setFont(this.font);
        for (String name : GlobalControls.screenNames) {
            this.screenCombo.addItem(name);
        }
        this.screenCombo.addActionListener(this);
        this.toolbarPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.toolbarPanel.setLocation(0, 6);
        this.toolbarPanel.setVisible(false);
        this.toolbarPanel.add(this.toolbar);
        this.toolbarPanel.add(this.screenCombo);
        this.toolbarPanel.setBorder(new EtchedBorder());
        this.add(this.toolbarPanel);
        this.setPreferredSize(new Dimension(200, 8));
        if (surface instanceof AnimatingSurface) {
            this.sliderPanel = new JPanel(new BorderLayout());
            this.label = new JLabel(" Sleep = 030 ms");
            this.label.setForeground(Color.BLACK);
            this.sliderPanel.add((Component)this.label, "West");
            this.slider = new JSlider(0, 0, 200, 30);
            this.slider.addChangeListener(this);
            this.sliderPanel.setBorder(new EtchedBorder());
            this.sliderPanel.add(this.slider);
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ Tools this$0;
                {
                    Tools tools = this$0;
                    Objects.requireNonNull(tools);
                    this.this$0 = tools;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.this$0.toolbarPanel.isVisible()) {
                        this.this$0.invalidate();
                        this.this$0.doSlider = !this.this$0.doSlider;
                        if (this.this$0.doSlider) {
                            this.this$0.remove(this.this$0.toolbarPanel);
                            this.this$0.add(this.this$0.sliderPanel);
                        } else {
                            this.this$0.remove(this.this$0.sliderPanel);
                            this.this$0.add(this.this$0.toolbarPanel);
                        }
                        this.this$0.validate();
                        this.this$0.repaint();
                    }
                }
            });
        }
    }

    public JButton addTool(Image img, String toolTip, ActionListener al) {
        JButton b = new JButton(this, (Icon)new ImageIcon(img)){
            Dimension prefSize;
            final /* synthetic */ Tools this$0;
            {
                Tools tools = this$0;
                Objects.requireNonNull(tools);
                this.this$0 = tools;
                super(arg0);
                this.prefSize = new Dimension(25, 22);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.prefSize;
            }
        };
        this.toolbar.add(b);
        b.setFocusPainted(false);
        b.setSelected(true);
        b.setToolTipText(toolTip);
        b.addActionListener(al);
        return b;
    }

    public JToggleButton addTool(String name, String toolTip, ActionListener al) {
        JToggleButton b = new JToggleButton(this, name){
            Dimension prefSize;
            final /* synthetic */ Tools this$0;
            {
                Tools tools = this$0;
                Objects.requireNonNull(tools);
                this.this$0 = tools;
                super(arg0);
                this.prefSize = new Dimension(25, 22);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.prefSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.prefSize;
            }
        };
        this.toolbar.add(b);
        b.setFocusPainted(false);
        if (toolTip.equals("Rendering Quality") || toolTip.equals("Antialiasing On") || toolTip.equals("Texture On") || toolTip.equals("Composite On")) {
            b.setSelected(true);
        } else {
            b.setSelected(false);
        }
        b.setToolTipText(toolTip);
        b.addActionListener(al);
        return b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JButton) {
            JButton b;
            b.setSelected(!(b = (JButton)obj).isSelected());
            if (b.getIcon() == null) {
                b.setBackground(b.isSelected() ? Color.GREEN : Color.LIGHT_GRAY);
            }
        }
        if (obj.equals(this.toggleB)) {
            boolean bl = this.isExpanded = !this.isExpanded;
            if (this.isExpanded) {
                this.setPreferredSize(new Dimension(200, 38));
            } else {
                this.setPreferredSize(new Dimension(200, 6));
            }
            this.toolbarPanel.setVisible(this.isExpanded);
            if (this.sliderPanel != null) {
                this.sliderPanel.setVisible(this.isExpanded);
            }
            this.getParent().validate();
            this.toggleB.getModel().setRollover(false);
            return;
        }
        if (obj.equals(this.printB)) {
            this.start();
            return;
        }
        if (obj.equals(this.startStopB)) {
            if (this.startStopB.getToolTipText().equals("Stop Animation")) {
                this.startStopB.setIcon(this.startIcon);
                this.startStopB.setToolTipText("Start Animation");
                this.surface.animating.stop();
            } else {
                this.startStopB.setIcon(this.stopIcon);
                this.startStopB.setToolTipText("Stop Animation");
                this.surface.animating.start();
            }
        } else if (obj.equals(this.aliasB)) {
            if (this.aliasB.getToolTipText().equals("Antialiasing On")) {
                this.aliasB.setToolTipText("Antialiasing Off");
            } else {
                this.aliasB.setToolTipText("Antialiasing On");
            }
            this.surface.setAntiAlias(this.aliasB.isSelected());
        } else if (obj.equals(this.renderB)) {
            if (this.renderB.getToolTipText().equals("Rendering Quality")) {
                this.renderB.setToolTipText("Rendering Speed");
            } else {
                this.renderB.setToolTipText("Rendering Quality");
            }
            this.surface.setRendering(this.renderB.isSelected());
        } else if (obj.equals(this.textureB)) {
            if (this.textureB.getToolTipText().equals("Texture On")) {
                this.textureB.setToolTipText("Texture Off");
                this.surface.setTexture(null);
                this.surface.clearSurface = true;
            } else {
                this.textureB.setToolTipText("Texture On");
                this.surface.setTexture(this.demoInstVars.getControls().texturechooser.texture);
            }
        } else if (obj.equals(this.compositeB)) {
            if (this.compositeB.getToolTipText().equals("Composite On")) {
                this.compositeB.setToolTipText("Composite Off");
            } else {
                this.compositeB.setToolTipText("Composite On");
            }
            this.surface.setComposite(this.compositeB.isSelected());
        } else if (obj.equals(this.screenCombo)) {
            this.surface.setImageType(this.screenCombo.getSelectedIndex());
        }
        if (this.issueRepaint && this.surface.animating != null) {
            if (this.surface.getSleepAmount() != 0L && this.surface.animating.running()) {
                this.surface.animating.doRepaint();
            }
        } else if (this.issueRepaint) {
            this.surface.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = this.slider.getValue();
        this.label.setText(" Sleep = " + this.decimalFormat.format(value) + " ms");
        this.label.repaint();
        this.surface.setSleepAmount(value);
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.setName("Printing " + this.surface.name);
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread = null;
        this.notifyAll();
    }

    @Override
    public void run() {
        boolean stopped = false;
        if (this.surface.animating != null && this.surface.animating.running()) {
            stopped = true;
            this.startStopB.doClick();
        }
        try {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(this.surface);
            boolean pDialogState = true;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            if (!this.demoInstVars.getPrintCB().isSelected()) {
                pDialogState = printJob.printDialog(aset);
            }
            if (pDialogState) {
                printJob.print(aset);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Tools.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (stopped) {
            this.startStopB.doClick();
        }
        this.thread = null;
    }

    static class ToggleIcon
    implements Icon,
    Runnable {
        private Color shadowColor = new Color(102, 102, 153);
        private Color fillColor;
        private Tools tools;
        private Thread thread;

        public ToggleIcon(Tools tools, Color fillColor) {
            this.tools = tools;
            this.fillColor = fillColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g.setColor(this.fillColor);
            g.fillRect(0, 0, w, h);
            while (x < w - 2) {
                g.setColor(Color.WHITE);
                g.fillRect(x, 1, 1, 1);
                g.fillRect(x + 2, 3, 1, 1);
                g.setColor(this.shadowColor);
                g.fillRect(x + 1, 2, 1, 1);
                g.fillRect(x + 3, 4, 1, 1);
                x += 4;
            }
        }

        @Override
        public int getIconWidth() {
            return this.tools.getSize().width;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("ToggleIcon");
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.tools.focus && this.thread != null) {
                this.tools.toggleB.doClick();
            }
            this.thread = null;
        }
    }
}

