/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import jdk.test.lib.StringArrayUtils;
import jdk.test.lib.cds.CDSJarUtils;

public class CDSModulePackager {
    private Path srcRoot;
    private Path outputDir;
    private String extraModulePaths;

    public CDSModulePackager(String srcRoot, String outputDir) {
        String testSrc = System.getProperty("test.src");
        this.srcRoot = Paths.get(testSrc, srcRoot);
        this.outputDir = Paths.get(outputDir, new String[0]);
    }

    public CDSModulePackager(String srcRoot) {
        this(srcRoot, "test-modules");
    }

    public CDSModulePackager(Path srcRoot, Path outputDir) {
        this.srcRoot = srcRoot;
        this.outputDir = outputDir;
    }

    public CDSModulePackager(Path srcRoot) {
        this(srcRoot, Paths.get("test-modules", new String[0]));
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void addExtraModulePath(String ... extra) {
        for (String s : extra) {
            this.extraModulePaths = this.extraModulePaths == null ? s : this.extraModulePaths + File.pathSeparator + s;
        }
    }

    public void addExtraModulePath(Path ... extra) {
        for (Path p : extra) {
            this.extraModulePaths = this.extraModulePaths == null ? p.toString() : this.extraModulePaths + File.pathSeparator + p.toString();
        }
    }

    public Path createModularJar(String moduleName) throws Exception {
        return this.createModularJarWithMainClass(moduleName, null, (CDSJarUtils.JarOptions)null, new String[0]);
    }

    public Path createModularJar(String moduleName, String ... javacOptions) throws Exception {
        return this.createModularJarWithMainClass(moduleName, null, (CDSJarUtils.JarOptions)null, javacOptions);
    }

    public Path createModularJarWithMainClass(String moduleName, String mainClass, String ... javacOptions) throws Exception {
        return this.createModularJarWithMainClass(moduleName, mainClass, (CDSJarUtils.JarOptions)null, javacOptions);
    }

    public Path createModularJarWithMainClass(String moduleName, String mainClass, CDSJarUtils.JarOptions jarOptions, String ... javacOptions) throws Exception {
        Path src = this.srcRoot.resolve(moduleName);
        Object modulePath = this.outputDir.toString();
        if (this.extraModulePaths != null) {
            modulePath = (String)modulePath + File.pathSeparator + this.extraModulePaths;
        }
        javacOptions = javacOptions == null ? new String[]{"--module-path", modulePath} : StringArrayUtils.concat(javacOptions, new String[]{"--module-path", modulePath});
        if (mainClass != null) {
            if (jarOptions == null) {
                jarOptions = CDSJarUtils.JarOptions.of(new String[0]);
            }
            jarOptions.setMainClass(mainClass);
        }
        Path jarFile = this.outputDir.resolve(moduleName + ".jar");
        CDSJarUtils.buildFromSourceDirectory(jarFile.toString(), src.toString(), jarOptions, javacOptions);
        return jarFile;
    }
}

