/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CertUtils {
    public static final String RSA_CERT = "-----BEGIN CERTIFICATE-----\nMIIDCTCCAfGgAwIBAgIUe7ugVQCdaRYey+KtJdEy//pSGwUwDQYJKoZIhvcNAQEL\nBQAwFDESMBAGA1UEAwwJbG9jYWxob3N0MB4XDTE5MDgwMTExNTgyNVoXDTI5MDcy\nOTExNTgyNVowFDESMBAGA1UEAwwJbG9jYWxob3N0MIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAxDGfn+GQEErnE1ErBaYpH8+rFgUS/nhFuaKLMNsYMtAY\nGI7XvnwzSMeYou6tDobi0WMxlnQRSlVEmmT6OPOOC9RLnt2qdU2klXVR5DCzVTrp\nwX5TILkP+KzePRQFrpi4z6Fx15cIVhP4OdPUd4rwAffD+nYaijQezLuKwdBKBHlt\nGBGxn978Ppcmx/6qAfFZjhtxJXBM7LzUPkDs6jHy10FK9KkqjmmB6zXM0Rvv8nN3\n9o55H3LnbO4XSIoRUGwSISSiHEBHbOZyBblDc0yoRAnjqxSDIj5oxessfDt5gG6C\nLqrUyfLDo7pbmQrdBoH2NEX9yScYVE1MnlRA6LusCQIDAQABo1MwUTAdBgNVHQ4E\nFgQUbZzwnSvM67UCB3ng5fTGcL24uqUwHwYDVR0jBBgwFoAUbZzwnSvM67UCB3ng\n5fTGcL24uqUwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAQEAgAtI\nfeN7JySd5HdEqA0/vvCCoBJ/Z9//3OxQyW8NnkmVW3F1eMIWII/vOdYj1WJgq1uK\na4GKiUVgEYTVSJxwj3mBmvd9o93Im9BSI0RkGOQOTnCLJNTksAD+2qO4F984xucS\n/R2BChlbik7+7uPZ7qnhfDmxyMJqtUuze/JkA4IrVssbFM30j70gGjNNd/waBsR2\nupI29x7LSCdPkXmwUuzUR5/zBHaR4pZ2nQvsfxoP384BvpM1SCNrBUGvxGzDDiGA\npOJwIJoTEU7gGaHF8BeEUtC1YbSDWr+dN4IM7uzL6sdVs8xPVxkeptlVU7cDIyiN\nDPm3K0U4oj/KoFfMHg==\n-----END CERTIFICATE-----";
    public static final String RSA_KEY = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDEMZ+f4ZAQSucT\nUSsFpikfz6sWBRL+eEW5oosw2xgy0BgYjte+fDNIx5ii7q0OhuLRYzGWdBFKVUSa\nZPo4844L1Eue3ap1TaSVdVHkMLNVOunBflMguQ/4rN49FAWumLjPoXHXlwhWE/g5\n09R3ivAB98P6dhqKNB7Mu4rB0EoEeW0YEbGf3vw+lybH/qoB8VmOG3ElcEzsvNQ+\nQOzqMfLXQUr0qSqOaYHrNczRG+/yc3f2jnkfcuds7hdIihFQbBIhJKIcQEds5nIF\nuUNzTKhECeOrFIMiPmjF6yx8O3mAboIuqtTJ8sOjuluZCt0GgfY0Rf3JJxhUTUye\nVEDou6wJAgMBAAECggEAFwYn0HB9IpxXr9mnrdsJGnWZg1UHHJvqutVLdmlP1q67\nFS62POGAdzsNO5m872Z++cmlSR3H5axKB8Bv6P0UH2lDkpo65dc9yFhjSt84PHlU\nc2Oqx71QFYPb9NkDrbC4h41Pudg8nzVqvQaR+ZFxhxmXgy4XAT8KmkYsC4CxHwMY\nFYCHsNc8kpyXc7P5bbjpdQHMwpBP3dyo42h8cim8P2c5pKM0ipSm4vD9r8NIbvG7\n+bzLBC0aJCfL0wY2c8qRD2k5Xl/NRKovya8v6IUCyigyJV5DZMOfRqCMDeMuiaxl\ncvKqIPO5wxE3Wt36cEPZGO6GI6H+tzXZT0+y0+OfXQKBgQD5kR2GscpFhc+/A9Qn\nQQxeMHjDqXUjP11Czg+/K2vKjC+RHNIzOh+4jGWNb9nlMSu22IRltRzyDOrPRytB\nRT2o5rUGSv/oZ/lEMMyHz+xPaBfegYSCkZ3h01iL1fdAUALHtzG5c6S8JXhtWzHk\nq/dk6iXPfTtSREBkwv7c43vXTwKBgQDJQE0ZvgTSnscA+GkM1R7tH0hqKyk/xeus\n/xu23EraiIg4qoJ7Lk2IRvOkgotuK/SK+qoWlBr3OwBRzByxBXSdjdciZ5jbOc1g\nTA4Qwma6R9ukYdW+W95nYmsgyOi0+7tX9oVJatBJGyq3atayUANy8Lun4kSRdurn\nWibRxuxxJwKBgQCq62vhV9pECwTguWqPB8nEqEXNGz2SSk9A9YdrUf2c1q2tIKQF\nWYVoCx9x4mzEvwxFSbxDO+r7C0W1d/Rz20wDZR4NlUf2j170CMfLK+eX6p6OUP3D\nvp72jpxSCNQxQ5rj1N9FN6JXCQKVQqPFDNF+V65VkFsUWJIRcErEVTf3mQKBgAiW\nAbQTc0k5FOxprLGrdgJPz1sYNE5QN1nOGHSYuWjRYl5oh+CRfSVPQZ3HJAOzRF+Z\niiAkeXIKxly3BJJY1TzTjFYfbVoNAUIWfJMieBeCcVB2DBRu/vISNNfVOnheNQPv\ntIgJUpGL4yqoGDjLSRpiQt9Ku/ooxKTSJ83TWssJAoGAflsMfkS9hdoAcWMUWkPU\nVMTP/yHshZKJK66uAtLJYvSLXMJAN4uCIobiPM0EsdLxTh1nrL36NmWsTZlMhMsS\nrPaBIT6f6m2M2+8ixiJoZ1ut2iyKxkkvWcECbXqjWw6ndGyAoL1/7OR5guJliePy\naxFzqDc4QQBTtrjLYuHGi9k=";
    public static final String ECDSA_CERT = "-----BEGIN CERTIFICATE-----\nMIIBfjCCASOgAwIBAgIUPAlrMdd8AJOyeVT5wjzS3XZW8FAwCgYIKoZIzj0EAwIw\nFDESMBAGA1UEAwwJbG9jYWxob3N0MB4XDTE5MDgwMTExNTgzNFoXDTI5MDcyOTEx\nNTgzNFowFDESMBAGA1UEAwwJbG9jYWxob3N0MFkwEwYHKoZIzj0CAQYIKoZIzj0D\nAQcDQgAEs8ThmP8Xi9aBkB3WPfHRflpk6u44/9NIH4IiRSmbB7jmgCH3rP50izNR\nva4fKIZUJ0vPCS9zBr4rKVco9Z6qV6NTMFEwHQYDVR0OBBYEFFgf2AXMfO1OpBul\nArF1gqmVA04YMB8GA1UdIwQYMBaAFFgf2AXMfO1OpBulArF1gqmVA04YMA8GA1Ud\nEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwIDSQAwRgIhAKWR1yXjBedp6hOoxvZ8n9e8\nk2ZPdboTfyIRvCw9O4BUAiEAuHsWWs34c3xPCxsyoxbpgkBLwdZ1pZASbCMbgZ59\nRYo=\n-----END CERTIFICATE-----";
    public static final String ECDSA_KEY = "MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgajTO2cTGJdOUawrQ\nXqGfGuX6AEevTXQY0hlVHAVx516hRANCAASzxOGY/xeL1oGQHdY98dF+WmTq7jj/\n00gfgiJFKZsHuOaAIfes/nSLM1G9rh8ohlQnS88JL3MGvispVyj1nqpX";
    public static final String ECRSA_CERT = "-----BEGIN CERTIFICATE-----\nMIICLTCCARWgAwIBAgIUal67lzz4Cg3vCspyC21/teCvsoYwDQYJKoZIhvcNAQEL\nBQAwFDESMBAGA1UEAwwJbG9jYWxob3N0MB4XDTIwMDQxNDA4MTQwNFoXDTMwMDQx\nMjA4MTQwNFowFDESMBAGA1UEAwwJbG9jYWxob3N0MFkwEwYHKoZIzj0CAQYIKoZI\nzj0DAQcDQgAEZOIGqyJHpWFhyiRbZACdNBYHvXTzWVWMC10RW8vfxiOPAZBlPzqn\nd2X6/bGhSN1EkrMl8YlJTAKvZcGaaKFUHKNCMEAwHQYDVR0OBBYEFCl9FR9xeNjc\n5+Zkg/Rrk7JpTKnFMB8GA1UdIwQYMBaAFG2c8J0rzOu1Agd54OX0xnC9uLqlMA0G\nCSqGSIb3DQEBCwUAA4IBAQCPcwr88n/vjsHPByiF28P2cEZ02JdQH0FQVe+6Xw7t\nRn62aTAmS3kaHovXXrFpDpwgz+BMtGSNVTeR7zFttAZLyYb6w6rD8tCfZqHqOTC8\nctCHz7D2QnsH3tdSV1J7A8N3+P8t4cmCs1AED92yLhy9sumXBvZ2ZskpUtcA5nZB\ndjTvyJ3F74835w0s2FzWPnTULvBmit2Z94b22QyZLkFhThUpMBlu2LmXosLrdfji\nxVcV68tpQ1nk1o9tE4V7h4/SjYVaDM1fmlaY+eM3XcbK30mVyktty5ScuOMhLpb6\nRFP/QKvmQ/2l4+rj/epV84ImDuEAhkBGOU6vo4X4l1Du\n-----END CERTIFICATE-----";
    public static final String ECRSA_KEY = "MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgldlJrkmEDVtzh4r9\nNO8Yn/89mZuBhKPasVgpRjKQxRyhRANCAARk4garIkelYWHKJFtkAJ00Fge9dPNZ\nVYwLXRFby9/GI48BkGU/Oqd3Zfr9saFI3USSsyXxiUlMAq9lwZpooVQc";
    public static final String RSASSAPSS_CERT = "-----BEGIN CERTIFICATE-----\nMIIDaTCCAiCgAwIBAgIUdgfayw+KiSZyy9sg7N+yUlABalYwPgYJKoZIhvcNAQEK\nMDGgDTALBglghkgBZQMEAgGhGjAYBgkqhkiG9w0BAQgwCwYJYIZIAWUDBAIBogQC\nAgDeMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDAeFw0xOTA4MDExMTU4NDBaFw0yOTA3\nMjkxMTU4NDBaMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDCCASAwCwYJKoZIhvcNAQEK\nA4IBDwAwggEKAoIBAQC5igqwiTdawCKIDmGVXAnYSIj5QIiMW4VzeWj87+bWqMec\n9uiOkFBI9c1y3CMoAPu9SEBbycAMadExB0pRq93Kz7pO30nyOFwDhvnArqg0e+mn\n6yaJeYWkQFX0HNS/vBwlVPLSkyuE80Tt1bND7ur4z31hT6H16nDBfx14b9aXW9j0\nL2zqZbyq4jhbELeBK0DtD1tpmJsYHxXjL174fDQ0dArNjIq529veS9z+FjdpuZTm\ne3XxOyWofA0EV4t3wN7x5RvI0pTo7Na+15TjTlhwHTuaiUPsOvMg73sI+3OxXGHI\nGDoOgqliYqHH0SkTYWpZF9Be3Th/R90Qg7Pvzo4HAgMBAAGjUzBRMB0GA1UdDgQW\nBBRQAfLTSK6mt9aKxrWbHUKsKwrBfDAfBgNVHSMEGDAWgBRQAfLTSK6mt9aKxrWb\nHUKsKwrBfDAPBgNVHRMBAf8EBTADAQH/MD4GCSqGSIb3DQEBCjAxoA0wCwYJYIZI\nAWUDBAIBoRowGAYJKoZIhvcNAQEIMAsGCWCGSAFlAwQCAaIEAgIA3gOCAQEAQPJz\nTGugNS+wmxe6BGHmWLLsRJAQn/lr+3dJIfkfBlmkc43tSdL5R+5LfkNjE7sCUW4s\nFFKVlQH8XzHbJH0USNp+yxJBjBv5XpXW+mrhGhCBiIoEXce78irNJLy6dJPIFo/m\nz4Lt2YS5VassInrBvb9KyNlinpqJ5sjptLM2Nc77Rv/uFOkgTNwyuAi+LYuP1lEm\n4AZcywjfxBv/mmuZ8oAgPj50cN0gsgQmi/bofiZsK4GrZpSncjMYZvG/C4WF2Zem\ncd7KZtQoPrv3bSE3gyotN04wE2nFLsaR2gheuv0URitDPAzpv8QV3WjEUt6uaFZi\nK6deQ/N/JiwhoqjM+Q==\n-----END CERTIFICATE-----";
    public static final String RSASSAPSS_KEY = "MIIEuwIBADALBgkqhkiG9w0BAQoEggSnMIIEowIBAAKCAQEAuYoKsIk3WsAiiA5h\nlVwJ2EiI+UCIjFuFc3lo/O/m1qjHnPbojpBQSPXNctwjKAD7vUhAW8nADGnRMQdK\nUavdys+6Tt9J8jhcA4b5wK6oNHvpp+smiXmFpEBV9BzUv7wcJVTy0pMrhPNE7dWz\nQ+7q+M99YU+h9epwwX8deG/Wl1vY9C9s6mW8quI4WxC3gStA7Q9baZibGB8V4y9e\n+Hw0NHQKzYyKudvb3kvc/hY3abmU5nt18TslqHwNBFeLd8De8eUbyNKU6OzWvteU\n405YcB07molD7DrzIO97CPtzsVxhyBg6DoKpYmKhx9EpE2FqWRfQXt04f0fdEIOz\n786OBwIDAQABAoIBAH4eO03st9fUKqTZQbPJMFf4VkM3fpoJzBjGOntUh1D6wVUM\n8N+XcTtm+hRNVwhmQrhTWIwMA6NsemodToNdlBG8SiQ624Tukn1DTpmPH38ti5I8\n4aEpHZKcuNCKmIMMVwV5TOWebEKfKgeQ754J1Wbzg4KWIr2KcsLUqS+otfGDsOMK\nnuIhFQhamtNFzuWSRIYJl5jfNcnXmeTivVNywE0Q/PGD3lLn8xB3Bk6uNTAUFBdc\nnbK7efViSfuNY+kZbHne+mcSGiBJPSzTfd25+/JhYaKFjPiQsIqPAwnZK80LBdeb\nlxf3zSzpgbx9Jai+kULZJsrVoReZlS6fxeqzZAECgYEA4jRcR6tEQGImsIT7zBTS\nFYTsqr0wzuUl2m3mNNQX9ZIKEVJxv9Vevyd4eQIwQRwgPM2U2JLsXPjVFc/fCAJO\nKuLY5sXog4b0c8cHjA8nbJbmjKHkXfgCnKFGoXvUV13LgFg9DX6hzkCKMJxDO9R+\npE9k6HXq58yyDvRBvFOCuYECgYEA0fpxa0gwCmyMKQeFnBPd53rnPOBoW2YKnIzR\n/X1q6YRFdeRgvcBXScPknU1nvoxAtRqHYDSI3d/sHMzZ+qb0BBoD7i2qjKsSH32u\njP5m5+psPebJ0UEH/bTUbETWEu9rt8sapag6Mp1QL6uYZW5OOULCpGYa9KcfX93A\nhwgeO4cCgYBy+mptg4CNuVYxI2dZtLuUdJxXrRLCF3fGL1Z0Q9pp2HGFnIJ1H9+p\nCkcSOyqL7d/1CApAi23ZVCH7lE2ppIJXCjd2FeK5+D8JGoGbj5haedl2YlPR795j\n/xYHvwmP3v0xn6ho05UrYWLckpEaOEim/DQudMGSUVmwgDdpookwAQKBgQCv6RhL\nwFY+5WEmnl6YuywUWSqQHZBPwdTyAieKLh/7MgzfD0zcqt51td84yTg4slcjYe43\n8ssW1hmApz2Wd3fGV+UjDK7s2gR8zVYGWLrtX77+vPImlEyVh4DOk3yksF+Vwlm4\nno7jCFe9GAy8LQTrg7p87+11OO1X6vb4KRzq0QKBgCZD8lN/qHpscBQucx60vToU\n247vlb9LmzsMFVUeyJhg/v1+1kswIImuYC+X0nO8yF++mD8OyWIZaXZAkmEsU9qF\nZCdo4KHSmFTKm6mCPW+5tro3GCsavRZqFHeQF8iVRsN3V86q6wRlMvyYmKMLd0Ko\n0CyaEnQ+kBtL6IaeVNQV";
    public static final String DSA_CERT = "-----BEGIN CERTIFICATE-----\nMIIEbzCCBBSgAwIBAgIUSTOKqM3ZFPgJoQwvZ6MnpvzfJfgwCwYJYIZIAWUDBAMC\nMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDAeFw0xOTA4MDExMjAxMzBaFw0zOTA3Mjcx\nMjAxMzBaMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDCCA0cwggI5BgcqhkjOOAQBMIIC\nLAKCAQEAsFMaoryk333Vm0JY8QEu1y0HmQkvp5dlM/4ozMj8l6hx8HYo+LYTQD4e\nt7b7xUf5sYc4mjxpwbV4uf8Q4G1BHfJCGdGKxKigObsbDqpRRBlubHppOX6F6mRz\nwgaNRfWqlZbcSa+X82SfagtjMVKrH75eIs74U7EBQRun7XilrDFKuG6c98cY1JFI\nBpAp/Sw+kEk0LYYgdGIVWhNCunECcqWtdz1AEBzHOiqEthKTzF+o1qxBFCYjOnZo\nwkgG5fqXDc4Rb0iNyxSQXK/lTi/4r6IABY3u7f5NOhj0GmRbbCA/Ef0i6GQKJqzk\nhfzTQDwRsvX17xLFTOeNQb26dvm23wIhAL6RNExpfF++/0Ph4mkPqxuDLHWACa/y\n3VeNr8NjO7ovAoIBABndio/73FVBpnpbFdT1DnqY3IWUbpr40zudROuGWvSd66Ia\npNtRb/fcgMm3UjAq92SjbF+Rn+gf1ylm1LCtE4xeN02gxCJnR9/HKmuSTDnVOH5F\n62yjQaEPZ7rG2cr7fP67YiW1b3nTQSL11y62MVvp+JH1BMVd4gYMop7wG8eRajFr\nhW3AY6dz5J2w6fywvZTIXzv1cZS7be1adcdYSvkFs9V6bT+lQHKNpqM8aab61Kp9\naB3+p39nKYm6KPpc/wuSHs5Ez5C89mLrHB4l6xZAMAWqwkDnUmiRScwfyOIKG8VY\n2c9GtfZOCB21dupwXGruFH1tcg5IP7wHJddOWCADggEGAAKCAQEAkrNcrwgXKVWc\ngwv4CAJhRAH0svQChcLI1I5+6FB8KomN4xVW+obJcNag3qbTCd3V3mHu6gITxxkq\nEoA2zCBQFMAIGW2G1PkqOlBK8K3hOut/IEbWmiMlC51P0AUHBd1NDCY6q96Y+mot\nogGc3lMQZK5mWseUirP6Qt43N7Ev57PXypKC5MnQKA2+NEhhiHvDruSBloj9zu+w\noNhXZP+0dPBb96eeHwcRj25MSuhY+Jpg2OoU+FzDvx7QDEqkq801EBdr9WOiY9hx\nDpbUZH3mLYo9tzBwDK8RngPlcwlMpuR/A3pu6qLAGJHnVWb1c9mhNHv+8p5to74k\n2RqOaSU26aNTMFEwHQYDVR0OBBYEFJ8MbprhtUOkVraW76QALKQnZ6yNMB8GA1Ud\nIwQYMBaAFJ8MbprhtUOkVraW76QALKQnZ6yNMA8GA1UdEwEB/wQFMAMBAf8wCwYJ\nYIZIAWUDBAMCA0gAMEUCIHaOTmgo0rK4EWGLruxLiTcHZs1KanLrf9FlKbmur9Ee\nAiEAnE+fxuTBexuPj2elmnxViUj/UYo/NlC4OarhIO1SCzk=\n-----END CERTIFICATE-----";
    public static final String DSA_KEY = "MIICZQIBADCCAjkGByqGSM44BAEwggIsAoIBAQCwUxqivKTffdWbQljxAS7XLQeZ\nCS+nl2Uz/ijMyPyXqHHwdij4thNAPh63tvvFR/mxhziaPGnBtXi5/xDgbUEd8kIZ\n0YrEqKA5uxsOqlFEGW5semk5foXqZHPCBo1F9aqVltxJr5fzZJ9qC2MxUqsfvl4i\nzvhTsQFBG6fteKWsMUq4bpz3xxjUkUgGkCn9LD6QSTQthiB0YhVaE0K6cQJypa13\nPUAQHMc6KoS2EpPMX6jWrEEUJiM6dmjCSAbl+pcNzhFvSI3LFJBcr+VOL/ivogAF\nje7t/k06GPQaZFtsID8R/SLoZAomrOSF/NNAPBGy9fXvEsVM541Bvbp2+bbfAiEA\nvpE0TGl8X77/Q+HiaQ+rG4MsdYAJr/LdV42vw2M7ui8CggEAGd2Kj/vcVUGmelsV\n1PUOepjchZRumvjTO51E64Za9J3rohqk21Fv99yAybdSMCr3ZKNsX5Gf6B/XKWbU\nsK0TjF43TaDEImdH38cqa5JMOdU4fkXrbKNBoQ9nusbZyvt8/rtiJbVvedNBIvXX\nLrYxW+n4kfUExV3iBgyinvAbx5FqMWuFbcBjp3PknbDp/LC9lMhfO/VxlLtt7Vp1\nx1hK+QWz1XptP6VAco2mozxppvrUqn1oHf6nf2cpiboo+lz/C5IezkTPkLz2Yusc\nHiXrFkAwBarCQOdSaJFJzB/I4gobxVjZz0a19k4IHbV26nBcau4UfW1yDkg/vAcl\n105YIAQjAiEAvP+ZQ7yzUk8rNgk65U/SF++Eyt+i+WR1UBvGxAEEKIQ=";
    public static final String ED25519_CERT = "-----BEGIN CERTIFICATE-----\nMIIBezCCAS2gAwIBAgIUWHWImuHg2oPa0Oc/AiNPdM5D4D8wBQYDK2VwMBQxEjAQ\nBgNVBAMMCWxvY2FsaG9zdDAeFw0yMDA1MjUwMTI4NDlaFw0zMDA1MjMwMTI4NDla\nMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDAqMAUGAytlcAMhADPu3xC31fcrVuWZ6sOC\n85Wap5RqQHiVQIJ1DbQhKgjso4GQMIGNMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O\nBBYEFPbedM1iNhjOapOtdXXnHezJnnSTMB8GA1UdIwQYMBaAFPbedM1iNhjOapOt\ndXXnHezJnnSTMA4GA1UdDwEB/wQEAwIBhjAqBgNVHSUBAf8EIDAeBggrBgEFBQcD\nAwYIKwYBBQUHAwgGCCsGAQUFBwMJMAUGAytlcANBAOzu4k2pIqplPBx5k+JVcOB7\nK325r21JCAWqME+fa2sdUR1FM8LpQkWD363YOfEFleUkl28Tk6Kccz3oc4yc5AI=\n-----END CERTIFICATE-----";
    public static final String ED25519_KEY = "MC4CAQAwBQYDK2VwBCIEICyAry1Yd7O4M5ttEERs86vMixQRR71oKi4vzSEBTXag";
    public static final String ED448_CERT = "-----BEGIN CERTIFICATE-----\nMIIBxjCCAUagAwIBAgIUduqfA9mv3WrUI3FU/p6vasLjK10wBQYDK2VxMBQxEjAQ\nBgNVBAMMCWxvY2FsaG9zdDAeFw0yMDA1MjUwMTMyNDJaFw0zMDA1MjMwMTMyNDJa\nMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDBDMAUGAytlcQM6AFVSJI1vSXDf9UMNBfNQ\nIUA4lfGSr+7klW//faIVrRphIvD1Mq0SkYQv5b3uyyrkht9FcbVMJjVPAKOBkDCB\njTAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQ61lrTCnJftliX4a3xBrWlU/XK\neDAfBgNVHSMEGDAWgBQ61lrTCnJftliX4a3xBrWlU/XKeDAOBgNVHQ8BAf8EBAMC\nAYYwKgYDVR0lAQH/BCAwHgYIKwYBBQUHAwMGCCsGAQUFBwMIBggrBgEFBQcDCTAF\nBgMrZXEDcwD95HY/4XWzrgFNsW2sFha7GWnAZMW9PXcUP243Kt6O1HUsJa/ynKQJ\nc0DDikNF+8wl/lwF7XX4toCh9WyN+wWCAi2Eau9ATDumDsme7r+VniT0UZto8WQ2\nI4B1bAfPIO7JR1zPfpDVu12muwfm+u4pCAA=\n-----END CERTIFICATE-----";
    public static final String ED448_KEY = "MEcCAQAwBQYDK2VxBDsEOQcoJHPOIS+azOeX2MIEF4TYdfVEaZf/x1OdYpkI0J3m\n//MKpGqR4+s6XL8EQNKKJhjNZlvs34XbQw==";
    private static final String TEST_SRC = System.getProperty("test.src", ".");

    private CertUtils() {
    }

    public static PrivateKey getKeyFromString(String keyAlgo, String keyStr) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(keyAlgo);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(keyStr));
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        return key;
    }

    public static PrivateKey getKeyFromFile(String keyAlgo, String keyPath) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return CertUtils.getKeyFromString(keyAlgo, CertUtils.readFile(keyPath, line -> !line.startsWith("-----")));
    }

    public static X509Certificate getCertFromStream(InputStream input) throws CertificateException, IOException {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certFactory.generateCertificate(input);
            return x509Certificate;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public static X509Certificate getCertFromString(String certStr) throws CertificateException, IOException {
        return CertUtils.getCertFromStream(new ByteArrayInputStream(certStr.getBytes()));
    }

    public static X509Certificate getCertFromFile(String certFilePath) throws CertificateException, IOException {
        return CertUtils.getCertFromStream(Files.newInputStream(Paths.get(TEST_SRC, certFilePath), new OpenOption[0]));
    }

    public static X509CRL getCRLFromFile(String crlFilePath) throws CertificateException, CRLException, IOException {
        File crlFile = new File(TEST_SRC, crlFilePath);
        try (FileInputStream fis = new FileInputStream(crlFile);){
            X509CRL x509CRL = (X509CRL)CertificateFactory.getInstance("X.509").generateCRL(fis);
            return x509CRL;
        }
    }

    public static X509CRL getCRLFromString(String crl) throws CertificateException, CRLException {
        byte[] crlBytes = crl.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(crlBytes);
        return (X509CRL)CertificateFactory.getInstance("X.509").generateCRL(bais);
    }

    public static CertPath buildPath(String[] fileNames) throws Exception {
        return CertUtils.buildPath("", fileNames);
    }

    public static CertPath buildPath(String relPath, String[] fileNames) throws Exception {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (int i = 0; i < fileNames.length; ++i) {
            list.add(0, CertUtils.getCertFromFile(relPath + fileNames[i]));
        }
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        return cf.generateCertPath(list);
    }

    public static CertStore createStore(String[] fileNames) throws Exception {
        return CertUtils.createStore("", fileNames);
    }

    public static CertStore createStore(String relPath, String[] fileNames) throws Exception {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        for (int i = 0; i < fileNames.length; ++i) {
            certs.add(CertUtils.getCertFromFile(relPath + fileNames[i]));
        }
        return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certs));
    }

    public static CertStore createCRLStore(String[] fileNames) throws Exception {
        return CertUtils.createCRLStore("", fileNames);
    }

    public static CertStore createCRLStore(String relPath, String[] fileNames) throws Exception {
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        for (int i = 0; i < fileNames.length; ++i) {
            crls.add(CertUtils.getCRLFromFile(relPath + fileNames[i]));
        }
        return CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls));
    }

    public static PKIXCertPathBuilderResult build(PKIXBuilderParameters params) throws Exception {
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)builder.build(params);
    }

    public static PKIXCertPathValidatorResult validate(CertPath path, PKIXParameters params) throws Exception {
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        return (PKIXCertPathValidatorResult)validator.validate(path, params);
    }

    private static String readFile(String relativeFilePath, Predicate<String> predicate) {
        String string;
        block9: {
            Path filePath = Paths.get(TEST_SRC, relativeFilePath);
            Stream<String> lines = Files.lines(filePath);
            try {
                Stream<String> interStream = null;
                if (predicate != null) {
                    interStream = lines.filter(predicate);
                }
                String string2 = string = interStream != null ? interStream.collect(Collectors.joining("\n")) : lines.collect(Collectors.joining("\n"));
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read file", e);
                }
            }
            lines.close();
        }
        return string;
    }

    public static class ForwardingX509Certificate
    extends X509Certificate {
        private static final long serialVersionUID = -8453912214640985478L;
        private final X509Certificate cert;

        public ForwardingX509Certificate(X509Certificate cert) {
            this.cert = cert;
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return this.cert.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return this.cert.getExtensionValue(oid);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return this.cert.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return this.cert.hasUnsupportedCriticalExtension();
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        }

        @Override
        public int getVersion() {
            return this.cert.getVersion();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.cert.getSerialNumber();
        }

        @Override
        public Principal getIssuerDN() {
            return this.cert.getIssuerDN();
        }

        @Override
        public Principal getSubjectDN() {
            return this.cert.getSubjectDN();
        }

        @Override
        public Date getNotBefore() {
            return this.cert.getNotBefore();
        }

        @Override
        public Date getNotAfter() {
            return this.cert.getNotAfter();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return this.cert.getTBSCertificate();
        }

        @Override
        public byte[] getSignature() {
            return this.cert.getSignature();
        }

        @Override
        public String getSigAlgName() {
            return this.cert.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return this.cert.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return this.cert.getSigAlgParams();
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return this.cert.getIssuerUniqueID();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return this.cert.getSubjectUniqueID();
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.cert.getKeyUsage();
        }

        @Override
        public int getBasicConstraints() {
            return this.cert.getBasicConstraints();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return this.cert.getEncoded();
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
            this.cert.verify(key);
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
            this.cert.verify(key, sigProvider);
        }

        @Override
        public PublicKey getPublicKey() {
            return this.cert.getPublicKey();
        }

        @Override
        public String toString() {
            return this.cert.toString();
        }
    }
}

