/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import jdk.test.lib.hprof.model.AbstractJavaHeapObjectVisitor;
import jdk.test.lib.hprof.model.HackJavaValue;
import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaField;
import jdk.test.lib.hprof.model.JavaHeapObject;
import jdk.test.lib.hprof.model.JavaObject;
import jdk.test.lib.hprof.model.JavaStatic;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.ReachableExcludes;
import jdk.test.lib.hprof.model.ReferenceChain;
import jdk.test.lib.hprof.model.Root;
import jdk.test.lib.hprof.model.StackTrace;
import jdk.test.lib.hprof.model.ThreadObject;
import jdk.test.lib.hprof.parser.ReadBuffer;
import jdk.test.lib.hprof.util.Misc;

public class Snapshot
implements AutoCloseable {
    public static final long SMALL_ID_MASK = 0xFFFFFFFFL;
    public static final JavaThing[] EMPTY_JAVATHING_ARRAY = new JavaThing[0];
    private static final JavaField[] EMPTY_FIELD_ARRAY = new JavaField[0];
    private static final JavaStatic[] EMPTY_STATIC_ARRAY = new JavaStatic[0];
    private Hashtable<Number, JavaHeapObject> heapObjects = new Hashtable();
    private Hashtable<Number, JavaClass> fakeClasses = new Hashtable();
    private Vector<Root> roots = new Vector();
    private Map<String, JavaClass> classes = new TreeMap<String, JavaClass>();
    private volatile Map<JavaHeapObject, Boolean> newObjects;
    private volatile Map<JavaHeapObject, StackTrace> siteTraces;
    private Map<JavaHeapObject, Root> rootsMap = new HashMap<JavaHeapObject, Root>();
    private SoftReference<Vector<?>> finalizablesCache;
    private ArrayList<ThreadObject> threads = new ArrayList();
    private JavaThing nullThing = new HackJavaValue("<null>", 0L);
    private JavaClass weakReferenceClass;
    private int referentFieldIndex;
    private JavaClass javaLangClass;
    private JavaClass javaLangString;
    private JavaClass javaLangClassLoader;
    private volatile JavaClass otherArrayType;
    private ReachableExcludes reachableExcludes;
    private ReadBuffer readBuf;
    private boolean hasNewSet;
    private boolean unresolvedObjectsOK;
    private boolean newStyleArrayClass;
    private int identifierSize = 4;
    private int minimumObjectSize;
    private static final int DOT_LIMIT = 5000;

    public Snapshot(ReadBuffer buf) {
        this.readBuf = buf;
    }

    public void setSiteTrace(JavaHeapObject obj, StackTrace trace) {
        if (trace != null && trace.getFrames().length != 0) {
            this.initSiteTraces();
            this.siteTraces.put(obj, trace);
        }
    }

    public StackTrace getSiteTrace(JavaHeapObject obj) {
        if (this.siteTraces != null) {
            return this.siteTraces.get(obj);
        }
        return null;
    }

    public void setNewStyleArrayClass(boolean value) {
        this.newStyleArrayClass = value;
    }

    public boolean isNewStyleArrayClass() {
        return this.newStyleArrayClass;
    }

    public void setIdentifierSize(int size) {
        this.identifierSize = size;
        this.minimumObjectSize = 2 * size;
    }

    public int getIdentifierSize() {
        return this.identifierSize;
    }

    public int getMinimumObjectSize() {
        return this.minimumObjectSize;
    }

    public void addHeapObject(long id, JavaHeapObject ho) {
        this.heapObjects.put(this.makeId(id), ho);
    }

    public void addRoot(Root r) {
        r.setIndex(this.roots.size());
        this.roots.addElement(r);
    }

    public void addClass(long id, JavaClass c) {
        this.addHeapObject(id, c);
        this.putInClassesMap(c);
    }

    public void addThreadObject(ThreadObject thread) {
        this.threads.add(thread);
    }

    JavaClass addFakeInstanceClass(long classID, int instSize) {
        int i;
        String name = "unknown-class<@" + Misc.toHex(classID) + ">";
        int numInts = instSize / 4;
        int numBytes = instSize % 4;
        JavaField[] fields = new JavaField[numInts + numBytes];
        for (i = 0; i < numInts; ++i) {
            fields[i] = new JavaField("unknown-field-" + i, "I");
        }
        for (i = 0; i < numBytes; ++i) {
            fields[i + numInts] = new JavaField("unknown-field-" + i + numInts, "B");
        }
        JavaClass c = new JavaClass(name, 0L, 0L, 0L, 0L, fields, EMPTY_STATIC_ARRAY, instSize);
        this.addFakeClass(this.makeId(classID), c);
        return c;
    }

    public boolean getHasNewSet() {
        return this.hasNewSet;
    }

    public void resolve(boolean calculateRefs) {
        System.out.println("Resolving " + this.heapObjects.size() + " objects...");
        this.javaLangClass = this.findClass("java.lang.Class");
        if (this.javaLangClass == null) {
            System.out.println("WARNING:  hprof file does not include java.lang.Class!");
            this.javaLangClass = new JavaClass("java.lang.Class", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
            this.addFakeClass(this.javaLangClass);
        }
        this.javaLangString = this.findClass("java.lang.String");
        if (this.javaLangString == null) {
            System.out.println("WARNING:  hprof file does not include java.lang.String!");
            this.javaLangString = new JavaClass("java.lang.String", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
            this.addFakeClass(this.javaLangString);
        }
        this.javaLangClassLoader = this.findClass("java.lang.ClassLoader");
        if (this.javaLangClassLoader == null) {
            System.out.println("WARNING:  hprof file does not include java.lang.ClassLoader!");
            this.javaLangClassLoader = new JavaClass("java.lang.ClassLoader", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
            this.addFakeClass(this.javaLangClassLoader);
        }
        for (JavaHeapObject t : this.heapObjects.values()) {
            if (!(t instanceof JavaClass)) continue;
            t.resolve(this);
        }
        for (JavaHeapObject t : this.heapObjects.values()) {
            if (t instanceof JavaClass) continue;
            t.resolve(this);
        }
        this.heapObjects.putAll(this.fakeClasses);
        this.fakeClasses.clear();
        this.weakReferenceClass = this.findClass("java.lang.ref.Reference");
        this.referentFieldIndex = 0;
        if (this.weakReferenceClass != null) {
            JavaField[] fields = this.weakReferenceClass.getFieldsForInstance();
            for (int i = 0; i < fields.length; ++i) {
                if (!"referent".equals(fields[i].getName())) continue;
                this.referentFieldIndex = i;
                break;
            }
        }
        if (calculateRefs) {
            this.calculateReferencesToObjects();
            System.out.print("Eliminating duplicate references");
            System.out.flush();
        }
        int count = 0;
        for (JavaHeapObject t : this.heapObjects.values()) {
            t.setupReferrers();
            if (!calculateRefs || ++count % 5000 != 0) continue;
            System.out.print(".");
            System.out.flush();
        }
        if (calculateRefs) {
            System.out.println("");
        }
        this.classes = Collections.unmodifiableMap(this.classes);
    }

    private void calculateReferencesToObjects() {
        System.out.print("Chasing references, expect " + this.heapObjects.size() / 5000 + " dots");
        System.out.flush();
        int count = 0;
        MyVisitor visitor = new MyVisitor();
        Iterator<Object> iterator = this.heapObjects.values().iterator();
        while (iterator.hasNext()) {
            JavaHeapObject t;
            visitor.t = t = iterator.next();
            t.visitReferencedObjects(visitor);
            if (++count % 5000 != 0) continue;
            System.out.print(".");
            System.out.flush();
        }
        System.out.println();
        for (Root r : this.roots) {
            r.resolve(this);
            JavaHeapObject t = this.findThing(r.getId());
            if (t == null) continue;
            t.addReferenceFromRoot(r);
        }
    }

    public void markNewRelativeTo(Snapshot baseline) {
        this.hasNewSet = true;
        for (JavaHeapObject t : this.heapObjects.values()) {
            JavaHeapObject other;
            long thingID = t.getId();
            boolean isNew = thingID == 0L || thingID == -1L ? false : ((other = baseline.findThing(t.getId())) == null ? true : !t.isSameTypeAs(other));
            t.setNew(isNew);
        }
    }

    public Enumeration<JavaHeapObject> getThings() {
        return this.heapObjects.elements();
    }

    public JavaHeapObject findThing(long id) {
        Number idObj = this.makeId(id);
        JavaHeapObject jho = this.heapObjects.get(idObj);
        return jho != null ? jho : (JavaHeapObject)this.fakeClasses.get(idObj);
    }

    public JavaHeapObject findThing(String id) {
        return this.findThing(Misc.parseHex(id));
    }

    public JavaClass findClass(String name) {
        if (name.startsWith("0x")) {
            return (JavaClass)this.findThing(name);
        }
        return this.classes.get(name);
    }

    public Iterator<JavaClass> getClasses() {
        return this.classes.values().iterator();
    }

    public JavaClass[] getClassesArray() {
        JavaClass[] res = new JavaClass[this.classes.size()];
        this.classes.values().toArray(res);
        return res;
    }

    public synchronized Enumeration<?> getFinalizerObjects() {
        Vector<?> obj;
        if (this.finalizablesCache != null && (obj = this.finalizablesCache.get()) != null) {
            return obj.elements();
        }
        JavaClass clazz = this.findClass("java.lang.ref.Finalizer");
        JavaObject queue = (JavaObject)clazz.getStaticField("queue");
        JavaThing tmp = queue.getField("head");
        Vector<JavaHeapObject> finalizables = new Vector<JavaHeapObject>();
        if (tmp != this.getNullThing()) {
            JavaObject head = (JavaObject)tmp;
            while (true) {
                JavaHeapObject referent = (JavaHeapObject)head.getField("referent");
                JavaThing next = head.getField("next");
                if (next == this.getNullThing() || next.equals(head)) break;
                head = (JavaObject)next;
                finalizables.add(referent);
            }
        }
        this.finalizablesCache = new SoftReference(finalizables);
        return finalizables.elements();
    }

    public Enumeration<Root> getRoots() {
        return this.roots.elements();
    }

    public Root[] getRootsArray() {
        Root[] res = new Root[this.roots.size()];
        this.roots.toArray(res);
        return res;
    }

    public Root getRootAt(int i) {
        return this.roots.elementAt(i);
    }

    public List<ThreadObject> getThreads() {
        return Collections.unmodifiableList(this.threads);
    }

    public ReferenceChain[] rootsetReferencesTo(JavaHeapObject target, boolean includeWeak) {
        Vector<ReferenceChain> fifo = new Vector<ReferenceChain>();
        Hashtable<JavaHeapObject, JavaHeapObject> visited = new Hashtable<JavaHeapObject, JavaHeapObject>();
        Vector<ReferenceChain> result = new Vector<ReferenceChain>();
        visited.put(target, target);
        fifo.addElement(new ReferenceChain(target, null));
        while (fifo.size() > 0) {
            ReferenceChain chain = (ReferenceChain)fifo.elementAt(0);
            fifo.removeElementAt(0);
            JavaHeapObject curr = chain.getObj();
            if (curr.getRoot() != null) {
                result.addElement(chain);
            }
            Enumeration<JavaThing> referrers = curr.getReferrers();
            while (referrers.hasMoreElements()) {
                JavaHeapObject t = (JavaHeapObject)referrers.nextElement();
                if (t == null || visited.containsKey(t) || !includeWeak && t.refersOnlyWeaklyTo(this, curr)) continue;
                visited.put(t, t);
                fifo.addElement(new ReferenceChain(t, chain));
            }
        }
        ReferenceChain[] realResult = new ReferenceChain[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            realResult[i] = (ReferenceChain)result.elementAt(i);
        }
        return realResult;
    }

    public boolean getUnresolvedObjectsOK() {
        return this.unresolvedObjectsOK;
    }

    public void setUnresolvedObjectsOK(boolean v) {
        this.unresolvedObjectsOK = v;
    }

    public JavaClass getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    public int getReferentFieldIndex() {
        return this.referentFieldIndex;
    }

    public JavaThing getNullThing() {
        return this.nullThing;
    }

    public void setReachableExcludes(ReachableExcludes e) {
        this.reachableExcludes = e;
    }

    public ReachableExcludes getReachableExcludes() {
        return this.reachableExcludes;
    }

    void addReferenceFromRoot(Root r, JavaHeapObject obj) {
        Root root = this.rootsMap.get(obj);
        if (root == null) {
            this.rootsMap.put(obj, r);
        } else {
            this.rootsMap.put(obj, root.mostInteresting(r));
        }
    }

    Root getRoot(JavaHeapObject obj) {
        return this.rootsMap.get(obj);
    }

    JavaClass getJavaLangClass() {
        return this.javaLangClass;
    }

    JavaClass getJavaLangString() {
        return this.javaLangString;
    }

    JavaClass getJavaLangClassLoader() {
        return this.javaLangClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaClass getOtherArrayType() {
        if (this.otherArrayType == null) {
            Snapshot snapshot = this;
            synchronized (snapshot) {
                if (this.otherArrayType == null) {
                    this.addFakeClass(new JavaClass("[<other>", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0));
                    this.otherArrayType = this.findClass("[<other>");
                }
            }
        }
        return this.otherArrayType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaClass getArrayClass(String elementSignature) {
        JavaClass clazz;
        Map<String, JavaClass> map = this.classes;
        synchronized (map) {
            clazz = this.findClass("[" + elementSignature);
            if (clazz == null) {
                clazz = new JavaClass("[" + elementSignature, 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
                this.addFakeClass(clazz);
            }
        }
        return clazz;
    }

    ReadBuffer getReadBuffer() {
        return this.readBuf;
    }

    void setNew(JavaHeapObject obj, boolean isNew) {
        this.initNewObjects();
        if (isNew) {
            this.newObjects.put(obj, Boolean.TRUE);
        }
    }

    boolean isNew(JavaHeapObject obj) {
        if (this.newObjects != null) {
            return this.newObjects.get(obj) != null;
        }
        return false;
    }

    private Number makeId(long id) {
        if (this.identifierSize == 4) {
            return (int)id;
        }
        return id;
    }

    private void putInClassesMap(JavaClass c) {
        Object name = c.getName();
        if (this.classes.containsKey(name)) {
            name = (String)name + "-" + c.getIdString();
        }
        this.classes.put(c.getName(), c);
    }

    private void addFakeClass(JavaClass c) {
        this.putInClassesMap(c);
        c.resolve(this);
    }

    private void addFakeClass(Number id, JavaClass c) {
        this.fakeClasses.put(id, c);
        this.addFakeClass(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initNewObjects() {
        if (this.newObjects == null) {
            Snapshot snapshot = this;
            synchronized (snapshot) {
                if (this.newObjects == null) {
                    this.newObjects = new HashMap<JavaHeapObject, Boolean>();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initSiteTraces() {
        if (this.siteTraces == null) {
            Snapshot snapshot = this;
            synchronized (snapshot) {
                if (this.siteTraces == null) {
                    this.siteTraces = new HashMap<JavaHeapObject, StackTrace>();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.readBuf.close();
    }

    private static class MyVisitor
    extends AbstractJavaHeapObjectVisitor {
        JavaHeapObject t;

        private MyVisitor() {
        }

        @Override
        public void visit(JavaHeapObject other) {
            other.addReferenceFrom(this.t);
        }
    }
}

