/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.MigratedValueClass;
import jdk.internal.ValueBased;
import jdk.internal.misc.CDS;
import jdk.internal.util.DecimalDigits;
import jdk.internal.value.DeserializeConstructor;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;

@MigratedValueClass
@ValueBased
public final class Long
extends Number
implements Comparable<Long>,
Constable,
ConstantDesc {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    private static final long serialVersionUID = 4290774380558885855L;

    public static String toString(long i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(i);
        }
        if (String.COMPACT_STRINGS) {
            boolean negative;
            byte[] buf = new byte[65];
            int charPos = 64;
            boolean bl = negative = i < 0L;
            if (!negative) {
                i = -i;
            }
            while (i <= (long)(-radix)) {
                buf[charPos--] = Integer.digits[(int)(-(i % (long)radix))];
                i /= (long)radix;
            }
            buf[charPos] = Integer.digits[(int)(-i)];
            if (negative) {
                buf[--charPos] = 45;
            }
            return StringLatin1.newString(buf, charPos, 65 - charPos);
        }
        return Long.toStringUTF16(i, radix);
    }

    private static String toStringUTF16(long i, int radix) {
        boolean negative;
        byte[] buf = new byte[130];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            StringUTF16.putChar(buf, charPos--, Integer.digits[(int)(-(i % (long)radix))]);
            i /= (long)radix;
        }
        StringUTF16.putChar(buf, charPos, Integer.digits[(int)(-i)]);
        if (negative) {
            StringUTF16.putChar(buf, --charPos, 45);
        }
        return StringUTF16.newString(buf, charPos, 65 - charPos);
    }

    public static String toUnsignedString(long i, int radix) {
        if (i >= 0L) {
            return Long.toString(i, radix);
        }
        return switch (radix) {
            case 2 -> Long.toBinaryString(i);
            case 4 -> Long.toUnsignedString0(i, 2);
            case 8 -> Long.toOctalString(i);
            case 10 -> {
                long quot = (i >>> 1) / 5L;
                long rem = i - quot * 10L;
                yield Long.toString(quot) + rem;
            }
            case 16 -> Long.toHexString(i);
            case 32 -> Long.toUnsignedString0(i, 5);
            default -> Long.toUnsignedBigInteger(i).toString(radix);
        };
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static String toHexString(long i) {
        return Long.toUnsignedString0(i, 4);
    }

    public static String toOctalString(long i) {
        return Long.toUnsignedString0(i, 3);
    }

    public static String toBinaryString(long i) {
        return Long.toUnsignedString0(i, 1);
    }

    static String toUnsignedString0(long val, int shift) {
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[chars];
            Long.formatUnsignedLong0(val, shift, buf, 0, chars);
            return new String(buf, 0);
        }
        byte[] buf = new byte[chars * 2];
        Long.formatUnsignedLong0UTF16(val, shift, buf, 0, chars);
        return new String(buf, 1);
    }

    private static void formatUnsignedLong0(long val, int shift, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = Integer.digits[(int)val & mask];
            val >>>= shift;
        } while (charPos > offset);
    }

    private static void formatUnsignedLong0UTF16(long val, int shift, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            StringUTF16.putChar(buf, --charPos, Integer.digits[(int)val & mask]);
            val >>>= shift;
        } while (charPos > offset);
    }

    public static String toString(long i) {
        int size = DecimalDigits.stringSize((long)i);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[size];
            DecimalDigits.uncheckedGetCharsLatin1((long)i, (int)size, (byte[])buf);
            return new String(buf, 0);
        }
        byte[] buf = new byte[size * 2];
        DecimalDigits.uncheckedGetCharsUTF16((long)i, (int)size, (byte[])buf);
        return new String(buf, 1);
    }

    public static String toUnsignedString(long i) {
        return Long.toUnsignedString(i, 10);
    }

    public static long parseLong(String s, int radix) throws NumberFormatException {
        char firstChar;
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        int len = s.length();
        if (len == 0) {
            throw NumberFormatException.forInputString("", radix);
        }
        int digit = -256;
        int i = 0;
        if ((firstChar = s.charAt(i++)) != '-' && firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && len > 1) {
            long limit = firstChar != '-' ? -9223372036854775807L : Long.MIN_VALUE;
            long multmin = limit / (long)radix;
            long result = -(digit & 0xFF);
            boolean inRange = true;
            while (i < len && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = result > multmin || result == multmin && digit <= (int)((long)radix * multmin - limit))) {
                result = (long)radix * result - (long)digit;
            }
            if (inRange && i == len && digit >= 0) {
                return firstChar != '-' ? -result : result;
            }
        }
        throw NumberFormatException.forInputString(s, radix);
    }

    public static long parseLong(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        char firstChar;
        Objects.requireNonNull(s);
        Objects.checkFromToIndex(beginIndex, endIndex, s.length());
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        if (beginIndex == endIndex) {
            throw NumberFormatException.forInputString("", radix);
        }
        int digit = -256;
        int i = beginIndex;
        if ((firstChar = s.charAt(i++)) != '-' && firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && endIndex - beginIndex > 1) {
            long limit = firstChar != '-' ? -9223372036854775807L : Long.MIN_VALUE;
            long multmin = limit / (long)radix;
            long result = -(digit & 0xFF);
            boolean inRange = true;
            while (i < endIndex && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = result > multmin || result == multmin && digit <= (int)((long)radix * multmin - limit))) {
                result = (long)radix * result - (long)digit;
            }
            if (inRange && i == endIndex && digit >= 0) {
                return firstChar != '-' ? -result : result;
            }
        }
        throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i - (digit < -1 ? 0 : 1));
    }

    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        char firstChar;
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        int len = s.length();
        if (len == 0) {
            throw NumberFormatException.forInputString(s, radix);
        }
        int i = 0;
        if ((firstChar = s.charAt(i++)) == '-') {
            throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
        }
        int digit = -256;
        if (firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && len > 1) {
            long multmax = Long.divideUnsigned(-1L, radix);
            long result = digit & 0xFF;
            boolean inRange = true;
            while (i < len && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = Long.compareUnsigned(result, multmax) < 0 || result == multmax && digit < (int)((long)(-radix) * multmax))) {
                result = (long)radix * result + (long)digit;
            }
            if (inRange && i == len && digit >= 0) {
                return result;
            }
        }
        if (digit < 0) {
            throw NumberFormatException.forInputString(s, radix);
        }
        throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }

    public static long parseUnsignedLong(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        char firstChar;
        Objects.requireNonNull(s);
        Objects.checkFromToIndex(beginIndex, endIndex, s.length());
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        if (beginIndex == endIndex) {
            throw NumberFormatException.forInputString("", radix);
        }
        int i = beginIndex;
        if ((firstChar = s.charAt(i++)) == '-') {
            throw new NumberFormatException("Illegal leading minus sign on unsigned string " + s + ".");
        }
        int digit = -256;
        if (firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && endIndex - beginIndex > 1) {
            long multmax = Long.divideUnsigned(-1L, radix);
            long result = digit & 0xFF;
            boolean inRange = true;
            while (i < endIndex && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = Long.compareUnsigned(result, multmax) < 0 || result == multmax && digit < (int)((long)(-radix) * multmax))) {
                result = (long)radix * result + (long)digit;
            }
            if (inRange && i == endIndex && digit >= 0) {
                return result;
            }
        }
        if (digit < 0) {
            throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i - (digit < -1 ? 0 : 1));
        }
        throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }

    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return Long.parseUnsignedLong(s, 10);
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    @IntrinsicCandidate
    @DeserializeConstructor
    public static Long valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Long decode(String nm) throws NumberFormatException {
        long result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.isEmpty()) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Long.parseLong(nm, index, nm.length(), radix);
            result = negative ? -result : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Long.parseLong(constant, radix);
        }
        return result;
    }

    @Deprecated(since="9")
    public Long(long value) {
        this.value = value;
    }

    @Deprecated(since="9")
    public Long(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    @IntrinsicCandidate
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Long) {
            Long ell = (Long)obj;
            return this.value == ell;
        }
        return false;
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        return result == null ? Long.valueOf(val) : result;
    }

    public static Long getLong(String nm, Long val) {
        String v;
        String string = v = nm != null && !nm.isEmpty() ? System.getProperty(nm) : null;
        if (v != null) {
            try {
                return Long.decode(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    @Override
    public int compareTo(Long anotherLong) {
        return Long.compare(this.value, anotherLong.value);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @IntrinsicCandidate
    public static int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    @IntrinsicCandidate
    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return q + ((r | r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
        }
        return (dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63;
    }

    @IntrinsicCandidate
    public static long remainderUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return r - ((r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >> 63 & divisor);
        }
        return dividend - ((dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >> 63 & divisor);
    }

    public static long highestOneBit(long i) {
        return i & Long.MIN_VALUE >>> Long.numberOfLeadingZeros(i);
    }

    public static long lowestOneBit(long i) {
        return i & -i;
    }

    @IntrinsicCandidate
    public static int numberOfLeadingZeros(long i) {
        int x = (int)(i >>> 32);
        return x == 0 ? 32 + Integer.numberOfLeadingZeros((int)i) : Integer.numberOfLeadingZeros(x);
    }

    @IntrinsicCandidate
    public static int numberOfTrailingZeros(long i) {
        int x = (int)i;
        return x == 0 ? 32 + Integer.numberOfTrailingZeros((int)(i >>> 32)) : Integer.numberOfTrailingZeros(x);
    }

    @IntrinsicCandidate
    public static int bitCount(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    public static long rotateLeft(long i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> distance | i << -distance;
    }

    @IntrinsicCandidate
    public static long reverse(long i) {
        i = (i & 0x5555555555555555L) << 1 | i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) << 2 | i >>> 2 & 0x3333333333333333L;
        i = (i & 0xF0F0F0F0F0F0F0FL) << 4 | i >>> 4 & 0xF0F0F0F0F0F0F0FL;
        return Long.reverseBytes(i);
    }

    @IntrinsicCandidate
    public static long compress(long i, long mask) {
        i &= mask;
        long maskCount = (mask ^ 0xFFFFFFFFFFFFFFFFL) << 1;
        for (int j = 0; j < 6; ++j) {
            long maskPrefix = Long.parallelSuffix(maskCount);
            long maskMove = maskPrefix & mask;
            mask = mask ^ maskMove | maskMove >>> (1 << j);
            long t = i & maskMove;
            i = i ^ t | t >>> (1 << j);
            maskCount &= maskPrefix ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return i;
    }

    @IntrinsicCandidate
    public static long expand(long i, long mask) {
        long originalMask = mask;
        long maskCount = (mask ^ 0xFFFFFFFFFFFFFFFFL) << 1;
        long maskPrefix = Long.parallelSuffix(maskCount);
        long maskMove1 = maskPrefix & mask;
        mask = mask ^ maskMove1 | maskMove1 >>> 1;
        maskCount &= maskPrefix ^ 0xFFFFFFFFFFFFFFFFL;
        maskPrefix = Long.parallelSuffix(maskCount);
        long maskMove2 = maskPrefix & mask;
        mask = mask ^ maskMove2 | maskMove2 >>> 2;
        maskCount &= maskPrefix ^ 0xFFFFFFFFFFFFFFFFL;
        maskPrefix = Long.parallelSuffix(maskCount);
        long maskMove3 = maskPrefix & mask;
        mask = mask ^ maskMove3 | maskMove3 >>> 4;
        maskCount &= maskPrefix ^ 0xFFFFFFFFFFFFFFFFL;
        maskPrefix = Long.parallelSuffix(maskCount);
        long maskMove4 = maskPrefix & mask;
        mask = mask ^ maskMove4 | maskMove4 >>> 8;
        maskCount &= maskPrefix ^ 0xFFFFFFFFFFFFFFFFL;
        maskPrefix = Long.parallelSuffix(maskCount);
        long maskMove5 = maskPrefix & mask;
        mask = mask ^ maskMove5 | maskMove5 >>> 16;
        maskCount &= maskPrefix ^ 0xFFFFFFFFFFFFFFFFL;
        maskPrefix = Long.parallelSuffix(maskCount);
        long maskMove6 = maskPrefix & mask;
        long t = i << 32;
        i = i & (maskMove6 ^ 0xFFFFFFFFFFFFFFFFL) | t & maskMove6;
        t = i << 16;
        i = i & (maskMove5 ^ 0xFFFFFFFFFFFFFFFFL) | t & maskMove5;
        t = i << 8;
        i = i & (maskMove4 ^ 0xFFFFFFFFFFFFFFFFL) | t & maskMove4;
        t = i << 4;
        i = i & (maskMove3 ^ 0xFFFFFFFFFFFFFFFFL) | t & maskMove3;
        t = i << 2;
        i = i & (maskMove2 ^ 0xFFFFFFFFFFFFFFFFL) | t & maskMove2;
        t = i << 1;
        i = i & (maskMove1 ^ 0xFFFFFFFFFFFFFFFFL) | t & maskMove1;
        return i & originalMask;
    }

    @ForceInline
    private static long parallelSuffix(long maskCount) {
        long maskPrefix = maskCount ^ maskCount << 1;
        maskPrefix ^= maskPrefix << 2;
        maskPrefix ^= maskPrefix << 4;
        maskPrefix ^= maskPrefix << 8;
        maskPrefix ^= maskPrefix << 16;
        maskPrefix ^= maskPrefix << 32;
        return maskPrefix;
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    @IntrinsicCandidate
    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        return i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public Optional<Long> describeConstable() {
        return Optional.of(this);
    }

    @Override
    public Long resolveConstantDesc(MethodHandles.Lookup lookup) {
        return this;
    }

    private static final class LongCache {
        @Stable
        static final Long[] cache;
        static Long[] archivedCache;

        private LongCache() {
        }

        static {
            int size = 256;
            CDS.initializeFromArchive(LongCache.class);
            if (archivedCache == null) {
                Long[] c = new Long[size];
                long value = -128L;
                for (int i = 0; i < size; ++i) {
                    c[i] = new Long(value++);
                }
                archivedCache = c;
            }
            cache = archivedCache;
            assert (cache.length == size);
        }
    }
}

