/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.MinguoChronology;
import java.time.chrono.MinguoEra;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import jdk.internal.MigratedValueClass;
import jdk.internal.ValueBased;

@ValueBased
@MigratedValueClass
public final class MinguoDate
extends ChronoLocalDateImpl<MinguoDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = 1300372329181994526L;
    private final transient LocalDate isoDate;

    public static MinguoDate now() {
        return MinguoDate.now(Clock.systemDefaultZone());
    }

    public static MinguoDate now(ZoneId zone) {
        return MinguoDate.now(Clock.system(zone));
    }

    public static MinguoDate now(Clock clock) {
        return new MinguoDate(LocalDate.now(clock));
    }

    public static MinguoDate of(int prolepticYear, int month, int dayOfMonth) {
        return new MinguoDate(LocalDate.of(prolepticYear + 1911, month, dayOfMonth));
    }

    public static MinguoDate from(TemporalAccessor temporal) {
        return MinguoChronology.INSTANCE.date(temporal);
    }

    MinguoDate(LocalDate isoDate) {
        Objects.requireNonNull(isoDate, "isoDate");
        this.isoDate = isoDate;
    }

    @Override
    public MinguoChronology getChronology() {
        return MinguoChronology.INSTANCE;
    }

    @Override
    public MinguoEra getEra() {
        return this.getProlepticYear() >= 1 ? MinguoEra.ROC : MinguoEra.BEFORE_ROC;
    }

    @Override
    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                ChronoField f = (ChronoField)field;
                switch (f) {
                    case DAY_OF_MONTH: 
                    case DAY_OF_YEAR: 
                    case ALIGNED_WEEK_OF_MONTH: {
                        return this.isoDate.range(field);
                    }
                    case YEAR_OF_ERA: {
                        ValueRange range = ChronoField.YEAR.range();
                        long max = this.getProlepticYear() <= 0 ? -range.getMinimum() + 1L + 1911L : range.getMaximum() - 1911L;
                        return ValueRange.of(1L, max);
                    }
                }
                return this.getChronology().range(f);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    int prolepticYear = this.getProlepticYear();
                    return prolepticYear >= 1 ? prolepticYear : 1 - prolepticYear;
                }
                case YEAR: {
                    return this.getProlepticYear();
                }
                case ERA: {
                    return this.getProlepticYear() >= 1 ? 1 : 0;
                }
            }
            return this.isoDate.getLong(field);
        }
        return field.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.getProlepticYear() * 12L + (long)this.isoDate.getMonthValue() - 1L;
    }

    private int getProlepticYear() {
        return this.isoDate.getYear() - 1911;
    }

    @Override
    public MinguoDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            if (this.getLong(chronoField) == newValue) {
                return this;
            }
            return switch (chronoField) {
                case ChronoField.PROLEPTIC_MONTH -> {
                    this.getChronology().range(chronoField).checkValidValue(newValue, chronoField);
                    yield this.plusMonths(newValue - this.getProlepticMonth());
                }
                case ChronoField.YEAR_OF_ERA -> {
                    int nvalue = this.getChronology().range(chronoField).checkValidIntValue(newValue, chronoField);
                    yield this.with(this.isoDate.withYear(this.getProlepticYear() >= 1 ? nvalue + 1911 : 1 - nvalue + 1911));
                }
                case ChronoField.YEAR -> {
                    int nvalue = this.getChronology().range(chronoField).checkValidIntValue(newValue, chronoField);
                    yield this.with(this.isoDate.withYear(nvalue + 1911));
                }
                case ChronoField.ERA -> this.with(this.isoDate.withYear(1 - this.getProlepticYear() + 1911));
                default -> this.with(this.isoDate.with(field, newValue));
            };
        }
        return (MinguoDate)super.with(field, newValue);
    }

    @Override
    public MinguoDate with(TemporalAdjuster adjuster) {
        return (MinguoDate)super.with(adjuster);
    }

    @Override
    public MinguoDate plus(TemporalAmount amount) {
        return (MinguoDate)super.plus(amount);
    }

    @Override
    public MinguoDate minus(TemporalAmount amount) {
        return (MinguoDate)super.minus(amount);
    }

    @Override
    MinguoDate plusYears(long years) {
        return this.with(this.isoDate.plusYears(years));
    }

    @Override
    MinguoDate plusMonths(long months) {
        return this.with(this.isoDate.plusMonths(months));
    }

    @Override
    MinguoDate plusWeeks(long weeksToAdd) {
        return (MinguoDate)super.plusWeeks(weeksToAdd);
    }

    @Override
    MinguoDate plusDays(long days) {
        return this.with(this.isoDate.plusDays(days));
    }

    @Override
    public MinguoDate plus(long amountToAdd, TemporalUnit unit) {
        return (MinguoDate)super.plus(amountToAdd, unit);
    }

    @Override
    public MinguoDate minus(long amountToSubtract, TemporalUnit unit) {
        return (MinguoDate)super.minus(amountToSubtract, unit);
    }

    @Override
    MinguoDate minusYears(long yearsToSubtract) {
        return (MinguoDate)super.minusYears(yearsToSubtract);
    }

    @Override
    MinguoDate minusMonths(long monthsToSubtract) {
        return (MinguoDate)super.minusMonths(monthsToSubtract);
    }

    @Override
    MinguoDate minusWeeks(long weeksToSubtract) {
        return (MinguoDate)super.minusWeeks(weeksToSubtract);
    }

    @Override
    MinguoDate minusDays(long daysToSubtract) {
        return (MinguoDate)super.minusDays(daysToSubtract);
    }

    private MinguoDate with(LocalDate newDate) {
        return newDate.equals(this.isoDate) ? this : new MinguoDate(newDate);
    }

    public final ChronoLocalDateTime<MinguoDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDate) {
        Period period = this.isoDate.until(endDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MinguoDate)) return false;
        MinguoDate otherDate = (MinguoDate)obj;
        if (!this.isoDate.equals(otherDate.isoDate)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(7, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.get(ChronoField.YEAR));
        out.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        out.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static MinguoDate readExternal(DataInput in) throws IOException {
        int year = in.readInt();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        return MinguoChronology.INSTANCE.date(year, month, dayOfMonth);
    }
}

