/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: siginfo_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the siginfo_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=siginfo_t.class)
public class siginfo_tPointer extends StructurePointer {

	// NULL
	public static final siginfo_tPointer NULL = new siginfo_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected siginfo_tPointer(long address) {
		super(address);
	}

	public static siginfo_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static siginfo_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static siginfo_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new siginfo_tPointer(address);
	}

	public siginfo_tPointer add(long count) {
		return siginfo_tPointer.cast(address + (siginfo_t.SIZEOF * count));
	}

	public siginfo_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public siginfo_tPointer addOffset(long offset) {
		return siginfo_tPointer.cast(address + offset);
	}

	public siginfo_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public siginfo_tPointer sub(long count) {
		return siginfo_tPointer.cast(address - (siginfo_t.SIZEOF * count));
	}

	public siginfo_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public siginfo_tPointer subOffset(long offset) {
		return siginfo_tPointer.cast(address - offset);
	}

	public siginfo_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public siginfo_tPointer untag(long mask) {
		return siginfo_tPointer.cast(address & ~mask);
	}

	public siginfo_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return siginfo_t.SIZEOF;
	}

	// Implementation methods

	// __pid_t _sifields._kill.si_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_kill$si_pidOffset_", declaredType="__pid_t")
	public IDATA _sifields$_kill$si_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_kill$si_pidOffset_));
	}

	// __pid_t _sifields._kill.si_pid
	public IDATAPointer _sifields$_kill$si_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_kill$si_pidOffset_));
	}

	// __uid_t _sifields._kill.si_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_kill$si_uidOffset_", declaredType="__uid_t")
	public UDATA _sifields$_kill$si_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(siginfo_t.__sifields$_kill$si_uidOffset_));
	}

	// __uid_t _sifields._kill.si_uid
	public UDATAPointer _sifields$_kill$si_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_kill$si_uidOffset_));
	}

	// I32[] _sifields._pad
	public IDATAPointer _sifields$_padEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(siginfo_t.__sifields$_padOffset_));
	}

	// __pid_t _sifields._rt.si_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_rt$si_pidOffset_", declaredType="__pid_t")
	public IDATA _sifields$_rt$si_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_rt$si_pidOffset_));
	}

	// __pid_t _sifields._rt.si_pid
	public IDATAPointer _sifields$_rt$si_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_rt$si_pidOffset_));
	}

	// sigval_t _sifields._rt.si_sigval
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_rt$si_sigvalOffset_", declaredType="sigval_t")
	public sigvalPointer _sifields$_rt$si_sigval() throws CorruptDataException {
		return sigvalPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_rt$si_sigvalOffset_));
	}

	// sigval_t _sifields._rt.si_sigval
	public PointerPointer _sifields$_rt$si_sigvalEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_rt$si_sigvalOffset_));
	}

	// __uid_t _sifields._rt.si_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_rt$si_uidOffset_", declaredType="__uid_t")
	public UDATA _sifields$_rt$si_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(siginfo_t.__sifields$_rt$si_uidOffset_));
	}

	// __uid_t _sifields._rt.si_uid
	public UDATAPointer _sifields$_rt$si_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_rt$si_uidOffset_));
	}

	// __pid_t _sifields._sigchld.si_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigchld$si_pidOffset_", declaredType="__pid_t")
	public IDATA _sifields$_sigchld$si_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_sigchld$si_pidOffset_));
	}

	// __pid_t _sifields._sigchld.si_pid
	public IDATAPointer _sifields$_sigchld$si_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigchld$si_pidOffset_));
	}

	// I32 _sifields._sigchld.si_status
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigchld$si_statusOffset_", declaredType="I32")
	public IDATA _sifields$_sigchld$si_status() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_sigchld$si_statusOffset_));
	}

	// I32 _sifields._sigchld.si_status
	public IDATAPointer _sifields$_sigchld$si_statusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigchld$si_statusOffset_));
	}

	// __sigchld_clock_t _sifields._sigchld.si_stime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigchld$si_stimeOffset_", declaredType="__sigchld_clock_t")
	public IDATA _sifields$_sigchld$si_stime() throws CorruptDataException {
		return new I64(getLongAtOffset(siginfo_t.__sifields$_sigchld$si_stimeOffset_));
	}

	// __sigchld_clock_t _sifields._sigchld.si_stime
	public IDATAPointer _sifields$_sigchld$si_stimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigchld$si_stimeOffset_));
	}

	// __uid_t _sifields._sigchld.si_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigchld$si_uidOffset_", declaredType="__uid_t")
	public UDATA _sifields$_sigchld$si_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(siginfo_t.__sifields$_sigchld$si_uidOffset_));
	}

	// __uid_t _sifields._sigchld.si_uid
	public UDATAPointer _sifields$_sigchld$si_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigchld$si_uidOffset_));
	}

	// __sigchld_clock_t _sifields._sigchld.si_utime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigchld$si_utimeOffset_", declaredType="__sigchld_clock_t")
	public IDATA _sifields$_sigchld$si_utime() throws CorruptDataException {
		return new I64(getLongAtOffset(siginfo_t.__sifields$_sigchld$si_utimeOffset_));
	}

	// __sigchld_clock_t _sifields._sigchld.si_utime
	public IDATAPointer _sifields$_sigchld$si_utimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigchld$si_utimeOffset_));
	}

	// void* _sifields._sigfault.si_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigfault$si_addrOffset_", declaredType="void*")
	public VoidPointer _sifields$_sigfault$si_addr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(siginfo_t.__sifields$_sigfault$si_addrOffset_));
	}

	// void* _sifields._sigfault.si_addr
	public PointerPointer _sifields$_sigfault$si_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigfault$si_addrOffset_));
	}

	// I64 _sifields._sigpoll.si_band
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigpoll$si_bandOffset_", declaredType="I64")
	public IDATA _sifields$_sigpoll$si_band() throws CorruptDataException {
		return new I64(getLongAtOffset(siginfo_t.__sifields$_sigpoll$si_bandOffset_));
	}

	// I64 _sifields._sigpoll.si_band
	public IDATAPointer _sifields$_sigpoll$si_bandEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigpoll$si_bandOffset_));
	}

	// I32 _sifields._sigpoll.si_fd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigpoll$si_fdOffset_", declaredType="I32")
	public IDATA _sifields$_sigpoll$si_fd() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_sigpoll$si_fdOffset_));
	}

	// I32 _sifields._sigpoll.si_fd
	public IDATAPointer _sifields$_sigpoll$si_fdEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigpoll$si_fdOffset_));
	}

	// U32 _sifields._sigsys._arch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigsys$_archOffset_", declaredType="U32")
	public UDATA _sifields$_sigsys$_arch() throws CorruptDataException {
		return new U32(getIntAtOffset(siginfo_t.__sifields$_sigsys$_archOffset_));
	}

	// U32 _sifields._sigsys._arch
	public UDATAPointer _sifields$_sigsys$_archEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigsys$_archOffset_));
	}

	// void* _sifields._sigsys._call_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigsys$_call_addrOffset_", declaredType="void*")
	public VoidPointer _sifields$_sigsys$_call_addr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(siginfo_t.__sifields$_sigsys$_call_addrOffset_));
	}

	// void* _sifields._sigsys._call_addr
	public PointerPointer _sifields$_sigsys$_call_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigsys$_call_addrOffset_));
	}

	// I32 _sifields._sigsys._syscall
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_sigsys$_syscallOffset_", declaredType="I32")
	public IDATA _sifields$_sigsys$_syscall() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_sigsys$_syscallOffset_));
	}

	// I32 _sifields._sigsys._syscall
	public IDATAPointer _sifields$_sigsys$_syscallEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_sigsys$_syscallOffset_));
	}

	// I32 _sifields._timer.si_overrun
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_timer$si_overrunOffset_", declaredType="I32")
	public IDATA _sifields$_timer$si_overrun() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_timer$si_overrunOffset_));
	}

	// I32 _sifields._timer.si_overrun
	public IDATAPointer _sifields$_timer$si_overrunEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_timer$si_overrunOffset_));
	}

	// sigval_t _sifields._timer.si_sigval
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_timer$si_sigvalOffset_", declaredType="sigval_t")
	public sigvalPointer _sifields$_timer$si_sigval() throws CorruptDataException {
		return sigvalPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_timer$si_sigvalOffset_));
	}

	// sigval_t _sifields._timer.si_sigval
	public PointerPointer _sifields$_timer$si_sigvalEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_timer$si_sigvalOffset_));
	}

	// I32 _sifields._timer.si_tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sifields$_timer$si_tidOffset_", declaredType="I32")
	public IDATA _sifields$_timer$si_tid() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t.__sifields$_timer$si_tidOffset_));
	}

	// I32 _sifields._timer.si_tid
	public IDATAPointer _sifields$_timer$si_tidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t.__sifields$_timer$si_tidOffset_));
	}

	// I32 si_code
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_codeOffset_", declaredType="I32")
	public IDATA si_code() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t._si_codeOffset_));
	}

	// I32 si_code
	public IDATAPointer si_codeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t._si_codeOffset_));
	}

	// I32 si_errno
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_errnoOffset_", declaredType="I32")
	public IDATA si_errno() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t._si_errnoOffset_));
	}

	// I32 si_errno
	public IDATAPointer si_errnoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t._si_errnoOffset_));
	}

	// I32 si_signo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_signoOffset_", declaredType="I32")
	public IDATA si_signo() throws CorruptDataException {
		return new I32(getIntAtOffset(siginfo_t._si_signoOffset_));
	}

	// I32 si_signo
	public IDATAPointer si_signoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(siginfo_t._si_signoOffset_));
	}

}
