/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ObjectFieldInfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ObjectFieldInfo {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __cacheLineSizeOffset_;
	public static final int __classRequiresPrePaddingOffset_;
	public static final int __contendedDoubleCountOffset_;
	public static final int __contendedObjectCountOffset_;
	public static final int __contendedSingleCountOffset_;
	public static final int __flatAlignedObjectInstanceBackfillOffset_;
	public static final int __flatAlignedSingleInstanceBackfillOffset_;
	public static final int __flatUnAlignedObjectInstanceBackfillOffset_;
	public static final int __flatUnAlignedSingleInstanceBackfillOffset_;
	public static final int __flattenedClassCacheOffset_;
	public static final int __hiddenFieldCountOffset_;
	public static final int __hiddenFieldOffsetResolutionRequiredOffset_;
	public static final int __instanceDoubleCountOffset_;
	public static final int __instanceFieldBackfillEligibleOffset_;
	public static final int __instanceObjectCountOffset_;
	public static final int __instanceSingleCountOffset_;
	public static final int __isBackFillPostPaddedOffset_;
	public static final int __isValueOffset_;
	public static final int __myBackfillOffsetOffset_;
	public static final int __objectCanUseBackfillOffset_;
	public static final int __objectHeaderSizeOffset_;
	public static final int __referenceSizeOffset_;
	public static final int __romClassOffset_;
	public static final int __subclassBackfillOffsetOffset_;
	public static final int __superclassBackfillOffsetOffset_;
	public static final int __superclassFieldsSizeOffset_;
	public static final int __totalDoubleCountOffset_;
	public static final int __totalFlatFieldDoubleBytesOffset_;
	public static final int __totalFlatFieldRefBytesOffset_;
	public static final int __totalFlatFieldSingleBytesOffset_;
	public static final int __totalObjectCountOffset_;
	public static final int __totalSingleCountOffset_;
	public static final int __useContendedClassLayoutOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__cacheLineSizeOffset_ = 0;
		__classRequiresPrePaddingOffset_ = 0;
		__contendedDoubleCountOffset_ = 0;
		__contendedObjectCountOffset_ = 0;
		__contendedSingleCountOffset_ = 0;
		__flatAlignedObjectInstanceBackfillOffset_ = 0;
		__flatAlignedSingleInstanceBackfillOffset_ = 0;
		__flatUnAlignedObjectInstanceBackfillOffset_ = 0;
		__flatUnAlignedSingleInstanceBackfillOffset_ = 0;
		__flattenedClassCacheOffset_ = 0;
		__hiddenFieldCountOffset_ = 0;
		__hiddenFieldOffsetResolutionRequiredOffset_ = 0;
		__instanceDoubleCountOffset_ = 0;
		__instanceFieldBackfillEligibleOffset_ = 0;
		__instanceObjectCountOffset_ = 0;
		__instanceSingleCountOffset_ = 0;
		__isBackFillPostPaddedOffset_ = 0;
		__isValueOffset_ = 0;
		__myBackfillOffsetOffset_ = 0;
		__objectCanUseBackfillOffset_ = 0;
		__objectHeaderSizeOffset_ = 0;
		__referenceSizeOffset_ = 0;
		__romClassOffset_ = 0;
		__subclassBackfillOffsetOffset_ = 0;
		__superclassBackfillOffsetOffset_ = 0;
		__superclassFieldsSizeOffset_ = 0;
		__totalDoubleCountOffset_ = 0;
		__totalFlatFieldDoubleBytesOffset_ = 0;
		__totalFlatFieldRefBytesOffset_ = 0;
		__totalFlatFieldSingleBytesOffset_ = 0;
		__totalObjectCountOffset_ = 0;
		__totalSingleCountOffset_ = 0;
		__useContendedClassLayoutOffset_ = 0;
	}

}
