/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_xnr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ग्रीनविच मीन टैम",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "एपिआ दा मानक टैम",
               "",
               "एपिआ दे ध्याड़े दे उजाले दा टैम",
               "",
               "एपिआ दा टैम",
               "",
            };
        final String[] Cook = new String[] {
               "कुक टापुआं दे झुंडे दा मानक टैम",
               "",
               "कुक टापुआं दे झुंडे दा अद्धी तोंदिया दा टैम",
               "",
               "कुक टापुआं दे झुंडे दा टैम",
               "",
            };
        final String[] Cuba = new String[] {
               "क्यूबा दा मानक टैम",
               "CST",
               "क्यूबा दे ध्याड़े दे उजाले दा टैम",
               "CDT",
               "क्यूबा दा टैम",
               "CT",
            };
        final String[] Fiji = new String[] {
               "फ़िजी दा मानक टैम",
               "",
               "फ़िजी दी तोंदिया दा टैम",
               "",
               "फ़िजी दा टैम",
               "",
            };
        final String[] Gulf = new String[] {
               "खाड़ी दा मानक टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "होव्ड दा मानक टैम",
               "",
               "होव्ड दी तोंदिया दा टैम",
               "",
               "होव्ड दा टैम",
               "",
            };
        final String[] Iran = new String[] {
               "ईरान दा मानक टैम",
               "",
               "ईरान दे ध्याड़े दे उजाले दा टैम",
               "",
               "ईरान दा टैम",
               "",
            };
        final String[] Niue = new String[] {
               "नीयू दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ओम्स्क दा मानक टैम",
               "",
               "ओम्स्क दी तोंदिया दा टैम",
               "",
               "ओम्स्क दा टैम",
               "",
            };
        final String[] Peru = new String[] {
               "पेरू दा मानक टैम",
               "",
               "पेरू दी तोंदिया दा टैम",
               "",
               "पेरू दा टैम",
               "",
            };
        final String[] Truk = new String[] {
               "चुक दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "वेक टापू दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "चिली दा मानक टैम",
               "",
               "चिली दी तोंदिया दा टैम",
               "",
               "चिली दा टैम",
               "",
            };
        final String[] China = new String[] {
               "चीन दा मानक टैम",
               "CST",
               "चीन दे ध्याड़े दे उजाले दा टैम",
               "CDT",
               "चीन दा टैम",
               "CT",
            };
        final String[] Cocos = new String[] {
               "कोकोस टापुआं दे झुंडे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "डेविस दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "भारते दा मानक टैम",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "जापाने दा मानक टैम",
               "JST",
               "जापाने दे ध्याड़े दे उजाले दा टैम",
               "JDT",
               "जापाने दा टैम",
               "JT",
            };
        final String[] Korea = new String[] {
               "कोरियाई दा मानक टैम",
               "KST",
               "कोरियाई दे ध्याड़े दे उजाले दा टैम",
               "KST",
               "कोरियाई दा टैम",
               "KST",
            };
        final String[] Nauru = new String[] {
               "नौरू दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "नेपाल दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "पलाउ दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "समोआ दा मानक टैम",
               "SST",
               "समोआ दे ध्याड़े दे उजाले दा टैम",
               "SST",
               "समोआ दा टैम",
               "SST",
            };
        final String[] Syowa = new String[] {
               "स्योवा दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "टोंगा दा मानक टैम",
               "",
               "टोंगा दी तोंदिया दा टैम",
               "",
               "टोंगा दा टैम",
               "",
            };
        final String[] Yukon = new String[] {
               "युकॉन टैम",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "अलास्‍का दा मानक टैम",
               "AKST",
               "अलास्‍का दे ध्याड़े दे उजाले दा टैम",
               "AKDT",
               "अलास्का दा टैम",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "एमेज़ोन दा मानक टैम",
               "",
               "एमेज़ोन दी तोंदिया दा टैम",
               "",
               "एमेज़ोन दा टैम",
               "",
            };
        final String[] Azores = new String[] {
               "अज़ोरेस दा मानक टैम",
               "",
               "अज़ोरेस दी तोंदिया दा टैम",
               "",
               "अज़ोरेस दा टैम",
               "",
            };
        final String[] Bhutan = new String[] {
               "भूटाने दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ब्रूनेई दारूस्सलम दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ईस्टर टापू दा मानक टैम",
               "",
               "ईस्टर टापू दी तोंदिया दा टैम",
               "",
               "ईस्टर टापू दा टैम",
               "",
            };
        final String[] Guyana = new String[] {
               "गुयाना दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "हवाई–आल्यूशन दा मानक टैम",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "इज़राइल दा मानक टैम",
               "IST",
               "इज़राइल दे ध्याड़े दे उजाले दा टैम",
               "IDT",
               "इज़राइल दा टैम",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "कोसराए दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "माव्सन दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "मॉस्को दा मानक टैम",
               "MSK",
               "मॉस्को दि तोंदिया दा टैम",
               "MSK",
               "मॉस्को दा टैम",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "पोनापे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ताहिती दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ताइपे दा मानक टैम",
               "CST",
               "ताइपे दे ध्याड़े दे उजाले दा टैम",
               "CDT",
               "ताइपे दा टैम",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "तुवालू दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "वोस्तोक दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "वालिस कने फ़्यूचूना दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "अरब दा मानक टैम",
               "",
               "अरब दे ध्याड़े दे उजाले दा टैम",
               "",
               "अरब दा टैम",
               "",
            };
        final String[] Armenia = new String[] {
               "आर्मेनिया दा मानक टैम",
               "",
               "आर्मेनिया दी तोंदिया दा टैम",
               "",
               "आर्मेनिया दा टैम",
               "",
            };
        final String[] Bolivia = new String[] {
               "बोलीविया दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "चैथम दा मानक टैम",
               "",
               "चैथम दे ध्याड़े दे उजाले दा टैम",
               "",
               "चैथम दा टैम",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "समन्वित दुनिया दा टैम",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "इक्वाडोर दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "गैंबियर दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "जॉर्जिया दा मानक टैम",
               "",
               "जॉर्जिया दी तोंदिया दा टैम",
               "",
               "जॉर्जिया दा टैम",
               "",
            };
        final String[] Irkutsk = new String[] {
               "इर्कुत्स्क दा मानक टैम",
               "",
               "इर्कुत्स्क दी तोंदिया दा टैम",
               "",
               "इर्कुत्स्क दा टैम",
               "",
            };
        final String[] Magadan = new String[] {
               "मागादान दा मानक टैम",
               "",
               "मागादान दी तोंदिया दा टैम",
               "",
               "मागादान दा टैम",
               "",
            };
        final String[] Myanmar = new String[] {
               "म्यांमार दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "नॉरफ़ॉक टापू दा मानक टैम",
               "",
               "नॉरफ़ॉक टापू दे ध्याड़े दे उजाले दा टैम",
               "",
               "नॉरफ़ॉक टापू दा टैम",
               "",
            };
        final String[] Noronha = new String[] {
               "फ़र्नांर्डो डे नोरोन्हा मानक दा टैम",
               "",
               "फ़र्नांर्डो डे नोरोन्हा दे तोंदिया दा टैम",
               "",
               "फ़र्नांर्डो डे नोरोन्हा दा टैम",
               "",
            };
        final String[] Reunion = new String[] {
               "रीयूनियन दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "रोथेरा दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "सोलोमन टापुआं दे झुंडे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "टोकेलाऊ दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "उरुग्वे दा मानक टैम",
               "",
               "उरुग्वे दी तोंदिया दा टैम",
               "",
               "उरुग्वे दा टैम",
               "",
            };
        final String[] Vanuatu = new String[] {
               "वनुआतू दा मानक टैम",
               "",
               "वनुआतू दी तोंदिया दा टैम",
               "",
               "वनुआतू दा टैम",
               "",
            };
        final String[] Yakutsk = new String[] {
               "याकुत्स्क दा मानक टैम",
               "",
               "याकुत्स्क दी तोंदिया दा टैम",
               "",
               "याकुत्स्क दा टैम",
               "",
            };
        final String[] Atlantic = new String[] {
               "अटलांटिक दा मानक टैम",
               "AST",
               "अटलांटिक दे ध्याड़े दे उजाले दा टैम",
               "AST",
               "अटलांटिक दा टैम",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ब्राज़ीलिया दा मानक टैम",
               "",
               "ब्राज़ीलिया दी तोंदिया दा टैम",
               "",
               "ब्राज़ीलिया दा टैम",
               "",
            };
        final String[] Chamorro = new String[] {
               "चामोरो दा मानक टैम",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "कोलंबिया दा मानक टैम",
               "",
               "कोलंबिया दी तोंदिया दा टैम",
               "",
               "कोलंबिया दा टैम",
               "",
            };
        final String[] Falkland = new String[] {
               "फ़ॉकलैंड टापुआं दे झुंडे दा मानक टैम",
               "",
               "फ़ॉकलैंड टापुआं दे झुंडे दी तोंदिया दा टैम",
               "",
               "फ़ॉकलैंड टापुआं दे झुंडे दा टैम",
               "",
            };
        final String[] Malaysia = new String[] {
               "मलेशिया दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "मालदीव दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "उलान बटोर दा मानक टैम",
               "",
               "उलान बटोर दी तोंदिया दा टैम",
               "",
               "उलान बटोर दा टैम",
               "",
            };
        final String[] Pakistan = new String[] {
               "पाकिस्ताने दा मानक टैम",
               "PKT",
               "पाकिस्ताने दी तोंदिया दा टैम",
               "PKST",
               "पाकिस्ताने दा टैम",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "पैराग्वे दा मानक टैम",
               "",
               "पैराग्वे दी तोंदिया दा टैम",
               "",
               "पैराग्वे दा टैम",
               "",
            };
        final String[] Pitcairn = new String[] {
               "पिटकैर्न दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "सूरीनामे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "अर्जेंटीना दा मानक टैम",
               "",
               "अर्जेंटीना दी तोंदिया दा टैम",
               "",
               "अर्जेंटीना दा टैम",
               "",
            };
        final String[] Christmas = new String[] {
               "क्रिसमस टापू दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "गैलापेगोस दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "हाँग काँग दा मानक टैम",
               "HKT",
               "हाँग काँग दी तोंदिया दा टैम",
               "HKST",
               "हाँग काँग दा टैम",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "इंडोचाइना दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "किर्गिस्‍तान दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "लॉर्ड होवे दा मानक टैम",
               "",
               "लॉर्ड होवे दे ध्याड़े दे उजाले दा टैम",
               "",
               "लॉर्ड होवे दा टैम",
               "",
            };
        final String[] Marquesas = new String[] {
               "मार्केसस दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "मॉरीशस दा मानक टैम",
               "",
               "मॉरीशस दी तोंदिया दा टैम",
               "",
               "मॉरीशस दा टैम",
               "",
            };
        final String[] Singapore = new String[] {
               "सिंगापुरे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "वेनेज़ुएला दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "अज़रबैजान दा मानक टैम",
               "",
               "अज़रबैजान दी तोंदिया दा टैम",
               "",
               "अज़रबैजान दा टैम",
               "",
            };
        final String[] Bangladesh = new String[] {
               "बांग्लादेशे दा मानक टैम",
               "",
               "बांग्लादेशे दी तोंदिया दा टैम",
               "",
               "बांग्लादेशा दा टैम",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "केप वर्ड दा मानक टैम",
               "",
               "केप वर्ड दी तोंदिया दा टैम",
               "",
               "केप वर्ड दा टैम",
               "",
            };
        final String[] East_Timor = new String[] {
               "पैलेी तिमोरे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "सेशेल्स दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ताजिकिस्ताने दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "उज़्बेकिस्तान दा मानक टैम",
               "",
               "उज़्बेकिस्तान दी तोंदिया दा टैम",
               "",
               "उज़्बेकिस्तान दा टैम",
               "",
            };
        final String[] Afghanistan = new String[] {
               "अफ़गानिस्ताने दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "क्रास्नोयार्स्क दा मानक टैम",
               "",
               "क्रास्नोयार्स्क दी तोंदिया दा टैम",
               "",
               "क्रास्नोयार्स्क दा टैम",
               "",
            };
        final String[] New_Zealand = new String[] {
               "न्यूज़ीलैंड दा मानक टैम",
               "NZST",
               "न्यूज़ीलैंड दे ध्याड़े दे उजाले दा टैम",
               "NZDT",
               "न्यूज़ीलैंड दा टैम",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "फ़िलिपीन दा मानक टैम",
               "PST",
               "फ़िलिपीन दी तोंदिया दा टैम",
               "PDT",
               "फ़िलिपीन दा टैम",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "व्लादिवोस्तोक दा मानक टैम",
               "",
               "व्लादिवोस्तोक दी तोंदिया दा टैम",
               "",
               "व्लादिवोस्तोक दा टैम",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "हिंद महासागर दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "लाइन टापुआं दे झुंडे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "न्यूफ़ाउंडलैंड दा मानक टैम",
               "NST",
               "न्यूफ़ाउंडलैंड दे ध्याड़े दे उजाले दा टैम",
               "NDT",
               "न्यूफ़ाउंडलैंड दा टैम",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "तुर्कमेनिस्ताने दा मानक टैम",
               "",
               "तुर्कमेनिस्ताने दी तोंदिया दा टैम",
               "",
               "तुर्कमेनिस्तान दा टैम",
               "",
            };
        final String[] French_Guiana = new String[] {
               "फ़्रेंच गुयाना दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "न्यू कैलेडोनिया दा मानक टैम",
               "",
               "न्यू कैलेडोनिया दी तोंदिया दा टैम",
               "",
               "न्यू कैलेडोनिया दा टैम",
               "",
            };
        final String[] South_Georgia = new String[] {
               "दखण जॉर्जिया दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "येकातेरिनबर्ग दा मानक टैम",
               "",
               "येकातेरिनबर्ग दी तोंदिया दा टैम",
               "",
               "येकातेरिनबर्ग दा टैम",
               "",
            };
        final String[] Africa_Central = new String[] {
               "मध्य अफ़्रीका दा टैम",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "पैलेी अफ़्रीका दा टैम",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "पश्चिम अफ़्रीका दा टैम",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ड्यूमोंट डी अर्विले दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "बिचले यूरोपे दा मानक टैम",
               "CET",
               "बिचले यूरोपे दी तोंदिया दा टैम",
               "CEST",
               "बिचले यूरोपे दा टैम",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "पैलेी यूरोपे दा मानक टैम",
               "EET",
               "पैलेी यूरोपे दी तोंदिया दा टैम",
               "EEST",
               "पैलेी यूरोपे दा टैम",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "पश्चिमी यूरोपे दा मानक टैम",
               "WET",
               "पश्चिमी यूरोपे दी तोंदिया दा टैम",
               "WEST",
               "पश्चिमी यूरोपे दा टैम",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "मेक्सिकन प्रशांत दा मानक टैम",
               "MST",
               "मेक्सिकन प्रशांत दे ध्याड़े दे उजाले दा टैम",
               "MDT",
               "मेक्सिकन प्रशांत दा टैम",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "दखण अफ़्रीका दा मानक टैम",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "उत्तरी अमरिकी केंद्रीय दा मानक टैम",
               "CST",
               "उत्तरी अमरिकी केंद्रीय दे ध्याड़े दे उजाले दा टैम",
               "CDT",
               "उत्तरी अमरिकी केंद्रीय दा टैम",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "उत्तरी अमरिकी पैलेी दा मानक टैम",
               "EST",
               "उत्तरी अमरिकी पैलेी दे ध्याड़े दे उजाले दा टैम",
               "EST",
               "उत्तरी अमरिकी पैलेी टैम",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "उत्तरी अमेरिकी प्रशांते दा मानक टैम",
               "PST",
               "उत्तरी अमेरिकी प्रशांते दे ध्याड़े दे उजाले दा टैम",
               "PDT",
               "उत्तरी अमेरिकी प्रशांते दा टैम",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "दखणे बखें फ़्रांस कने अंटार्कटिक दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "गिल्बर्ट टापुआं दे झुंडे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "हवाई–आल्यूशन दा मानक टैम",
               "HST",
               "हवाई–आल्यूशन दे ध्याड़े दे उजाले दा टैम",
               "HDT",
               "हवाई–आल्यूशन दा टैम",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "फ़ीनिक्स टापुआं दे झुंडे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "सेंट पिएरे कने मिक्वेलान दा मानक टैम",
               "",
               "सेंट पिएरे कने मिक्वेलान दे ध्याड़े दे उजाले दा टैम",
               "",
               "सेंट पिएरे कने मिक्वेलान दा टैम",
               "",
            };
        final String[] America_Mountain = new String[] {
               "उत्तरी अमेरिकी पहाड़े दा मानक टैम",
               "MST",
               "उत्तरी अमेरिकी पहाड़े दे ध्याड़े दे उजाले दा टैम",
               "MST",
               "उत्तरी अमरिकी पहाड़े दा टैम",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "मार्शल टापुआं दे झुंडे दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "पापुआ न्यू गिनी दा टैम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "अस्‍ट्रेलिया दे केंद्रीय दा मानक टैम",
               "ACST",
               "अस्‍ट्रेलिया दे केंद्रीय दे ध्याड़े दे उजाले दा टैम",
               "ACDT",
               "बिचले अस्ट्रेलिया दा टैम",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "अस्‍ट्रेलियाई पैलेी दा मानक टैम",
               "AEST",
               "अस्‍ट्रेलियाई पैलेी दे ध्याड़े दे उजाले दा टैम",
               "AEDT",
               "पैलेी अस्ट्रेलिया दा टैम",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "अस्ट्रेलिया पश्चिमी दा मानक टैम",
               "AWST",
               "अस्ट्रेलिया पश्चिमी दे ध्याड़े दे उजाले दा टैम",
               "AWDT",
               "पश्चिमी अस्ट्रेलिया दा टैम",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "बिचले इंडोनेशिया दा टैम",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "पैलेी इंडोनेशिया दा टैम",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "पश्चिमी इंडोनेशिया दा टैम",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "अस्‍ट्रेलिया केंद्रीय पश्चिमी दा मानक टैम",
               "",
               "अस्‍ट्रेलियाई केंद्रीय पश्चिमी ध्याड़े दे उजाले दा टैम",
               "",
               "अस्‍ट्रेलियाई केंद्रीय पश्चिमी दा टैम",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "ब्रिटिश दी तोंदिया दा टैम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "समन्वित दुनिया दा टैम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "आइरिश दा मानक टैम",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "समन्वित दुनिया दा टैम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "समन्वित दुनिया दा टैम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "ब्रिटिश दी तोंदिया दा टैम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "समन्वित दुनिया दा टैम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "समन्वित दुनिया दा टैम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "समन्वित दुनिया दा टैम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "आइरिश दा मानक टैम",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "ब्रिटिश दी तोंदिया दा टैम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "ब्रिटिश दी तोंदिया दा टैम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "ब्रिटिश दी तोंदिया दा टैम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "ब्रिटिश दी तोंदिया दा टैम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ग्रीनविच मीन टैम",
                    "GMT",
                    "ब्रिटिश दी तोंदिया दा टैम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "अदन" },
            { "timezone.excity.Asia/Baku", "बाकु" },
            { "timezone.excity.Asia/Dili", "डिलि" },
            { "timezone.excity.Asia/Gaza", "गाज़ा" },
            { "timezone.excity.Asia/Hovd", "होव्ड" },
            { "timezone.excity.Asia/Omsk", "ओम्स्क" },
            { "timezone.excity.Asia/Oral", "ओरल" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "अम्मान" },
            { "timezone.excity.Asia/Aqtau", "अक्ताउ" },
            { "timezone.excity.Asia/Chita", "त्शिता" },
            { "timezone.excity.Asia/Dhaka", "ढाका" },
            { "timezone.excity.Asia/Dubai", "डबई" },
            { "timezone.excity.Asia/Kabul", "काबल" },
            { "timezone.excity.Asia/Macau", "मकाऊ" },
            { "timezone.excity.Asia/Qatar", "कतर" },
            { "timezone.excity.Asia/Seoul", "सिओल" },
            { "timezone.excity.Asia/Tokyo", "टोक्यो" },
            { "timezone.excity.Asia/Tomsk", "तोम्स्क" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "जुबा" },
            { "timezone.excity.Africa/Lome", "लोम" },
            { "timezone.excity.Asia/Almaty", "अल्माटी" },
            { "timezone.excity.Asia/Anadyr", "अनाडिर" },
            { "timezone.excity.Asia/Aqtobe", "अक्तोब" },
            { "timezone.excity.Asia/Atyrau", "एतराउ" },
            { "timezone.excity.Asia/Beirut", "बेरुत" },
            { "timezone.excity.Asia/Brunei", "ब्रूनेई" },
            { "timezone.excity.Asia/Hebron", "हेब्रोन" },
            { "timezone.excity.Asia/Kuwait", "कुवैत" },
            { "timezone.excity.Asia/Manila", "मनीला" },
            { "timezone.excity.Asia/Muscat", "मस्कट" },
            { "timezone.excity.Asia/Riyadh", "रियाद" },
            { "timezone.excity.Asia/Saigon", "हो ची मिन्ह शहर" },
            { "timezone.excity.Asia/Taipei", "ताइपेई" },
            { "timezone.excity.Asia/Tehran", "तेहरान" },
            { "timezone.excity.Asia/Urumqi", "उरूम्की" },
            { "timezone.excity.Etc/Unknown", "अणजाण शहर" },
            { "timezone.excity.Europe/Kiev", "कीव" },
            { "timezone.excity.Europe/Oslo", "ओस्लो" },
            { "timezone.excity.Europe/Riga", "रीगा" },
            { "timezone.excity.Europe/Rome", "रोम" },
            { "timezone.excity.Indian/Mahe", "माहे" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "एक्रा" },
            { "timezone.excity.Africa/Cairo", "कायरो" },
            { "timezone.excity.Africa/Ceuta", "सेउटा" },
            { "timezone.excity.Africa/Dakar", "डकार" },
            { "timezone.excity.Africa/Lagos", "लागोस" },
            { "timezone.excity.Africa/Tunis", "ट्यूनिस" },
            { "timezone.excity.America/Adak", "अडक" },
            { "timezone.excity.America/Lima", "लीमा" },
            { "timezone.excity.America/Nome", "नोम" },
            { "timezone.excity.Asia/Baghdad", "बगदाद" },
            { "timezone.excity.Asia/Bahrain", "बहरीन" },
            { "timezone.excity.Asia/Bangkok", "बैंकॉक" },
            { "timezone.excity.Asia/Barnaul", "बर्नोल" },
            { "timezone.excity.Asia/Bishkek", "बिश्केक" },
            { "timezone.excity.Asia/Colombo", "कोलंबो" },
            { "timezone.excity.Asia/Irkutsk", "इर्कुत्स्क" },
            { "timezone.excity.Asia/Jakarta", "जकार्ता" },
            { "timezone.excity.Asia/Karachi", "कराची" },
            { "timezone.excity.Asia/Kuching", "कूचिंग" },
            { "timezone.excity.Asia/Magadan", "मागादान" },
            { "timezone.excity.Asia/Nicosia", "निकोसिया" },
            { "timezone.excity.Asia/Rangoon", "रंगून" },
            { "timezone.excity.Asia/Tbilisi", "टबिलिसी" },
            { "timezone.excity.Asia/Thimphu", "थिंपू" },
            { "timezone.excity.Asia/Yakutsk", "याकूत्स्क" },
            { "timezone.excity.Asia/Yerevan", "येरेवान" },
            { "timezone.excity.Europe/Kirov", "किरोव" },
            { "timezone.excity.Europe/Malta", "माल्टा" },
            { "timezone.excity.Europe/Minsk", "मिंस्क" },
            { "timezone.excity.Europe/Paris", "पैरस" },
            { "timezone.excity.Europe/Sofia", "सोफ़िया" },
            { "timezone.excity.Europe/Vaduz", "वादुज़" },
            { "timezone.excity.Indian/Cocos", "कोकोस" },
            { "timezone.excity.Pacific/Apia", "एपिया" },
            { "timezone.excity.Pacific/Fiji", "फ़िजी" },
            { "timezone.excity.Pacific/Guam", "गुआम" },
            { "timezone.excity.Pacific/Niue", "नीयू" },
            { "timezone.excity.Pacific/Truk", "चक" },
            { "timezone.excity.Pacific/Wake", "वेक" },
            { "timezone.excity.Africa/Asmera", "अस्मारा" },
            { "timezone.excity.Africa/Bamako", "बमाको" },
            { "timezone.excity.Africa/Bangui", "बांगुइ" },
            { "timezone.excity.Africa/Banjul", "बैंजुल" },
            { "timezone.excity.Africa/Bissau", "बिसाऊ" },
            { "timezone.excity.Africa/Douala", "डूआला" },
            { "timezone.excity.Africa/Harare", "हरारे" },
            { "timezone.excity.Africa/Kigali", "किगाली" },
            { "timezone.excity.Africa/Luanda", "लुआंडा" },
            { "timezone.excity.Africa/Lusaka", "लुसाका" },
            { "timezone.excity.Africa/Malabo", "मलाबो" },
            { "timezone.excity.Africa/Maputo", "मापुटो" },
            { "timezone.excity.Africa/Maseru", "मासेरू" },
            { "timezone.excity.Africa/Niamey", "नियामी" },
            { "timezone.excity.America/Aruba", "अरूबा" },
            { "timezone.excity.America/Bahia", "बहिया" },
            { "timezone.excity.America/Belem", "बेलेम" },
            { "timezone.excity.America/Boise", "बॉइसी" },
            { "timezone.excity.America/Jujuy", "जुजोए" },
            { "timezone.excity.America/Sitka", "सिट्का" },
            { "timezone.excity.America/Thule", "थ्यूले" },
            { "timezone.excity.Asia/Ashgabat", "अश्गाबात" },
            { "timezone.excity.Asia/Calcutta", "कलकाता" },
            { "timezone.excity.Asia/Damascus", "दमास्कस" },
            { "timezone.excity.Asia/Dushanbe", "दुशांबे" },
            { "timezone.excity.Asia/Jayapura", "जयापुरा" },
            { "timezone.excity.Asia/Katmandu", "काठमांडू" },
            { "timezone.excity.Asia/Khandyga", "खांडिगा" },
            { "timezone.excity.Asia/Makassar", "मकस्सर" },
            { "timezone.excity.Asia/Qostanay", "कोस्टाने" },
            { "timezone.excity.Asia/Sakhalin", "सखालिन" },
            { "timezone.excity.Asia/Shanghai", "शंघाई" },
            { "timezone.excity.Asia/Tashkent", "ताशकंद" },
            { "timezone.excity.Asia/Ust-Nera", "यूस्ट–नेरा" },
            { "timezone.excity.Europe/Athens", "एथेंस" },
            { "timezone.excity.Europe/Berlin", "बर्लिन" },
            { "timezone.excity.Europe/Dublin", "डबलिन" },
            { "timezone.excity.Europe/Jersey", "जर्सी" },
            { "timezone.excity.Europe/Lisbon", "लिस्बन" },
            { "timezone.excity.Europe/London", "लंदन" },
            { "timezone.excity.Europe/Madrid", "मैड्रिड" },
            { "timezone.excity.Europe/Monaco", "मोनाको" },
            { "timezone.excity.Europe/Moscow", "मॉस्को" },
            { "timezone.excity.Europe/Prague", "प्राग" },
            { "timezone.excity.Europe/Samara", "समारा" },
            { "timezone.excity.Europe/Skopje", "स्कोप्जे" },
            { "timezone.excity.Europe/Tirane", "टाइरेन" },
            { "timezone.excity.Europe/Vienna", "विएना" },
            { "timezone.excity.Europe/Warsaw", "वॉरसॉ" },
            { "timezone.excity.Europe/Zagreb", "ज़ाग्रेब" },
            { "timezone.excity.Europe/Zurich", "ज़्यूरिख़" },
            { "timezone.excity.Indian/Chagos", "शागोस" },
            { "timezone.excity.Indian/Comoro", "कोमोरो" },
            { "timezone.excity.Pacific/Efate", "एफ़ेट" },
            { "timezone.excity.Pacific/Nauru", "नौरु" },
            { "timezone.excity.Pacific/Palau", "पलाऊ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "अबिदजान" },
            { "timezone.excity.Africa/Algiers", "अल्जीयर्स" },
            { "timezone.excity.Africa/Conakry", "कोनाक्री" },
            { "timezone.excity.Africa/Kampala", "कंपाला" },
            { "timezone.excity.Africa/Mbabane", "एमबाबेन" },
            { "timezone.excity.Africa/Nairobi", "नैरोबी" },
            { "timezone.excity.Africa/Tripoli", "त्रिपोली" },
            { "timezone.excity.America/Belize", "बेलीज़" },
            { "timezone.excity.America/Bogota", "बोगोटा" },
            { "timezone.excity.America/Cancun", "कैनकुन" },
            { "timezone.excity.America/Cayman", "कैमेन" },
            { "timezone.excity.America/Cuiaba", "क्यूआबा" },
            { "timezone.excity.America/Dawson", "डॉसन" },
            { "timezone.excity.America/Denver", "डेनवर" },
            { "timezone.excity.America/Guyana", "गुयाना" },
            { "timezone.excity.America/Havana", "हवाना" },
            { "timezone.excity.America/Inuvik", "इनूविक" },
            { "timezone.excity.America/Juneau", "ज्यूनाउ" },
            { "timezone.excity.America/La_Paz", "ला पाज़" },
            { "timezone.excity.America/Maceio", "मेसीओ" },
            { "timezone.excity.America/Manaus", "मनौस" },
            { "timezone.excity.America/Merida", "मेरिडा" },
            { "timezone.excity.America/Nassau", "नासाउ" },
            { "timezone.excity.America/Panama", "पनामा" },
            { "timezone.excity.America/Recife", "रेसाइफ़" },
            { "timezone.excity.America/Regina", "रेजिना" },
            { "timezone.excity.Asia/Famagusta", "फ़ामागुस्ता" },
            { "timezone.excity.Asia/Hong_Kong", "हाँग काँग" },
            { "timezone.excity.Asia/Jerusalem", "यरूशलम" },
            { "timezone.excity.Asia/Kamchatka", "कमचत्का" },
            { "timezone.excity.Asia/Pontianak", "पोंटीयांक" },
            { "timezone.excity.Asia/Pyongyang", "प्योंगयांग" },
            { "timezone.excity.Asia/Qyzylorda", "केज़ेलोर्डा" },
            { "timezone.excity.Asia/Samarkand", "समरकंद" },
            { "timezone.excity.Asia/Singapore", "सिंगापुर" },
            { "timezone.excity.Asia/Vientiane", "विएनतियान" },
            { "timezone.excity.Europe/Andorra", "अंडोरा" },
            { "timezone.excity.Europe/Saratov", "सारातोव" },
            { "timezone.excity.Europe/Tallinn", "तेलिन" },
            { "timezone.excity.Europe/Vatican", "वेटिकन" },
            { "timezone.excity.Europe/Vilnius", "विल्नियस" },
            { "timezone.excity.Indian/Mayotte", "मायोत्ते" },
            { "timezone.excity.Indian/Reunion", "रीयूनियन" },
            { "timezone.excity.Pacific/Easter", "ईस्टर" },
            { "timezone.excity.Pacific/Kosrae", "कोसराए" },
            { "timezone.excity.Pacific/Majuro", "माजुरो" },
            { "timezone.excity.Pacific/Midway", "मिडवे" },
            { "timezone.excity.Pacific/Noumea", "नौमिया" },
            { "timezone.excity.Pacific/Ponape", "पोनपेई" },
            { "timezone.excity.Pacific/Saipan", "सायपान" },
            { "timezone.excity.Pacific/Tahiti", "ताहिती" },
            { "timezone.excity.Pacific/Tarawa", "टारावा" },
            { "timezone.excity.Pacific/Wallis", "वालिस" },
            { "timezone.excity.Africa/Blantyre", "ब्लांटायर" },
            { "timezone.excity.Africa/Djibouti", "जिबूती" },
            { "timezone.excity.Africa/El_Aaiun", "अल आइयून" },
            { "timezone.excity.Africa/Freetown", "फ़्रीटाउन" },
            { "timezone.excity.Africa/Gaborone", "गाबोरोन" },
            { "timezone.excity.Africa/Khartoum", "खार्तूम" },
            { "timezone.excity.Africa/Kinshasa", "किंशासा" },
            { "timezone.excity.Africa/Monrovia", "मोनरोविया" },
            { "timezone.excity.Africa/Ndjamena", "नेद्जामीना" },
            { "timezone.excity.Africa/Sao_Tome", "साओ टोम" },
            { "timezone.excity.Africa/Windhoek", "विंडहोक" },
            { "timezone.excity.America/Antigua", "एंटीगुआ" },
            { "timezone.excity.America/Caracas", "काराकस" },
            { "timezone.excity.America/Cayenne", "कायेन" },
            { "timezone.excity.America/Chicago", "शिकागो" },
            { "timezone.excity.America/Cordoba", "कोर्डोबा" },
            { "timezone.excity.America/Creston", "क्रेस्टन" },
            { "timezone.excity.America/Curacao", "कुराकाओ" },
            { "timezone.excity.America/Detroit", "डेट्रॉयट" },
            { "timezone.excity.America/Godthab", "नुक" },
            { "timezone.excity.America/Grenada", "ग्रेनाडा" },
            { "timezone.excity.America/Halifax", "हेलिफ़ैक्स" },
            { "timezone.excity.America/Iqaluit", "इकालुईट" },
            { "timezone.excity.America/Jamaica", "जमैका" },
            { "timezone.excity.America/Managua", "मानागुआ" },
            { "timezone.excity.America/Marigot", "मैरीगोट" },
            { "timezone.excity.America/Mendoza", "मेंडोज़ा" },
            { "timezone.excity.America/Moncton", "मोंकटन" },
            { "timezone.excity.America/Noronha", "नोरोन्हा" },
            { "timezone.excity.America/Ojinaga", "ओखाजीनागा" },
            { "timezone.excity.America/Phoenix", "फ़ीनिक्स" },
            { "timezone.excity.America/Tijuana", "तिजुआना" },
            { "timezone.excity.America/Toronto", "टोरंटो" },
            { "timezone.excity.America/Tortola", "टोर्टोला" },
            { "timezone.excity.America/Yakutat", "याकूटाट" },
            { "timezone.excity.Asia/Phnom_Penh", "नोम पेन्ह" },
            { "timezone.excity.Atlantic/Azores", "अज़ोरेस" },
            { "timezone.excity.Atlantic/Canary", "कैनेरी" },
            { "timezone.excity.Atlantic/Faeroe", "फ़ैरो" },
            { "timezone.excity.Australia/Eucla", "यूक्ला" },
            { "timezone.excity.Australia/Perth", "पर्थ" },
            { "timezone.excity.Europe/Belgrade", "बेलग्रेड" },
            { "timezone.excity.Europe/Brussels", "ब्रूसेल्स" },
            { "timezone.excity.Europe/Budapest", "बुडापेस्ट" },
            { "timezone.excity.Europe/Busingen", "ब्यूसिनजेन" },
            { "timezone.excity.Europe/Chisinau", "चिसीनाउ" },
            { "timezone.excity.Europe/Guernsey", "गर्नसी" },
            { "timezone.excity.Europe/Helsinki", "हेलसिंकी" },
            { "timezone.excity.Europe/Istanbul", "इस्तांबुल" },
            { "timezone.excity.Europe/Sarajevo", "साराजेवो" },
            { "timezone.excity.Indian/Maldives", "मालदीव" },
            { "timezone.excity.Pacific/Chatham", "चैथम" },
            { "timezone.excity.Pacific/Fakaofo", "फ़ाकाओफ़ो" },
            { "timezone.excity.Pacific/Gambier", "गैंबियर" },
            { "timezone.excity.Pacific/Norfolk", "नॉरफ़ॉक" },
            { "timezone.excity.Africa/Bujumbura", "बुजुंबूरा" },
            { "timezone.excity.Africa/Mogadishu", "मोगादिशु" },
            { "timezone.excity.America/Anguilla", "एंग्विला" },
            { "timezone.excity.America/Asuncion", "एसनशियॉन" },
            { "timezone.excity.America/Barbados", "बारबाडोस" },
            { "timezone.excity.America/Dominica", "डोमिनिका" },
            { "timezone.excity.America/Edmonton", "एडमंटन" },
            { "timezone.excity.America/Eirunepe", "ईरुनेपे" },
            { "timezone.excity.America/Mazatlan", "मज़ाटलान" },
            { "timezone.excity.America/Miquelon", "मिकेलॉन" },
            { "timezone.excity.America/New_York", "न्यूयॉर्क" },
            { "timezone.excity.America/Resolute", "रिसोल्यूट" },
            { "timezone.excity.America/Santarem", "सैंटारेम" },
            { "timezone.excity.America/Santiago", "सैंटियागो" },
            { "timezone.excity.America/St_Johns", "सेंट जोंस" },
            { "timezone.excity.America/St_Kitts", "सेंट किट्स" },
            { "timezone.excity.America/St_Lucia", "सेंट लूसिया" },
            { "timezone.excity.America/Winnipeg", "विनीपेग" },
            { "timezone.excity.Antarctica/Casey", "केसी" },
            { "timezone.excity.Antarctica/Davis", "डेविस" },
            { "timezone.excity.Antarctica/Syowa", "स्योवा" },
            { "timezone.excity.Antarctica/Troll", "ट्रोल" },
            { "timezone.excity.Asia/Krasnoyarsk", "क्रास्नोयार्स्क" },
            { "timezone.excity.Asia/Novosibirsk", "नोवोसिबिर्स्क" },
            { "timezone.excity.Asia/Ulaanbaatar", "उलानबातर" },
            { "timezone.excity.Asia/Vladivostok", "व्लादिवोस्तोक" },
            { "timezone.excity.Atlantic/Bermuda", "बरमूडा" },
            { "timezone.excity.Atlantic/Madeira", "मडेरा" },
            { "timezone.excity.Atlantic/Stanley", "स्टैनली" },
            { "timezone.excity.Australia/Darwin", "डार्विन" },
            { "timezone.excity.Australia/Hobart", "होबार्ट" },
            { "timezone.excity.Australia/Sydney", "सिडनी" },
            { "timezone.excity.Europe/Amsterdam", "एम्स्टरडम" },
            { "timezone.excity.Europe/Astrakhan", "आस्ट्राखान" },
            { "timezone.excity.Europe/Bucharest", "बुख़ारेस्ट" },
            { "timezone.excity.Europe/Gibraltar", "जिब्राल्टर" },
            { "timezone.excity.Europe/Ljubljana", "ल्यूबेलजाना" },
            { "timezone.excity.Europe/Mariehamn", "मारियाहैम" },
            { "timezone.excity.Europe/Podgorica", "पोड्गोरिका" },
            { "timezone.excity.Europe/Stockholm", "स्टॉकहोम" },
            { "timezone.excity.Europe/Ulyanovsk", "उल्यानोव्स्क" },
            { "timezone.excity.Europe/Volgograd", "वोल्गोग्राड" },
            { "timezone.excity.Indian/Christmas", "क्रिसमिस" },
            { "timezone.excity.Indian/Kerguelen", "करगुलेन" },
            { "timezone.excity.Indian/Mauritius", "मॉरीशस" },
            { "timezone.excity.Pacific/Auckland", "ऑकलैंड" },
            { "timezone.excity.Pacific/Funafuti", "फ़्यूनाफ़ुटी" },
            { "timezone.excity.Pacific/Pitcairn", "पिटकैर्न" },
            { "timezone.excity.Africa/Casablanca", "कासाब्लांका" },
            { "timezone.excity.Africa/Libreville", "लिब्रेविले" },
            { "timezone.excity.Africa/Lubumbashi", "लुबुमबाशी" },
            { "timezone.excity.Africa/Nouakchott", "नौआकशॉट" },
            { "timezone.excity.Africa/Porto-Novo", "पोर्टो-नोवो" },
            { "timezone.excity.America/Anchorage", "एंकरेज" },
            { "timezone.excity.America/Araguaina", "आराग्वेना" },
            { "timezone.excity.America/Boa_Vista", "बोआ विस्ता" },
            { "timezone.excity.America/Catamarca", "काटामार्का" },
            { "timezone.excity.America/Chihuahua", "चिहुआहुआ" },
            { "timezone.excity.America/Fortaleza", "फ़ोर्टालेज़ा" },
            { "timezone.excity.America/Glace_Bay", "ग्लेस खाड़ी" },
            { "timezone.excity.America/Goose_Bay", "गूस खाड़ी" },
            { "timezone.excity.America/Guatemala", "ग्वाटेमाला" },
            { "timezone.excity.America/Guayaquil", "ग्वायाकील" },
            { "timezone.excity.America/Matamoros", "माटामोरोस" },
            { "timezone.excity.America/Menominee", "मेनोमिनी" },
            { "timezone.excity.America/Monterrey", "मोंटेरेरी" },
            { "timezone.excity.America/Sao_Paulo", "साओ पाउलो" },
            { "timezone.excity.America/St_Thomas", "सेंट थॉमस" },
            { "timezone.excity.America/Vancouver", "वैंकूवर" },
            { "timezone.excity.Antarctica/Mawson", "मॉसन" },
            { "timezone.excity.Antarctica/Palmer", "पॉमर" },
            { "timezone.excity.Antarctica/Vostok", "वोस्तोक" },
            { "timezone.excity.Asia/Kuala_Lumpur", "कुआलालंपुर" },
            { "timezone.excity.Asia/Novokuznetsk", "नोवोकुज़्नेत्स्क" },
            { "timezone.excity.Europe/Bratislava", "ब्रातिस्लावा" },
            { "timezone.excity.Europe/Copenhagen", "कोपेनहेगन" },
            { "timezone.excity.Europe/Luxembourg", "लक्ज़मबर्ग" },
            { "timezone.excity.Europe/San_Marino", "सैन मारीनो" },
            { "timezone.excity.Europe/Simferopol", "सिम्फ़ेरोपोल" },
            { "timezone.excity.Pacific/Enderbury", "कैंटन" },
            { "timezone.excity.Pacific/Galapagos", "गेलापागोस" },
            { "timezone.excity.Pacific/Kwajalein", "क्वाज़ालीन" },
            { "timezone.excity.Pacific/Marquesas", "मार्केसस" },
            { "timezone.excity.Pacific/Pago_Pago", "पागो गंगो" },
            { "timezone.excity.Pacific/Rarotonga", "रारोटोंगा" },
            { "timezone.excity.Pacific/Tongatapu", "टोंगाटापू" },
            { "timezone.excity.Africa/Addis_Ababa", "अदीस अबाबा" },
            { "timezone.excity.Africa/Brazzaville", "ब्राज़ाविले" },
            { "timezone.excity.Africa/Ouagadougou", "औगाडोगू" },
            { "timezone.excity.America/Costa_Rica", "कोस्टा रिका" },
            { "timezone.excity.America/Grand_Turk", "ग्रांड टर्क" },
            { "timezone.excity.America/Guadeloupe", "ग्वाडेलोप" },
            { "timezone.excity.America/Hermosillo", "हर्मोसिल्लो" },
            { "timezone.excity.America/Kralendijk", "क्रालैंडिजिक" },
            { "timezone.excity.America/Louisville", "लुइसविले" },
            { "timezone.excity.America/Martinique", "मार्टिनिक" },
            { "timezone.excity.America/Metlakatla", "मेट्लेकाट्ला" },
            { "timezone.excity.America/Montevideo", "मोंटेवीडियो" },
            { "timezone.excity.America/Montserrat", "मोंटसेरात" },
            { "timezone.excity.America/Paramaribo", "पारामारिबो" },
            { "timezone.excity.America/Rio_Branco", "रियो ब्रांको" },
            { "timezone.excity.America/St_Vincent", "सेंट विंसेंट" },
            { "timezone.excity.America/Whitehorse", "व्हाइटहोर्स" },
            { "timezone.excity.Antarctica/McMurdo", "मैकमुर्डो" },
            { "timezone.excity.Antarctica/Rothera", "रोथेरा" },
            { "timezone.excity.Asia/Srednekolymsk", "स्रेद्निकोलिमस्क" },
            { "timezone.excity.Asia/Yekaterinburg", "येकातेरिनबर्ग" },
            { "timezone.excity.Atlantic/Reykjavik", "रेक्याविक" },
            { "timezone.excity.Atlantic/St_Helena", "सेंट हेलेना" },
            { "timezone.excity.Australia/Adelaide", "एडिलेड" },
            { "timezone.excity.Australia/Brisbane", "ब्रिस्बन" },
            { "timezone.excity.Australia/Lindeman", "लिंडेमान" },
            { "timezone.excity.Europe/Isle_of_Man", "आइल ऑफ़ मैन" },
            { "timezone.excity.Europe/Kaliningrad", "कालीनिनग्राड" },
            { "timezone.excity.Pacific/Kiritimati", "किरीतिमाति" },
            { "timezone.excity.Africa/Johannesburg", "जोहांसबर्ग" },
            { "timezone.excity.America/El_Salvador", "अल सल्वाडोर" },
            { "timezone.excity.America/Fort_Nelson", "फ़ोर्ट नेल्सन" },
            { "timezone.excity.America/Los_Angeles", "लॉस एंजिल्स" },
            { "timezone.excity.America/Mexico_City", "मेक्सिको सिटी" },
            { "timezone.excity.America/Porto_Velho", "पोर्टो वेल्हो" },
            { "timezone.excity.America/Puerto_Rico", "पोर्टो रिको" },
            { "timezone.excity.America/Tegucigalpa", "टेगुसिगल्पा" },
            { "timezone.excity.Arctic/Longyearbyen", "लॉन्गईयरबायेन" },
            { "timezone.excity.Atlantic/Cape_Verde", "केप वर्ड" },
            { "timezone.excity.Australia/Lord_Howe", "लॉर्ड होवे" },
            { "timezone.excity.Australia/Melbourne", "मेलबोर्न" },
            { "timezone.excity.Indian/Antananarivo", "एंटानानरीवो" },
            { "timezone.excity.Pacific/Guadalcanal", "ग्वाडलकनाल" },
            { "timezone.excity.Africa/Dar_es_Salaam", "दार अस सलाम" },
            { "timezone.excity.America/Blanc-Sablon", "ब्लांक-सेबलोन" },
            { "timezone.excity.America/Buenos_Aires", "ब्यूनस आयरस" },
            { "timezone.excity.America/Campo_Grande", "कैंपो ग्रांडे" },
            { "timezone.excity.America/Danmarkshavn", "डेनमार्कशॉन" },
            { "timezone.excity.America/Dawson_Creek", "डॉसन क्रीक" },
            { "timezone.excity.America/Indiana/Knox", "नौक्स, इंडियाना" },
            { "timezone.excity.America/Indianapolis", "इंडियानापोलिस" },
            { "timezone.excity.America/Punta_Arenas", "पुंटा एरिनास" },
            { "timezone.excity.America/Rankin_Inlet", "रेंकिन इनलेट" },
            { "timezone.excity.America/Scoresbysund", "इटोकोर्टोरमिट" },
            { "timezone.excity.Antarctica/Macquarie", "मक्वारी" },
            { "timezone.excity.Pacific/Bougainville", "बोगनविले" },
            { "timezone.excity.Pacific/Port_Moresby", "पोर्ट मोरेस्बी" },
            { "timezone.excity.America/Cambridge_Bay", "कैम्ब्रिज खाड़ी" },
            { "timezone.excity.America/Coral_Harbour", "अटिकोकान" },
            { "timezone.excity.America/Indiana/Vevay", "वेवे, इंडियाना" },
            { "timezone.excity.America/Lower_Princes", "लोअर प्रिंसेस क्वार्टर" },
            { "timezone.excity.America/Port_of_Spain", "पोर्ट ऑफ़ स्पेन" },
            { "timezone.excity.America/Santo_Domingo", "सेंटो डोमिंगो" },
            { "timezone.excity.America/St_Barthelemy", "सेंट बार्थेलेमी" },
            { "timezone.excity.America/Swift_Current", "स्विफ़्ट करंट" },
            { "timezone.excity.Australia/Broken_Hill", "ब्रोकन हिल" },
            { "timezone.excity.America/Bahia_Banderas", "बेहिया बांडेरास" },
            { "timezone.excity.America/Port-au-Prince", "पोर्ट-ऑ-प्रिंस" },
            { "timezone.excity.Atlantic/South_Georgia", "दखणी जॉर्जिया" },
            { "timezone.excity.America/Argentina/Salta", "साल्टा" },
            { "timezone.excity.America/Indiana/Marengo", "मारेंगो, इंडियाना" },
            { "timezone.excity.America/Indiana/Winamac", "विनामेक, इंडियाना" },
            { "timezone.excity.America/Argentina/Tucuman", "टोकूमन" },
            { "timezone.excity.America/Argentina/Ushuaia", "उशुआइया" },
            { "timezone.excity.America/Indiana/Tell_City", "टेल सिटी, इंडियाना" },
            { "timezone.excity.America/Indiana/Vincennes", "विंसेनेस, इंडियाना" },
            { "timezone.excity.Antarctica/DumontDUrville", "ड्यूमोंट डी अर्विले" },
            { "timezone.excity.America/Argentina/La_Rioja", "ला रिओजा" },
            { "timezone.excity.America/Argentina/San_Juan", "सैन ह्वान" },
            { "timezone.excity.America/Argentina/San_Luis", "सैन लूई" },
            { "timezone.excity.America/Indiana/Petersburg", "पीटर्सबर्ग, इंडियाना" },
            { "timezone.excity.America/Kentucky/Monticello", "मोंटीसेलो, केंटकी" },
            { "timezone.excity.America/North_Dakota/Beulah", "ब्यूला, उत्तरी डकोटा" },
            { "timezone.excity.America/North_Dakota/Center", "मध्य, उत्तरी दाकोता" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "रियो गालेगोस" },
            { "timezone.excity.America/North_Dakota/New_Salem", "न्यू सालेम, उत्तरी डकोटा" },
        };
        return data;
    }
}
