/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: vm_region_submap_info_64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class vm_region_submap_info_64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _behaviorOffset_;
	public static final int _external_pagerOffset_;
	public static final int _inheritanceOffset_;
	public static final int _is_submapOffset_;
	public static final int _max_protectionOffset_;
	public static final int _object_idOffset_;
	public static final int _object_id_fullOffset_;
	public static final int _offsetOffset_;
	public static final int _pages_dirtiedOffset_;
	public static final int _pages_residentOffset_;
	public static final int _pages_reusableOffset_;
	public static final int _pages_shared_now_privateOffset_;
	public static final int _pages_swapped_outOffset_;
	public static final int _protectionOffset_;
	public static final int _ref_countOffset_;
	public static final int _shadow_depthOffset_;
	public static final int _share_modeOffset_;
	public static final int _user_tagOffset_;
	public static final int _user_wired_countOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_behaviorOffset_ = 0;
		_external_pagerOffset_ = 0;
		_inheritanceOffset_ = 0;
		_is_submapOffset_ = 0;
		_max_protectionOffset_ = 0;
		_object_idOffset_ = 0;
		_object_id_fullOffset_ = 0;
		_offsetOffset_ = 0;
		_pages_dirtiedOffset_ = 0;
		_pages_residentOffset_ = 0;
		_pages_reusableOffset_ = 0;
		_pages_shared_now_privateOffset_ = 0;
		_pages_swapped_outOffset_ = 0;
		_protectionOffset_ = 0;
		_ref_countOffset_ = 0;
		_shadow_depthOffset_ = 0;
		_share_modeOffset_ = 0;
		_user_tagOffset_ = 0;
		_user_wired_countOffset_ = 0;
	}

}
