/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.net;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class SimpleSSLContext {
    private static final String DEFAULT_PROTOCOL = "TLS";
    private static final String DEFAULT_KEY_STORE_FILE_REL_PATH = "jdk/test/lib/net/testkeys";

    private SimpleSSLContext() {
    }

    public static SSLContext findSSLContext() {
        return SimpleSSLContext.findSSLContext(DEFAULT_PROTOCOL);
    }

    public static SSLContext findSSLContext(String protocol) {
        Objects.requireNonNull(protocol);
        return SimpleSSLContext.findSSLContext(DEFAULT_KEY_STORE_FILE_REL_PATH, protocol);
    }

    public static SSLContext findSSLContext(String keyStoreFileRelPath, String protocol) {
        Objects.requireNonNull(keyStoreFileRelPath);
        Objects.requireNonNull(protocol);
        String sourcePaths = System.getProperty("test.src.path");
        for (Object sourcePath : Collections.list(new StringTokenizer(sourcePaths, File.pathSeparator))) {
            Path keyStoreFileAbsPath = Path.of((String)sourcePath, keyStoreFileRelPath);
            if (!Files.exists(keyStoreFileAbsPath, new LinkOption[0])) continue;
            return SimpleSSLContext.loadSSLContext(keyStoreFileAbsPath, protocol);
        }
        throw new RuntimeException("Could not find any key store at source path(s) '%s' using key store file relative path '%s'".formatted(sourcePaths, keyStoreFileRelPath));
    }

    private static SSLContext loadSSLContext(Path keyStoreFilePath, String protocol) {
        SSLContext sSLContext;
        block8: {
            InputStream storeStream = Files.newInputStream(keyStoreFilePath, new OpenOption[0]);
            try {
                char[] passphrase = "passphrase".toCharArray();
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(storeStream, passphrase);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
                kmf.init(ks, passphrase);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                tmf.init(ks);
                SSLContext sslContext = SSLContext.getInstance(protocol);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                sSLContext = sslContext;
                if (storeStream == null) break block8;
            }
            catch (Throwable passphrase) {
                try {
                    if (storeStream != null) {
                        try {
                            storeStream.close();
                        }
                        catch (Throwable throwable) {
                            passphrase.addSuppressed(throwable);
                        }
                    }
                    throw passphrase;
                }
                catch (Exception e) {
                    String message = "Failed loading 'SSLContext' from key store at location '%s' for protocol '%s'".formatted(keyStoreFilePath, protocol);
                    throw new RuntimeException(message, e);
                }
            }
            storeStream.close();
        }
        return sSLContext;
    }
}

