/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jdk.test.lib.JDKToolFinder;
import jdk.test.lib.Utils;
import jdk.test.lib.cds.CDSOptions;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;
import jtreg.SkippedException;

public class CDSTestUtils {
    public static final String MSG_RANGE_NOT_WITHIN_HEAP = "Unable to allocate region, range is not within java heap.";
    public static final String MSG_RANGE_ALREADT_IN_USE = "Unable to allocate region, java heap range is already in use.";
    public static final String MSG_DYNAMIC_NOT_SUPPORTED = "-XX:ArchiveClassesAtExit is unsupported when base CDS archive is not loaded";
    public static final String MSG_STATIC_FIELD_MAY_HOLD_DIFFERENT_VALUE = "an object points to a static field that may hold a different value at runtime";
    public static final boolean DYNAMIC_DUMP = Boolean.getBoolean("test.dynamic.cds.archive");
    static int logCounter = 0;
    public static final boolean copyChildStdoutToMainStdout = Boolean.getBoolean("test.cds.copy.child.stdout");
    public static final String UnableToMapMsg = "Unable to map shared archive: test did not complete";
    private static final String outputDir = System.getProperty("user.dir", ".");
    private static final File outputDirAsFile = new File(outputDir);
    private static String testName = Utils.TEST_NAME.replace('/', '.');
    private static final SimpleDateFormat timeStampFormat = new SimpleDateFormat("HH'h'mm'm'ss's'SSS");
    private static String defaultArchiveName;
    private static String[] phCopied;

    private static int getNextLogCounter() {
        return logCounter++;
    }

    public static OutputAnalyzer createArchive(String ... cliPrefix) throws Exception {
        return CDSTestUtils.createArchive(new CDSOptions().addPrefix(cliPrefix));
    }

    public static OutputAnalyzer createArchive(CDSOptions opts) throws Exception {
        CDSTestUtils.startNewArchiveName();
        ArrayList<Object> cmd = new ArrayList<Object>();
        for (String p : opts.prefix) {
            cmd.add(p);
        }
        cmd.add("-Xshare:dump");
        cmd.add("-Xlog:cds,aot+hashtables");
        if (opts.archiveName == null) {
            opts.archiveName = CDSTestUtils.getDefaultArchiveName();
        }
        cmd.add("-XX:SharedArchiveFile=" + opts.archiveName);
        if (opts.classList != null) {
            File classListFile = CDSTestUtils.makeClassList(opts.classList);
            cmd.add("-XX:ExtraSharedClassListFile=" + classListFile.getPath());
        }
        for (String s : opts.suffix) {
            cmd.add(s);
        }
        String[] cmdLine = cmd.toArray(new String[cmd.size()]);
        ProcessBuilder pb = ProcessTools.createTestJavaProcessBuilder(cmdLine);
        return CDSTestUtils.executeAndLog(pb, "dump");
    }

    public static boolean isDynamicArchive() {
        return DYNAMIC_DUMP;
    }

    public static OutputAnalyzer checkDump(OutputAnalyzer output, String ... extraMatches) throws Exception {
        if (!DYNAMIC_DUMP) {
            output.shouldContain("Loading classes to share");
        } else {
            output.shouldContain("Written dynamic archive 0x");
        }
        output.shouldHaveExitValue(0);
        output.shouldNotContain(MSG_STATIC_FIELD_MAY_HOLD_DIFFERENT_VALUE);
        for (String match : extraMatches) {
            output.shouldContain(match);
        }
        return output;
    }

    public static OutputAnalyzer checkBaseDump(OutputAnalyzer output) throws Exception {
        output.shouldContain("Loading classes to share");
        output.shouldHaveExitValue(0);
        output.shouldNotContain(MSG_STATIC_FIELD_MAY_HOLD_DIFFERENT_VALUE);
        return output;
    }

    public static OutputAnalyzer createArchiveAndCheck(CDSOptions opts) throws Exception {
        return CDSTestUtils.checkDump(CDSTestUtils.createArchive(opts), new String[0]);
    }

    public static OutputAnalyzer createArchiveAndCheck(String ... cliPrefix) throws Exception {
        return CDSTestUtils.checkDump(CDSTestUtils.createArchive(cliPrefix), new String[0]);
    }

    public static void checkCommonExecExceptions(OutputAnalyzer output, Exception e) throws Exception {
        if (output.getStdout().contains("https://bugreport.java.com/bugreport/crash.jsp")) {
            throw new RuntimeException("Hotspot crashed");
        }
        if (output.getStdout().contains("TEST FAILED")) {
            throw new RuntimeException("Test Failed");
        }
        if (output.getOutput().contains("Unable to unmap shared space")) {
            throw new RuntimeException("Unable to unmap shared space");
        }
        CDSTestUtils.checkMappingFailure(output);
        if (e != null) {
            throw e;
        }
    }

    public static void checkCommonExecExceptions(OutputAnalyzer output) throws Exception {
        CDSTestUtils.checkCommonExecExceptions(output, null);
    }

    private static String hasUnableToMapMessage(OutputAnalyzer output) {
        String outStr = output.getOutput();
        if (output.getExitValue() == 1) {
            if (outStr.contains(MSG_RANGE_NOT_WITHIN_HEAP)) {
                return MSG_RANGE_NOT_WITHIN_HEAP;
            }
            if (outStr.contains(MSG_DYNAMIC_NOT_SUPPORTED)) {
                return MSG_DYNAMIC_NOT_SUPPORTED;
            }
        }
        return null;
    }

    public static boolean isUnableToMap(OutputAnalyzer output) {
        return CDSTestUtils.hasUnableToMapMessage(output) != null;
    }

    public static void checkMappingFailure(OutputAnalyzer out) throws SkippedException {
        String match = CDSTestUtils.hasUnableToMapMessage(out);
        if (match != null) {
            throw new SkippedException("Unable to map shared archive: test did not complete: " + match);
        }
    }

    public static Result run(String ... cliPrefix) throws Exception {
        CDSOptions opts = new CDSOptions();
        opts.setArchiveName(CDSTestUtils.getDefaultArchiveName());
        opts.addPrefix(cliPrefix);
        return new Result(opts, CDSTestUtils.runWithArchive(opts));
    }

    public static Result run(CDSOptions opts) throws Exception {
        return new Result(opts, CDSTestUtils.runWithArchive(opts));
    }

    public static Result dumpClassList(String classListName, String ... cli) throws Exception {
        CDSOptions opts = new CDSOptions().setUseVersion(false).setXShareMode("auto").addPrefix("-XX:DumpLoadedClassList=" + classListName).addSuffix(cli);
        Result res = CDSTestUtils.run(opts).assertNormalExit(new String[0]);
        return res;
    }

    public static OutputAnalyzer runWithArchive(String ... cliPrefix) throws Exception {
        return CDSTestUtils.runWithArchive(new CDSOptions().setArchiveName(CDSTestUtils.getDefaultArchiveName()).addPrefix(cliPrefix));
    }

    public static void addVerifyArchivedFields(ArrayList<String> cmd) {
        cmd.add("-XX:+UnlockDiagnosticVMOptions");
        cmd.add("-XX:VerifyArchivedFields=1");
    }

    public static OutputAnalyzer runWithArchive(CDSOptions opts) throws Exception {
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.addAll(opts.prefix);
        cmd.add("-Xshare:" + opts.xShareMode);
        cmd.add("-Dtest.timeout.factor=" + Utils.TIMEOUT_FACTOR);
        if (!opts.useSystemArchive) {
            if (opts.archiveName == null) {
                opts.archiveName = CDSTestUtils.getDefaultArchiveName();
            }
            cmd.add("-XX:SharedArchiveFile=" + opts.archiveName);
        }
        if (opts.useVersion) {
            cmd.add("-version");
        }
        for (String s : opts.suffix) {
            cmd.add(s);
        }
        String[] cmdLine = cmd.toArray(new String[cmd.size()]);
        ProcessBuilder pb = ProcessTools.createTestJavaProcessBuilder(cmdLine);
        return CDSTestUtils.executeAndLog(pb, "exec");
    }

    public static OutputAnalyzer runWithArchiveAndCheck(CDSOptions opts) throws Exception {
        return CDSTestUtils.checkExec(CDSTestUtils.runWithArchive(opts), new String[0]);
    }

    public static OutputAnalyzer runWithArchiveAndCheck(String ... cliPrefix) throws Exception {
        return CDSTestUtils.checkExec(CDSTestUtils.runWithArchive(cliPrefix), new String[0]);
    }

    public static OutputAnalyzer checkExec(OutputAnalyzer output, String ... extraMatches) throws Exception {
        CDSOptions opts = new CDSOptions();
        return CDSTestUtils.checkExec(output, opts, extraMatches);
    }

    public static OutputAnalyzer checkExec(OutputAnalyzer output, CDSOptions opts, String ... extraMatches) throws Exception {
        try {
            if ("on".equals(opts.xShareMode)) {
                output.shouldContain("sharing");
            }
            output.shouldHaveExitValue(0);
        }
        catch (RuntimeException e) {
            CDSTestUtils.checkCommonExecExceptions(output, e);
            return output;
        }
        CDSTestUtils.checkMatches(output, extraMatches);
        return output;
    }

    public static OutputAnalyzer checkExecExpectError(OutputAnalyzer output, int expectedExitValue, String ... extraMatches) throws Exception {
        CDSTestUtils.checkMappingFailure(output);
        output.shouldHaveExitValue(expectedExitValue);
        CDSTestUtils.checkMatches(output, extraMatches);
        return output;
    }

    public static OutputAnalyzer checkMatches(OutputAnalyzer output, String ... matches) throws Exception {
        for (String match : matches) {
            output.shouldContain(match);
        }
        return output;
    }

    public static String getOutputDir() {
        return outputDir;
    }

    public static File getOutputDirAsFile() {
        return outputDirAsFile;
    }

    public static File getTestArtifact(String name, boolean checkExistence) {
        File file = new File(outputDirAsFile, name);
        if (checkExistence && !file.exists()) {
            throw new RuntimeException("Cannot find " + file.getPath());
        }
        return file;
    }

    public static File makeClassList(String[] classes) throws Exception {
        return CDSTestUtils.makeClassList(testName + "-", classes);
    }

    public static File makeClassList(String testCaseName, String[] classes) throws Exception {
        File classList = CDSTestUtils.getTestArtifact(testCaseName + "test.classlist", false);
        FileOutputStream fos = new FileOutputStream(classList);
        PrintStream ps = new PrintStream(fos);
        CDSTestUtils.addToClassList(ps, classes);
        ps.close();
        fos.close();
        return classList;
    }

    public static void addToClassList(PrintStream ps, String[] classes) throws IOException {
        if (classes != null) {
            for (String s : classes) {
                ps.println(s);
            }
        }
    }

    public static void startNewArchiveName() {
        defaultArchiveName = testName + timeStampFormat.format(new Date()) + ".jsa";
    }

    public static String getDefaultArchiveName() {
        return defaultArchiveName;
    }

    public static File getOutputFile(String name) {
        return new File(outputDirAsFile, testName + "-" + name);
    }

    public static String getOutputFileName(String name) {
        return CDSTestUtils.getOutputFile(name).getName();
    }

    public static File getOutputSourceFile(String name) {
        return new File(outputDirAsFile, name);
    }

    public static File getSourceFile(String name) {
        File dir = new File(System.getProperty("test.src", "."));
        return new File(dir, name);
    }

    public static boolean isRunningWithArchive(List<String> cmd) {
        if (!cmd.get(0).equals(JDKToolFinder.getJDKTool("java")) || cmd.size() < 2) {
            return false;
        }
        for (int i = cmd.size() - 1; i >= 1; --i) {
            String s = cmd.get(i);
            if (!s.equals("-Xshare:dump") && !s.equals("-Xshare:off")) continue;
            return false;
        }
        return true;
    }

    public static boolean isGCOption(String s) {
        return s.startsWith("-XX:+Use") && s.endsWith("GC");
    }

    public static boolean hasGCOption(List<String> cmd) {
        for (String s : cmd) {
            if (!CDSTestUtils.isGCOption(s)) continue;
            return true;
        }
        return false;
    }

    public static void handleCDSRuntimeOptions(ProcessBuilder pb) {
        List<String> cmd = pb.command();
        String jtropts = System.getProperty("test.cds.runtime.options");
        if (jtropts != null && CDSTestUtils.isRunningWithArchive(cmd)) {
            ArrayList<String> cdsRuntimeOpts = new ArrayList<String>();
            boolean hasGCOption = CDSTestUtils.hasGCOption(cmd);
            for (String s : jtropts.split(",")) {
                if (CDSOptions.disabledRuntimePrefixes.contains(s) || hasGCOption && CDSTestUtils.isGCOption(s)) continue;
                cdsRuntimeOpts.add(s);
            }
            pb.command().addAll(1, cdsRuntimeOpts);
        }
    }

    public static OutputAnalyzer executeAndLog(ProcessBuilder pb, String logName) throws Exception {
        CDSTestUtils.handleCDSRuntimeOptions(pb);
        return CDSTestUtils.executeAndLog(pb.start(), logName);
    }

    public static OutputAnalyzer executeAndLog(Process process, String logName) throws Exception {
        long started = System.currentTimeMillis();
        OutputAnalyzer output = new OutputAnalyzer(process);
        String logFileNameStem = String.format("%04d", CDSTestUtils.getNextLogCounter()) + "-" + logName;
        File stdout = CDSTestUtils.getOutputFile(logFileNameStem + ".stdout");
        File stderr = CDSTestUtils.getOutputFile(logFileNameStem + ".stderr");
        CDSTestUtils.writeFile(stdout, output.getStdout());
        CDSTestUtils.writeFile(stderr, output.getStderr());
        System.out.println("[ELAPSED: " + (System.currentTimeMillis() - started) + " ms]");
        System.out.println("[logging stdout to " + String.valueOf(stdout) + "]");
        System.out.println("[logging stderr to " + String.valueOf(stderr) + "]");
        System.out.println("[STDERR]\n" + output.getStderr());
        if (copyChildStdoutToMainStdout) {
            System.out.println("[STDOUT]\n" + output.getStdout());
        }
        if (output.getExitValue() != 0 && output.getStdout().contains("A fatal error has been detected")) {
            throw new RuntimeException("Hotspot crashed");
        }
        return output;
    }

    private static void writeFile(File file, String content) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        PrintStream ps = new PrintStream(fos);
        ps.print(content);
        ps.close();
        fos.close();
    }

    public static String formatArchiveConfigSymbol(String symbol) {
        int refCount = -1;
        if (CDSTestUtils.isAsciiPrintable(symbol)) {
            return symbol.length() + " " + refCount + ": " + symbol;
        }
        StringBuilder sb = new StringBuilder();
        int utf8_length = CDSTestUtils.escapeArchiveConfigString(sb, symbol);
        return utf8_length + " " + refCount + ": " + sb.toString();
    }

    private static int escapeArchiveConfigString(StringBuilder sb, String s) {
        byte[] arr;
        try {
            arr = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected", e);
        }
        for (int i = 0; i < arr.length; ++i) {
            char ch = (char)(arr[i] & 0xFF);
            if (CDSTestUtils.isAsciiPrintable(ch)) {
                sb.append(ch);
                continue;
            }
            if (ch == '\t') {
                sb.append("\\t");
                continue;
            }
            if (ch == '\r') {
                sb.append("\\r");
                continue;
            }
            if (ch == '\n') {
                sb.append("\\n");
                continue;
            }
            if (ch == '\\') {
                sb.append("\\\\");
                continue;
            }
            String hex = Integer.toHexString(ch);
            if (ch < '\u0010') {
                sb.append("\\x0");
            } else {
                sb.append("\\x");
            }
            sb.append(hex);
        }
        return arr.length;
    }

    private static boolean isAsciiPrintable(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (CDSTestUtils.isAsciiPrintable(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static void clone(File src, File dst) throws Exception {
        if (dst.exists()) {
            if (!dst.isDirectory()) {
                throw new RuntimeException("Not a directory :" + String.valueOf(dst));
            }
        } else if (!dst.mkdir()) {
            throw new RuntimeException("Cannot create directory: " + String.valueOf(dst));
        }
        for (String child : src.list()) {
            if (child.equals(".") || child.equals("..")) continue;
            File child_src = new File(src, child);
            File child_dst = new File(dst, child);
            if (child_dst.exists()) {
                throw new RuntimeException("Already exists: " + String.valueOf(child_dst));
            }
            if (child_src.isFile()) {
                boolean needPhCopy = false;
                for (String target : phCopied) {
                    if (!child.equals(target)) continue;
                    needPhCopy = true;
                    break;
                }
                if (needPhCopy) {
                    Files.copy(child_src.toPath(), child_dst.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    continue;
                }
                Files.createSymbolicLink(child_dst.toPath(), child_src.toPath(), new FileAttribute[0]);
                continue;
            }
            CDSTestUtils.clone(child_src, child_dst);
        }
    }

    public static void rename(File fromFile, File toFile) throws Exception {
        if (!fromFile.exists()) {
            throw new RuntimeException(fromFile.getName() + " does not exist");
        }
        if (toFile.exists()) {
            throw new RuntimeException(toFile.getName() + " already exists");
        }
        boolean success = fromFile.renameTo(toFile);
        if (!success) {
            throw new RuntimeException("rename file " + fromFile.getName() + " to " + toFile.getName() + " failed");
        }
    }

    public static ProcessBuilder makeBuilder(String ... args) throws Exception {
        System.out.print("[");
        for (String s : args) {
            System.out.print(" " + s);
        }
        System.out.println(" ]");
        return new ProcessBuilder(args);
    }

    public static Path copyFile(String srcFile, String destDir) throws Exception {
        int idx = srcFile.lastIndexOf(File.separator);
        String jarName = srcFile.substring(idx + 1);
        Path srcPath = Paths.get(jarName, new String[0]);
        Path newPath = Paths.get(destDir, new String[0]);
        Path newDir = !Files.exists(newPath, new LinkOption[0]) ? Files.createDirectories(newPath, new FileAttribute[0]) : newPath;
        Path destPath = newDir.resolve(jarName);
        Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        return destPath;
    }

    public static boolean isAOTClassLinkingEnabled() {
        return CDSTestUtils.isBooleanVMOptionEnabledInCommandLine("AOTClassLinking");
    }

    public static boolean isBooleanVMOptionEnabledInCommandLine(String optionName) {
        String lastMatch = null;
        String pattern = "^-XX:." + optionName + "$";
        for (String s : Utils.getTestJavaOpts()) {
            if (!s.matches(pattern)) continue;
            lastMatch = s;
        }
        return lastMatch != null && lastMatch.equals("-XX:+" + optionName);
    }

    static {
        phCopied = new String[]{System.mapLibraryName("jvm"), "java", "jvm.cfg"};
    }

    public static class Result {
        private final OutputAnalyzer output;
        private final CDSOptions options;
        private final boolean hasNormalExit;
        private final String CDS_DISABLED = "warning: CDS is disabled when the";

        public Result(CDSOptions opts, OutputAnalyzer out) throws Exception {
            CDSTestUtils.checkMappingFailure(out);
            this.options = opts;
            this.output = out;
            boolean bl = this.hasNormalExit = this.output.getExitValue() == 0;
            if (this.hasNormalExit && "on".equals(this.options.xShareMode) && this.output.getStderr().contains("java version") && !this.output.getStderr().contains("warning: CDS is disabled when the")) {
                this.output.shouldContain("sharing");
            }
        }

        public Result assertNormalExit(Checker checker) throws Exception {
            checker.check(this.output);
            this.output.shouldHaveExitValue(0);
            return this;
        }

        public Result assertAbnormalExit(Checker checker) throws Exception {
            checker.check(this.output);
            this.output.shouldNotHaveExitValue(0);
            return this;
        }

        public Result assertSilentlyDisabledCDS(Checker checker) throws Exception {
            this.output.shouldContain("warning: CDS is disabled when the");
            checker.check(this.output);
            return this;
        }

        public Result assertSilentlyDisabledCDS(int exitCode, String ... matches) throws Exception {
            return this.assertSilentlyDisabledCDS(out -> {
                out.shouldHaveExitValue(exitCode);
                CDSTestUtils.checkMatches(out, matches);
            });
        }

        public Result ifNormalExit(Checker checker) throws Exception {
            if (this.hasNormalExit) {
                checker.check(this.output);
            }
            return this;
        }

        public Result ifAbnormalExit(Checker checker) throws Exception {
            if (!this.hasNormalExit) {
                checker.check(this.output);
            }
            return this;
        }

        public Result ifNoMappingFailure(Checker checker) throws Exception {
            checker.check(this.output);
            return this;
        }

        public Result assertNormalExit(String ... matches) throws Exception {
            CDSTestUtils.checkMatches(this.output, matches);
            this.output.shouldHaveExitValue(0);
            return this;
        }

        public Result assertAbnormalExit(String ... matches) throws Exception {
            CDSTestUtils.checkMatches(this.output, matches);
            this.output.shouldNotHaveExitValue(0);
            return this;
        }
    }

    public static interface Checker {
        public void check(OutputAnalyzer var1) throws Exception;
    }
}

