/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: API_VERSIONPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the API_VERSIONPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=API_VERSION.class)
public class API_VERSIONPointer extends StructurePointer {

	// NULL
	public static final API_VERSIONPointer NULL = new API_VERSIONPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected API_VERSIONPointer(long address) {
		super(address);
	}

	public static API_VERSIONPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static API_VERSIONPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static API_VERSIONPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new API_VERSIONPointer(address);
	}

	public API_VERSIONPointer add(long count) {
		return API_VERSIONPointer.cast(address + (API_VERSION.SIZEOF * count));
	}

	public API_VERSIONPointer add(Scalar count) {
		return add(count.longValue());
	}

	public API_VERSIONPointer addOffset(long offset) {
		return API_VERSIONPointer.cast(address + offset);
	}

	public API_VERSIONPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public API_VERSIONPointer sub(long count) {
		return API_VERSIONPointer.cast(address - (API_VERSION.SIZEOF * count));
	}

	public API_VERSIONPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public API_VERSIONPointer subOffset(long offset) {
		return API_VERSIONPointer.cast(address - offset);
	}

	public API_VERSIONPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public API_VERSIONPointer untag(long mask) {
		return API_VERSIONPointer.cast(address & ~mask);
	}

	public API_VERSIONPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return API_VERSION.SIZEOF;
	}

	// Implementation methods

	// U16 MajorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MajorVersionOffset_", declaredType="U16")
	public U16 MajorVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(API_VERSION._MajorVersionOffset_));
	}

	// U16 MajorVersion
	public U16Pointer MajorVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(API_VERSION._MajorVersionOffset_));
	}

	// U16 MinorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MinorVersionOffset_", declaredType="U16")
	public U16 MinorVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(API_VERSION._MinorVersionOffset_));
	}

	// U16 MinorVersion
	public U16Pointer MinorVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(API_VERSION._MinorVersionOffset_));
	}

	// U16 Reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReservedOffset_", declaredType="U16")
	public U16 Reserved() throws CorruptDataException {
		return new U16(getShortAtOffset(API_VERSION._ReservedOffset_));
	}

	// U16 Reserved
	public U16Pointer ReservedEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(API_VERSION._ReservedOffset_));
	}

	// U16 Revision
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RevisionOffset_", declaredType="U16")
	public U16 Revision() throws CorruptDataException {
		return new U16(getShortAtOffset(API_VERSION._RevisionOffset_));
	}

	// U16 Revision
	public U16Pointer RevisionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(API_VERSION._RevisionOffset_));
	}

}
