/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GC_ContinuationSlotIteratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GC_ContinuationSlotIteratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GC_ContinuationSlotIterator.class)
public class GC_ContinuationSlotIteratorPointer extends StructurePointer {

	// NULL
	public static final GC_ContinuationSlotIteratorPointer NULL = new GC_ContinuationSlotIteratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GC_ContinuationSlotIteratorPointer(long address) {
		super(address);
	}

	public static GC_ContinuationSlotIteratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GC_ContinuationSlotIteratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GC_ContinuationSlotIteratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new GC_ContinuationSlotIteratorPointer(address);
	}

	public GC_ContinuationSlotIteratorPointer add(long count) {
		return GC_ContinuationSlotIteratorPointer.cast(address + (GC_ContinuationSlotIterator.SIZEOF * count));
	}

	public GC_ContinuationSlotIteratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GC_ContinuationSlotIteratorPointer addOffset(long offset) {
		return GC_ContinuationSlotIteratorPointer.cast(address + offset);
	}

	public GC_ContinuationSlotIteratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GC_ContinuationSlotIteratorPointer sub(long count) {
		return GC_ContinuationSlotIteratorPointer.cast(address - (GC_ContinuationSlotIterator.SIZEOF * count));
	}

	public GC_ContinuationSlotIteratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GC_ContinuationSlotIteratorPointer subOffset(long offset) {
		return GC_ContinuationSlotIteratorPointer.cast(address - offset);
	}

	public GC_ContinuationSlotIteratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GC_ContinuationSlotIteratorPointer untag(long mask) {
		return GC_ContinuationSlotIteratorPointer.cast(address & ~mask);
	}

	public GC_ContinuationSlotIteratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GC_ContinuationSlotIterator.SIZEOF;
	}

	// Implementation methods

	// J9MonitorEnterRecord* _jniMonitorRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__jniMonitorRecordOffset_", declaredType="J9MonitorEnterRecord*")
	public J9MonitorEnterRecordPointer _jniMonitorRecord() throws CorruptDataException {
		return J9MonitorEnterRecordPointer.cast(getPointerAtOffset(GC_ContinuationSlotIterator.__jniMonitorRecordOffset_));
	}

	// J9MonitorEnterRecord* _jniMonitorRecord
	public PointerPointer _jniMonitorRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_ContinuationSlotIterator.__jniMonitorRecordOffset_));
	}

	// J9MonitorEnterRecord* _monitorRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__monitorRecordOffset_", declaredType="J9MonitorEnterRecord*")
	public J9MonitorEnterRecordPointer _monitorRecord() throws CorruptDataException {
		return J9MonitorEnterRecordPointer.cast(getPointerAtOffset(GC_ContinuationSlotIterator.__monitorRecordOffset_));
	}

	// J9MonitorEnterRecord* _monitorRecord
	public PointerPointer _monitorRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_ContinuationSlotIterator.__monitorRecordOffset_));
	}

	// GC_ContinuationSlotIterator$State _state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stateOffset_", declaredType="GC_ContinuationSlotIterator$State")
	public long _state() throws CorruptDataException {
		if (GC_ContinuationSlotIterator$State.SIZEOF == 1) {
			return getByteAtOffset(GC_ContinuationSlotIterator.__stateOffset_);
		} else if (GC_ContinuationSlotIterator$State.SIZEOF == 2) {
			return getShortAtOffset(GC_ContinuationSlotIterator.__stateOffset_);
		} else if (GC_ContinuationSlotIterator$State.SIZEOF == 4) {
			return getIntAtOffset(GC_ContinuationSlotIterator.__stateOffset_);
		} else if (GC_ContinuationSlotIterator$State.SIZEOF == 8) {
			return getLongAtOffset(GC_ContinuationSlotIterator.__stateOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// GC_ContinuationSlotIterator$State _state
	public EnumPointer _stateEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(GC_ContinuationSlotIterator.__stateOffset_), GC_ContinuationSlotIterator$State.class);
	}

	// J9VMThread* _vmThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vmThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer _vmThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(GC_ContinuationSlotIterator.__vmThreadOffset_));
	}

	// J9VMThread* _vmThread
	public PointerPointer _vmThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_ContinuationSlotIterator.__vmThreadOffset_));
	}

	// void** _vthread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vthreadOffset_", declaredType="void**")
	public PointerPointer _vthread() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(GC_ContinuationSlotIterator.__vthreadOffset_));
	}

	// void** _vthread
	public PointerPointer _vthreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_ContinuationSlotIterator.__vthreadOffset_));
	}

}
