/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9SharedClassJavacoreDataDescriptorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9SharedClassJavacoreDataDescriptorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9SharedClassJavacoreDataDescriptor.class)
public class J9SharedClassJavacoreDataDescriptorPointer extends StructurePointer {

	// NULL
	public static final J9SharedClassJavacoreDataDescriptorPointer NULL = new J9SharedClassJavacoreDataDescriptorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9SharedClassJavacoreDataDescriptorPointer(long address) {
		super(address);
	}

	public static J9SharedClassJavacoreDataDescriptorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9SharedClassJavacoreDataDescriptorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9SharedClassJavacoreDataDescriptorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9SharedClassJavacoreDataDescriptorPointer(address);
	}

	public J9SharedClassJavacoreDataDescriptorPointer add(long count) {
		return J9SharedClassJavacoreDataDescriptorPointer.cast(address + (J9SharedClassJavacoreDataDescriptor.SIZEOF * count));
	}

	public J9SharedClassJavacoreDataDescriptorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9SharedClassJavacoreDataDescriptorPointer addOffset(long offset) {
		return J9SharedClassJavacoreDataDescriptorPointer.cast(address + offset);
	}

	public J9SharedClassJavacoreDataDescriptorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9SharedClassJavacoreDataDescriptorPointer sub(long count) {
		return J9SharedClassJavacoreDataDescriptorPointer.cast(address - (J9SharedClassJavacoreDataDescriptor.SIZEOF * count));
	}

	public J9SharedClassJavacoreDataDescriptorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9SharedClassJavacoreDataDescriptorPointer subOffset(long offset) {
		return J9SharedClassJavacoreDataDescriptorPointer.cast(address - offset);
	}

	public J9SharedClassJavacoreDataDescriptorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9SharedClassJavacoreDataDescriptorPointer untag(long mask) {
		return J9SharedClassJavacoreDataDescriptorPointer.cast(address & ~mask);
	}

	public J9SharedClassJavacoreDataDescriptorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9SharedClassJavacoreDataDescriptor.SIZEOF;
	}

	// Implementation methods

	// U64 aotBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_aotBytesOffset_", declaredType="U64")
	public UDATA aotBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._aotBytesOffset_));
	}

	// U64 aotBytes
	public UDATAPointer aotBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._aotBytesOffset_));
	}

	// U64 aotClassChainDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_aotClassChainDataBytesOffset_", declaredType="U64")
	public UDATA aotClassChainDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._aotClassChainDataBytesOffset_));
	}

	// U64 aotClassChainDataBytes
	public UDATAPointer aotClassChainDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._aotClassChainDataBytesOffset_));
	}

	// U64 aotDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_aotDataBytesOffset_", declaredType="U64")
	public UDATA aotDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._aotDataBytesOffset_));
	}

	// U64 aotDataBytes
	public UDATAPointer aotDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._aotDataBytesOffset_));
	}

	// U64 aotThunkDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_aotThunkDataBytesOffset_", declaredType="U64")
	public UDATA aotThunkDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._aotThunkDataBytesOffset_));
	}

	// U64 aotThunkDataBytes
	public UDATAPointer aotThunkDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._aotThunkDataBytesOffset_));
	}

	// const U8* cacheDir
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacheDirOffset_", declaredType="const U8*")
	public U8Pointer cacheDir() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._cacheDirOffset_));
	}

	// const U8* cacheDir
	public PointerPointer cacheDirEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._cacheDirOffset_));
	}

	// void* cacheEndAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacheEndAddressOffset_", declaredType="void*")
	public VoidPointer cacheEndAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._cacheEndAddressOffset_));
	}

	// void* cacheEndAddress
	public PointerPointer cacheEndAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._cacheEndAddressOffset_));
	}

	// U64 cacheGen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacheGenOffset_", declaredType="U64")
	public UDATA cacheGen() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._cacheGenOffset_));
	}

	// U64 cacheGen
	public UDATAPointer cacheGenEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._cacheGenOffset_));
	}

	// const U8* cacheName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacheNameOffset_", declaredType="const U8*")
	public U8Pointer cacheName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._cacheNameOffset_));
	}

	// const U8* cacheName
	public PointerPointer cacheNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._cacheNameOffset_));
	}

	// U64 cacheSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacheSizeOffset_", declaredType="U64")
	public UDATA cacheSize() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._cacheSizeOffset_));
	}

	// U64 cacheSize
	public UDATAPointer cacheSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._cacheSizeOffset_));
	}

	// U64 ccCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ccCountOffset_", declaredType="U64")
	public UDATA ccCount() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._ccCountOffset_));
	}

	// U64 ccCount
	public UDATAPointer ccCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._ccCountOffset_));
	}

	// U64 ccStartedCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ccStartedCountOffset_", declaredType="U64")
	public UDATA ccStartedCount() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._ccStartedCountOffset_));
	}

	// U64 ccStartedCount
	public UDATAPointer ccStartedCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._ccStartedCountOffset_));
	}

	// U64 corruptValue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_corruptValueOffset_", declaredType="U64")
	public UDATA corruptValue() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._corruptValueOffset_));
	}

	// U64 corruptValue
	public UDATAPointer corruptValueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._corruptValueOffset_));
	}

	// I64 corruptionCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_corruptionCodeOffset_", declaredType="I64")
	public IDATA corruptionCode() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._corruptionCodeOffset_));
	}

	// I64 corruptionCode
	public IDATAPointer corruptionCodeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._corruptionCodeOffset_));
	}

	// U64 currentOSPageSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_currentOSPageSizeOffset_", declaredType="U64")
	public UDATA currentOSPageSize() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._currentOSPageSizeOffset_));
	}

	// U64 currentOSPageSize
	public UDATAPointer currentOSPageSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._currentOSPageSizeOffset_));
	}

	// U64 debugAreaLineNumberTableBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_debugAreaLineNumberTableBytesOffset_", declaredType="U64")
	public UDATA debugAreaLineNumberTableBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._debugAreaLineNumberTableBytesOffset_));
	}

	// U64 debugAreaLineNumberTableBytes
	public UDATAPointer debugAreaLineNumberTableBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._debugAreaLineNumberTableBytesOffset_));
	}

	// U64 debugAreaLocalVariableTableBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_debugAreaLocalVariableTableBytesOffset_", declaredType="U64")
	public UDATA debugAreaLocalVariableTableBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._debugAreaLocalVariableTableBytesOffset_));
	}

	// U64 debugAreaLocalVariableTableBytes
	public UDATAPointer debugAreaLocalVariableTableBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._debugAreaLocalVariableTableBytesOffset_));
	}

	// U64 debugAreaSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_debugAreaSizeOffset_", declaredType="U64")
	public UDATA debugAreaSize() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._debugAreaSizeOffset_));
	}

	// U64 debugAreaSize
	public UDATAPointer debugAreaSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._debugAreaSizeOffset_));
	}

	// U64 debugAreaUsed
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_debugAreaUsedOffset_", declaredType="U64")
	public UDATA debugAreaUsed() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._debugAreaUsedOffset_));
	}

	// U64 debugAreaUsed
	public UDATAPointer debugAreaUsedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._debugAreaUsedOffset_));
	}

	// U64 extraFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_extraFlagsOffset_", declaredType="U64")
	public UDATA extraFlags() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._extraFlagsOffset_));
	}

	// U64 extraFlags
	public UDATAPointer extraFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._extraFlagsOffset_));
	}

	// U32 extraStartupHints
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_extraStartupHintsOffset_", declaredType="U32")
	public UDATA extraStartupHints() throws CorruptDataException {
		return new U32(getIntAtOffset(J9SharedClassJavacoreDataDescriptor._extraStartupHintsOffset_));
	}

	// U32 extraStartupHints
	public UDATAPointer extraStartupHintsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._extraStartupHintsOffset_));
	}

	// U32 feature
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_featureOffset_", declaredType="U32")
	public UDATA feature() throws CorruptDataException {
		return new U32(getIntAtOffset(J9SharedClassJavacoreDataDescriptor._featureOffset_));
	}

	// U32 feature
	public UDATAPointer featureEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._featureOffset_));
	}

	// U64 freeBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_freeBytesOffset_", declaredType="U64")
	public UDATA freeBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._freeBytesOffset_));
	}

	// U64 freeBytes
	public UDATAPointer freeBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._freeBytesOffset_));
	}

	// U64 indexedDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexedDataBytesOffset_", declaredType="U64")
	public UDATA indexedDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._indexedDataBytesOffset_));
	}

	// U64 indexedDataBytes
	public UDATAPointer indexedDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._indexedDataBytesOffset_));
	}

	// U64 jclDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jclDataBytesOffset_", declaredType="U64")
	public UDATA jclDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._jclDataBytesOffset_));
	}

	// U64 jclDataBytes
	public UDATAPointer jclDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._jclDataBytesOffset_));
	}

	// U64 jitHintDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jitHintDataBytesOffset_", declaredType="U64")
	public UDATA jitHintDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._jitHintDataBytesOffset_));
	}

	// U64 jitHintDataBytes
	public UDATAPointer jitHintDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._jitHintDataBytesOffset_));
	}

	// U64 jitProfileDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jitProfileDataBytesOffset_", declaredType="U64")
	public UDATA jitProfileDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._jitProfileDataBytesOffset_));
	}

	// U64 jitProfileDataBytes
	public UDATAPointer jitProfileDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._jitProfileDataBytesOffset_));
	}

	// I64 maxAOT
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxAOTOffset_", declaredType="I64")
	public IDATA maxAOT() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._maxAOTOffset_));
	}

	// I64 maxAOT
	public IDATAPointer maxAOTEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._maxAOTOffset_));
	}

	// I64 maxJIT
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxJITOffset_", declaredType="I64")
	public IDATA maxJIT() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._maxJITOffset_));
	}

	// I64 maxJIT
	public IDATAPointer maxJITEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._maxJITOffset_));
	}

	// void* metadataStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_metadataStartOffset_", declaredType="void*")
	public VoidPointer metadataStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._metadataStartOffset_));
	}

	// void* metadataStart
	public PointerPointer metadataStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._metadataStartOffset_));
	}

	// I64 minAOT
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minAOTOffset_", declaredType="I64")
	public IDATA minAOT() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._minAOTOffset_));
	}

	// I64 minAOT
	public IDATAPointer minAOTEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._minAOTOffset_));
	}

	// I64 minJIT
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minJITOffset_", declaredType="I64")
	public IDATA minJIT() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._minJITOffset_));
	}

	// I64 minJIT
	public IDATAPointer minJITEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._minJITOffset_));
	}

	// U64 nattach
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nattachOffset_", declaredType="U64")
	public UDATA nattach() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._nattachOffset_));
	}

	// U64 nattach
	public UDATAPointer nattachEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._nattachOffset_));
	}

	// U64 numAOTMethods
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numAOTMethodsOffset_", declaredType="U64")
	public UDATA numAOTMethods() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numAOTMethodsOffset_));
	}

	// U64 numAOTMethods
	public UDATAPointer numAOTMethodsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numAOTMethodsOffset_));
	}

	// U64 numAotClassChains
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numAotClassChainsOffset_", declaredType="U64")
	public UDATA numAotClassChains() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numAotClassChainsOffset_));
	}

	// U64 numAotClassChains
	public UDATAPointer numAotClassChainsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numAotClassChainsOffset_));
	}

	// U64 numAotDataEntries
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numAotDataEntriesOffset_", declaredType="U64")
	public UDATA numAotDataEntries() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numAotDataEntriesOffset_));
	}

	// U64 numAotDataEntries
	public UDATAPointer numAotDataEntriesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numAotDataEntriesOffset_));
	}

	// U64 numAotThunks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numAotThunksOffset_", declaredType="U64")
	public UDATA numAotThunks() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numAotThunksOffset_));
	}

	// U64 numAotThunks
	public UDATAPointer numAotThunksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numAotThunksOffset_));
	}

	// U64 numClasspaths
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numClasspathsOffset_", declaredType="U64")
	public UDATA numClasspaths() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numClasspathsOffset_));
	}

	// U64 numClasspaths
	public UDATAPointer numClasspathsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numClasspathsOffset_));
	}

	// U64 numJclEntries
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numJclEntriesOffset_", declaredType="U64")
	public UDATA numJclEntries() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numJclEntriesOffset_));
	}

	// U64 numJclEntries
	public UDATAPointer numJclEntriesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numJclEntriesOffset_));
	}

	// U64 numJitHints
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numJitHintsOffset_", declaredType="U64")
	public UDATA numJitHints() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numJitHintsOffset_));
	}

	// U64 numJitHints
	public UDATAPointer numJitHintsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numJitHintsOffset_));
	}

	// U64 numJitProfiles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numJitProfilesOffset_", declaredType="U64")
	public UDATA numJitProfiles() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numJitProfilesOffset_));
	}

	// U64 numJitProfiles
	public UDATAPointer numJitProfilesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numJitProfilesOffset_));
	}

	// U64 numObjects
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numObjectsOffset_", declaredType="U64")
	public UDATA numObjects() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numObjectsOffset_));
	}

	// U64 numObjects
	public UDATAPointer numObjectsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numObjectsOffset_));
	}

	// U64 numROMClasses
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numROMClassesOffset_", declaredType="U64")
	public UDATA numROMClasses() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numROMClassesOffset_));
	}

	// U64 numROMClasses
	public UDATAPointer numROMClassesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numROMClassesOffset_));
	}

	// U64 numStaleClasses
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numStaleClassesOffset_", declaredType="U64")
	public UDATA numStaleClasses() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numStaleClassesOffset_));
	}

	// U64 numStaleClasses
	public UDATAPointer numStaleClassesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numStaleClassesOffset_));
	}

	// U64 numStartupHints
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numStartupHintsOffset_", declaredType="U64")
	public UDATA numStartupHints() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numStartupHintsOffset_));
	}

	// U64 numStartupHints
	public UDATAPointer numStartupHintsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numStartupHintsOffset_));
	}

	// U64 numTokens
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numTokensOffset_", declaredType="U64")
	public UDATA numTokens() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numTokensOffset_));
	}

	// U64 numTokens
	public UDATAPointer numTokensEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numTokensOffset_));
	}

	// U64 numURLs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numURLsOffset_", declaredType="U64")
	public UDATA numURLs() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numURLsOffset_));
	}

	// U64 numURLs
	public UDATAPointer numURLsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numURLsOffset_));
	}

	// U64 numZipCaches
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numZipCachesOffset_", declaredType="U64")
	public UDATA numZipCaches() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._numZipCachesOffset_));
	}

	// U64 numZipCaches
	public UDATAPointer numZipCachesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._numZipCachesOffset_));
	}

	// U64 objectBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_objectBytesOffset_", declaredType="U64")
	public UDATA objectBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._objectBytesOffset_));
	}

	// U64 objectBytes
	public UDATAPointer objectBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._objectBytesOffset_));
	}

	// U64 otherBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_otherBytesOffset_", declaredType="U64")
	public UDATA otherBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._otherBytesOffset_));
	}

	// U64 otherBytes
	public UDATAPointer otherBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._otherBytesOffset_));
	}

	// U64 percFull
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_percFullOffset_", declaredType="U64")
	public UDATA percFull() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._percFullOffset_));
	}

	// U64 percFull
	public UDATAPointer percFullEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._percFullOffset_));
	}

	// U64 percStale
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_percStaleOffset_", declaredType="U64")
	public UDATA percStale() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._percStaleOffset_));
	}

	// U64 percStale
	public UDATAPointer percStaleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._percStaleOffset_));
	}

	// U64 readWriteBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_readWriteBytesOffset_", declaredType="U64")
	public UDATA readWriteBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._readWriteBytesOffset_));
	}

	// U64 readWriteBytes
	public UDATAPointer readWriteBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._readWriteBytesOffset_));
	}

	// void* readWriteLockTID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_readWriteLockTIDOffset_", declaredType="void*")
	public VoidPointer readWriteLockTID() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._readWriteLockTIDOffset_));
	}

	// void* readWriteLockTID
	public PointerPointer readWriteLockTIDEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._readWriteLockTIDOffset_));
	}

	// U64 romClassBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_romClassBytesOffset_", declaredType="U64")
	public UDATA romClassBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._romClassBytesOffset_));
	}

	// U64 romClassBytes
	public UDATAPointer romClassBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._romClassBytesOffset_));
	}

	// void* romClassEnd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_romClassEndOffset_", declaredType="void*")
	public VoidPointer romClassEnd() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._romClassEndOffset_));
	}

	// void* romClassEnd
	public PointerPointer romClassEndEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._romClassEndOffset_));
	}

	// void* romClassStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_romClassStartOffset_", declaredType="void*")
	public VoidPointer romClassStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._romClassStartOffset_));
	}

	// void* romClassStart
	public PointerPointer romClassStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._romClassStartOffset_));
	}

	// U64 runtimeFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runtimeFlagsOffset_", declaredType="U64")
	public UDATA runtimeFlags() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._runtimeFlagsOffset_));
	}

	// U64 runtimeFlags
	public UDATAPointer runtimeFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._runtimeFlagsOffset_));
	}

	// I64 semid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_semidOffset_", declaredType="I64")
	public IDATA semid() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._semidOffset_));
	}

	// I64 semid
	public IDATAPointer semidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._semidOffset_));
	}

	// I64 shmid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shmidOffset_", declaredType="I64")
	public IDATA shmid() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._shmidOffset_));
	}

	// I64 shmid
	public IDATAPointer shmidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._shmidOffset_));
	}

	// U64 softMaxBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_softMaxBytesOffset_", declaredType="U64")
	public UDATA softMaxBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._softMaxBytesOffset_));
	}

	// U64 softMaxBytes
	public UDATAPointer softMaxBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._softMaxBytesOffset_));
	}

	// U64 startupHintBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_startupHintBytesOffset_", declaredType="U64")
	public UDATA startupHintBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._startupHintBytesOffset_));
	}

	// U64 startupHintBytes
	public UDATAPointer startupHintBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._startupHintBytesOffset_));
	}

	// U8 topLayer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_topLayerOffset_", declaredType="U8")
	public U8 topLayer() throws CorruptDataException {
		return new U8(getByteAtOffset(J9SharedClassJavacoreDataDescriptor._topLayerOffset_));
	}

	// U8 topLayer
	public U8Pointer topLayerEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._topLayerOffset_));
	}

	// I64 totalSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_totalSizeOffset_", declaredType="I64")
	public IDATA totalSize() throws CorruptDataException {
		return new I64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._totalSizeOffset_));
	}

	// I64 totalSize
	public IDATAPointer totalSizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._totalSizeOffset_));
	}

	// U64 unindexedDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unindexedDataBytesOffset_", declaredType="U64")
	public UDATA unindexedDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._unindexedDataBytesOffset_));
	}

	// U64 unindexedDataBytes
	public UDATAPointer unindexedDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._unindexedDataBytesOffset_));
	}

	// void* writeLockTID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_writeLockTIDOffset_", declaredType="void*")
	public VoidPointer writeLockTID() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassJavacoreDataDescriptor._writeLockTIDOffset_));
	}

	// void* writeLockTID
	public PointerPointer writeLockTIDEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._writeLockTIDOffset_));
	}

	// U64 zipCacheDataBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_zipCacheDataBytesOffset_", declaredType="U64")
	public UDATA zipCacheDataBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(J9SharedClassJavacoreDataDescriptor._zipCacheDataBytesOffset_));
	}

	// U64 zipCacheDataBytes
	public UDATAPointer zipCacheDataBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassJavacoreDataDescriptor._zipCacheDataBytesOffset_));
	}

}
