/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9ZipCacheInternalPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9ZipCacheInternalPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9ZipCacheInternal.class)
public class J9ZipCacheInternalPointer extends StructurePointer {

	// NULL
	public static final J9ZipCacheInternalPointer NULL = new J9ZipCacheInternalPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9ZipCacheInternalPointer(long address) {
		super(address);
	}

	public static J9ZipCacheInternalPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9ZipCacheInternalPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9ZipCacheInternalPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9ZipCacheInternalPointer(address);
	}

	public J9ZipCacheInternalPointer add(long count) {
		return J9ZipCacheInternalPointer.cast(address + (J9ZipCacheInternal.SIZEOF * count));
	}

	public J9ZipCacheInternalPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9ZipCacheInternalPointer addOffset(long offset) {
		return J9ZipCacheInternalPointer.cast(address + offset);
	}

	public J9ZipCacheInternalPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9ZipCacheInternalPointer sub(long count) {
		return J9ZipCacheInternalPointer.cast(address - (J9ZipCacheInternal.SIZEOF * count));
	}

	public J9ZipCacheInternalPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9ZipCacheInternalPointer subOffset(long offset) {
		return J9ZipCacheInternalPointer.cast(address - offset);
	}

	public J9ZipCacheInternalPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9ZipCacheInternalPointer untag(long mask) {
		return J9ZipCacheInternalPointer.cast(address & ~mask);
	}

	public J9ZipCacheInternalPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9ZipCacheInternal.SIZEOF;
	}

	// Implementation methods

	// J9ZipCacheEntry* entry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entryOffset_", declaredType="J9ZipCacheEntry*")
	public J9ZipCacheEntryPointer entry() throws CorruptDataException {
		return J9ZipCacheEntryPointer.cast(getPointerAtOffset(J9ZipCacheInternal._entryOffset_));
	}

	// J9ZipCacheEntry* entry
	public PointerPointer entryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ZipCacheInternal._entryOffset_));
	}

	// J9ZipCache info
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_infoOffset_", declaredType="J9ZipCache")
	public J9ZipCachePointer info() throws CorruptDataException {
		return J9ZipCachePointer.cast(nonNullFieldEA(J9ZipCacheInternal._infoOffset_));
	}

	// J9ZipCache info
	public PointerPointer infoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ZipCacheInternal._infoOffset_));
	}

	// I64 zipFileFd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_zipFileFdOffset_", declaredType="I64")
	public IDATA zipFileFd() throws CorruptDataException {
		return new I64(getLongAtOffset(J9ZipCacheInternal._zipFileFdOffset_));
	}

	// I64 zipFileFd
	public IDATAPointer zipFileFdEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9ZipCacheInternal._zipFileFdOffset_));
	}

	// U8 zipFileType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_zipFileTypeOffset_", declaredType="U8")
	public U8 zipFileType() throws CorruptDataException {
		return new U8(getByteAtOffset(J9ZipCacheInternal._zipFileTypeOffset_));
	}

	// U8 zipFileType
	public U8Pointer zipFileTypeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9ZipCacheInternal._zipFileTypeOffset_));
	}

}
