/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: LocalJ9UTF8BufferPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the LocalJ9UTF8BufferPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=LocalJ9UTF8Buffer.class)
public class LocalJ9UTF8BufferPointer extends StructurePointer {

	// NULL
	public static final LocalJ9UTF8BufferPointer NULL = new LocalJ9UTF8BufferPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected LocalJ9UTF8BufferPointer(long address) {
		super(address);
	}

	public static LocalJ9UTF8BufferPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static LocalJ9UTF8BufferPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static LocalJ9UTF8BufferPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new LocalJ9UTF8BufferPointer(address);
	}

	public LocalJ9UTF8BufferPointer add(long count) {
		return LocalJ9UTF8BufferPointer.cast(address + (LocalJ9UTF8Buffer.SIZEOF * count));
	}

	public LocalJ9UTF8BufferPointer add(Scalar count) {
		return add(count.longValue());
	}

	public LocalJ9UTF8BufferPointer addOffset(long offset) {
		return LocalJ9UTF8BufferPointer.cast(address + offset);
	}

	public LocalJ9UTF8BufferPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public LocalJ9UTF8BufferPointer sub(long count) {
		return LocalJ9UTF8BufferPointer.cast(address - (LocalJ9UTF8Buffer.SIZEOF * count));
	}

	public LocalJ9UTF8BufferPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public LocalJ9UTF8BufferPointer subOffset(long offset) {
		return LocalJ9UTF8BufferPointer.cast(address - offset);
	}

	public LocalJ9UTF8BufferPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public LocalJ9UTF8BufferPointer untag(long mask) {
		return LocalJ9UTF8BufferPointer.cast(address & ~mask);
	}

	public LocalJ9UTF8BufferPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return LocalJ9UTF8Buffer.SIZEOF;
	}

	// Implementation methods

	// U64 capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_capacityOffset_", declaredType="U64")
	public UDATA capacity() throws CorruptDataException {
		return new U64(getLongAtOffset(LocalJ9UTF8Buffer._capacityOffset_));
	}

	// U64 capacity
	public UDATAPointer capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LocalJ9UTF8Buffer._capacityOffset_));
	}

	// U8* cursor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cursorOffset_", declaredType="U8*")
	public U8Pointer cursor() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(LocalJ9UTF8Buffer._cursorOffset_));
	}

	// U8* cursor
	public PointerPointer cursorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(LocalJ9UTF8Buffer._cursorOffset_));
	}

	// J9UTF8* utf8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_utf8Offset_", declaredType="J9UTF8*")
	public J9UTF8Pointer utf8() throws CorruptDataException {
		return J9UTF8Pointer.cast(getPointerAtOffset(LocalJ9UTF8Buffer._utf8Offset_));
	}

	// J9UTF8* utf8
	public PointerPointer utf8EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(LocalJ9UTF8Buffer._utf8Offset_));
	}

}
