/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_ObjectAccessBarrierPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_ObjectAccessBarrierPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_ObjectAccessBarrier.class)
public class MM_ObjectAccessBarrierPointer extends MM_BaseVirtualPointer {

	// NULL
	public static final MM_ObjectAccessBarrierPointer NULL = new MM_ObjectAccessBarrierPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_ObjectAccessBarrierPointer(long address) {
		super(address);
	}

	public static MM_ObjectAccessBarrierPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_ObjectAccessBarrierPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_ObjectAccessBarrierPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_ObjectAccessBarrierPointer(address);
	}

	public MM_ObjectAccessBarrierPointer add(long count) {
		return MM_ObjectAccessBarrierPointer.cast(address + (MM_ObjectAccessBarrier.SIZEOF * count));
	}

	public MM_ObjectAccessBarrierPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_ObjectAccessBarrierPointer addOffset(long offset) {
		return MM_ObjectAccessBarrierPointer.cast(address + offset);
	}

	public MM_ObjectAccessBarrierPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_ObjectAccessBarrierPointer sub(long count) {
		return MM_ObjectAccessBarrierPointer.cast(address - (MM_ObjectAccessBarrier.SIZEOF * count));
	}

	public MM_ObjectAccessBarrierPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_ObjectAccessBarrierPointer subOffset(long offset) {
		return MM_ObjectAccessBarrierPointer.cast(address - offset);
	}

	public MM_ObjectAccessBarrierPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_ObjectAccessBarrierPointer untag(long mask) {
		return MM_ObjectAccessBarrierPointer.cast(address & ~mask);
	}

	public MM_ObjectAccessBarrierPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_ObjectAccessBarrier.SIZEOF;
	}

	// Implementation methods

	// bool _compressObjectReferences
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__compressObjectReferencesOffset_", declaredType="bool")
	public boolean _compressObjectReferences() throws CorruptDataException {
		return getBoolAtOffset(MM_ObjectAccessBarrier.__compressObjectReferencesOffset_);
	}

	// bool _compressObjectReferences
	public BoolPointer _compressObjectReferencesEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_ObjectAccessBarrier.__compressObjectReferencesOffset_));
	}

	// U64 _compressedPointersShift
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__compressedPointersShiftOffset_", declaredType="U64")
	public UDATA _compressedPointersShift() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectAccessBarrier.__compressedPointersShiftOffset_));
	}

	// U64 _compressedPointersShift
	public UDATAPointer _compressedPointersShiftEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAccessBarrier.__compressedPointersShiftOffset_));
	}

	// U64 _continuationLinkOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__continuationLinkOffsetOffset_", declaredType="U64")
	public UDATA _continuationLinkOffset() throws CorruptDataException, NoSuchFieldException {
	try {
		return new U64(getLongAtOffset(MM_ObjectAccessBarrier.__continuationLinkOffsetOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// U64 _continuationLinkOffset
	public UDATAPointer _continuationLinkOffsetEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAccessBarrier.__continuationLinkOffsetOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// MM_GCExtensions* _extensions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__extensionsOffset_", declaredType="MM_GCExtensions*")
	public MM_GCExtensionsPointer _extensions() throws CorruptDataException {
		return MM_GCExtensionsPointer.cast(getPointerAtOffset(MM_ObjectAccessBarrier.__extensionsOffset_));
	}

	// MM_GCExtensions* _extensions
	public PointerPointer _extensionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ObjectAccessBarrier.__extensionsOffset_));
	}

	// MM_Heap* _heap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapOffset_", declaredType="MM_Heap*")
	public MM_HeapPointer _heap() throws CorruptDataException {
		return MM_HeapPointer.cast(getPointerAtOffset(MM_ObjectAccessBarrier.__heapOffset_));
	}

	// MM_Heap* _heap
	public PointerPointer _heapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ObjectAccessBarrier.__heapOffset_));
	}

	// U64 _ownableSynchronizerLinkOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ownableSynchronizerLinkOffsetOffset_", declaredType="U64")
	public UDATA _ownableSynchronizerLinkOffset() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectAccessBarrier.__ownableSynchronizerLinkOffsetOffset_));
	}

	// U64 _ownableSynchronizerLinkOffset
	public UDATAPointer _ownableSynchronizerLinkOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAccessBarrier.__ownableSynchronizerLinkOffsetOffset_));
	}

	// U64 _referenceLinkOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__referenceLinkOffsetOffset_", declaredType="U64")
	public UDATA _referenceLinkOffset() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectAccessBarrier.__referenceLinkOffsetOffset_));
	}

	// U64 _referenceLinkOffset
	public UDATAPointer _referenceLinkOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAccessBarrier.__referenceLinkOffsetOffset_));
	}

}
