/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: StackIteratorData4HeapWalkerPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the StackIteratorData4HeapWalkerPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=StackIteratorData4HeapWalker.class)
public class StackIteratorData4HeapWalkerPointer extends StructurePointer {

	// NULL
	public static final StackIteratorData4HeapWalkerPointer NULL = new StackIteratorData4HeapWalkerPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected StackIteratorData4HeapWalkerPointer(long address) {
		super(address);
	}

	public static StackIteratorData4HeapWalkerPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static StackIteratorData4HeapWalkerPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static StackIteratorData4HeapWalkerPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new StackIteratorData4HeapWalkerPointer(address);
	}

	public StackIteratorData4HeapWalkerPointer add(long count) {
		return StackIteratorData4HeapWalkerPointer.cast(address + (StackIteratorData4HeapWalker.SIZEOF * count));
	}

	public StackIteratorData4HeapWalkerPointer add(Scalar count) {
		return add(count.longValue());
	}

	public StackIteratorData4HeapWalkerPointer addOffset(long offset) {
		return StackIteratorData4HeapWalkerPointer.cast(address + offset);
	}

	public StackIteratorData4HeapWalkerPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public StackIteratorData4HeapWalkerPointer sub(long count) {
		return StackIteratorData4HeapWalkerPointer.cast(address - (StackIteratorData4HeapWalker.SIZEOF * count));
	}

	public StackIteratorData4HeapWalkerPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public StackIteratorData4HeapWalkerPointer subOffset(long offset) {
		return StackIteratorData4HeapWalkerPointer.cast(address - offset);
	}

	public StackIteratorData4HeapWalkerPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public StackIteratorData4HeapWalkerPointer untag(long mask) {
		return StackIteratorData4HeapWalkerPointer.cast(address & ~mask);
	}

	public StackIteratorData4HeapWalkerPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return StackIteratorData4HeapWalker.SIZEOF;
	}

	// Implementation methods

	// MM_EnvironmentBase* env
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_envOffset_", declaredType="MM_EnvironmentBase*")
	public MM_EnvironmentBasePointer env() throws CorruptDataException {
		return MM_EnvironmentBasePointer.cast(getPointerAtOffset(StackIteratorData4HeapWalker._envOffset_));
	}

	// MM_EnvironmentBase* env
	public PointerPointer envEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4HeapWalker._envOffset_));
	}

	// J9Object* fromObject
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fromObjectOffset_", declaredType="J9Object*")
	public J9ObjectPointer fromObject() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(StackIteratorData4HeapWalker._fromObjectOffset_));
	}

	// J9Object* fromObject
	public PointerPointer fromObjectEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4HeapWalker._fromObjectOffset_));
	}

	// void* function
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_functionOffset_", declaredType="void*")
	public VoidPointer function() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(StackIteratorData4HeapWalker._functionOffset_));
	}

	// void* function
	public PointerPointer functionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4HeapWalker._functionOffset_));
	}

	// MM_HeapWalker* heapWalker
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_heapWalkerOffset_", declaredType="MM_HeapWalker*")
	public MM_HeapWalkerPointer heapWalker() throws CorruptDataException {
		return MM_HeapWalkerPointer.cast(getPointerAtOffset(StackIteratorData4HeapWalker._heapWalkerOffset_));
	}

	// MM_HeapWalker* heapWalker
	public PointerPointer heapWalkerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4HeapWalker._heapWalkerOffset_));
	}

	// void* userData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_userDataOffset_", declaredType="void*")
	public VoidPointer userData() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(StackIteratorData4HeapWalker._userDataOffset_));
	}

	// void* userData
	public PointerPointer userDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4HeapWalker._userDataOffset_));
	}

}
