/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ThreadInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ThreadInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ThreadInfo.class)
public class ThreadInfoPointer extends StructurePointer {

	// NULL
	public static final ThreadInfoPointer NULL = new ThreadInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ThreadInfoPointer(long address) {
		super(address);
	}

	public static ThreadInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ThreadInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ThreadInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ThreadInfoPointer(address);
	}

	public ThreadInfoPointer add(long count) {
		return ThreadInfoPointer.cast(address + (ThreadInfo.SIZEOF * count));
	}

	public ThreadInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ThreadInfoPointer addOffset(long offset) {
		return ThreadInfoPointer.cast(address + offset);
	}

	public ThreadInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ThreadInfoPointer sub(long count) {
		return ThreadInfoPointer.cast(address - (ThreadInfo.SIZEOF * count));
	}

	public ThreadInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ThreadInfoPointer subOffset(long offset) {
		return ThreadInfoPointer.cast(address - offset);
	}

	public ThreadInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ThreadInfoPointer untag(long mask) {
		return ThreadInfoPointer.cast(address & ~mask);
	}

	public ThreadInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ThreadInfo.SIZEOF;
	}

	// Implementation methods

	// I64 blockedCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_blockedCountOffset_", declaredType="I64")
	public IDATA blockedCount() throws CorruptDataException {
		return new I64(getLongAtOffset(ThreadInfo._blockedCountOffset_));
	}

	// I64 blockedCount
	public IDATAPointer blockedCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadInfo._blockedCountOffset_));
	}

	// I64 blockedTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_blockedTimeOffset_", declaredType="I64")
	public IDATA blockedTime() throws CorruptDataException {
		return new I64(getLongAtOffset(ThreadInfo._blockedTimeOffset_));
	}

	// I64 blockedTime
	public IDATAPointer blockedTimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadInfo._blockedTimeOffset_));
	}

	// _jobject* blocker
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_blockerOffset_", declaredType="_jobject*")
	public _jobjectPointer blocker() throws CorruptDataException {
		return _jobjectPointer.cast(getPointerAtOffset(ThreadInfo._blockerOffset_));
	}

	// _jobject* blocker
	public PointerPointer blockerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadInfo._blockerOffset_));
	}

	// _jobject* blockerOwner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_blockerOwnerOffset_", declaredType="_jobject*")
	public _jobjectPointer blockerOwner() throws CorruptDataException {
		return _jobjectPointer.cast(getPointerAtOffset(ThreadInfo._blockerOwnerOffset_));
	}

	// _jobject* blockerOwner
	public PointerPointer blockerOwnerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadInfo._blockerOwnerOffset_));
	}

	// I32 jclThreadState
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jclThreadStateOffset_", declaredType="I32")
	public IDATA jclThreadState() throws CorruptDataException {
		return new I32(getIntAtOffset(ThreadInfo._jclThreadStateOffset_));
	}

	// I32 jclThreadState
	public IDATAPointer jclThreadStateEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadInfo._jclThreadStateOffset_));
	}

	// void lockedMonitors
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lockedMonitorsOffset_", declaredType="void")
	public VoidPointer lockedMonitors() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(ThreadInfo._lockedMonitorsOffset_));
	}

	// void lockedMonitors
	public PointerPointer lockedMonitorsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadInfo._lockedMonitorsOffset_));
	}

	// void lockedSynchronizers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lockedSynchronizersOffset_", declaredType="void")
	public VoidPointer lockedSynchronizers() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(ThreadInfo._lockedSynchronizersOffset_));
	}

	// void lockedSynchronizers
	public PointerPointer lockedSynchronizersEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadInfo._lockedSynchronizersOffset_));
	}

	// I64 nativeTID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nativeTIDOffset_", declaredType="I64")
	public IDATA nativeTID() throws CorruptDataException {
		return new I64(getLongAtOffset(ThreadInfo._nativeTIDOffset_));
	}

	// I64 nativeTID
	public IDATAPointer nativeTIDEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadInfo._nativeTIDOffset_));
	}

	// void stack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackOffset_", declaredType="void")
	public VoidPointer stack() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(ThreadInfo._stackOffset_));
	}

	// void stack
	public PointerPointer stackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadInfo._stackOffset_));
	}

	// _jobject* stackTrace
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackTraceOffset_", declaredType="_jobject*")
	public _jobjectPointer stackTrace() throws CorruptDataException {
		return _jobjectPointer.cast(getPointerAtOffset(ThreadInfo._stackTraceOffset_));
	}

	// _jobject* stackTrace
	public PointerPointer stackTraceEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadInfo._stackTraceOffset_));
	}

	// _jobject* thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadOffset_", declaredType="_jobject*")
	public _jobjectPointer thread() throws CorruptDataException {
		return _jobjectPointer.cast(getPointerAtOffset(ThreadInfo._threadOffset_));
	}

	// _jobject* thread
	public PointerPointer threadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadInfo._threadOffset_));
	}

	// U64 vmstate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmstateOffset_", declaredType="U64")
	public UDATA vmstate() throws CorruptDataException {
		return new U64(getLongAtOffset(ThreadInfo._vmstateOffset_));
	}

	// U64 vmstate
	public UDATAPointer vmstateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadInfo._vmstateOffset_));
	}

	// I64 waitedCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_waitedCountOffset_", declaredType="I64")
	public IDATA waitedCount() throws CorruptDataException {
		return new I64(getLongAtOffset(ThreadInfo._waitedCountOffset_));
	}

	// I64 waitedCount
	public IDATAPointer waitedCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadInfo._waitedCountOffset_));
	}

	// I64 waitedTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_waitedTimeOffset_", declaredType="I64")
	public IDATA waitedTime() throws CorruptDataException {
		return new I64(getLongAtOffset(ThreadInfo._waitedTimeOffset_));
	}

	// I64 waitedTime
	public IDATAPointer waitedTimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadInfo._waitedTimeOffset_));
	}

}
