/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: WSADataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the WSADataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=WSAData.class)
public class WSADataPointer extends StructurePointer {

	// NULL
	public static final WSADataPointer NULL = new WSADataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected WSADataPointer(long address) {
		super(address);
	}

	public static WSADataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static WSADataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static WSADataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new WSADataPointer(address);
	}

	public WSADataPointer add(long count) {
		return WSADataPointer.cast(address + (WSAData.SIZEOF * count));
	}

	public WSADataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public WSADataPointer addOffset(long offset) {
		return WSADataPointer.cast(address + offset);
	}

	public WSADataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public WSADataPointer sub(long count) {
		return WSADataPointer.cast(address - (WSAData.SIZEOF * count));
	}

	public WSADataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public WSADataPointer subOffset(long offset) {
		return WSADataPointer.cast(address - offset);
	}

	public WSADataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public WSADataPointer untag(long mask) {
		return WSADataPointer.cast(address & ~mask);
	}

	public WSADataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return WSAData.SIZEOF;
	}

	// Implementation methods

	// U16 iMaxSockets
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iMaxSocketsOffset_", declaredType="U16")
	public U16 iMaxSockets() throws CorruptDataException {
		return new U16(getShortAtOffset(WSAData._iMaxSocketsOffset_));
	}

	// U16 iMaxSockets
	public U16Pointer iMaxSocketsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(WSAData._iMaxSocketsOffset_));
	}

	// U16 iMaxUdpDg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iMaxUdpDgOffset_", declaredType="U16")
	public U16 iMaxUdpDg() throws CorruptDataException {
		return new U16(getShortAtOffset(WSAData._iMaxUdpDgOffset_));
	}

	// U16 iMaxUdpDg
	public U16Pointer iMaxUdpDgEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(WSAData._iMaxUdpDgOffset_));
	}

	// U8* lpVendorInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpVendorInfoOffset_", declaredType="U8*")
	public U8Pointer lpVendorInfo() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(WSAData._lpVendorInfoOffset_));
	}

	// U8* lpVendorInfo
	public PointerPointer lpVendorInfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(WSAData._lpVendorInfoOffset_));
	}

	// U8[] szDescription
	public U8Pointer szDescriptionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(WSAData._szDescriptionOffset_));
	}

	// U8[] szSystemStatus
	public U8Pointer szSystemStatusEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(WSAData._szSystemStatusOffset_));
	}

	// U16 wHighVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wHighVersionOffset_", declaredType="U16")
	public U16 wHighVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(WSAData._wHighVersionOffset_));
	}

	// U16 wHighVersion
	public U16Pointer wHighVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(WSAData._wHighVersionOffset_));
	}

	// U16 wVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wVersionOffset_", declaredType="U16")
	public U16 wVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(WSAData._wVersionOffset_));
	}

	// U16 wVersion
	public U16Pointer wVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(WSAData._wVersionOffset_));
	}

}
