/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IMAGEHLP_MODULE64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IMAGEHLP_MODULE64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IMAGEHLP_MODULE64.class)
public class _IMAGEHLP_MODULE64Pointer extends StructurePointer {

	// NULL
	public static final _IMAGEHLP_MODULE64Pointer NULL = new _IMAGEHLP_MODULE64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IMAGEHLP_MODULE64Pointer(long address) {
		super(address);
	}

	public static _IMAGEHLP_MODULE64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IMAGEHLP_MODULE64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IMAGEHLP_MODULE64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IMAGEHLP_MODULE64Pointer(address);
	}

	public _IMAGEHLP_MODULE64Pointer add(long count) {
		return _IMAGEHLP_MODULE64Pointer.cast(address + (_IMAGEHLP_MODULE64.SIZEOF * count));
	}

	public _IMAGEHLP_MODULE64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IMAGEHLP_MODULE64Pointer addOffset(long offset) {
		return _IMAGEHLP_MODULE64Pointer.cast(address + offset);
	}

	public _IMAGEHLP_MODULE64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IMAGEHLP_MODULE64Pointer sub(long count) {
		return _IMAGEHLP_MODULE64Pointer.cast(address - (_IMAGEHLP_MODULE64.SIZEOF * count));
	}

	public _IMAGEHLP_MODULE64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IMAGEHLP_MODULE64Pointer subOffset(long offset) {
		return _IMAGEHLP_MODULE64Pointer.cast(address - offset);
	}

	public _IMAGEHLP_MODULE64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IMAGEHLP_MODULE64Pointer untag(long mask) {
		return _IMAGEHLP_MODULE64Pointer.cast(address & ~mask);
	}

	public _IMAGEHLP_MODULE64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IMAGEHLP_MODULE64.SIZEOF;
	}

	// Implementation methods

	// U64 BaseOfImage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BaseOfImageOffset_", declaredType="U64")
	public UDATA BaseOfImage() throws CorruptDataException {
		return new U64(getLongAtOffset(_IMAGEHLP_MODULE64._BaseOfImageOffset_));
	}

	// U64 BaseOfImage
	public UDATAPointer BaseOfImageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._BaseOfImageOffset_));
	}

	// U8[] CVData
	public U8Pointer CVDataEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._CVDataOffset_));
	}

	// U32 CVSig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CVSigOffset_", declaredType="U32")
	public UDATA CVSig() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._CVSigOffset_));
	}

	// U32 CVSig
	public UDATAPointer CVSigEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._CVSigOffset_));
	}

	// U32 CheckSum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CheckSumOffset_", declaredType="U32")
	public UDATA CheckSum() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._CheckSumOffset_));
	}

	// U32 CheckSum
	public UDATAPointer CheckSumEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._CheckSumOffset_));
	}

	// I32 DbgUnmatched
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DbgUnmatchedOffset_", declaredType="I32")
	public IDATA DbgUnmatched() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGEHLP_MODULE64._DbgUnmatchedOffset_));
	}

	// I32 DbgUnmatched
	public IDATAPointer DbgUnmatchedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._DbgUnmatchedOffset_));
	}

	// I32 GlobalSymbols
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GlobalSymbolsOffset_", declaredType="I32")
	public IDATA GlobalSymbols() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGEHLP_MODULE64._GlobalSymbolsOffset_));
	}

	// I32 GlobalSymbols
	public IDATAPointer GlobalSymbolsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._GlobalSymbolsOffset_));
	}

	// U8[] ImageName
	public U8Pointer ImageNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._ImageNameOffset_));
	}

	// U32 ImageSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ImageSizeOffset_", declaredType="U32")
	public UDATA ImageSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._ImageSizeOffset_));
	}

	// U32 ImageSize
	public UDATAPointer ImageSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._ImageSizeOffset_));
	}

	// I32 LineNumbers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LineNumbersOffset_", declaredType="I32")
	public IDATA LineNumbers() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGEHLP_MODULE64._LineNumbersOffset_));
	}

	// I32 LineNumbers
	public IDATAPointer LineNumbersEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._LineNumbersOffset_));
	}

	// U8[] LoadedImageName
	public U8Pointer LoadedImageNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._LoadedImageNameOffset_));
	}

	// U8[] LoadedPdbName
	public U8Pointer LoadedPdbNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._LoadedPdbNameOffset_));
	}

	// U32 MachineType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MachineTypeOffset_", declaredType="U32")
	public UDATA MachineType() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._MachineTypeOffset_));
	}

	// U32 MachineType
	public UDATAPointer MachineTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._MachineTypeOffset_));
	}

	// U8[] ModuleName
	public U8Pointer ModuleNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._ModuleNameOffset_));
	}

	// U32 NumSyms
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumSymsOffset_", declaredType="U32")
	public UDATA NumSyms() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._NumSymsOffset_));
	}

	// U32 NumSyms
	public UDATAPointer NumSymsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._NumSymsOffset_));
	}

	// U32 PdbAge
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PdbAgeOffset_", declaredType="U32")
	public UDATA PdbAge() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._PdbAgeOffset_));
	}

	// U32 PdbAge
	public UDATAPointer PdbAgeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._PdbAgeOffset_));
	}

	// U32 PdbSig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PdbSigOffset_", declaredType="U32")
	public UDATA PdbSig() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._PdbSigOffset_));
	}

	// U32 PdbSig
	public UDATAPointer PdbSigEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._PdbSigOffset_));
	}

	// _GUID PdbSig70
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PdbSig70Offset_", declaredType="_GUID")
	public _GUIDPointer PdbSig70() throws CorruptDataException {
		return _GUIDPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._PdbSig70Offset_));
	}

	// _GUID PdbSig70
	public PointerPointer PdbSig70EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._PdbSig70Offset_));
	}

	// I32 PdbUnmatched
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PdbUnmatchedOffset_", declaredType="I32")
	public IDATA PdbUnmatched() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGEHLP_MODULE64._PdbUnmatchedOffset_));
	}

	// I32 PdbUnmatched
	public IDATAPointer PdbUnmatchedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._PdbUnmatchedOffset_));
	}

	// I32 Publics
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PublicsOffset_", declaredType="I32")
	public IDATA Publics() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGEHLP_MODULE64._PublicsOffset_));
	}

	// I32 Publics
	public IDATAPointer PublicsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._PublicsOffset_));
	}

	// U32 Reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReservedOffset_", declaredType="U32")
	public UDATA Reserved() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._ReservedOffset_));
	}

	// U32 Reserved
	public UDATAPointer ReservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._ReservedOffset_));
	}

	// U32 SizeOfStruct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfStructOffset_", declaredType="U32")
	public UDATA SizeOfStruct() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._SizeOfStructOffset_));
	}

	// U32 SizeOfStruct
	public UDATAPointer SizeOfStructEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._SizeOfStructOffset_));
	}

	// I32 SourceIndexed
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SourceIndexedOffset_", declaredType="I32")
	public IDATA SourceIndexed() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGEHLP_MODULE64._SourceIndexedOffset_));
	}

	// I32 SourceIndexed
	public IDATAPointer SourceIndexedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._SourceIndexedOffset_));
	}

	// SYM_TYPE SymType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymTypeOffset_", declaredType="SYM_TYPE")
	public long SymType() throws CorruptDataException {
		if (SYM_TYPE.SIZEOF == 1) {
			return getByteAtOffset(_IMAGEHLP_MODULE64._SymTypeOffset_);
		} else if (SYM_TYPE.SIZEOF == 2) {
			return getShortAtOffset(_IMAGEHLP_MODULE64._SymTypeOffset_);
		} else if (SYM_TYPE.SIZEOF == 4) {
			return getIntAtOffset(_IMAGEHLP_MODULE64._SymTypeOffset_);
		} else if (SYM_TYPE.SIZEOF == 8) {
			return getLongAtOffset(_IMAGEHLP_MODULE64._SymTypeOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// SYM_TYPE SymType
	public EnumPointer SymTypeEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._SymTypeOffset_), SYM_TYPE.class);
	}

	// U32 TimeDateStamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TimeDateStampOffset_", declaredType="U32")
	public UDATA TimeDateStamp() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_MODULE64._TimeDateStampOffset_));
	}

	// U32 TimeDateStamp
	public UDATAPointer TimeDateStampEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._TimeDateStampOffset_));
	}

	// I32 TypeInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TypeInfoOffset_", declaredType="I32")
	public IDATA TypeInfo() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGEHLP_MODULE64._TypeInfoOffset_));
	}

	// I32 TypeInfo
	public IDATAPointer TypeInfoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_MODULE64._TypeInfoOffset_));
	}

}
