/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _JUMP_BUFFERPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _JUMP_BUFFERPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_JUMP_BUFFER.class)
public class _JUMP_BUFFERPointer extends StructurePointer {

	// NULL
	public static final _JUMP_BUFFERPointer NULL = new _JUMP_BUFFERPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _JUMP_BUFFERPointer(long address) {
		super(address);
	}

	public static _JUMP_BUFFERPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _JUMP_BUFFERPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _JUMP_BUFFERPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _JUMP_BUFFERPointer(address);
	}

	public _JUMP_BUFFERPointer add(long count) {
		return _JUMP_BUFFERPointer.cast(address + (_JUMP_BUFFER.SIZEOF * count));
	}

	public _JUMP_BUFFERPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _JUMP_BUFFERPointer addOffset(long offset) {
		return _JUMP_BUFFERPointer.cast(address + offset);
	}

	public _JUMP_BUFFERPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _JUMP_BUFFERPointer sub(long count) {
		return _JUMP_BUFFERPointer.cast(address - (_JUMP_BUFFER.SIZEOF * count));
	}

	public _JUMP_BUFFERPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _JUMP_BUFFERPointer subOffset(long offset) {
		return _JUMP_BUFFERPointer.cast(address - offset);
	}

	public _JUMP_BUFFERPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _JUMP_BUFFERPointer untag(long mask) {
		return _JUMP_BUFFERPointer.cast(address & ~mask);
	}

	public _JUMP_BUFFERPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _JUMP_BUFFER.SIZEOF;
	}

	// Implementation methods

	// U16 FpCsr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FpCsrOffset_", declaredType="U16")
	public U16 FpCsr() throws CorruptDataException {
		return new U16(getShortAtOffset(_JUMP_BUFFER._FpCsrOffset_));
	}

	// U16 FpCsr
	public U16Pointer FpCsrEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._FpCsrOffset_));
	}

	// U64 Frame
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FrameOffset_", declaredType="U64")
	public UDATA Frame() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._FrameOffset_));
	}

	// U64 Frame
	public UDATAPointer FrameEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._FrameOffset_));
	}

	// U32 MxCsr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MxCsrOffset_", declaredType="U32")
	public UDATA MxCsr() throws CorruptDataException {
		return new U32(getIntAtOffset(_JUMP_BUFFER._MxCsrOffset_));
	}

	// U32 MxCsr
	public UDATAPointer MxCsrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._MxCsrOffset_));
	}

	// U64 R12
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R12Offset_", declaredType="U64")
	public UDATA R12() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._R12Offset_));
	}

	// U64 R12
	public UDATAPointer R12EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._R12Offset_));
	}

	// U64 R13
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R13Offset_", declaredType="U64")
	public UDATA R13() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._R13Offset_));
	}

	// U64 R13
	public UDATAPointer R13EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._R13Offset_));
	}

	// U64 R14
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R14Offset_", declaredType="U64")
	public UDATA R14() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._R14Offset_));
	}

	// U64 R14
	public UDATAPointer R14EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._R14Offset_));
	}

	// U64 R15
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R15Offset_", declaredType="U64")
	public UDATA R15() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._R15Offset_));
	}

	// U64 R15
	public UDATAPointer R15EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._R15Offset_));
	}

	// U64 Rbp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RbpOffset_", declaredType="U64")
	public UDATA Rbp() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._RbpOffset_));
	}

	// U64 Rbp
	public UDATAPointer RbpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._RbpOffset_));
	}

	// U64 Rbx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RbxOffset_", declaredType="U64")
	public UDATA Rbx() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._RbxOffset_));
	}

	// U64 Rbx
	public UDATAPointer RbxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._RbxOffset_));
	}

	// U64 Rdi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RdiOffset_", declaredType="U64")
	public UDATA Rdi() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._RdiOffset_));
	}

	// U64 Rdi
	public UDATAPointer RdiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._RdiOffset_));
	}

	// U64 Rip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RipOffset_", declaredType="U64")
	public UDATA Rip() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._RipOffset_));
	}

	// U64 Rip
	public UDATAPointer RipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._RipOffset_));
	}

	// U64 Rsi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RsiOffset_", declaredType="U64")
	public UDATA Rsi() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._RsiOffset_));
	}

	// U64 Rsi
	public UDATAPointer RsiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._RsiOffset_));
	}

	// U64 Rsp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RspOffset_", declaredType="U64")
	public UDATA Rsp() throws CorruptDataException {
		return new U64(getLongAtOffset(_JUMP_BUFFER._RspOffset_));
	}

	// U64 Rsp
	public UDATAPointer RspEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_JUMP_BUFFER._RspOffset_));
	}

	// U16 Spare
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SpareOffset_", declaredType="U16")
	public U16 Spare() throws CorruptDataException {
		return new U16(getShortAtOffset(_JUMP_BUFFER._SpareOffset_));
	}

	// U16 Spare
	public U16Pointer SpareEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._SpareOffset_));
	}

	// _SETJMP_FLOAT128 Xmm10
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm10Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm10() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm10Offset_));
	}

	// _SETJMP_FLOAT128 Xmm10
	public PointerPointer Xmm10EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm10Offset_));
	}

	// _SETJMP_FLOAT128 Xmm11
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm11Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm11() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm11Offset_));
	}

	// _SETJMP_FLOAT128 Xmm11
	public PointerPointer Xmm11EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm11Offset_));
	}

	// _SETJMP_FLOAT128 Xmm12
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm12Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm12() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm12Offset_));
	}

	// _SETJMP_FLOAT128 Xmm12
	public PointerPointer Xmm12EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm12Offset_));
	}

	// _SETJMP_FLOAT128 Xmm13
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm13Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm13() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm13Offset_));
	}

	// _SETJMP_FLOAT128 Xmm13
	public PointerPointer Xmm13EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm13Offset_));
	}

	// _SETJMP_FLOAT128 Xmm14
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm14Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm14() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm14Offset_));
	}

	// _SETJMP_FLOAT128 Xmm14
	public PointerPointer Xmm14EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm14Offset_));
	}

	// _SETJMP_FLOAT128 Xmm15
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm15Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm15() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm15Offset_));
	}

	// _SETJMP_FLOAT128 Xmm15
	public PointerPointer Xmm15EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm15Offset_));
	}

	// _SETJMP_FLOAT128 Xmm6
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm6Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm6() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm6Offset_));
	}

	// _SETJMP_FLOAT128 Xmm6
	public PointerPointer Xmm6EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm6Offset_));
	}

	// _SETJMP_FLOAT128 Xmm7
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm7Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm7() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm7Offset_));
	}

	// _SETJMP_FLOAT128 Xmm7
	public PointerPointer Xmm7EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm7Offset_));
	}

	// _SETJMP_FLOAT128 Xmm8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm8Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm8() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm8Offset_));
	}

	// _SETJMP_FLOAT128 Xmm8
	public PointerPointer Xmm8EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm8Offset_));
	}

	// _SETJMP_FLOAT128 Xmm9
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm9Offset_", declaredType="_SETJMP_FLOAT128")
	public _SETJMP_FLOAT128Pointer Xmm9() throws CorruptDataException {
		return _SETJMP_FLOAT128Pointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm9Offset_));
	}

	// _SETJMP_FLOAT128 Xmm9
	public PointerPointer Xmm9EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_JUMP_BUFFER._Xmm9Offset_));
	}

}
