/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _KNONVOLATILE_CONTEXT_POINTERSPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _KNONVOLATILE_CONTEXT_POINTERSPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_KNONVOLATILE_CONTEXT_POINTERS.class)
public class _KNONVOLATILE_CONTEXT_POINTERSPointer extends StructurePointer {

	// NULL
	public static final _KNONVOLATILE_CONTEXT_POINTERSPointer NULL = new _KNONVOLATILE_CONTEXT_POINTERSPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _KNONVOLATILE_CONTEXT_POINTERSPointer(long address) {
		super(address);
	}

	public static _KNONVOLATILE_CONTEXT_POINTERSPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _KNONVOLATILE_CONTEXT_POINTERSPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _KNONVOLATILE_CONTEXT_POINTERSPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _KNONVOLATILE_CONTEXT_POINTERSPointer(address);
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer add(long count) {
		return _KNONVOLATILE_CONTEXT_POINTERSPointer.cast(address + (_KNONVOLATILE_CONTEXT_POINTERS.SIZEOF * count));
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer addOffset(long offset) {
		return _KNONVOLATILE_CONTEXT_POINTERSPointer.cast(address + offset);
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer sub(long count) {
		return _KNONVOLATILE_CONTEXT_POINTERSPointer.cast(address - (_KNONVOLATILE_CONTEXT_POINTERS.SIZEOF * count));
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer subOffset(long offset) {
		return _KNONVOLATILE_CONTEXT_POINTERSPointer.cast(address - offset);
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer untag(long mask) {
		return _KNONVOLATILE_CONTEXT_POINTERSPointer.cast(address & ~mask);
	}

	public _KNONVOLATILE_CONTEXT_POINTERSPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _KNONVOLATILE_CONTEXT_POINTERS.SIZEOF;
	}

	// Implementation methods

	// _M128A*[] FloatingContext
	public PointerPointer FloatingContextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._FloatingContextOffset_));
	}

	// U64*[] IntegerContext
	public PointerPointer IntegerContextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._IntegerContextOffset_));
	}

	// U64* R10
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R10Offset_", declaredType="U64*")
	public UDATAPointer R10() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R10Offset_));
	}

	// U64* R10
	public PointerPointer R10EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R10Offset_));
	}

	// U64* R11
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R11Offset_", declaredType="U64*")
	public UDATAPointer R11() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R11Offset_));
	}

	// U64* R11
	public PointerPointer R11EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R11Offset_));
	}

	// U64* R12
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R12Offset_", declaredType="U64*")
	public UDATAPointer R12() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R12Offset_));
	}

	// U64* R12
	public PointerPointer R12EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R12Offset_));
	}

	// U64* R13
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R13Offset_", declaredType="U64*")
	public UDATAPointer R13() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R13Offset_));
	}

	// U64* R13
	public PointerPointer R13EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R13Offset_));
	}

	// U64* R14
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R14Offset_", declaredType="U64*")
	public UDATAPointer R14() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R14Offset_));
	}

	// U64* R14
	public PointerPointer R14EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R14Offset_));
	}

	// U64* R15
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R15Offset_", declaredType="U64*")
	public UDATAPointer R15() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R15Offset_));
	}

	// U64* R15
	public PointerPointer R15EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R15Offset_));
	}

	// U64* R8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R8Offset_", declaredType="U64*")
	public UDATAPointer R8() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R8Offset_));
	}

	// U64* R8
	public PointerPointer R8EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R8Offset_));
	}

	// U64* R9
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R9Offset_", declaredType="U64*")
	public UDATAPointer R9() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._R9Offset_));
	}

	// U64* R9
	public PointerPointer R9EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._R9Offset_));
	}

	// U64* Rax
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RaxOffset_", declaredType="U64*")
	public UDATAPointer Rax() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RaxOffset_));
	}

	// U64* Rax
	public PointerPointer RaxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RaxOffset_));
	}

	// U64* Rbp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RbpOffset_", declaredType="U64*")
	public UDATAPointer Rbp() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RbpOffset_));
	}

	// U64* Rbp
	public PointerPointer RbpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RbpOffset_));
	}

	// U64* Rbx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RbxOffset_", declaredType="U64*")
	public UDATAPointer Rbx() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RbxOffset_));
	}

	// U64* Rbx
	public PointerPointer RbxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RbxOffset_));
	}

	// U64* Rcx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RcxOffset_", declaredType="U64*")
	public UDATAPointer Rcx() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RcxOffset_));
	}

	// U64* Rcx
	public PointerPointer RcxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RcxOffset_));
	}

	// U64* Rdi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RdiOffset_", declaredType="U64*")
	public UDATAPointer Rdi() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RdiOffset_));
	}

	// U64* Rdi
	public PointerPointer RdiEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RdiOffset_));
	}

	// U64* Rdx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RdxOffset_", declaredType="U64*")
	public UDATAPointer Rdx() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RdxOffset_));
	}

	// U64* Rdx
	public PointerPointer RdxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RdxOffset_));
	}

	// U64* Rsi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RsiOffset_", declaredType="U64*")
	public UDATAPointer Rsi() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RsiOffset_));
	}

	// U64* Rsi
	public PointerPointer RsiEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RsiOffset_));
	}

	// U64* Rsp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RspOffset_", declaredType="U64*")
	public UDATAPointer Rsp() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._RspOffset_));
	}

	// U64* Rsp
	public PointerPointer RspEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._RspOffset_));
	}

	// _M128A* Xmm0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm0Offset_", declaredType="_M128A*")
	public _M128APointer Xmm0() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm0Offset_));
	}

	// _M128A* Xmm0
	public PointerPointer Xmm0EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm0Offset_));
	}

	// _M128A* Xmm1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm1Offset_", declaredType="_M128A*")
	public _M128APointer Xmm1() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm1Offset_));
	}

	// _M128A* Xmm1
	public PointerPointer Xmm1EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm1Offset_));
	}

	// _M128A* Xmm10
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm10Offset_", declaredType="_M128A*")
	public _M128APointer Xmm10() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm10Offset_));
	}

	// _M128A* Xmm10
	public PointerPointer Xmm10EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm10Offset_));
	}

	// _M128A* Xmm11
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm11Offset_", declaredType="_M128A*")
	public _M128APointer Xmm11() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm11Offset_));
	}

	// _M128A* Xmm11
	public PointerPointer Xmm11EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm11Offset_));
	}

	// _M128A* Xmm12
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm12Offset_", declaredType="_M128A*")
	public _M128APointer Xmm12() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm12Offset_));
	}

	// _M128A* Xmm12
	public PointerPointer Xmm12EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm12Offset_));
	}

	// _M128A* Xmm13
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm13Offset_", declaredType="_M128A*")
	public _M128APointer Xmm13() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm13Offset_));
	}

	// _M128A* Xmm13
	public PointerPointer Xmm13EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm13Offset_));
	}

	// _M128A* Xmm14
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm14Offset_", declaredType="_M128A*")
	public _M128APointer Xmm14() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm14Offset_));
	}

	// _M128A* Xmm14
	public PointerPointer Xmm14EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm14Offset_));
	}

	// _M128A* Xmm15
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm15Offset_", declaredType="_M128A*")
	public _M128APointer Xmm15() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm15Offset_));
	}

	// _M128A* Xmm15
	public PointerPointer Xmm15EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm15Offset_));
	}

	// _M128A* Xmm2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm2Offset_", declaredType="_M128A*")
	public _M128APointer Xmm2() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm2Offset_));
	}

	// _M128A* Xmm2
	public PointerPointer Xmm2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm2Offset_));
	}

	// _M128A* Xmm3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm3Offset_", declaredType="_M128A*")
	public _M128APointer Xmm3() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm3Offset_));
	}

	// _M128A* Xmm3
	public PointerPointer Xmm3EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm3Offset_));
	}

	// _M128A* Xmm4
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm4Offset_", declaredType="_M128A*")
	public _M128APointer Xmm4() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm4Offset_));
	}

	// _M128A* Xmm4
	public PointerPointer Xmm4EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm4Offset_));
	}

	// _M128A* Xmm5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm5Offset_", declaredType="_M128A*")
	public _M128APointer Xmm5() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm5Offset_));
	}

	// _M128A* Xmm5
	public PointerPointer Xmm5EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm5Offset_));
	}

	// _M128A* Xmm6
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm6Offset_", declaredType="_M128A*")
	public _M128APointer Xmm6() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm6Offset_));
	}

	// _M128A* Xmm6
	public PointerPointer Xmm6EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm6Offset_));
	}

	// _M128A* Xmm7
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm7Offset_", declaredType="_M128A*")
	public _M128APointer Xmm7() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm7Offset_));
	}

	// _M128A* Xmm7
	public PointerPointer Xmm7EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm7Offset_));
	}

	// _M128A* Xmm8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm8Offset_", declaredType="_M128A*")
	public _M128APointer Xmm8() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm8Offset_));
	}

	// _M128A* Xmm8
	public PointerPointer Xmm8EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm8Offset_));
	}

	// _M128A* Xmm9
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm9Offset_", declaredType="_M128A*")
	public _M128APointer Xmm9() throws CorruptDataException {
		return _M128APointer.cast(getPointerAtOffset(_KNONVOLATILE_CONTEXT_POINTERS._Xmm9Offset_));
	}

	// _M128A* Xmm9
	public PointerPointer Xmm9EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KNONVOLATILE_CONTEXT_POINTERS._Xmm9Offset_));
	}

}
