/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LARGE_INTEGERPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LARGE_INTEGERPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LARGE_INTEGER.class)
public class _LARGE_INTEGERPointer extends StructurePointer {

	// NULL
	public static final _LARGE_INTEGERPointer NULL = new _LARGE_INTEGERPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LARGE_INTEGERPointer(long address) {
		super(address);
	}

	public static _LARGE_INTEGERPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LARGE_INTEGERPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LARGE_INTEGERPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LARGE_INTEGERPointer(address);
	}

	public _LARGE_INTEGERPointer add(long count) {
		return _LARGE_INTEGERPointer.cast(address + (_LARGE_INTEGER.SIZEOF * count));
	}

	public _LARGE_INTEGERPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LARGE_INTEGERPointer addOffset(long offset) {
		return _LARGE_INTEGERPointer.cast(address + offset);
	}

	public _LARGE_INTEGERPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LARGE_INTEGERPointer sub(long count) {
		return _LARGE_INTEGERPointer.cast(address - (_LARGE_INTEGER.SIZEOF * count));
	}

	public _LARGE_INTEGERPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LARGE_INTEGERPointer subOffset(long offset) {
		return _LARGE_INTEGERPointer.cast(address - offset);
	}

	public _LARGE_INTEGERPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LARGE_INTEGERPointer untag(long mask) {
		return _LARGE_INTEGERPointer.cast(address & ~mask);
	}

	public _LARGE_INTEGERPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LARGE_INTEGER.SIZEOF;
	}

	// Implementation methods

	// I32 HighPart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_HighPartOffset_", declaredType="I32")
	public IDATA HighPart() throws CorruptDataException {
		return new I32(getIntAtOffset(_LARGE_INTEGER._HighPartOffset_));
	}

	// I32 HighPart
	public IDATAPointer HighPartEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LARGE_INTEGER._HighPartOffset_));
	}

	// U32 LowPart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LowPartOffset_", declaredType="U32")
	public UDATA LowPart() throws CorruptDataException {
		return new U32(getIntAtOffset(_LARGE_INTEGER._LowPartOffset_));
	}

	// U32 LowPart
	public UDATAPointer LowPartEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LARGE_INTEGER._LowPartOffset_));
	}

	// I64 QuadPart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_QuadPartOffset_", declaredType="I64")
	public IDATA QuadPart() throws CorruptDataException {
		return new I64(getLongAtOffset(_LARGE_INTEGER._QuadPartOffset_));
	}

	// I64 QuadPart
	public IDATAPointer QuadPartEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LARGE_INTEGER._QuadPartOffset_));
	}

	// I32 u.HighPart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$HighPartOffset_", declaredType="I32")
	public IDATA u$HighPart() throws CorruptDataException {
		return new I32(getIntAtOffset(_LARGE_INTEGER._u$HighPartOffset_));
	}

	// I32 u.HighPart
	public IDATAPointer u$HighPartEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LARGE_INTEGER._u$HighPartOffset_));
	}

	// U32 u.LowPart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$LowPartOffset_", declaredType="U32")
	public UDATA u$LowPart() throws CorruptDataException {
		return new U32(getIntAtOffset(_LARGE_INTEGER._u$LowPartOffset_));
	}

	// U32 u.LowPart
	public UDATAPointer u$LowPartEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LARGE_INTEGER._u$LowPartOffset_));
	}

}
