/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _MEMORY_BASIC_INFORMATIONPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _MEMORY_BASIC_INFORMATIONPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_MEMORY_BASIC_INFORMATION.class)
public class _MEMORY_BASIC_INFORMATIONPointer extends StructurePointer {

	// NULL
	public static final _MEMORY_BASIC_INFORMATIONPointer NULL = new _MEMORY_BASIC_INFORMATIONPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _MEMORY_BASIC_INFORMATIONPointer(long address) {
		super(address);
	}

	public static _MEMORY_BASIC_INFORMATIONPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _MEMORY_BASIC_INFORMATIONPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _MEMORY_BASIC_INFORMATIONPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _MEMORY_BASIC_INFORMATIONPointer(address);
	}

	public _MEMORY_BASIC_INFORMATIONPointer add(long count) {
		return _MEMORY_BASIC_INFORMATIONPointer.cast(address + (_MEMORY_BASIC_INFORMATION.SIZEOF * count));
	}

	public _MEMORY_BASIC_INFORMATIONPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _MEMORY_BASIC_INFORMATIONPointer addOffset(long offset) {
		return _MEMORY_BASIC_INFORMATIONPointer.cast(address + offset);
	}

	public _MEMORY_BASIC_INFORMATIONPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _MEMORY_BASIC_INFORMATIONPointer sub(long count) {
		return _MEMORY_BASIC_INFORMATIONPointer.cast(address - (_MEMORY_BASIC_INFORMATION.SIZEOF * count));
	}

	public _MEMORY_BASIC_INFORMATIONPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _MEMORY_BASIC_INFORMATIONPointer subOffset(long offset) {
		return _MEMORY_BASIC_INFORMATIONPointer.cast(address - offset);
	}

	public _MEMORY_BASIC_INFORMATIONPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _MEMORY_BASIC_INFORMATIONPointer untag(long mask) {
		return _MEMORY_BASIC_INFORMATIONPointer.cast(address & ~mask);
	}

	public _MEMORY_BASIC_INFORMATIONPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _MEMORY_BASIC_INFORMATION.SIZEOF;
	}

	// Implementation methods

	// void* AllocationBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AllocationBaseOffset_", declaredType="void*")
	public VoidPointer AllocationBase() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_MEMORY_BASIC_INFORMATION._AllocationBaseOffset_));
	}

	// void* AllocationBase
	public PointerPointer AllocationBaseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._AllocationBaseOffset_));
	}

	// U32 AllocationProtect
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AllocationProtectOffset_", declaredType="U32")
	public UDATA AllocationProtect() throws CorruptDataException {
		return new U32(getIntAtOffset(_MEMORY_BASIC_INFORMATION._AllocationProtectOffset_));
	}

	// U32 AllocationProtect
	public UDATAPointer AllocationProtectEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._AllocationProtectOffset_));
	}

	// void* BaseAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BaseAddressOffset_", declaredType="void*")
	public VoidPointer BaseAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_MEMORY_BASIC_INFORMATION._BaseAddressOffset_));
	}

	// void* BaseAddress
	public PointerPointer BaseAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._BaseAddressOffset_));
	}

	// U16 PartitionId
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PartitionIdOffset_", declaredType="U16")
	public U16 PartitionId() throws CorruptDataException {
		return new U16(getShortAtOffset(_MEMORY_BASIC_INFORMATION._PartitionIdOffset_));
	}

	// U16 PartitionId
	public U16Pointer PartitionIdEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._PartitionIdOffset_));
	}

	// U32 Protect
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProtectOffset_", declaredType="U32")
	public UDATA Protect() throws CorruptDataException {
		return new U32(getIntAtOffset(_MEMORY_BASIC_INFORMATION._ProtectOffset_));
	}

	// U32 Protect
	public UDATAPointer ProtectEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._ProtectOffset_));
	}

	// U64 RegionSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RegionSizeOffset_", declaredType="U64")
	public UDATA RegionSize() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORY_BASIC_INFORMATION._RegionSizeOffset_));
	}

	// U64 RegionSize
	public UDATAPointer RegionSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._RegionSizeOffset_));
	}

	// U32 State
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StateOffset_", declaredType="U32")
	public UDATA State() throws CorruptDataException {
		return new U32(getIntAtOffset(_MEMORY_BASIC_INFORMATION._StateOffset_));
	}

	// U32 State
	public UDATAPointer StateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._StateOffset_));
	}

	// U32 Type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TypeOffset_", declaredType="U32")
	public UDATA Type() throws CorruptDataException {
		return new U32(getIntAtOffset(_MEMORY_BASIC_INFORMATION._TypeOffset_));
	}

	// U32 Type
	public UDATAPointer TypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORY_BASIC_INFORMATION._TypeOffset_));
	}

}
