/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _MINIDUMP_MEMORY_INFOPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _MINIDUMP_MEMORY_INFOPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_MINIDUMP_MEMORY_INFO.class)
public class _MINIDUMP_MEMORY_INFOPointer extends StructurePointer {

	// NULL
	public static final _MINIDUMP_MEMORY_INFOPointer NULL = new _MINIDUMP_MEMORY_INFOPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _MINIDUMP_MEMORY_INFOPointer(long address) {
		super(address);
	}

	public static _MINIDUMP_MEMORY_INFOPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _MINIDUMP_MEMORY_INFOPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _MINIDUMP_MEMORY_INFOPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _MINIDUMP_MEMORY_INFOPointer(address);
	}

	public _MINIDUMP_MEMORY_INFOPointer add(long count) {
		return _MINIDUMP_MEMORY_INFOPointer.cast(address + (_MINIDUMP_MEMORY_INFO.SIZEOF * count));
	}

	public _MINIDUMP_MEMORY_INFOPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _MINIDUMP_MEMORY_INFOPointer addOffset(long offset) {
		return _MINIDUMP_MEMORY_INFOPointer.cast(address + offset);
	}

	public _MINIDUMP_MEMORY_INFOPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _MINIDUMP_MEMORY_INFOPointer sub(long count) {
		return _MINIDUMP_MEMORY_INFOPointer.cast(address - (_MINIDUMP_MEMORY_INFO.SIZEOF * count));
	}

	public _MINIDUMP_MEMORY_INFOPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _MINIDUMP_MEMORY_INFOPointer subOffset(long offset) {
		return _MINIDUMP_MEMORY_INFOPointer.cast(address - offset);
	}

	public _MINIDUMP_MEMORY_INFOPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _MINIDUMP_MEMORY_INFOPointer untag(long mask) {
		return _MINIDUMP_MEMORY_INFOPointer.cast(address & ~mask);
	}

	public _MINIDUMP_MEMORY_INFOPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _MINIDUMP_MEMORY_INFO.SIZEOF;
	}

	// Implementation methods

	// U64 AllocationBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AllocationBaseOffset_", declaredType="U64")
	public UDATA AllocationBase() throws CorruptDataException {
		return new U64(getLongAtOffset(_MINIDUMP_MEMORY_INFO._AllocationBaseOffset_));
	}

	// U64 AllocationBase
	public UDATAPointer AllocationBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO._AllocationBaseOffset_));
	}

	// U32 AllocationProtect
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AllocationProtectOffset_", declaredType="U32")
	public UDATA AllocationProtect() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_MEMORY_INFO._AllocationProtectOffset_));
	}

	// U32 AllocationProtect
	public UDATAPointer AllocationProtectEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO._AllocationProtectOffset_));
	}

	// U64 BaseAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BaseAddressOffset_", declaredType="U64")
	public UDATA BaseAddress() throws CorruptDataException {
		return new U64(getLongAtOffset(_MINIDUMP_MEMORY_INFO._BaseAddressOffset_));
	}

	// U64 BaseAddress
	public UDATAPointer BaseAddressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO._BaseAddressOffset_));
	}

	// U32 Protect
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProtectOffset_", declaredType="U32")
	public UDATA Protect() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_MEMORY_INFO._ProtectOffset_));
	}

	// U32 Protect
	public UDATAPointer ProtectEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO._ProtectOffset_));
	}

	// U64 RegionSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RegionSizeOffset_", declaredType="U64")
	public UDATA RegionSize() throws CorruptDataException {
		return new U64(getLongAtOffset(_MINIDUMP_MEMORY_INFO._RegionSizeOffset_));
	}

	// U64 RegionSize
	public UDATAPointer RegionSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO._RegionSizeOffset_));
	}

	// U32 State
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StateOffset_", declaredType="U32")
	public UDATA State() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_MEMORY_INFO._StateOffset_));
	}

	// U32 State
	public UDATAPointer StateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO._StateOffset_));
	}

	// U32 Type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TypeOffset_", declaredType="U32")
	public UDATA Type() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_MEMORY_INFO._TypeOffset_));
	}

	// U32 Type
	public UDATAPointer TypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO._TypeOffset_));
	}

	// U32 __alignment1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___alignment1Offset_", declaredType="U32")
	public UDATA __alignment1() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_MEMORY_INFO.___alignment1Offset_));
	}

	// U32 __alignment1
	public UDATAPointer __alignment1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO.___alignment1Offset_));
	}

	// U32 __alignment2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___alignment2Offset_", declaredType="U32")
	public UDATA __alignment2() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_MEMORY_INFO.___alignment2Offset_));
	}

	// U32 __alignment2
	public UDATAPointer __alignment2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_MEMORY_INFO.___alignment2Offset_));
	}

}
