/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _NT_TIBPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _NT_TIBPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_NT_TIB.class)
public class _NT_TIBPointer extends StructurePointer {

	// NULL
	public static final _NT_TIBPointer NULL = new _NT_TIBPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _NT_TIBPointer(long address) {
		super(address);
	}

	public static _NT_TIBPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _NT_TIBPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _NT_TIBPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _NT_TIBPointer(address);
	}

	public _NT_TIBPointer add(long count) {
		return _NT_TIBPointer.cast(address + (_NT_TIB.SIZEOF * count));
	}

	public _NT_TIBPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _NT_TIBPointer addOffset(long offset) {
		return _NT_TIBPointer.cast(address + offset);
	}

	public _NT_TIBPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _NT_TIBPointer sub(long count) {
		return _NT_TIBPointer.cast(address - (_NT_TIB.SIZEOF * count));
	}

	public _NT_TIBPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _NT_TIBPointer subOffset(long offset) {
		return _NT_TIBPointer.cast(address - offset);
	}

	public _NT_TIBPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _NT_TIBPointer untag(long mask) {
		return _NT_TIBPointer.cast(address & ~mask);
	}

	public _NT_TIBPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _NT_TIB.SIZEOF;
	}

	// Implementation methods

	// void* ArbitraryUserPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ArbitraryUserPointerOffset_", declaredType="void*")
	public VoidPointer ArbitraryUserPointer() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_NT_TIB._ArbitraryUserPointerOffset_));
	}

	// void* ArbitraryUserPointer
	public PointerPointer ArbitraryUserPointerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_NT_TIB._ArbitraryUserPointerOffset_));
	}

	// _EXCEPTION_REGISTRATION_RECORD* ExceptionList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionListOffset_", declaredType="_EXCEPTION_REGISTRATION_RECORD*")
	public _EXCEPTION_REGISTRATION_RECORDPointer ExceptionList() throws CorruptDataException {
		return _EXCEPTION_REGISTRATION_RECORDPointer.cast(getPointerAtOffset(_NT_TIB._ExceptionListOffset_));
	}

	// _EXCEPTION_REGISTRATION_RECORD* ExceptionList
	public PointerPointer ExceptionListEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_NT_TIB._ExceptionListOffset_));
	}

	// void* FiberData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FiberDataOffset_", declaredType="void*")
	public VoidPointer FiberData() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_NT_TIB._FiberDataOffset_));
	}

	// void* FiberData
	public PointerPointer FiberDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_NT_TIB._FiberDataOffset_));
	}

	// _NT_TIB* Self
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SelfOffset_", declaredType="_NT_TIB*")
	public _NT_TIBPointer Self() throws CorruptDataException {
		return _NT_TIBPointer.cast(getPointerAtOffset(_NT_TIB._SelfOffset_));
	}

	// _NT_TIB* Self
	public PointerPointer SelfEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_NT_TIB._SelfOffset_));
	}

	// void* StackBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StackBaseOffset_", declaredType="void*")
	public VoidPointer StackBase() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_NT_TIB._StackBaseOffset_));
	}

	// void* StackBase
	public PointerPointer StackBaseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_NT_TIB._StackBaseOffset_));
	}

	// void* StackLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StackLimitOffset_", declaredType="void*")
	public VoidPointer StackLimit() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_NT_TIB._StackLimitOffset_));
	}

	// void* StackLimit
	public PointerPointer StackLimitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_NT_TIB._StackLimitOffset_));
	}

	// void* SubSystemTib
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SubSystemTibOffset_", declaredType="void*")
	public VoidPointer SubSystemTib() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_NT_TIB._SubSystemTibOffset_));
	}

	// void* SubSystemTib
	public PointerPointer SubSystemTibEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_NT_TIB._SubSystemTibOffset_));
	}

	// U32 Version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VersionOffset_", declaredType="U32")
	public UDATA Version() throws CorruptDataException {
		return new U32(getIntAtOffset(_NT_TIB._VersionOffset_));
	}

	// U32 Version
	public UDATAPointer VersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_NT_TIB._VersionOffset_));
	}

}
