/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _OSVERSIONINFOAPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _OSVERSIONINFOAPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_OSVERSIONINFOA.class)
public class _OSVERSIONINFOAPointer extends StructurePointer {

	// NULL
	public static final _OSVERSIONINFOAPointer NULL = new _OSVERSIONINFOAPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _OSVERSIONINFOAPointer(long address) {
		super(address);
	}

	public static _OSVERSIONINFOAPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _OSVERSIONINFOAPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _OSVERSIONINFOAPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _OSVERSIONINFOAPointer(address);
	}

	public _OSVERSIONINFOAPointer add(long count) {
		return _OSVERSIONINFOAPointer.cast(address + (_OSVERSIONINFOA.SIZEOF * count));
	}

	public _OSVERSIONINFOAPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _OSVERSIONINFOAPointer addOffset(long offset) {
		return _OSVERSIONINFOAPointer.cast(address + offset);
	}

	public _OSVERSIONINFOAPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _OSVERSIONINFOAPointer sub(long count) {
		return _OSVERSIONINFOAPointer.cast(address - (_OSVERSIONINFOA.SIZEOF * count));
	}

	public _OSVERSIONINFOAPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _OSVERSIONINFOAPointer subOffset(long offset) {
		return _OSVERSIONINFOAPointer.cast(address - offset);
	}

	public _OSVERSIONINFOAPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _OSVERSIONINFOAPointer untag(long mask) {
		return _OSVERSIONINFOAPointer.cast(address & ~mask);
	}

	public _OSVERSIONINFOAPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _OSVERSIONINFOA.SIZEOF;
	}

	// Implementation methods

	// U32 dwBuildNumber
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwBuildNumberOffset_", declaredType="U32")
	public UDATA dwBuildNumber() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOA._dwBuildNumberOffset_));
	}

	// U32 dwBuildNumber
	public UDATAPointer dwBuildNumberEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOA._dwBuildNumberOffset_));
	}

	// U32 dwMajorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwMajorVersionOffset_", declaredType="U32")
	public UDATA dwMajorVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOA._dwMajorVersionOffset_));
	}

	// U32 dwMajorVersion
	public UDATAPointer dwMajorVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOA._dwMajorVersionOffset_));
	}

	// U32 dwMinorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwMinorVersionOffset_", declaredType="U32")
	public UDATA dwMinorVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOA._dwMinorVersionOffset_));
	}

	// U32 dwMinorVersion
	public UDATAPointer dwMinorVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOA._dwMinorVersionOffset_));
	}

	// U32 dwOSVersionInfoSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwOSVersionInfoSizeOffset_", declaredType="U32")
	public UDATA dwOSVersionInfoSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOA._dwOSVersionInfoSizeOffset_));
	}

	// U32 dwOSVersionInfoSize
	public UDATAPointer dwOSVersionInfoSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOA._dwOSVersionInfoSizeOffset_));
	}

	// U32 dwPlatformId
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwPlatformIdOffset_", declaredType="U32")
	public UDATA dwPlatformId() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOA._dwPlatformIdOffset_));
	}

	// U32 dwPlatformId
	public UDATAPointer dwPlatformIdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOA._dwPlatformIdOffset_));
	}

	// U8[] szCSDVersion
	public U8Pointer szCSDVersionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_OSVERSIONINFOA._szCSDVersionOffset_));
	}

}
