/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64.class)
public class _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer extends StructurePointer {

	// NULL
	public static final _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer NULL = new _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer(long address) {
		super(address);
	}

	public static _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer(address);
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer add(long count) {
		return _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer.cast(address + (_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64.SIZEOF * count));
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer addOffset(long offset) {
		return _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer.cast(address + offset);
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer sub(long count) {
		return _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer.cast(address - (_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64.SIZEOF * count));
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer subOffset(long offset) {
		return _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer.cast(address - offset);
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer untag(long mask) {
		return _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer.cast(address & ~mask);
	}

	public _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64.SIZEOF;
	}

	// Implementation methods

	// U64 CHPEMetadataPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CHPEMetadataPointerOffset_", declaredType="U64")
	public UDATA CHPEMetadataPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CHPEMetadataPointerOffset_));
	}

	// U64 CHPEMetadataPointer
	public UDATAPointer CHPEMetadataPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CHPEMetadataPointerOffset_));
	}

	// U16 CSDVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CSDVersionOffset_", declaredType="U16")
	public U16 CSDVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CSDVersionOffset_));
	}

	// U16 CSDVersion
	public U16Pointer CSDVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CSDVersionOffset_));
	}

	// U64 CastGuardOsDeterminedFailureMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CastGuardOsDeterminedFailureModeOffset_", declaredType="U64")
	public UDATA CastGuardOsDeterminedFailureMode() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CastGuardOsDeterminedFailureModeOffset_));
	}

	// U64 CastGuardOsDeterminedFailureMode
	public UDATAPointer CastGuardOsDeterminedFailureModeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CastGuardOsDeterminedFailureModeOffset_));
	}

	// _IMAGE_LOAD_CONFIG_CODE_INTEGRITY CodeIntegrity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CodeIntegrityOffset_", declaredType="_IMAGE_LOAD_CONFIG_CODE_INTEGRITY")
	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer CodeIntegrity() throws CorruptDataException {
		return _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CodeIntegrityOffset_));
	}

	// _IMAGE_LOAD_CONFIG_CODE_INTEGRITY CodeIntegrity
	public PointerPointer CodeIntegrityEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CodeIntegrityOffset_));
	}

	// U32 CriticalSectionDefaultTimeout
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CriticalSectionDefaultTimeoutOffset_", declaredType="U32")
	public UDATA CriticalSectionDefaultTimeout() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CriticalSectionDefaultTimeoutOffset_));
	}

	// U32 CriticalSectionDefaultTimeout
	public UDATAPointer CriticalSectionDefaultTimeoutEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._CriticalSectionDefaultTimeoutOffset_));
	}

	// U64 DeCommitFreeBlockThreshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DeCommitFreeBlockThresholdOffset_", declaredType="U64")
	public UDATA DeCommitFreeBlockThreshold() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DeCommitFreeBlockThresholdOffset_));
	}

	// U64 DeCommitFreeBlockThreshold
	public UDATAPointer DeCommitFreeBlockThresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DeCommitFreeBlockThresholdOffset_));
	}

	// U64 DeCommitTotalFreeThreshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DeCommitTotalFreeThresholdOffset_", declaredType="U64")
	public UDATA DeCommitTotalFreeThreshold() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DeCommitTotalFreeThresholdOffset_));
	}

	// U64 DeCommitTotalFreeThreshold
	public UDATAPointer DeCommitTotalFreeThresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DeCommitTotalFreeThresholdOffset_));
	}

	// U16 DependentLoadFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DependentLoadFlagsOffset_", declaredType="U16")
	public U16 DependentLoadFlags() throws CorruptDataException {
		return new U16(getShortAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DependentLoadFlagsOffset_));
	}

	// U16 DependentLoadFlags
	public U16Pointer DependentLoadFlagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DependentLoadFlagsOffset_));
	}

	// U64 DynamicValueRelocTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DynamicValueRelocTableOffset_", declaredType="U64")
	public UDATA DynamicValueRelocTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DynamicValueRelocTableOffset_));
	}

	// U64 DynamicValueRelocTable
	public UDATAPointer DynamicValueRelocTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DynamicValueRelocTableOffset_));
	}

	// U32 DynamicValueRelocTableOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DynamicValueRelocTableOffsetOffset_", declaredType="U32")
	public UDATA DynamicValueRelocTableOffset() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DynamicValueRelocTableOffsetOffset_));
	}

	// U32 DynamicValueRelocTableOffset
	public UDATAPointer DynamicValueRelocTableOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DynamicValueRelocTableOffsetOffset_));
	}

	// U16 DynamicValueRelocTableSection
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DynamicValueRelocTableSectionOffset_", declaredType="U16")
	public U16 DynamicValueRelocTableSection() throws CorruptDataException {
		return new U16(getShortAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DynamicValueRelocTableSectionOffset_));
	}

	// U16 DynamicValueRelocTableSection
	public U16Pointer DynamicValueRelocTableSectionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._DynamicValueRelocTableSectionOffset_));
	}

	// U64 EditList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EditListOffset_", declaredType="U64")
	public UDATA EditList() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._EditListOffset_));
	}

	// U64 EditList
	public UDATAPointer EditListEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._EditListOffset_));
	}

	// U64 EnclaveConfigurationPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EnclaveConfigurationPointerOffset_", declaredType="U64")
	public UDATA EnclaveConfigurationPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._EnclaveConfigurationPointerOffset_));
	}

	// U64 EnclaveConfigurationPointer
	public UDATAPointer EnclaveConfigurationPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._EnclaveConfigurationPointerOffset_));
	}

	// U32 GlobalFlagsClear
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GlobalFlagsClearOffset_", declaredType="U32")
	public UDATA GlobalFlagsClear() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GlobalFlagsClearOffset_));
	}

	// U32 GlobalFlagsClear
	public UDATAPointer GlobalFlagsClearEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GlobalFlagsClearOffset_));
	}

	// U32 GlobalFlagsSet
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GlobalFlagsSetOffset_", declaredType="U32")
	public UDATA GlobalFlagsSet() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GlobalFlagsSetOffset_));
	}

	// U32 GlobalFlagsSet
	public UDATAPointer GlobalFlagsSetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GlobalFlagsSetOffset_));
	}

	// U64 GuardAddressTakenIatEntryCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardAddressTakenIatEntryCountOffset_", declaredType="U64")
	public UDATA GuardAddressTakenIatEntryCount() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardAddressTakenIatEntryCountOffset_));
	}

	// U64 GuardAddressTakenIatEntryCount
	public UDATAPointer GuardAddressTakenIatEntryCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardAddressTakenIatEntryCountOffset_));
	}

	// U64 GuardAddressTakenIatEntryTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardAddressTakenIatEntryTableOffset_", declaredType="U64")
	public UDATA GuardAddressTakenIatEntryTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardAddressTakenIatEntryTableOffset_));
	}

	// U64 GuardAddressTakenIatEntryTable
	public UDATAPointer GuardAddressTakenIatEntryTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardAddressTakenIatEntryTableOffset_));
	}

	// U64 GuardCFCheckFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardCFCheckFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardCFCheckFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFCheckFunctionPointerOffset_));
	}

	// U64 GuardCFCheckFunctionPointer
	public UDATAPointer GuardCFCheckFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFCheckFunctionPointerOffset_));
	}

	// U64 GuardCFDispatchFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardCFDispatchFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardCFDispatchFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFDispatchFunctionPointerOffset_));
	}

	// U64 GuardCFDispatchFunctionPointer
	public UDATAPointer GuardCFDispatchFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFDispatchFunctionPointerOffset_));
	}

	// U64 GuardCFFunctionCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardCFFunctionCountOffset_", declaredType="U64")
	public UDATA GuardCFFunctionCount() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFFunctionCountOffset_));
	}

	// U64 GuardCFFunctionCount
	public UDATAPointer GuardCFFunctionCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFFunctionCountOffset_));
	}

	// U64 GuardCFFunctionTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardCFFunctionTableOffset_", declaredType="U64")
	public UDATA GuardCFFunctionTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFFunctionTableOffset_));
	}

	// U64 GuardCFFunctionTable
	public UDATAPointer GuardCFFunctionTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardCFFunctionTableOffset_));
	}

	// U64 GuardEHContinuationCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardEHContinuationCountOffset_", declaredType="U64")
	public UDATA GuardEHContinuationCount() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardEHContinuationCountOffset_));
	}

	// U64 GuardEHContinuationCount
	public UDATAPointer GuardEHContinuationCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardEHContinuationCountOffset_));
	}

	// U64 GuardEHContinuationTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardEHContinuationTableOffset_", declaredType="U64")
	public UDATA GuardEHContinuationTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardEHContinuationTableOffset_));
	}

	// U64 GuardEHContinuationTable
	public UDATAPointer GuardEHContinuationTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardEHContinuationTableOffset_));
	}

	// U32 GuardFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardFlagsOffset_", declaredType="U32")
	public UDATA GuardFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardFlagsOffset_));
	}

	// U32 GuardFlags
	public UDATAPointer GuardFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardFlagsOffset_));
	}

	// U64 GuardLongJumpTargetCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardLongJumpTargetCountOffset_", declaredType="U64")
	public UDATA GuardLongJumpTargetCount() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardLongJumpTargetCountOffset_));
	}

	// U64 GuardLongJumpTargetCount
	public UDATAPointer GuardLongJumpTargetCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardLongJumpTargetCountOffset_));
	}

	// U64 GuardLongJumpTargetTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardLongJumpTargetTableOffset_", declaredType="U64")
	public UDATA GuardLongJumpTargetTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardLongJumpTargetTableOffset_));
	}

	// U64 GuardLongJumpTargetTable
	public UDATAPointer GuardLongJumpTargetTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardLongJumpTargetTableOffset_));
	}

	// U64 GuardMemcpyFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardMemcpyFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardMemcpyFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardMemcpyFunctionPointerOffset_));
	}

	// U64 GuardMemcpyFunctionPointer
	public UDATAPointer GuardMemcpyFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardMemcpyFunctionPointerOffset_));
	}

	// U64 GuardRFFailureRoutine
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardRFFailureRoutineOffset_", declaredType="U64")
	public UDATA GuardRFFailureRoutine() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardRFFailureRoutineOffset_));
	}

	// U64 GuardRFFailureRoutine
	public UDATAPointer GuardRFFailureRoutineEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardRFFailureRoutineOffset_));
	}

	// U64 GuardRFFailureRoutineFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardRFFailureRoutineFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardRFFailureRoutineFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardRFFailureRoutineFunctionPointerOffset_));
	}

	// U64 GuardRFFailureRoutineFunctionPointer
	public UDATAPointer GuardRFFailureRoutineFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardRFFailureRoutineFunctionPointerOffset_));
	}

	// U64 GuardRFVerifyStackPointerFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardRFVerifyStackPointerFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardRFVerifyStackPointerFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardRFVerifyStackPointerFunctionPointerOffset_));
	}

	// U64 GuardRFVerifyStackPointerFunctionPointer
	public UDATAPointer GuardRFVerifyStackPointerFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardRFVerifyStackPointerFunctionPointerOffset_));
	}

	// U64 GuardXFGCheckFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardXFGCheckFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardXFGCheckFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardXFGCheckFunctionPointerOffset_));
	}

	// U64 GuardXFGCheckFunctionPointer
	public UDATAPointer GuardXFGCheckFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardXFGCheckFunctionPointerOffset_));
	}

	// U64 GuardXFGDispatchFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardXFGDispatchFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardXFGDispatchFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardXFGDispatchFunctionPointerOffset_));
	}

	// U64 GuardXFGDispatchFunctionPointer
	public UDATAPointer GuardXFGDispatchFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardXFGDispatchFunctionPointerOffset_));
	}

	// U64 GuardXFGTableDispatchFunctionPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GuardXFGTableDispatchFunctionPointerOffset_", declaredType="U64")
	public UDATA GuardXFGTableDispatchFunctionPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardXFGTableDispatchFunctionPointerOffset_));
	}

	// U64 GuardXFGTableDispatchFunctionPointer
	public UDATAPointer GuardXFGTableDispatchFunctionPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._GuardXFGTableDispatchFunctionPointerOffset_));
	}

	// U32 HotPatchTableOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_HotPatchTableOffsetOffset_", declaredType="U32")
	public UDATA HotPatchTableOffset() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._HotPatchTableOffsetOffset_));
	}

	// U32 HotPatchTableOffset
	public UDATAPointer HotPatchTableOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._HotPatchTableOffsetOffset_));
	}

	// U64 LockPrefixTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LockPrefixTableOffset_", declaredType="U64")
	public UDATA LockPrefixTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._LockPrefixTableOffset_));
	}

	// U64 LockPrefixTable
	public UDATAPointer LockPrefixTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._LockPrefixTableOffset_));
	}

	// U16 MajorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MajorVersionOffset_", declaredType="U16")
	public U16 MajorVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._MajorVersionOffset_));
	}

	// U16 MajorVersion
	public U16Pointer MajorVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._MajorVersionOffset_));
	}

	// U64 MaximumAllocationSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MaximumAllocationSizeOffset_", declaredType="U64")
	public UDATA MaximumAllocationSize() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._MaximumAllocationSizeOffset_));
	}

	// U64 MaximumAllocationSize
	public UDATAPointer MaximumAllocationSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._MaximumAllocationSizeOffset_));
	}

	// U16 MinorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MinorVersionOffset_", declaredType="U16")
	public U16 MinorVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._MinorVersionOffset_));
	}

	// U16 MinorVersion
	public U16Pointer MinorVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._MinorVersionOffset_));
	}

	// U64 ProcessAffinityMask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessAffinityMaskOffset_", declaredType="U64")
	public UDATA ProcessAffinityMask() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._ProcessAffinityMaskOffset_));
	}

	// U64 ProcessAffinityMask
	public UDATAPointer ProcessAffinityMaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._ProcessAffinityMaskOffset_));
	}

	// U32 ProcessHeapFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessHeapFlagsOffset_", declaredType="U32")
	public UDATA ProcessHeapFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._ProcessHeapFlagsOffset_));
	}

	// U32 ProcessHeapFlags
	public UDATAPointer ProcessHeapFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._ProcessHeapFlagsOffset_));
	}

	// U16 Reserved2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved2Offset_", declaredType="U16")
	public U16 Reserved2() throws CorruptDataException {
		return new U16(getShortAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._Reserved2Offset_));
	}

	// U16 Reserved2
	public U16Pointer Reserved2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._Reserved2Offset_));
	}

	// U32 Reserved3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved3Offset_", declaredType="U32")
	public UDATA Reserved3() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._Reserved3Offset_));
	}

	// U32 Reserved3
	public UDATAPointer Reserved3EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._Reserved3Offset_));
	}

	// U64 SEHandlerCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SEHandlerCountOffset_", declaredType="U64")
	public UDATA SEHandlerCount() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SEHandlerCountOffset_));
	}

	// U64 SEHandlerCount
	public UDATAPointer SEHandlerCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SEHandlerCountOffset_));
	}

	// U64 SEHandlerTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SEHandlerTableOffset_", declaredType="U64")
	public UDATA SEHandlerTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SEHandlerTableOffset_));
	}

	// U64 SEHandlerTable
	public UDATAPointer SEHandlerTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SEHandlerTableOffset_));
	}

	// U64 SecurityCookie
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SecurityCookieOffset_", declaredType="U64")
	public UDATA SecurityCookie() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SecurityCookieOffset_));
	}

	// U64 SecurityCookie
	public UDATAPointer SecurityCookieEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SecurityCookieOffset_));
	}

	// U32 Size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOffset_", declaredType="U32")
	public UDATA Size() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SizeOffset_));
	}

	// U32 Size
	public UDATAPointer SizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._SizeOffset_));
	}

	// U32 TimeDateStamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TimeDateStampOffset_", declaredType="U32")
	public UDATA TimeDateStamp() throws CorruptDataException {
		return new U32(getIntAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._TimeDateStampOffset_));
	}

	// U32 TimeDateStamp
	public UDATAPointer TimeDateStampEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._TimeDateStampOffset_));
	}

	// U64 VirtualMemoryThreshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VirtualMemoryThresholdOffset_", declaredType="U64")
	public UDATA VirtualMemoryThreshold() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._VirtualMemoryThresholdOffset_));
	}

	// U64 VirtualMemoryThreshold
	public UDATAPointer VirtualMemoryThresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._VirtualMemoryThresholdOffset_));
	}

	// U64 VolatileMetadataPointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VolatileMetadataPointerOffset_", declaredType="U64")
	public UDATA VolatileMetadataPointer() throws CorruptDataException {
		return new U64(getLongAtOffset(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._VolatileMetadataPointerOffset_));
	}

	// U64 VolatileMetadataPointer
	public UDATAPointer VolatileMetadataPointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RS5_IMAGE_LOAD_CONFIG_DIRECTORY64._VolatileMetadataPointerOffset_));
	}

}
