/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _TEBPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _TEBPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_TEB.class)
public class _TEBPointer extends StructurePointer {

	// NULL
	public static final _TEBPointer NULL = new _TEBPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _TEBPointer(long address) {
		super(address);
	}

	public static _TEBPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _TEBPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _TEBPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _TEBPointer(address);
	}

	public _TEBPointer add(long count) {
		return _TEBPointer.cast(address + (_TEB.SIZEOF * count));
	}

	public _TEBPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _TEBPointer addOffset(long offset) {
		return _TEBPointer.cast(address + offset);
	}

	public _TEBPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _TEBPointer sub(long count) {
		return _TEBPointer.cast(address - (_TEB.SIZEOF * count));
	}

	public _TEBPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _TEBPointer subOffset(long offset) {
		return _TEBPointer.cast(address - offset);
	}

	public _TEBPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _TEBPointer untag(long mask) {
		return _TEBPointer.cast(address & ~mask);
	}

	public _TEBPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _TEB.SIZEOF;
	}

	// Implementation methods

	// _PEB* ProcessEnvironmentBlock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessEnvironmentBlockOffset_", declaredType="_PEB*")
	public _PEBPointer ProcessEnvironmentBlock() throws CorruptDataException {
		return _PEBPointer.cast(getPointerAtOffset(_TEB._ProcessEnvironmentBlockOffset_));
	}

	// _PEB* ProcessEnvironmentBlock
	public PointerPointer ProcessEnvironmentBlockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._ProcessEnvironmentBlockOffset_));
	}

	// void*[] Reserved1
	public PointerPointer Reserved1EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._Reserved1Offset_));
	}

	// void*[] Reserved2
	public PointerPointer Reserved2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._Reserved2Offset_));
	}

	// U8[] Reserved3
	public U8Pointer Reserved3EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_TEB._Reserved3Offset_));
	}

	// U8[] Reserved4
	public U8Pointer Reserved4EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_TEB._Reserved4Offset_));
	}

	// void*[] Reserved5
	public PointerPointer Reserved5EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._Reserved5Offset_));
	}

	// void*[] Reserved6
	public PointerPointer Reserved6EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._Reserved6Offset_));
	}

	// void* ReservedForOle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReservedForOleOffset_", declaredType="void*")
	public VoidPointer ReservedForOle() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_TEB._ReservedForOleOffset_));
	}

	// void* ReservedForOle
	public PointerPointer ReservedForOleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._ReservedForOleOffset_));
	}

	// void* TlsExpansionSlots
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TlsExpansionSlotsOffset_", declaredType="void*")
	public VoidPointer TlsExpansionSlots() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_TEB._TlsExpansionSlotsOffset_));
	}

	// void* TlsExpansionSlots
	public PointerPointer TlsExpansionSlotsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._TlsExpansionSlotsOffset_));
	}

	// void*[] TlsSlots
	public PointerPointer TlsSlotsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TEB._TlsSlotsOffset_));
	}

}
