/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _TP_CALLBACK_ENVIRON_V3Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _TP_CALLBACK_ENVIRON_V3Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_TP_CALLBACK_ENVIRON_V3.class)
public class _TP_CALLBACK_ENVIRON_V3Pointer extends StructurePointer {

	// NULL
	public static final _TP_CALLBACK_ENVIRON_V3Pointer NULL = new _TP_CALLBACK_ENVIRON_V3Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _TP_CALLBACK_ENVIRON_V3Pointer(long address) {
		super(address);
	}

	public static _TP_CALLBACK_ENVIRON_V3Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _TP_CALLBACK_ENVIRON_V3Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _TP_CALLBACK_ENVIRON_V3Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _TP_CALLBACK_ENVIRON_V3Pointer(address);
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer add(long count) {
		return _TP_CALLBACK_ENVIRON_V3Pointer.cast(address + (_TP_CALLBACK_ENVIRON_V3.SIZEOF * count));
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer addOffset(long offset) {
		return _TP_CALLBACK_ENVIRON_V3Pointer.cast(address + offset);
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer sub(long count) {
		return _TP_CALLBACK_ENVIRON_V3Pointer.cast(address - (_TP_CALLBACK_ENVIRON_V3.SIZEOF * count));
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer subOffset(long offset) {
		return _TP_CALLBACK_ENVIRON_V3Pointer.cast(address - offset);
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer untag(long mask) {
		return _TP_CALLBACK_ENVIRON_V3Pointer.cast(address & ~mask);
	}

	public _TP_CALLBACK_ENVIRON_V3Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _TP_CALLBACK_ENVIRON_V3.SIZEOF;
	}

	// Implementation methods

	// _ACTIVATION_CONTEXT* ActivationContext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ActivationContextOffset_", declaredType="_ACTIVATION_CONTEXT*")
	public _ACTIVATION_CONTEXTPointer ActivationContext() throws CorruptDataException {
		return _ACTIVATION_CONTEXTPointer.cast(getPointerAtOffset(_TP_CALLBACK_ENVIRON_V3._ActivationContextOffset_));
	}

	// _ACTIVATION_CONTEXT* ActivationContext
	public PointerPointer ActivationContextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._ActivationContextOffset_));
	}

	// _TP_CALLBACK_PRIORITY CallbackPriority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CallbackPriorityOffset_", declaredType="_TP_CALLBACK_PRIORITY")
	public long CallbackPriority() throws CorruptDataException {
		if (_TP_CALLBACK_PRIORITY.SIZEOF == 1) {
			return getByteAtOffset(_TP_CALLBACK_ENVIRON_V3._CallbackPriorityOffset_);
		} else if (_TP_CALLBACK_PRIORITY.SIZEOF == 2) {
			return getShortAtOffset(_TP_CALLBACK_ENVIRON_V3._CallbackPriorityOffset_);
		} else if (_TP_CALLBACK_PRIORITY.SIZEOF == 4) {
			return getIntAtOffset(_TP_CALLBACK_ENVIRON_V3._CallbackPriorityOffset_);
		} else if (_TP_CALLBACK_PRIORITY.SIZEOF == 8) {
			return getLongAtOffset(_TP_CALLBACK_ENVIRON_V3._CallbackPriorityOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// _TP_CALLBACK_PRIORITY CallbackPriority
	public EnumPointer CallbackPriorityEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._CallbackPriorityOffset_), _TP_CALLBACK_PRIORITY.class);
	}

	// _TP_CLEANUP_GROUP* CleanupGroup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CleanupGroupOffset_", declaredType="_TP_CLEANUP_GROUP*")
	public _TP_CLEANUP_GROUPPointer CleanupGroup() throws CorruptDataException {
		return _TP_CLEANUP_GROUPPointer.cast(getPointerAtOffset(_TP_CALLBACK_ENVIRON_V3._CleanupGroupOffset_));
	}

	// _TP_CLEANUP_GROUP* CleanupGroup
	public PointerPointer CleanupGroupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._CleanupGroupOffset_));
	}

	// void* CleanupGroupCancelCallback
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CleanupGroupCancelCallbackOffset_", declaredType="void*")
	public VoidPointer CleanupGroupCancelCallback() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_TP_CALLBACK_ENVIRON_V3._CleanupGroupCancelCallbackOffset_));
	}

	// void* CleanupGroupCancelCallback
	public PointerPointer CleanupGroupCancelCallbackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._CleanupGroupCancelCallbackOffset_));
	}

	// void* FinalizationCallback
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FinalizationCallbackOffset_", declaredType="void*")
	public VoidPointer FinalizationCallback() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_TP_CALLBACK_ENVIRON_V3._FinalizationCallbackOffset_));
	}

	// void* FinalizationCallback
	public PointerPointer FinalizationCallbackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._FinalizationCallbackOffset_));
	}

	// _TP_POOL* Pool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PoolOffset_", declaredType="_TP_POOL*")
	public _TP_POOLPointer Pool() throws CorruptDataException {
		return _TP_POOLPointer.cast(getPointerAtOffset(_TP_CALLBACK_ENVIRON_V3._PoolOffset_));
	}

	// _TP_POOL* Pool
	public PointerPointer PoolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._PoolOffset_));
	}

	// void* RaceDll
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RaceDllOffset_", declaredType="void*")
	public VoidPointer RaceDll() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_TP_CALLBACK_ENVIRON_V3._RaceDllOffset_));
	}

	// void* RaceDll
	public PointerPointer RaceDllEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._RaceDllOffset_));
	}

	// U32 Size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOffset_", declaredType="U32")
	public UDATA Size() throws CorruptDataException {
		return new U32(getIntAtOffset(_TP_CALLBACK_ENVIRON_V3._SizeOffset_));
	}

	// U32 Size
	public UDATAPointer SizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._SizeOffset_));
	}

	// U32 Version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VersionOffset_", declaredType="U32")
	public UDATA Version() throws CorruptDataException {
		return new U32(getIntAtOffset(_TP_CALLBACK_ENVIRON_V3._VersionOffset_));
	}

	// U32 Version
	public UDATAPointer VersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._VersionOffset_));
	}

	// U32 u.Flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$FlagsOffset_", declaredType="U32")
	public UDATA u$Flags() throws CorruptDataException {
		return new U32(getIntAtOffset(_TP_CALLBACK_ENVIRON_V3._u$FlagsOffset_));
	}

	// U32 u.Flags
	public UDATAPointer u$FlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_TP_CALLBACK_ENVIRON_V3._u$FlagsOffset_));
	}

	// U32:1 u.s.LongFunction
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$s$LongFunctionOffset_", declaredType="U32:1")
	public UDATA u$s$LongFunction() throws CorruptDataException {
		return getU32Bitfield(_TP_CALLBACK_ENVIRON_V3._u$s$LongFunction_s_, _TP_CALLBACK_ENVIRON_V3._u$s$LongFunction_b_);
	}

	// U32:1 u.s.Persistent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$s$PersistentOffset_", declaredType="U32:1")
	public UDATA u$s$Persistent() throws CorruptDataException {
		return getU32Bitfield(_TP_CALLBACK_ENVIRON_V3._u$s$Persistent_s_, _TP_CALLBACK_ENVIRON_V3._u$s$Persistent_b_);
	}

	// U32:30 u.s.Private
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$s$PrivateOffset_", declaredType="U32:30")
	public UDATA u$s$Private() throws CorruptDataException {
		return getU32Bitfield(_TP_CALLBACK_ENVIRON_V3._u$s$Private_s_, _TP_CALLBACK_ENVIRON_V3._u$s$Private_b_);
	}

}
