/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _WIN32_FIND_DATAWPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _WIN32_FIND_DATAWPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_WIN32_FIND_DATAW.class)
public class _WIN32_FIND_DATAWPointer extends StructurePointer {

	// NULL
	public static final _WIN32_FIND_DATAWPointer NULL = new _WIN32_FIND_DATAWPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _WIN32_FIND_DATAWPointer(long address) {
		super(address);
	}

	public static _WIN32_FIND_DATAWPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _WIN32_FIND_DATAWPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _WIN32_FIND_DATAWPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _WIN32_FIND_DATAWPointer(address);
	}

	public _WIN32_FIND_DATAWPointer add(long count) {
		return _WIN32_FIND_DATAWPointer.cast(address + (_WIN32_FIND_DATAW.SIZEOF * count));
	}

	public _WIN32_FIND_DATAWPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _WIN32_FIND_DATAWPointer addOffset(long offset) {
		return _WIN32_FIND_DATAWPointer.cast(address + offset);
	}

	public _WIN32_FIND_DATAWPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _WIN32_FIND_DATAWPointer sub(long count) {
		return _WIN32_FIND_DATAWPointer.cast(address - (_WIN32_FIND_DATAW.SIZEOF * count));
	}

	public _WIN32_FIND_DATAWPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _WIN32_FIND_DATAWPointer subOffset(long offset) {
		return _WIN32_FIND_DATAWPointer.cast(address - offset);
	}

	public _WIN32_FIND_DATAWPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _WIN32_FIND_DATAWPointer untag(long mask) {
		return _WIN32_FIND_DATAWPointer.cast(address & ~mask);
	}

	public _WIN32_FIND_DATAWPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _WIN32_FIND_DATAW.SIZEOF;
	}

	// Implementation methods

	// U16[] cAlternateFileName
	public U16Pointer cAlternateFileNameEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._cAlternateFileNameOffset_));
	}

	// U16[] cFileName
	public U16Pointer cFileNameEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._cFileNameOffset_));
	}

	// U32 dwFileAttributes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileAttributesOffset_", declaredType="U32")
	public UDATA dwFileAttributes() throws CorruptDataException {
		return new U32(getIntAtOffset(_WIN32_FIND_DATAW._dwFileAttributesOffset_));
	}

	// U32 dwFileAttributes
	public UDATAPointer dwFileAttributesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._dwFileAttributesOffset_));
	}

	// U32 dwReserved0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwReserved0Offset_", declaredType="U32")
	public UDATA dwReserved0() throws CorruptDataException {
		return new U32(getIntAtOffset(_WIN32_FIND_DATAW._dwReserved0Offset_));
	}

	// U32 dwReserved0
	public UDATAPointer dwReserved0EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._dwReserved0Offset_));
	}

	// U32 dwReserved1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwReserved1Offset_", declaredType="U32")
	public UDATA dwReserved1() throws CorruptDataException {
		return new U32(getIntAtOffset(_WIN32_FIND_DATAW._dwReserved1Offset_));
	}

	// U32 dwReserved1
	public UDATAPointer dwReserved1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._dwReserved1Offset_));
	}

	// _FILETIME ftCreationTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ftCreationTimeOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer ftCreationTime() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._ftCreationTimeOffset_));
	}

	// _FILETIME ftCreationTime
	public PointerPointer ftCreationTimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._ftCreationTimeOffset_));
	}

	// _FILETIME ftLastAccessTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ftLastAccessTimeOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer ftLastAccessTime() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._ftLastAccessTimeOffset_));
	}

	// _FILETIME ftLastAccessTime
	public PointerPointer ftLastAccessTimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._ftLastAccessTimeOffset_));
	}

	// _FILETIME ftLastWriteTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ftLastWriteTimeOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer ftLastWriteTime() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._ftLastWriteTimeOffset_));
	}

	// _FILETIME ftLastWriteTime
	public PointerPointer ftLastWriteTimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._ftLastWriteTimeOffset_));
	}

	// U32 nFileSizeHigh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nFileSizeHighOffset_", declaredType="U32")
	public UDATA nFileSizeHigh() throws CorruptDataException {
		return new U32(getIntAtOffset(_WIN32_FIND_DATAW._nFileSizeHighOffset_));
	}

	// U32 nFileSizeHigh
	public UDATAPointer nFileSizeHighEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._nFileSizeHighOffset_));
	}

	// U32 nFileSizeLow
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nFileSizeLowOffset_", declaredType="U32")
	public UDATA nFileSizeLow() throws CorruptDataException {
		return new U32(getIntAtOffset(_WIN32_FIND_DATAW._nFileSizeLowOffset_));
	}

	// U32 nFileSizeLow
	public UDATAPointer nFileSizeLowEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_WIN32_FIND_DATAW._nFileSizeLowOffset_));
	}

}
