/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: canonicalfp_tagPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the canonicalfp_tagPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=canonicalfp_tag.class)
public class canonicalfp_tagPointer extends StructurePointer {

	// NULL
	public static final canonicalfp_tagPointer NULL = new canonicalfp_tagPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected canonicalfp_tagPointer(long address) {
		super(address);
	}

	public static canonicalfp_tagPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static canonicalfp_tagPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static canonicalfp_tagPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new canonicalfp_tagPointer(address);
	}

	public canonicalfp_tagPointer add(long count) {
		return canonicalfp_tagPointer.cast(address + (canonicalfp_tag.SIZEOF * count));
	}

	public canonicalfp_tagPointer add(Scalar count) {
		return add(count.longValue());
	}

	public canonicalfp_tagPointer addOffset(long offset) {
		return canonicalfp_tagPointer.cast(address + offset);
	}

	public canonicalfp_tagPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public canonicalfp_tagPointer sub(long count) {
		return canonicalfp_tagPointer.cast(address - (canonicalfp_tag.SIZEOF * count));
	}

	public canonicalfp_tagPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public canonicalfp_tagPointer subOffset(long offset) {
		return canonicalfp_tagPointer.cast(address - offset);
	}

	public canonicalfp_tagPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public canonicalfp_tagPointer untag(long mask) {
		return canonicalfp_tagPointer.cast(address & ~mask);
	}

	public canonicalfp_tagPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return canonicalfp_tag.SIZEOF;
	}

	// Implementation methods

	// I32 exponent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_exponentOffset_", declaredType="I32")
	public IDATA exponent() throws CorruptDataException {
		return new I32(getIntAtOffset(canonicalfp_tag._exponentOffset_));
	}

	// I32 exponent
	public IDATAPointer exponentEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(canonicalfp_tag._exponentOffset_));
	}

	// U64 mantissa
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mantissaOffset_", declaredType="U64")
	public UDATA mantissa() throws CorruptDataException {
		return new U64(getLongAtOffset(canonicalfp_tag._mantissaOffset_));
	}

	// U64 mantissa
	public UDATAPointer mantissaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(canonicalfp_tag._mantissaOffset_));
	}

	// U64 overflow
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_overflowOffset_", declaredType="U64")
	public UDATA overflow() throws CorruptDataException {
		return new U64(getLongAtOffset(canonicalfp_tag._overflowOffset_));
	}

	// U64 overflow
	public UDATAPointer overflowEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(canonicalfp_tag._overflowOffset_));
	}

	// I32 sign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_signOffset_", declaredType="I32")
	public IDATA sign() throws CorruptDataException {
		return new I32(getIntAtOffset(canonicalfp_tag._signOffset_));
	}

	// I32 sign
	public IDATAPointer signEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(canonicalfp_tag._signOffset_));
	}

}
