/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: finalizeWorkerDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the finalizeWorkerDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=finalizeWorkerData.class)
public class finalizeWorkerDataPointer extends StructurePointer {

	// NULL
	public static final finalizeWorkerDataPointer NULL = new finalizeWorkerDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected finalizeWorkerDataPointer(long address) {
		super(address);
	}

	public static finalizeWorkerDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static finalizeWorkerDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static finalizeWorkerDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new finalizeWorkerDataPointer(address);
	}

	public finalizeWorkerDataPointer add(long count) {
		return finalizeWorkerDataPointer.cast(address + (finalizeWorkerData.SIZEOF * count));
	}

	public finalizeWorkerDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public finalizeWorkerDataPointer addOffset(long offset) {
		return finalizeWorkerDataPointer.cast(address + offset);
	}

	public finalizeWorkerDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public finalizeWorkerDataPointer sub(long count) {
		return finalizeWorkerDataPointer.cast(address - (finalizeWorkerData.SIZEOF * count));
	}

	public finalizeWorkerDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public finalizeWorkerDataPointer subOffset(long offset) {
		return finalizeWorkerDataPointer.cast(address - offset);
	}

	public finalizeWorkerDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public finalizeWorkerDataPointer untag(long mask) {
		return finalizeWorkerDataPointer.cast(address & ~mask);
	}

	public finalizeWorkerDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return finalizeWorkerData.SIZEOF;
	}

	// Implementation methods

	// I64 die
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dieOffset_", declaredType="I64")
	public IDATA die() throws CorruptDataException {
		return new I64(getLongAtOffset(finalizeWorkerData._dieOffset_));
	}

	// I64 die
	public IDATAPointer dieEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(finalizeWorkerData._dieOffset_));
	}

	// I64 finished
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_finishedOffset_", declaredType="I64")
	public IDATA finished() throws CorruptDataException {
		return new I64(getLongAtOffset(finalizeWorkerData._finishedOffset_));
	}

	// I64 finished
	public IDATAPointer finishedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(finalizeWorkerData._finishedOffset_));
	}

	// I64 mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_modeOffset_", declaredType="I64")
	public IDATA mode() throws CorruptDataException {
		return new I64(getLongAtOffset(finalizeWorkerData._modeOffset_));
	}

	// I64 mode
	public IDATAPointer modeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(finalizeWorkerData._modeOffset_));
	}

	// J9ThreadMonitor* monitor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_monitorOffset_", declaredType="J9ThreadMonitor*")
	public J9ThreadMonitorPointer monitor() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(finalizeWorkerData._monitorOffset_));
	}

	// J9ThreadMonitor* monitor
	public PointerPointer monitorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(finalizeWorkerData._monitorOffset_));
	}

	// I64 noWorkDone
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_noWorkDoneOffset_", declaredType="I64")
	public IDATA noWorkDone() throws CorruptDataException {
		return new I64(getLongAtOffset(finalizeWorkerData._noWorkDoneOffset_));
	}

	// I64 noWorkDone
	public IDATAPointer noWorkDoneEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(finalizeWorkerData._noWorkDoneOffset_));
	}

	// J9JavaVM* vm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmOffset_", declaredType="J9JavaVM*")
	public J9JavaVMPointer vm() throws CorruptDataException {
		return J9JavaVMPointer.cast(getPointerAtOffset(finalizeWorkerData._vmOffset_));
	}

	// J9JavaVM* vm
	public PointerPointer vmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(finalizeWorkerData._vmOffset_));
	}

	// J9VMThread* vmThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer vmThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(finalizeWorkerData._vmThreadOffset_));
	}

	// J9VMThread* vmThread
	public PointerPointer vmThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(finalizeWorkerData._vmThreadOffset_));
	}

	// I64 wakeUp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wakeUpOffset_", declaredType="I64")
	public IDATA wakeUp() throws CorruptDataException {
		return new I64(getLongAtOffset(finalizeWorkerData._wakeUpOffset_));
	}

	// I64 wakeUp
	public IDATAPointer wakeUpEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(finalizeWorkerData._wakeUpOffset_));
	}

}
