/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ip_msfilterPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ip_msfilterPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ip_msfilter.class)
public class ip_msfilterPointer extends StructurePointer {

	// NULL
	public static final ip_msfilterPointer NULL = new ip_msfilterPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ip_msfilterPointer(long address) {
		super(address);
	}

	public static ip_msfilterPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ip_msfilterPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ip_msfilterPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ip_msfilterPointer(address);
	}

	public ip_msfilterPointer add(long count) {
		return ip_msfilterPointer.cast(address + (ip_msfilter.SIZEOF * count));
	}

	public ip_msfilterPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ip_msfilterPointer addOffset(long offset) {
		return ip_msfilterPointer.cast(address + offset);
	}

	public ip_msfilterPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ip_msfilterPointer sub(long count) {
		return ip_msfilterPointer.cast(address - (ip_msfilter.SIZEOF * count));
	}

	public ip_msfilterPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ip_msfilterPointer subOffset(long offset) {
		return ip_msfilterPointer.cast(address - offset);
	}

	public ip_msfilterPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ip_msfilterPointer untag(long mask) {
		return ip_msfilterPointer.cast(address & ~mask);
	}

	public ip_msfilterPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ip_msfilter.SIZEOF;
	}

	// Implementation methods

	// MULTICAST_MODE_TYPE imsf_fmode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_imsf_fmodeOffset_", declaredType="MULTICAST_MODE_TYPE")
	public long imsf_fmode() throws CorruptDataException {
		if (MULTICAST_MODE_TYPE.SIZEOF == 1) {
			return getByteAtOffset(ip_msfilter._imsf_fmodeOffset_);
		} else if (MULTICAST_MODE_TYPE.SIZEOF == 2) {
			return getShortAtOffset(ip_msfilter._imsf_fmodeOffset_);
		} else if (MULTICAST_MODE_TYPE.SIZEOF == 4) {
			return getIntAtOffset(ip_msfilter._imsf_fmodeOffset_);
		} else if (MULTICAST_MODE_TYPE.SIZEOF == 8) {
			return getLongAtOffset(ip_msfilter._imsf_fmodeOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MULTICAST_MODE_TYPE imsf_fmode
	public EnumPointer imsf_fmodeEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(ip_msfilter._imsf_fmodeOffset_), MULTICAST_MODE_TYPE.class);
	}

	// in_addr imsf_interface
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_imsf_interfaceOffset_", declaredType="in_addr")
	public in_addrPointer imsf_interface() throws CorruptDataException {
		return in_addrPointer.cast(nonNullFieldEA(ip_msfilter._imsf_interfaceOffset_));
	}

	// in_addr imsf_interface
	public PointerPointer imsf_interfaceEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ip_msfilter._imsf_interfaceOffset_));
	}

	// in_addr imsf_multiaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_imsf_multiaddrOffset_", declaredType="in_addr")
	public in_addrPointer imsf_multiaddr() throws CorruptDataException {
		return in_addrPointer.cast(nonNullFieldEA(ip_msfilter._imsf_multiaddrOffset_));
	}

	// in_addr imsf_multiaddr
	public PointerPointer imsf_multiaddrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ip_msfilter._imsf_multiaddrOffset_));
	}

	// U32 imsf_numsrc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_imsf_numsrcOffset_", declaredType="U32")
	public UDATA imsf_numsrc() throws CorruptDataException {
		return new U32(getIntAtOffset(ip_msfilter._imsf_numsrcOffset_));
	}

	// U32 imsf_numsrc
	public UDATAPointer imsf_numsrcEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ip_msfilter._imsf_numsrcOffset_));
	}

	// in_addr[] imsf_slist
	public in_addrPointer imsf_slistEA() throws CorruptDataException {
		return in_addrPointer.cast(nonNullFieldEA(ip_msfilter._imsf_slistOffset_));
	}

}
