/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagFUNCDESCPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagFUNCDESCPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagFUNCDESC.class)
public class tagFUNCDESCPointer extends StructurePointer {

	// NULL
	public static final tagFUNCDESCPointer NULL = new tagFUNCDESCPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagFUNCDESCPointer(long address) {
		super(address);
	}

	public static tagFUNCDESCPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagFUNCDESCPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagFUNCDESCPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagFUNCDESCPointer(address);
	}

	public tagFUNCDESCPointer add(long count) {
		return tagFUNCDESCPointer.cast(address + (tagFUNCDESC.SIZEOF * count));
	}

	public tagFUNCDESCPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagFUNCDESCPointer addOffset(long offset) {
		return tagFUNCDESCPointer.cast(address + offset);
	}

	public tagFUNCDESCPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagFUNCDESCPointer sub(long count) {
		return tagFUNCDESCPointer.cast(address - (tagFUNCDESC.SIZEOF * count));
	}

	public tagFUNCDESCPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagFUNCDESCPointer subOffset(long offset) {
		return tagFUNCDESCPointer.cast(address - offset);
	}

	public tagFUNCDESCPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagFUNCDESCPointer untag(long mask) {
		return tagFUNCDESCPointer.cast(address & ~mask);
	}

	public tagFUNCDESCPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagFUNCDESC.SIZEOF;
	}

	// Implementation methods

	// I16 cParams
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cParamsOffset_", declaredType="I16")
	public I16 cParams() throws CorruptDataException {
		return new I16(getShortAtOffset(tagFUNCDESC._cParamsOffset_));
	}

	// I16 cParams
	public I16Pointer cParamsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagFUNCDESC._cParamsOffset_));
	}

	// I16 cParamsOpt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cParamsOptOffset_", declaredType="I16")
	public I16 cParamsOpt() throws CorruptDataException {
		return new I16(getShortAtOffset(tagFUNCDESC._cParamsOptOffset_));
	}

	// I16 cParamsOpt
	public I16Pointer cParamsOptEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagFUNCDESC._cParamsOptOffset_));
	}

	// I16 cScodes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cScodesOffset_", declaredType="I16")
	public I16 cScodes() throws CorruptDataException {
		return new I16(getShortAtOffset(tagFUNCDESC._cScodesOffset_));
	}

	// I16 cScodes
	public I16Pointer cScodesEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagFUNCDESC._cScodesOffset_));
	}

	// tagCALLCONV callconv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_callconvOffset_", declaredType="tagCALLCONV")
	public long callconv() throws CorruptDataException {
		if (tagCALLCONV.SIZEOF == 1) {
			return getByteAtOffset(tagFUNCDESC._callconvOffset_);
		} else if (tagCALLCONV.SIZEOF == 2) {
			return getShortAtOffset(tagFUNCDESC._callconvOffset_);
		} else if (tagCALLCONV.SIZEOF == 4) {
			return getIntAtOffset(tagFUNCDESC._callconvOffset_);
		} else if (tagCALLCONV.SIZEOF == 8) {
			return getLongAtOffset(tagFUNCDESC._callconvOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// tagCALLCONV callconv
	public EnumPointer callconvEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(tagFUNCDESC._callconvOffset_), tagCALLCONV.class);
	}

	// tagELEMDESC elemdescFunc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_elemdescFuncOffset_", declaredType="tagELEMDESC")
	public tagELEMDESCPointer elemdescFunc() throws CorruptDataException {
		return tagELEMDESCPointer.cast(nonNullFieldEA(tagFUNCDESC._elemdescFuncOffset_));
	}

	// tagELEMDESC elemdescFunc
	public PointerPointer elemdescFuncEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagFUNCDESC._elemdescFuncOffset_));
	}

	// tagFUNCKIND funckind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_funckindOffset_", declaredType="tagFUNCKIND")
	public long funckind() throws CorruptDataException {
		if (tagFUNCKIND.SIZEOF == 1) {
			return getByteAtOffset(tagFUNCDESC._funckindOffset_);
		} else if (tagFUNCKIND.SIZEOF == 2) {
			return getShortAtOffset(tagFUNCDESC._funckindOffset_);
		} else if (tagFUNCKIND.SIZEOF == 4) {
			return getIntAtOffset(tagFUNCDESC._funckindOffset_);
		} else if (tagFUNCKIND.SIZEOF == 8) {
			return getLongAtOffset(tagFUNCDESC._funckindOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// tagFUNCKIND funckind
	public EnumPointer funckindEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(tagFUNCDESC._funckindOffset_), tagFUNCKIND.class);
	}

	// tagINVOKEKIND invkind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_invkindOffset_", declaredType="tagINVOKEKIND")
	public long invkind() throws CorruptDataException {
		if (tagINVOKEKIND.SIZEOF == 1) {
			return getByteAtOffset(tagFUNCDESC._invkindOffset_);
		} else if (tagINVOKEKIND.SIZEOF == 2) {
			return getShortAtOffset(tagFUNCDESC._invkindOffset_);
		} else if (tagINVOKEKIND.SIZEOF == 4) {
			return getIntAtOffset(tagFUNCDESC._invkindOffset_);
		} else if (tagINVOKEKIND.SIZEOF == 8) {
			return getLongAtOffset(tagFUNCDESC._invkindOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// tagINVOKEKIND invkind
	public EnumPointer invkindEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(tagFUNCDESC._invkindOffset_), tagINVOKEKIND.class);
	}

	// tagELEMDESC* lprgelemdescParam
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lprgelemdescParamOffset_", declaredType="tagELEMDESC*")
	public tagELEMDESCPointer lprgelemdescParam() throws CorruptDataException {
		return tagELEMDESCPointer.cast(getPointerAtOffset(tagFUNCDESC._lprgelemdescParamOffset_));
	}

	// tagELEMDESC* lprgelemdescParam
	public PointerPointer lprgelemdescParamEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagFUNCDESC._lprgelemdescParamOffset_));
	}

	// I32* lprgscode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lprgscodeOffset_", declaredType="I32*")
	public IDATAPointer lprgscode() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(tagFUNCDESC._lprgscodeOffset_));
	}

	// I32* lprgscode
	public PointerPointer lprgscodeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagFUNCDESC._lprgscodeOffset_));
	}

	// I32 memid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memidOffset_", declaredType="I32")
	public IDATA memid() throws CorruptDataException {
		return new I32(getIntAtOffset(tagFUNCDESC._memidOffset_));
	}

	// I32 memid
	public IDATAPointer memidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagFUNCDESC._memidOffset_));
	}

	// I16 oVft
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_oVftOffset_", declaredType="I16")
	public I16 oVft() throws CorruptDataException {
		return new I16(getShortAtOffset(tagFUNCDESC._oVftOffset_));
	}

	// I16 oVft
	public I16Pointer oVftEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagFUNCDESC._oVftOffset_));
	}

	// U16 wFuncFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wFuncFlagsOffset_", declaredType="U16")
	public U16 wFuncFlags() throws CorruptDataException {
		return new U16(getShortAtOffset(tagFUNCDESC._wFuncFlagsOffset_));
	}

	// U16 wFuncFlags
	public U16Pointer wFuncFlagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagFUNCDESC._wFuncFlagsOffset_));
	}

}
