/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagPROPVARIANTPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagPROPVARIANTPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagPROPVARIANT.class)
public class tagPROPVARIANTPointer extends StructurePointer {

	// NULL
	public static final tagPROPVARIANTPointer NULL = new tagPROPVARIANTPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagPROPVARIANTPointer(long address) {
		super(address);
	}

	public static tagPROPVARIANTPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagPROPVARIANTPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagPROPVARIANTPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagPROPVARIANTPointer(address);
	}

	public tagPROPVARIANTPointer add(long count) {
		return tagPROPVARIANTPointer.cast(address + (tagPROPVARIANT.SIZEOF * count));
	}

	public tagPROPVARIANTPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagPROPVARIANTPointer addOffset(long offset) {
		return tagPROPVARIANTPointer.cast(address + offset);
	}

	public tagPROPVARIANTPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagPROPVARIANTPointer sub(long count) {
		return tagPROPVARIANTPointer.cast(address - (tagPROPVARIANT.SIZEOF * count));
	}

	public tagPROPVARIANTPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagPROPVARIANTPointer subOffset(long offset) {
		return tagPROPVARIANTPointer.cast(address - offset);
	}

	public tagPROPVARIANTPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagPROPVARIANTPointer untag(long mask) {
		return tagPROPVARIANTPointer.cast(address & ~mask);
	}

	public tagPROPVARIANTPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagPROPVARIANT.SIZEOF;
	}

	// Implementation methods

	// I16 __OBSOLETE__VARIANT_BOOL
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___OBSOLETE__VARIANT_BOOLOffset_", declaredType="I16")
	public I16 __OBSOLETE__VARIANT_BOOL() throws CorruptDataException {
		return new I16(getShortAtOffset(tagPROPVARIANT.___OBSOLETE__VARIANT_BOOLOffset_));
	}

	// I16 __OBSOLETE__VARIANT_BOOL
	public I16Pointer __OBSOLETE__VARIANT_BOOLEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagPROPVARIANT.___OBSOLETE__VARIANT_BOOLOffset_));
	}

	// U8 bVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bValOffset_", declaredType="U8")
	public U8 bVal() throws CorruptDataException {
		return new U8(getByteAtOffset(tagPROPVARIANT._bValOffset_));
	}

	// U8 bVal
	public U8Pointer bValEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tagPROPVARIANT._bValOffset_));
	}

	// tagBLOB blob
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_blobOffset_", declaredType="tagBLOB")
	public tagBLOBPointer blob() throws CorruptDataException {
		return tagBLOBPointer.cast(nonNullFieldEA(tagPROPVARIANT._blobOffset_));
	}

	// tagBLOB blob
	public PointerPointer blobEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._blobOffset_));
	}

	// I16 boolVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_boolValOffset_", declaredType="I16")
	public I16 boolVal() throws CorruptDataException {
		return new I16(getShortAtOffset(tagPROPVARIANT._boolValOffset_));
	}

	// I16 boolVal
	public I16Pointer boolValEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagPROPVARIANT._boolValOffset_));
	}

	// U16* bstrVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bstrValOffset_", declaredType="U16*")
	public U16Pointer bstrVal() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagPROPVARIANT._bstrValOffset_));
	}

	// U16* bstrVal
	public PointerPointer bstrValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._bstrValOffset_));
	}

	// tagBSTRBLOB bstrblobVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bstrblobValOffset_", declaredType="tagBSTRBLOB")
	public tagBSTRBLOBPointer bstrblobVal() throws CorruptDataException {
		return tagBSTRBLOBPointer.cast(nonNullFieldEA(tagPROPVARIANT._bstrblobValOffset_));
	}

	// tagBSTRBLOB bstrblobVal
	public PointerPointer bstrblobValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._bstrblobValOffset_));
	}

	// U8 cVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cValOffset_", declaredType="U8")
	public U8 cVal() throws CorruptDataException {
		return new U8(getByteAtOffset(tagPROPVARIANT._cValOffset_));
	}

	// U8 cVal
	public U8Pointer cValEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tagPROPVARIANT._cValOffset_));
	}

	// tagCABOOL cabool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_caboolOffset_", declaredType="tagCABOOL")
	public tagCABOOLPointer cabool() throws CorruptDataException {
		return tagCABOOLPointer.cast(nonNullFieldEA(tagPROPVARIANT._caboolOffset_));
	}

	// tagCABOOL cabool
	public PointerPointer caboolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._caboolOffset_));
	}

	// tagCABSTR cabstr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cabstrOffset_", declaredType="tagCABSTR")
	public tagCABSTRPointer cabstr() throws CorruptDataException {
		return tagCABSTRPointer.cast(nonNullFieldEA(tagPROPVARIANT._cabstrOffset_));
	}

	// tagCABSTR cabstr
	public PointerPointer cabstrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cabstrOffset_));
	}

	// tagCABSTRBLOB cabstrblob
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cabstrblobOffset_", declaredType="tagCABSTRBLOB")
	public tagCABSTRBLOBPointer cabstrblob() throws CorruptDataException {
		return tagCABSTRBLOBPointer.cast(nonNullFieldEA(tagPROPVARIANT._cabstrblobOffset_));
	}

	// tagCABSTRBLOB cabstrblob
	public PointerPointer cabstrblobEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cabstrblobOffset_));
	}

	// tagCAC cac
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacOffset_", declaredType="tagCAC")
	public tagCACPointer cac() throws CorruptDataException {
		return tagCACPointer.cast(nonNullFieldEA(tagPROPVARIANT._cacOffset_));
	}

	// tagCAC cac
	public PointerPointer cacEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cacOffset_));
	}

	// tagCACLIPDATA caclipdata
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_caclipdataOffset_", declaredType="tagCACLIPDATA")
	public tagCACLIPDATAPointer caclipdata() throws CorruptDataException {
		return tagCACLIPDATAPointer.cast(nonNullFieldEA(tagPROPVARIANT._caclipdataOffset_));
	}

	// tagCACLIPDATA caclipdata
	public PointerPointer caclipdataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._caclipdataOffset_));
	}

	// tagCACY cacy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacyOffset_", declaredType="tagCACY")
	public tagCACYPointer cacy() throws CorruptDataException {
		return tagCACYPointer.cast(nonNullFieldEA(tagPROPVARIANT._cacyOffset_));
	}

	// tagCACY cacy
	public PointerPointer cacyEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cacyOffset_));
	}

	// tagCADATE cadate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cadateOffset_", declaredType="tagCADATE")
	public tagCADATEPointer cadate() throws CorruptDataException {
		return tagCADATEPointer.cast(nonNullFieldEA(tagPROPVARIANT._cadateOffset_));
	}

	// tagCADATE cadate
	public PointerPointer cadateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cadateOffset_));
	}

	// tagCADBL cadbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cadblOffset_", declaredType="tagCADBL")
	public tagCADBLPointer cadbl() throws CorruptDataException {
		return tagCADBLPointer.cast(nonNullFieldEA(tagPROPVARIANT._cadblOffset_));
	}

	// tagCADBL cadbl
	public PointerPointer cadblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cadblOffset_));
	}

	// tagCAFILETIME cafiletime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cafiletimeOffset_", declaredType="tagCAFILETIME")
	public tagCAFILETIMEPointer cafiletime() throws CorruptDataException {
		return tagCAFILETIMEPointer.cast(nonNullFieldEA(tagPROPVARIANT._cafiletimeOffset_));
	}

	// tagCAFILETIME cafiletime
	public PointerPointer cafiletimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cafiletimeOffset_));
	}

	// tagCAFLT caflt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cafltOffset_", declaredType="tagCAFLT")
	public tagCAFLTPointer caflt() throws CorruptDataException {
		return tagCAFLTPointer.cast(nonNullFieldEA(tagPROPVARIANT._cafltOffset_));
	}

	// tagCAFLT caflt
	public PointerPointer cafltEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cafltOffset_));
	}

	// tagCAH cah
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cahOffset_", declaredType="tagCAH")
	public tagCAHPointer cah() throws CorruptDataException {
		return tagCAHPointer.cast(nonNullFieldEA(tagPROPVARIANT._cahOffset_));
	}

	// tagCAH cah
	public PointerPointer cahEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cahOffset_));
	}

	// tagCAI cai
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_caiOffset_", declaredType="tagCAI")
	public tagCAIPointer cai() throws CorruptDataException {
		return tagCAIPointer.cast(nonNullFieldEA(tagPROPVARIANT._caiOffset_));
	}

	// tagCAI cai
	public PointerPointer caiEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._caiOffset_));
	}

	// tagCAL cal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_calOffset_", declaredType="tagCAL")
	public tagCALPointer cal() throws CorruptDataException {
		return tagCALPointer.cast(nonNullFieldEA(tagPROPVARIANT._calOffset_));
	}

	// tagCAL cal
	public PointerPointer calEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._calOffset_));
	}

	// tagCALPSTR calpstr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_calpstrOffset_", declaredType="tagCALPSTR")
	public tagCALPSTRPointer calpstr() throws CorruptDataException {
		return tagCALPSTRPointer.cast(nonNullFieldEA(tagPROPVARIANT._calpstrOffset_));
	}

	// tagCALPSTR calpstr
	public PointerPointer calpstrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._calpstrOffset_));
	}

	// tagCALPWSTR calpwstr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_calpwstrOffset_", declaredType="tagCALPWSTR")
	public tagCALPWSTRPointer calpwstr() throws CorruptDataException {
		return tagCALPWSTRPointer.cast(nonNullFieldEA(tagPROPVARIANT._calpwstrOffset_));
	}

	// tagCALPWSTR calpwstr
	public PointerPointer calpwstrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._calpwstrOffset_));
	}

	// tagCAPROPVARIANT capropvar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_capropvarOffset_", declaredType="tagCAPROPVARIANT")
	public tagCAPROPVARIANTPointer capropvar() throws CorruptDataException {
		return tagCAPROPVARIANTPointer.cast(nonNullFieldEA(tagPROPVARIANT._capropvarOffset_));
	}

	// tagCAPROPVARIANT capropvar
	public PointerPointer capropvarEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._capropvarOffset_));
	}

	// tagCASCODE cascode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cascodeOffset_", declaredType="tagCASCODE")
	public tagCASCODEPointer cascode() throws CorruptDataException {
		return tagCASCODEPointer.cast(nonNullFieldEA(tagPROPVARIANT._cascodeOffset_));
	}

	// tagCASCODE cascode
	public PointerPointer cascodeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cascodeOffset_));
	}

	// tagCAUB caub
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_caubOffset_", declaredType="tagCAUB")
	public tagCAUBPointer caub() throws CorruptDataException {
		return tagCAUBPointer.cast(nonNullFieldEA(tagPROPVARIANT._caubOffset_));
	}

	// tagCAUB caub
	public PointerPointer caubEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._caubOffset_));
	}

	// tagCAUH cauh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cauhOffset_", declaredType="tagCAUH")
	public tagCAUHPointer cauh() throws CorruptDataException {
		return tagCAUHPointer.cast(nonNullFieldEA(tagPROPVARIANT._cauhOffset_));
	}

	// tagCAUH cauh
	public PointerPointer cauhEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cauhOffset_));
	}

	// tagCAUI caui
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cauiOffset_", declaredType="tagCAUI")
	public tagCAUIPointer caui() throws CorruptDataException {
		return tagCAUIPointer.cast(nonNullFieldEA(tagPROPVARIANT._cauiOffset_));
	}

	// tagCAUI caui
	public PointerPointer cauiEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cauiOffset_));
	}

	// tagCAUL caul
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_caulOffset_", declaredType="tagCAUL")
	public tagCAULPointer caul() throws CorruptDataException {
		return tagCAULPointer.cast(nonNullFieldEA(tagPROPVARIANT._caulOffset_));
	}

	// tagCAUL caul
	public PointerPointer caulEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._caulOffset_));
	}

	// tagCACLSID cauuid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cauuidOffset_", declaredType="tagCACLSID")
	public tagCACLSIDPointer cauuid() throws CorruptDataException {
		return tagCACLSIDPointer.cast(nonNullFieldEA(tagPROPVARIANT._cauuidOffset_));
	}

	// tagCACLSID cauuid
	public PointerPointer cauuidEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cauuidOffset_));
	}

	// tagCY cyVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cyValOffset_", declaredType="tagCY")
	public tagCYPointer cyVal() throws CorruptDataException {
		return tagCYPointer.cast(nonNullFieldEA(tagPROPVARIANT._cyValOffset_));
	}

	// tagCY cyVal
	public PointerPointer cyValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._cyValOffset_));
	}

	// double date
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dateOffset_", declaredType="double")
	public double date() throws CorruptDataException {
		return getDoubleAtOffset(tagPROPVARIANT._dateOffset_);
	}

	// double date
	public DoublePointer dateEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(tagPROPVARIANT._dateOffset_));
	}

	// double dblVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dblValOffset_", declaredType="double")
	public double dblVal() throws CorruptDataException {
		return getDoubleAtOffset(tagPROPVARIANT._dblValOffset_);
	}

	// double dblVal
	public DoublePointer dblValEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(tagPROPVARIANT._dblValOffset_));
	}

	// tagDEC decVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_decValOffset_", declaredType="tagDEC")
	public tagDECPointer decVal() throws CorruptDataException {
		return tagDECPointer.cast(nonNullFieldEA(tagPROPVARIANT._decValOffset_));
	}

	// tagDEC decVal
	public PointerPointer decValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._decValOffset_));
	}

	// _FILETIME filetime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_filetimeOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer filetime() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(tagPROPVARIANT._filetimeOffset_));
	}

	// _FILETIME filetime
	public PointerPointer filetimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._filetimeOffset_));
	}

	// float fltVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fltValOffset_", declaredType="float")
	public float fltVal() throws CorruptDataException {
		return getFloatAtOffset(tagPROPVARIANT._fltValOffset_);
	}

	// float fltVal
	public FloatPointer fltValEA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(tagPROPVARIANT._fltValOffset_));
	}

	// _LARGE_INTEGER hVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hValOffset_", declaredType="_LARGE_INTEGER")
	public _LARGE_INTEGERPointer hVal() throws CorruptDataException {
		return _LARGE_INTEGERPointer.cast(nonNullFieldEA(tagPROPVARIANT._hValOffset_));
	}

	// _LARGE_INTEGER hVal
	public PointerPointer hValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._hValOffset_));
	}

	// I16 iVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iValOffset_", declaredType="I16")
	public I16 iVal() throws CorruptDataException {
		return new I16(getShortAtOffset(tagPROPVARIANT._iValOffset_));
	}

	// I16 iVal
	public I16Pointer iValEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagPROPVARIANT._iValOffset_));
	}

	// I32 intVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_intValOffset_", declaredType="I32")
	public IDATA intVal() throws CorruptDataException {
		return new I32(getIntAtOffset(tagPROPVARIANT._intValOffset_));
	}

	// I32 intVal
	public IDATAPointer intValEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagPROPVARIANT._intValOffset_));
	}

	// I32 lVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lValOffset_", declaredType="I32")
	public IDATA lVal() throws CorruptDataException {
		return new I32(getIntAtOffset(tagPROPVARIANT._lValOffset_));
	}

	// I32 lVal
	public IDATAPointer lValEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagPROPVARIANT._lValOffset_));
	}

	// IStorage* pStorage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pStorageOffset_", declaredType="IStorage*")
	public IStoragePointer pStorage() throws CorruptDataException {
		return IStoragePointer.cast(getPointerAtOffset(tagPROPVARIANT._pStorageOffset_));
	}

	// IStorage* pStorage
	public PointerPointer pStorageEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pStorageOffset_));
	}

	// IStream* pStream
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pStreamOffset_", declaredType="IStream*")
	public IStreamPointer pStream() throws CorruptDataException {
		return IStreamPointer.cast(getPointerAtOffset(tagPROPVARIANT._pStreamOffset_));
	}

	// IStream* pStream
	public PointerPointer pStreamEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pStreamOffset_));
	}

	// tagVersionedStream* pVersionedStream
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pVersionedStreamOffset_", declaredType="tagVersionedStream*")
	public tagVersionedStreamPointer pVersionedStream() throws CorruptDataException {
		return tagVersionedStreamPointer.cast(getPointerAtOffset(tagPROPVARIANT._pVersionedStreamOffset_));
	}

	// tagVersionedStream* pVersionedStream
	public PointerPointer pVersionedStreamEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pVersionedStreamOffset_));
	}

	// tagSAFEARRAY* parray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_parrayOffset_", declaredType="tagSAFEARRAY*")
	public tagSAFEARRAYPointer parray() throws CorruptDataException {
		return tagSAFEARRAYPointer.cast(getPointerAtOffset(tagPROPVARIANT._parrayOffset_));
	}

	// tagSAFEARRAY* parray
	public PointerPointer parrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._parrayOffset_));
	}

	// U8* pbVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pbValOffset_", declaredType="U8*")
	public U8Pointer pbVal() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pbValOffset_));
	}

	// U8* pbVal
	public PointerPointer pbValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pbValOffset_));
	}

	// I16* pboolVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pboolValOffset_", declaredType="I16*")
	public I16Pointer pboolVal() throws CorruptDataException {
		return I16Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pboolValOffset_));
	}

	// I16* pboolVal
	public PointerPointer pboolValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pboolValOffset_));
	}

	// void** pbstrVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pbstrValOffset_", declaredType="void**")
	public PointerPointer pbstrVal() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagPROPVARIANT._pbstrValOffset_));
	}

	// void** pbstrVal
	public PointerPointer pbstrValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pbstrValOffset_));
	}

	// U8* pcVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcValOffset_", declaredType="U8*")
	public U8Pointer pcVal() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pcValOffset_));
	}

	// U8* pcVal
	public PointerPointer pcValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pcValOffset_));
	}

	// tagCLIPDATA* pclipdata
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pclipdataOffset_", declaredType="tagCLIPDATA*")
	public tagCLIPDATAPointer pclipdata() throws CorruptDataException {
		return tagCLIPDATAPointer.cast(getPointerAtOffset(tagPROPVARIANT._pclipdataOffset_));
	}

	// tagCLIPDATA* pclipdata
	public PointerPointer pclipdataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pclipdataOffset_));
	}

	// tagCY* pcyVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcyValOffset_", declaredType="tagCY*")
	public tagCYPointer pcyVal() throws CorruptDataException {
		return tagCYPointer.cast(getPointerAtOffset(tagPROPVARIANT._pcyValOffset_));
	}

	// tagCY* pcyVal
	public PointerPointer pcyValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pcyValOffset_));
	}

	// double* pdate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdateOffset_", declaredType="double*")
	public DoublePointer pdate() throws CorruptDataException {
		return DoublePointer.cast(getPointerAtOffset(tagPROPVARIANT._pdateOffset_));
	}

	// double* pdate
	public PointerPointer pdateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pdateOffset_));
	}

	// double* pdblVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdblValOffset_", declaredType="double*")
	public DoublePointer pdblVal() throws CorruptDataException {
		return DoublePointer.cast(getPointerAtOffset(tagPROPVARIANT._pdblValOffset_));
	}

	// double* pdblVal
	public PointerPointer pdblValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pdblValOffset_));
	}

	// tagDEC* pdecVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdecValOffset_", declaredType="tagDEC*")
	public tagDECPointer pdecVal() throws CorruptDataException {
		return tagDECPointer.cast(getPointerAtOffset(tagPROPVARIANT._pdecValOffset_));
	}

	// tagDEC* pdecVal
	public PointerPointer pdecValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pdecValOffset_));
	}

	// IDispatch* pdispVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdispValOffset_", declaredType="IDispatch*")
	public IDispatchPointer pdispVal() throws CorruptDataException {
		return IDispatchPointer.cast(getPointerAtOffset(tagPROPVARIANT._pdispValOffset_));
	}

	// IDispatch* pdispVal
	public PointerPointer pdispValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pdispValOffset_));
	}

	// float* pfltVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pfltValOffset_", declaredType="float*")
	public FloatPointer pfltVal() throws CorruptDataException {
		return FloatPointer.cast(getPointerAtOffset(tagPROPVARIANT._pfltValOffset_));
	}

	// float* pfltVal
	public PointerPointer pfltValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pfltValOffset_));
	}

	// I16* piVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_piValOffset_", declaredType="I16*")
	public I16Pointer piVal() throws CorruptDataException {
		return I16Pointer.cast(getPointerAtOffset(tagPROPVARIANT._piValOffset_));
	}

	// I16* piVal
	public PointerPointer piValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._piValOffset_));
	}

	// I32* pintVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pintValOffset_", declaredType="I32*")
	public IDATAPointer pintVal() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pintValOffset_));
	}

	// I32* pintVal
	public PointerPointer pintValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pintValOffset_));
	}

	// I32* plVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_plValOffset_", declaredType="I32*")
	public IDATAPointer plVal() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(tagPROPVARIANT._plValOffset_));
	}

	// I32* plVal
	public PointerPointer plValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._plValOffset_));
	}

	// void** pparray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pparrayOffset_", declaredType="void**")
	public PointerPointer pparray() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagPROPVARIANT._pparrayOffset_));
	}

	// void** pparray
	public PointerPointer pparrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pparrayOffset_));
	}

	// void** ppdispVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ppdispValOffset_", declaredType="void**")
	public PointerPointer ppdispVal() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagPROPVARIANT._ppdispValOffset_));
	}

	// void** ppdispVal
	public PointerPointer ppdispValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._ppdispValOffset_));
	}

	// void** ppunkVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ppunkValOffset_", declaredType="void**")
	public PointerPointer ppunkVal() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagPROPVARIANT._ppunkValOffset_));
	}

	// void** ppunkVal
	public PointerPointer ppunkValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._ppunkValOffset_));
	}

	// I32* pscode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pscodeOffset_", declaredType="I32*")
	public IDATAPointer pscode() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pscodeOffset_));
	}

	// I32* pscode
	public PointerPointer pscodeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pscodeOffset_));
	}

	// U8* pszVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszValOffset_", declaredType="U8*")
	public U8Pointer pszVal() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pszValOffset_));
	}

	// U8* pszVal
	public PointerPointer pszValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pszValOffset_));
	}

	// U16* puiVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puiValOffset_", declaredType="U16*")
	public U16Pointer puiVal() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagPROPVARIANT._puiValOffset_));
	}

	// U16* puiVal
	public PointerPointer puiValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._puiValOffset_));
	}

	// U32* puintVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puintValOffset_", declaredType="U32*")
	public UDATAPointer puintVal() throws CorruptDataException {
		return U32Pointer.cast(getPointerAtOffset(tagPROPVARIANT._puintValOffset_));
	}

	// U32* puintVal
	public PointerPointer puintValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._puintValOffset_));
	}

	// U32* pulVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pulValOffset_", declaredType="U32*")
	public UDATAPointer pulVal() throws CorruptDataException {
		return U32Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pulValOffset_));
	}

	// U32* pulVal
	public PointerPointer pulValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pulValOffset_));
	}

	// IUnknown* punkVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_punkValOffset_", declaredType="IUnknown*")
	public IUnknownPointer punkVal() throws CorruptDataException {
		return IUnknownPointer.cast(getPointerAtOffset(tagPROPVARIANT._punkValOffset_));
	}

	// IUnknown* punkVal
	public PointerPointer punkValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._punkValOffset_));
	}

	// _GUID* puuid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puuidOffset_", declaredType="_GUID*")
	public _GUIDPointer puuid() throws CorruptDataException {
		return _GUIDPointer.cast(getPointerAtOffset(tagPROPVARIANT._puuidOffset_));
	}

	// _GUID* puuid
	public PointerPointer puuidEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._puuidOffset_));
	}

	// tagPROPVARIANT* pvarVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pvarValOffset_", declaredType="tagPROPVARIANT*")
	public tagPROPVARIANTPointer pvarVal() throws CorruptDataException {
		return tagPROPVARIANTPointer.cast(getPointerAtOffset(tagPROPVARIANT._pvarValOffset_));
	}

	// tagPROPVARIANT* pvarVal
	public PointerPointer pvarValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pvarValOffset_));
	}

	// U16* pwszVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwszValOffset_", declaredType="U16*")
	public U16Pointer pwszVal() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagPROPVARIANT._pwszValOffset_));
	}

	// U16* pwszVal
	public PointerPointer pwszValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._pwszValOffset_));
	}

	// I32 scode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scodeOffset_", declaredType="I32")
	public IDATA scode() throws CorruptDataException {
		return new I32(getIntAtOffset(tagPROPVARIANT._scodeOffset_));
	}

	// I32 scode
	public IDATAPointer scodeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagPROPVARIANT._scodeOffset_));
	}

	// _ULARGE_INTEGER uhVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uhValOffset_", declaredType="_ULARGE_INTEGER")
	public _ULARGE_INTEGERPointer uhVal() throws CorruptDataException {
		return _ULARGE_INTEGERPointer.cast(nonNullFieldEA(tagPROPVARIANT._uhValOffset_));
	}

	// _ULARGE_INTEGER uhVal
	public PointerPointer uhValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPROPVARIANT._uhValOffset_));
	}

	// U16 uiVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uiValOffset_", declaredType="U16")
	public U16 uiVal() throws CorruptDataException {
		return new U16(getShortAtOffset(tagPROPVARIANT._uiValOffset_));
	}

	// U16 uiVal
	public U16Pointer uiValEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagPROPVARIANT._uiValOffset_));
	}

	// U32 uintVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uintValOffset_", declaredType="U32")
	public UDATA uintVal() throws CorruptDataException {
		return new U32(getIntAtOffset(tagPROPVARIANT._uintValOffset_));
	}

	// U32 uintVal
	public UDATAPointer uintValEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagPROPVARIANT._uintValOffset_));
	}

	// U32 ulVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ulValOffset_", declaredType="U32")
	public UDATA ulVal() throws CorruptDataException {
		return new U32(getIntAtOffset(tagPROPVARIANT._ulValOffset_));
	}

	// U32 ulVal
	public UDATAPointer ulValEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagPROPVARIANT._ulValOffset_));
	}

	// U16 vt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vtOffset_", declaredType="U16")
	public U16 vt() throws CorruptDataException {
		return new U16(getShortAtOffset(tagPROPVARIANT._vtOffset_));
	}

	// U16 vt
	public U16Pointer vtEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagPROPVARIANT._vtOffset_));
	}

	// U16 wReserved1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReserved1Offset_", declaredType="U16")
	public U16 wReserved1() throws CorruptDataException {
		return new U16(getShortAtOffset(tagPROPVARIANT._wReserved1Offset_));
	}

	// U16 wReserved1
	public U16Pointer wReserved1EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagPROPVARIANT._wReserved1Offset_));
	}

	// U16 wReserved2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReserved2Offset_", declaredType="U16")
	public U16 wReserved2() throws CorruptDataException {
		return new U16(getShortAtOffset(tagPROPVARIANT._wReserved2Offset_));
	}

	// U16 wReserved2
	public U16Pointer wReserved2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagPROPVARIANT._wReserved2Offset_));
	}

	// U16 wReserved3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReserved3Offset_", declaredType="U16")
	public U16 wReserved3() throws CorruptDataException {
		return new U16(getShortAtOffset(tagPROPVARIANT._wReserved3Offset_));
	}

	// U16 wReserved3
	public U16Pointer wReserved3EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagPROPVARIANT._wReserved3Offset_));
	}

}
