/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagTHREADENTRY32Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagTHREADENTRY32Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagTHREADENTRY32.class)
public class tagTHREADENTRY32Pointer extends StructurePointer {

	// NULL
	public static final tagTHREADENTRY32Pointer NULL = new tagTHREADENTRY32Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagTHREADENTRY32Pointer(long address) {
		super(address);
	}

	public static tagTHREADENTRY32Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagTHREADENTRY32Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagTHREADENTRY32Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagTHREADENTRY32Pointer(address);
	}

	public tagTHREADENTRY32Pointer add(long count) {
		return tagTHREADENTRY32Pointer.cast(address + (tagTHREADENTRY32.SIZEOF * count));
	}

	public tagTHREADENTRY32Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagTHREADENTRY32Pointer addOffset(long offset) {
		return tagTHREADENTRY32Pointer.cast(address + offset);
	}

	public tagTHREADENTRY32Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagTHREADENTRY32Pointer sub(long count) {
		return tagTHREADENTRY32Pointer.cast(address - (tagTHREADENTRY32.SIZEOF * count));
	}

	public tagTHREADENTRY32Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagTHREADENTRY32Pointer subOffset(long offset) {
		return tagTHREADENTRY32Pointer.cast(address - offset);
	}

	public tagTHREADENTRY32Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagTHREADENTRY32Pointer untag(long mask) {
		return tagTHREADENTRY32Pointer.cast(address & ~mask);
	}

	public tagTHREADENTRY32Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagTHREADENTRY32.SIZEOF;
	}

	// Implementation methods

	// U32 cntUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cntUsageOffset_", declaredType="U32")
	public UDATA cntUsage() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTHREADENTRY32._cntUsageOffset_));
	}

	// U32 cntUsage
	public UDATAPointer cntUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTHREADENTRY32._cntUsageOffset_));
	}

	// U32 dwFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFlagsOffset_", declaredType="U32")
	public UDATA dwFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTHREADENTRY32._dwFlagsOffset_));
	}

	// U32 dwFlags
	public UDATAPointer dwFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTHREADENTRY32._dwFlagsOffset_));
	}

	// U32 dwSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwSizeOffset_", declaredType="U32")
	public UDATA dwSize() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTHREADENTRY32._dwSizeOffset_));
	}

	// U32 dwSize
	public UDATAPointer dwSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTHREADENTRY32._dwSizeOffset_));
	}

	// U32 th32OwnerProcessID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_th32OwnerProcessIDOffset_", declaredType="U32")
	public UDATA th32OwnerProcessID() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTHREADENTRY32._th32OwnerProcessIDOffset_));
	}

	// U32 th32OwnerProcessID
	public UDATAPointer th32OwnerProcessIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTHREADENTRY32._th32OwnerProcessIDOffset_));
	}

	// U32 th32ThreadID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_th32ThreadIDOffset_", declaredType="U32")
	public UDATA th32ThreadID() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTHREADENTRY32._th32ThreadIDOffset_));
	}

	// U32 th32ThreadID
	public UDATAPointer th32ThreadIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTHREADENTRY32._th32ThreadIDOffset_));
	}

	// I32 tpBasePri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tpBasePriOffset_", declaredType="I32")
	public IDATA tpBasePri() throws CorruptDataException {
		return new I32(getIntAtOffset(tagTHREADENTRY32._tpBasePriOffset_));
	}

	// I32 tpBasePri
	public IDATAPointer tpBasePriEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagTHREADENTRY32._tpBasePriOffset_));
	}

	// I32 tpDeltaPri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tpDeltaPriOffset_", declaredType="I32")
	public IDATA tpDeltaPri() throws CorruptDataException {
		return new I32(getIntAtOffset(tagTHREADENTRY32._tpDeltaPriOffset_));
	}

	// I32 tpDeltaPri
	public IDATAPointer tpDeltaPriEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagTHREADENTRY32._tpDeltaPriOffset_));
	}

}
