/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagTLIBATTRPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagTLIBATTRPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagTLIBATTR.class)
public class tagTLIBATTRPointer extends StructurePointer {

	// NULL
	public static final tagTLIBATTRPointer NULL = new tagTLIBATTRPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagTLIBATTRPointer(long address) {
		super(address);
	}

	public static tagTLIBATTRPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagTLIBATTRPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagTLIBATTRPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagTLIBATTRPointer(address);
	}

	public tagTLIBATTRPointer add(long count) {
		return tagTLIBATTRPointer.cast(address + (tagTLIBATTR.SIZEOF * count));
	}

	public tagTLIBATTRPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagTLIBATTRPointer addOffset(long offset) {
		return tagTLIBATTRPointer.cast(address + offset);
	}

	public tagTLIBATTRPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagTLIBATTRPointer sub(long count) {
		return tagTLIBATTRPointer.cast(address - (tagTLIBATTR.SIZEOF * count));
	}

	public tagTLIBATTRPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagTLIBATTRPointer subOffset(long offset) {
		return tagTLIBATTRPointer.cast(address - offset);
	}

	public tagTLIBATTRPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagTLIBATTRPointer untag(long mask) {
		return tagTLIBATTRPointer.cast(address & ~mask);
	}

	public tagTLIBATTRPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagTLIBATTR.SIZEOF;
	}

	// Implementation methods

	// _GUID guid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_guidOffset_", declaredType="_GUID")
	public _GUIDPointer guid() throws CorruptDataException {
		return _GUIDPointer.cast(nonNullFieldEA(tagTLIBATTR._guidOffset_));
	}

	// _GUID guid
	public PointerPointer guidEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagTLIBATTR._guidOffset_));
	}

	// U32 lcid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lcidOffset_", declaredType="U32")
	public UDATA lcid() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTLIBATTR._lcidOffset_));
	}

	// U32 lcid
	public UDATAPointer lcidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTLIBATTR._lcidOffset_));
	}

	// tagSYSKIND syskind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_syskindOffset_", declaredType="tagSYSKIND")
	public long syskind() throws CorruptDataException {
		if (tagSYSKIND.SIZEOF == 1) {
			return getByteAtOffset(tagTLIBATTR._syskindOffset_);
		} else if (tagSYSKIND.SIZEOF == 2) {
			return getShortAtOffset(tagTLIBATTR._syskindOffset_);
		} else if (tagSYSKIND.SIZEOF == 4) {
			return getIntAtOffset(tagTLIBATTR._syskindOffset_);
		} else if (tagSYSKIND.SIZEOF == 8) {
			return getLongAtOffset(tagTLIBATTR._syskindOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// tagSYSKIND syskind
	public EnumPointer syskindEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(tagTLIBATTR._syskindOffset_), tagSYSKIND.class);
	}

	// U16 wLibFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wLibFlagsOffset_", declaredType="U16")
	public U16 wLibFlags() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTLIBATTR._wLibFlagsOffset_));
	}

	// U16 wLibFlags
	public U16Pointer wLibFlagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTLIBATTR._wLibFlagsOffset_));
	}

	// U16 wMajorVerNum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wMajorVerNumOffset_", declaredType="U16")
	public U16 wMajorVerNum() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTLIBATTR._wMajorVerNumOffset_));
	}

	// U16 wMajorVerNum
	public U16Pointer wMajorVerNumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTLIBATTR._wMajorVerNumOffset_));
	}

	// U16 wMinorVerNum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wMinorVerNumOffset_", declaredType="U16")
	public U16 wMinorVerNum() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTLIBATTR._wMinorVerNumOffset_));
	}

	// U16 wMinorVerNum
	public U16Pointer wMinorVerNumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTLIBATTR._wMinorVerNumOffset_));
	}

}
