/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagVARDESCPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagVARDESCPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagVARDESC.class)
public class tagVARDESCPointer extends StructurePointer {

	// NULL
	public static final tagVARDESCPointer NULL = new tagVARDESCPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagVARDESCPointer(long address) {
		super(address);
	}

	public static tagVARDESCPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagVARDESCPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagVARDESCPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagVARDESCPointer(address);
	}

	public tagVARDESCPointer add(long count) {
		return tagVARDESCPointer.cast(address + (tagVARDESC.SIZEOF * count));
	}

	public tagVARDESCPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagVARDESCPointer addOffset(long offset) {
		return tagVARDESCPointer.cast(address + offset);
	}

	public tagVARDESCPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagVARDESCPointer sub(long count) {
		return tagVARDESCPointer.cast(address - (tagVARDESC.SIZEOF * count));
	}

	public tagVARDESCPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagVARDESCPointer subOffset(long offset) {
		return tagVARDESCPointer.cast(address - offset);
	}

	public tagVARDESCPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagVARDESCPointer untag(long mask) {
		return tagVARDESCPointer.cast(address & ~mask);
	}

	public tagVARDESCPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagVARDESC.SIZEOF;
	}

	// Implementation methods

	// tagELEMDESC elemdescVar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_elemdescVarOffset_", declaredType="tagELEMDESC")
	public tagELEMDESCPointer elemdescVar() throws CorruptDataException {
		return tagELEMDESCPointer.cast(nonNullFieldEA(tagVARDESC._elemdescVarOffset_));
	}

	// tagELEMDESC elemdescVar
	public PointerPointer elemdescVarEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARDESC._elemdescVarOffset_));
	}

	// U16* lpstrSchema
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpstrSchemaOffset_", declaredType="U16*")
	public U16Pointer lpstrSchema() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagVARDESC._lpstrSchemaOffset_));
	}

	// U16* lpstrSchema
	public PointerPointer lpstrSchemaEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARDESC._lpstrSchemaOffset_));
	}

	// tagVARIANT* lpvarValue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpvarValueOffset_", declaredType="tagVARIANT*")
	public tagVARIANTPointer lpvarValue() throws CorruptDataException {
		return tagVARIANTPointer.cast(getPointerAtOffset(tagVARDESC._lpvarValueOffset_));
	}

	// tagVARIANT* lpvarValue
	public PointerPointer lpvarValueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARDESC._lpvarValueOffset_));
	}

	// I32 memid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memidOffset_", declaredType="I32")
	public IDATA memid() throws CorruptDataException {
		return new I32(getIntAtOffset(tagVARDESC._memidOffset_));
	}

	// I32 memid
	public IDATAPointer memidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagVARDESC._memidOffset_));
	}

	// U32 oInst
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_oInstOffset_", declaredType="U32")
	public UDATA oInst() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVARDESC._oInstOffset_));
	}

	// U32 oInst
	public UDATAPointer oInstEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVARDESC._oInstOffset_));
	}

	// tagVARKIND varkind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_varkindOffset_", declaredType="tagVARKIND")
	public long varkind() throws CorruptDataException {
		if (tagVARKIND.SIZEOF == 1) {
			return getByteAtOffset(tagVARDESC._varkindOffset_);
		} else if (tagVARKIND.SIZEOF == 2) {
			return getShortAtOffset(tagVARDESC._varkindOffset_);
		} else if (tagVARKIND.SIZEOF == 4) {
			return getIntAtOffset(tagVARDESC._varkindOffset_);
		} else if (tagVARKIND.SIZEOF == 8) {
			return getLongAtOffset(tagVARDESC._varkindOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// tagVARKIND varkind
	public EnumPointer varkindEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(tagVARDESC._varkindOffset_), tagVARKIND.class);
	}

	// U16 wVarFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wVarFlagsOffset_", declaredType="U16")
	public U16 wVarFlags() throws CorruptDataException {
		return new U16(getShortAtOffset(tagVARDESC._wVarFlagsOffset_));
	}

	// U16 wVarFlags
	public U16Pointer wVarFlagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagVARDESC._wVarFlagsOffset_));
	}

}
