/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagVS_FIXEDFILEINFOPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagVS_FIXEDFILEINFOPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagVS_FIXEDFILEINFO.class)
public class tagVS_FIXEDFILEINFOPointer extends StructurePointer {

	// NULL
	public static final tagVS_FIXEDFILEINFOPointer NULL = new tagVS_FIXEDFILEINFOPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagVS_FIXEDFILEINFOPointer(long address) {
		super(address);
	}

	public static tagVS_FIXEDFILEINFOPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagVS_FIXEDFILEINFOPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagVS_FIXEDFILEINFOPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagVS_FIXEDFILEINFOPointer(address);
	}

	public tagVS_FIXEDFILEINFOPointer add(long count) {
		return tagVS_FIXEDFILEINFOPointer.cast(address + (tagVS_FIXEDFILEINFO.SIZEOF * count));
	}

	public tagVS_FIXEDFILEINFOPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagVS_FIXEDFILEINFOPointer addOffset(long offset) {
		return tagVS_FIXEDFILEINFOPointer.cast(address + offset);
	}

	public tagVS_FIXEDFILEINFOPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagVS_FIXEDFILEINFOPointer sub(long count) {
		return tagVS_FIXEDFILEINFOPointer.cast(address - (tagVS_FIXEDFILEINFO.SIZEOF * count));
	}

	public tagVS_FIXEDFILEINFOPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagVS_FIXEDFILEINFOPointer subOffset(long offset) {
		return tagVS_FIXEDFILEINFOPointer.cast(address - offset);
	}

	public tagVS_FIXEDFILEINFOPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagVS_FIXEDFILEINFOPointer untag(long mask) {
		return tagVS_FIXEDFILEINFOPointer.cast(address & ~mask);
	}

	public tagVS_FIXEDFILEINFOPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagVS_FIXEDFILEINFO.SIZEOF;
	}

	// Implementation methods

	// U32 dwFileDateLS
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileDateLSOffset_", declaredType="U32")
	public UDATA dwFileDateLS() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileDateLSOffset_));
	}

	// U32 dwFileDateLS
	public UDATAPointer dwFileDateLSEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileDateLSOffset_));
	}

	// U32 dwFileDateMS
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileDateMSOffset_", declaredType="U32")
	public UDATA dwFileDateMS() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileDateMSOffset_));
	}

	// U32 dwFileDateMS
	public UDATAPointer dwFileDateMSEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileDateMSOffset_));
	}

	// U32 dwFileFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileFlagsOffset_", declaredType="U32")
	public UDATA dwFileFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileFlagsOffset_));
	}

	// U32 dwFileFlags
	public UDATAPointer dwFileFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileFlagsOffset_));
	}

	// U32 dwFileFlagsMask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileFlagsMaskOffset_", declaredType="U32")
	public UDATA dwFileFlagsMask() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileFlagsMaskOffset_));
	}

	// U32 dwFileFlagsMask
	public UDATAPointer dwFileFlagsMaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileFlagsMaskOffset_));
	}

	// U32 dwFileOS
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileOSOffset_", declaredType="U32")
	public UDATA dwFileOS() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileOSOffset_));
	}

	// U32 dwFileOS
	public UDATAPointer dwFileOSEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileOSOffset_));
	}

	// U32 dwFileSubtype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileSubtypeOffset_", declaredType="U32")
	public UDATA dwFileSubtype() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileSubtypeOffset_));
	}

	// U32 dwFileSubtype
	public UDATAPointer dwFileSubtypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileSubtypeOffset_));
	}

	// U32 dwFileType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileTypeOffset_", declaredType="U32")
	public UDATA dwFileType() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileTypeOffset_));
	}

	// U32 dwFileType
	public UDATAPointer dwFileTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileTypeOffset_));
	}

	// U32 dwFileVersionLS
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileVersionLSOffset_", declaredType="U32")
	public UDATA dwFileVersionLS() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileVersionLSOffset_));
	}

	// U32 dwFileVersionLS
	public UDATAPointer dwFileVersionLSEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileVersionLSOffset_));
	}

	// U32 dwFileVersionMS
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFileVersionMSOffset_", declaredType="U32")
	public UDATA dwFileVersionMS() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwFileVersionMSOffset_));
	}

	// U32 dwFileVersionMS
	public UDATAPointer dwFileVersionMSEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwFileVersionMSOffset_));
	}

	// U32 dwProductVersionLS
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwProductVersionLSOffset_", declaredType="U32")
	public UDATA dwProductVersionLS() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwProductVersionLSOffset_));
	}

	// U32 dwProductVersionLS
	public UDATAPointer dwProductVersionLSEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwProductVersionLSOffset_));
	}

	// U32 dwProductVersionMS
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwProductVersionMSOffset_", declaredType="U32")
	public UDATA dwProductVersionMS() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwProductVersionMSOffset_));
	}

	// U32 dwProductVersionMS
	public UDATAPointer dwProductVersionMSEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwProductVersionMSOffset_));
	}

	// U32 dwSignature
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwSignatureOffset_", declaredType="U32")
	public UDATA dwSignature() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwSignatureOffset_));
	}

	// U32 dwSignature
	public UDATAPointer dwSignatureEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwSignatureOffset_));
	}

	// U32 dwStrucVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwStrucVersionOffset_", declaredType="U32")
	public UDATA dwStrucVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVS_FIXEDFILEINFO._dwStrucVersionOffset_));
	}

	// U32 dwStrucVersion
	public UDATAPointer dwStrucVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVS_FIXEDFILEINFO._dwStrucVersionOffset_));
	}

}
