/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: uchar3Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the uchar3Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=uchar3.class)
public class uchar3Pointer extends StructurePointer {

	// NULL
	public static final uchar3Pointer NULL = new uchar3Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected uchar3Pointer(long address) {
		super(address);
	}

	public static uchar3Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static uchar3Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static uchar3Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new uchar3Pointer(address);
	}

	public uchar3Pointer add(long count) {
		return uchar3Pointer.cast(address + (uchar3.SIZEOF * count));
	}

	public uchar3Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public uchar3Pointer addOffset(long offset) {
		return uchar3Pointer.cast(address + offset);
	}

	public uchar3Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public uchar3Pointer sub(long count) {
		return uchar3Pointer.cast(address - (uchar3.SIZEOF * count));
	}

	public uchar3Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public uchar3Pointer subOffset(long offset) {
		return uchar3Pointer.cast(address - offset);
	}

	public uchar3Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public uchar3Pointer untag(long mask) {
		return uchar3Pointer.cast(address & ~mask);
	}

	public uchar3Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return uchar3.SIZEOF;
	}

	// Implementation methods

	// U8 x
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xOffset_", declaredType="U8")
	public U8 x() throws CorruptDataException {
		return new U8(getByteAtOffset(uchar3._xOffset_));
	}

	// U8 x
	public U8Pointer xEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(uchar3._xOffset_));
	}

	// U8 y
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_yOffset_", declaredType="U8")
	public U8 y() throws CorruptDataException {
		return new U8(getByteAtOffset(uchar3._yOffset_));
	}

	// U8 y
	public U8Pointer yEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(uchar3._yOffset_));
	}

	// U8 z
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_zOffset_", declaredType="U8")
	public U8 z() throws CorruptDataException {
		return new U8(getByteAtOffset(uchar3._zOffset_));
	}

	// U8 z
	public U8Pointer zEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(uchar3._zOffset_));
	}

}
