/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9JavaVM
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9JavaVM {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9VM_DEBUG_ATTRIBUTE_ALLOW_RETRANSFORM;
	public static final long J9VM_DEBUG_ATTRIBUTE_ALLOW_USER_HEAP_WALK;
	public static final long J9VM_DEBUG_ATTRIBUTE_CAN_ACCESS_LOCALS;
	public static final long J9VM_DEBUG_ATTRIBUTE_CAN_POP_FRAMES;
	public static final long J9VM_DEBUG_ATTRIBUTE_CAN_REDEFINE_CLASSES;
	public static final long J9VM_DEBUG_ATTRIBUTE_LINE_NUMBER_TABLE;
	public static final long J9VM_DEBUG_ATTRIBUTE_LOCAL_VARIABLE_TABLE;
	public static final long J9VM_DEBUG_ATTRIBUTE_MAINTAIN_FULL_INLINE_MAP;
	public static final long J9VM_DEBUG_ATTRIBUTE_MAINTAIN_ORIGINAL_METHOD_ORDER;
	public static final long J9VM_DEBUG_ATTRIBUTE_RECORD_ALL;
	public static final long J9VM_DEBUG_ATTRIBUTE_SOURCE_DEBUG_EXTENSION;
	public static final long J9VM_DEBUG_ATTRIBUTE_SOURCE_FILE;
	public static final long J9VM_DEFLATION_POLICY_ASAP;
	public static final long J9VM_DEFLATION_POLICY_NEVER;
	public static final long J9VM_DEFLATION_POLICY_SMART;
	public static final long J9VM_IDENTIFIER;
	public static final long J9VM_PHASE_EARLY_STARTUP;
	public static final long J9VM_PHASE_NOT_STARTUP;
	public static final long J9VM_PHASE_STARTUP;
	public static final long J9VM_ZERO_DEFAULT_OPTIONS;
	public static final long J9VM_ZERO_SHAREBOOTZIPCACHE;

	// Offsets

	public static final int _EsJNIFunctionsOffset_;
	public static final int _J9SigQuitShutdownOffset_;
	public static final int _abortHookOffset_;
	public static final int _accumulatedThreadCountOffset_;
	public static final int _addExportsOffset_;
	public static final int _addModulesCountOffset_;
	public static final int _addOpensOffset_;
	public static final int _addProvidesOffset_;
	public static final int _addReadsOffset_;
	public static final int _addUsesOffset_;
	public static final int _alreadyHaveExclusiveOffset_;
	public static final int _alternateJitDirOffset_;
	public static final int _anonClassCountOffset_;
	public static final int _anonClassLoaderOffset_;
	public static final int _aotFindAndInitializeMethodEntryPointOffset_;
	public static final int _aotInitializeJxeEntryPointOffset_;
	public static final int _aotRuntimeInitMutexOffset_;
	public static final int _applicationClassLoaderOffset_;
	public static final int _arrayROMClassesOffset_;
	public static final int _arrayletLeafLogSizeOffset_;
	public static final int _arrayletLeafSizeOffset_;
	public static final int _asyncEventHandlersOffset_;
	public static final int _asyncEventMutexOffset_;
	public static final int _attachContextOffset_;
	public static final int _bindNativeMutexOffset_;
	public static final int _blockedContinuationsOffset_;
	public static final int _blockedVirtualThreadsMutexOffset_;
	public static final int _booleanArrayClassOffset_;
	public static final int _booleanReflectClassOffset_;
	public static final int _bootstrapClassPathOffset_;
	public static final int _byteArrayClassOffset_;
	public static final int _byteReflectClassOffset_;
	public static final int _bytecodeLoopOffset_;
	public static final int _bytecodeVerificationDataOffset_;
	public static final int _cInterpreterOffset_;
	public static final int _cacheFreeOffset_;
	public static final int _cacheMissOffset_;
	public static final int _callInReturnPCOffset_;
	public static final int _cancelAbsoluteThresholdOffset_;
	public static final int _charArrayClassOffset_;
	public static final int _charReflectClassOffset_;
	public static final int _checkJNIDataOffset_;
	public static final int _cifArgumentTypesCacheOffset_;
	public static final int _cifArgumentTypesCacheMutexOffset_;
	public static final int _cifNativeCalloutDataCacheOffset_;
	public static final int _cifNativeCalloutDataCacheMutexOffset_;
	public static final int _classLoaderAllocationCountOffset_;
	public static final int _classLoaderBlocksOffset_;
	public static final int _classLoaderBlocksMutexOffset_;
	public static final int _classLoaderModuleAndLocationMutexOffset_;
	public static final int _classLoadingConstraintsOffset_;
	public static final int _classLoadingMaxStackOffset_;
	public static final int _classLoadingStackPoolOffset_;
	public static final int _classMemorySegmentsOffset_;
	public static final int _classTableMutexOffset_;
	public static final int _classUnloadMutexOffset_;
	public static final int _closeScopeMutexOffset_;
	public static final int _closeScopeNotifyCountOffset_;
	public static final int _codertOldAboutToBootstrapOffset_;
	public static final int _codertOldVMShutdownOffset_;
	public static final int _collectJitPrivateThreadDataOffset_;
	public static final int _compatibilityFlagsOffset_;
	public static final int _compressedPointersShiftOffset_;
	public static final int _constantDynamicMutexOffset_;
	public static final int _contendedLoadTableOffset_;
	public static final int _contiguousIndexableHeaderSizeOffset_;
	public static final int _continuationT1SizeOffset_;
	public static final int _continuationT2CacheOffset_;
	public static final int _continuationT2SizeOffset_;
	public static final int _cpuCacheWritebackCapabilitiesOffset_;
	public static final int _cudaGlobalsOffset_;
	public static final int _customSpinOptionsOffset_;
	public static final int _dCacheLineSizeOffset_;
	public static final int _daemonThreadCountOffset_;
	public static final int _deadThreadListOffset_;
	public static final int _debugField1Offset_;
	public static final int _decompileNameOffset_;
	public static final int _defaultMemorySpaceOffset_;
	public static final int _defaultOSStackSizeOffset_;
	public static final int _destroyVMStateOffset_;
	public static final int _directByteBufferMemoryMaxOffset_;
	public static final int _disclaimableRAMSegmentCountOffset_;
	public static final int _disclaimableROMSegmentCountOffset_;
	public static final int _discontiguousIndexableHeaderSizeOffset_;
	public static final int _dllLoadTableOffset_;
	public static final int _doubleArrayClassOffset_;
	public static final int _doubleJITExitInterpreterOffset_;
	public static final int _doubleReflectClassOffset_;
	public static final int _dynamicLoadBuffersOffset_;
	public static final int _dynamicLoadClassAllocationIncrementOffset_;
	public static final int _enableGlobalLockReservationOffset_;
	public static final int _ensureHashedClassesOffset_;
	public static final int _exclusiveAccessMutexOffset_;
	public static final int _exclusiveAccessResponseCountOffset_;
	public static final int _exclusiveAccessStateOffset_;
	public static final int _exclusiveVMAccessQueueHeadOffset_;
	public static final int _exclusiveVMAccessQueueTailOffset_;
	public static final int _exitHookOffset_;
	public static final int _extendedMethodFlagsMutexOffset_;
	public static final int _extendedRuntimeFlagsOffset_;
	public static final int _extendedRuntimeFlags2Offset_;
	public static final int _extendedRuntimeFlags3Offset_;
	public static final int _extensionClassLoaderOffset_;
	public static final int _fieldIndexMutexOffset_;
	public static final int _fieldIndexTableOffset_;
	public static final int _fieldIndexThresholdOffset_;
	public static final int _finalizeFlagsOffset_;
	public static final int _finalizeForceClassLoaderUnloadCountOffset_;
	public static final int _finalizeMainFlagsOffset_;
	public static final int _finalizeMainMonitorOffset_;
	public static final int _finalizeMainThreadOffset_;
	public static final int _finalizeRunFinalizationCountOffset_;
	public static final int _finalizeRunFinalizationMutexOffset_;
	public static final int _finalizeWorkerDataOffset_;
	public static final int _floatArrayClassOffset_;
	public static final int _floatJITExitInterpreterOffset_;
	public static final int _floatReflectClassOffset_;
	public static final int _flushFunctionOffset_;
	public static final int _freeAotRuntimeInfoOffset_;
	public static final int _freePreviousClassLoadersOffset_;
	public static final int _gcAllocationTypeOffset_;
	public static final int _gcExtensionsOffset_;
	public static final int _gcOptionsOffset_;
	public static final int _gcPolicyOffset_;
	public static final int _gcReadBarrierTypeOffset_;
	public static final int _gcWriteBarrierTypeOffset_;
	public static final int _globalEventFlagsOffset_;
	public static final int _globalHotFieldPoolMutexOffset_;
	public static final int _heapBaseOffset_;
	public static final int _heapOOMStringRefOffset_;
	public static final int _heapTopOffset_;
	public static final int _hiddenFinalizeLinkFieldShapeOffset_;
	public static final int _hiddenInstanceFieldsOffset_;
	public static final int _hiddenInstanceFieldsMutexOffset_;
	public static final int _hiddenLockwordFieldShapeOffset_;
	public static final int _hookInterfaceOffset_;
	public static final int _hookVMEventOffset_;
	public static final int _hotFieldClassInfoPoolOffset_;
	public static final int _hotFieldClassInfoPoolMutexOffset_;
	public static final int _hotSwapCountOffset_;
	public static final int _identityHashDataOffset_;
	public static final int _impdep1PCOffset_;
	public static final int _indexableObjectLayoutOffset_;
	public static final int _initialMethodsOffset_;
	public static final int _initialStackSizeOffset_;
	public static final int _initializeSlotsOnTLHAllocateOffset_;
	public static final int _intArrayClassOffset_;
	public static final int _intReflectClassOffset_;
	public static final int _internalSuspendStateOffsetOffset_;
	public static final int _internalVMFunctionsOffset_;
	public static final int _internalVMLabelsOffset_;
	public static final int _isAgentLibraryLoadedOffset_;
	public static final int _isClassUnloadMutexHeldForRedefinitionOffset_;
	public static final int _isIndexableDataAddrPresentOffset_;
	public static final int _isIndexableDualHeaderShapeEnabledOffset_;
	public static final int _j2seRootDirectoryOffset_;
	public static final int _j2seVersionOffset_;
	public static final int _j9Thread2JavaPriorityMapOffset_;
	public static final int _j9libvmDirectoryOffset_;
	public static final int _j9rasOffset_;
	public static final int _j9rasDumpFunctionsOffset_;
	public static final int _j9rasGlobalStorageOffset_;
	public static final int _j9rasdumpGlobalStorageOffset_;
	public static final int _java2J9ThreadPriorityMapOffset_;
	public static final int _javaBaseModuleOffset_;
	public static final int _javaHomeOffset_;
	public static final int _javaVMOffset_;
	public static final int _java_nio_BufferOffset_;
	public static final int _java_nio_Buffer_addressOffset_;
	public static final int _java_nio_Buffer_capacityOffset_;
	public static final int _java_nio_DirectByteBufferOffset_;
	public static final int _java_nio_DirectByteBuffer_initOffset_;
	public static final int _jclCacheMutexOffset_;
	public static final int _jclConstantPoolOffset_;
	public static final int _jclFlagsOffset_;
	public static final int _jclSysPropBufferOffset_;
	public static final int _jfrAsyncKeyOffset_;
	public static final int _jfrBufferOffset_;
	public static final int _jfrBufferMutexOffset_;
	public static final int _jfrSamplerMutexOffset_;
	public static final int _jfrSamplerStateOffset_;
	public static final int _jfrSamplerThreadOffset_;
	public static final int _jfrStateOffset_;
	public static final int _jfrThreadCPULoadAsyncKeyOffset_;
	public static final int _jimModulesOffset_;
	public static final int _jimageIntfOffset_;
	public static final int _jitConfigOffset_;
	public static final int _jitExceptionHandlerSearchOffset_;
	public static final int _jitGetOwnedObjectMonitorsOffset_;
	public static final int _jitOldAboutToBootstrapOffset_;
	public static final int _jitOldVMShutdownOffset_;
	public static final int _jitVMEntryKeepAliveOffsetOffset_;
	public static final int _jitWalkStackFramesOffset_;
	public static final int _jliArgumentHelperOffset_;
	public static final int _jliMethodHandleInvokeWithArgsOffset_;
	public static final int _jliMethodHandleInvokeWithArgsListOffset_;
	public static final int _jlrMethodInvokeOffset_;
	public static final int _jlrMethodInvokeMHOffset_;
	public static final int _jniArrayCacheMaxSizeOffset_;
	public static final int _jniCriticalLockOffset_;
	public static final int _jniCriticalResponseCountOffset_;
	public static final int _jniFrameMutexOffset_;
	public static final int _jniFunctionTableOffset_;
	public static final int _jniGlobalReferencesOffset_;
	public static final int _jniSendTargetOffset_;
	public static final int _jniWeakGlobalReferencesOffset_;
	public static final int _jvmExtensionInterfaceOffset_;
	public static final int _jvmtiDataOffset_;
	public static final int _layoutStrFFITypeTableOffset_;
	public static final int _linkNextOffset_;
	public static final int _linkPreviousOffset_;
	public static final int _loadAgentLibraryOnAttachOffset_;
	public static final int _loadedClassCountOffset_;
	public static final int _localMapFunctionOffset_;
	public static final int _lockwordExceptionsOffset_;
	public static final int _lockwordModeOffset_;
	public static final int _longArrayClassOffset_;
	public static final int _longReflectClassOffset_;
	public static final int _mainThreadOffset_;
	public static final int _managementDataOffset_;
	public static final int _mapMemoryBufferOffset_;
	public static final int _mapMemoryBufferMutexOffset_;
	public static final int _mapMemoryBufferSizeOffset_;
	public static final int _mapMemoryResultsBufferOffset_;
	public static final int _maxCStackUseOffset_;
	public static final int _maxInvariantLocalTableNodeCountOffset_;
	public static final int _maxStackUseOffset_;
	public static final int _memberNameListNodePoolOffset_;
	public static final int _memberNameListsMutexOffset_;
	public static final int _memoryManagerFunctionsOffset_;
	public static final int _memoryMaxOffset_;
	public static final int _memorySegmentsOffset_;
	public static final int _methodHandleCompileCountOffset_;
	public static final int _minimumLearningRatioOffset_;
	public static final int _minimumReservedRatioOffset_;
	public static final int _minimumSuperclassArraySizeOffset_;
	public static final int _modularityPoolOffset_;
	public static final int _modulePointerOffsetOffset_;
	public static final int _modulesPathEntryOffset_;
	public static final int _monitorTableCountOffset_;
	public static final int _monitorTableListOffset_;
	public static final int _monitorTableListPoolOffset_;
	public static final int _monitorTableMutexOffset_;
	public static final int _monitorTablesOffset_;
	public static final int _mutableCallSiteInvalidationCookieOffsetOffset_;
	public static final int _nativeLibrariesLoadMethodIDOffset_;
	public static final int _nativeLibraryMonitorOffset_;
	public static final int _nativeMethodBindTableOffset_;
	public static final int _nextStatisticOffset_;
	public static final int _nextTIDOffset_;
	public static final int _objectAlignmentInBytesOffset_;
	public static final int _objectAlignmentShiftOffset_;
	public static final int _objectMemorySegmentsOffset_;
	public static final int _omrRuntimeOffset_;
	public static final int _omrVMOffset_;
	public static final int _originalSIGPIPESignalActionOffset_;
	public static final int _osrGlobalBufferOffset_;
	public static final int _osrGlobalBufferLockOffset_;
	public static final int _osrGlobalBufferSizeOffset_;
	public static final int _pathSeparatorOffset_;
	public static final int _peakThreadCountOffset_;
	public static final int _pendingBlockedVirtualThreadsNotifyOffset_;
	public static final int _phaseOffset_;
	public static final int _portLibraryOffset_;
	public static final int _priorityAsyncEventDispatchOffset_;
	public static final int _priorityAsyncEventDispatchNHOffset_;
	public static final int _priorityJitCompileOffset_;
	public static final int _priorityJitSampleOffset_;
	public static final int _priorityMetronomeAlarmOffset_;
	public static final int _priorityMetronomeTraceOffset_;
	public static final int _priorityPosixSignalDispatchOffset_;
	public static final int _priorityPosixSignalDispatchNHOffset_;
	public static final int _priorityRealtimePriorityShiftOffset_;
	public static final int _priorityTimerDispatchOffset_;
	public static final int _priorityTimerDispatchNHOffset_;
	public static final int _processReferenceActiveOffset_;
	public static final int _processReferenceMonitorOffset_;
	public static final int _ramClassAllocationIncrementOffset_;
	public static final int _ramClassSub4GAllocationIncrementOffset_;
	public static final int _realtimeHeapMapBasePageRoundedOffset_;
	public static final int _realtimeHeapMapBitsOffset_;
	public static final int _realtimeSizeClassesOffset_;
	public static final int _reflectFunctionsOffset_;
	public static final int _requiredDebugAttributesOffset_;
	public static final int _reserved1_identifierOffset_;
	public static final int _reserved2_libraryOffset_;
	public static final int _reservedAbsoluteThresholdOffset_;
	public static final int _reservedTransitionThresholdOffset_;
	public static final int _romClassAllocationIncrementOffset_;
	public static final int _romMethodSortThresholdOffset_;
	public static final int _rsOverflowOffset_;
	public static final int _runtimeFlagsOffset_;
	public static final int _runtimeFlagsMutexOffset_;
	public static final int _safePointResponseCountOffset_;
	public static final int _safePointStateOffset_;
	public static final int _scvTenureRatioHighOffset_;
	public static final int _scvTenureRatioLowOffset_;
	public static final int _segmentMutexOffset_;
	public static final int _segregatedAllocationCacheSizeOffset_;
	public static final int _selectorHashTableOffset_;
	public static final int _setVerboseStateOffset_;
	public static final int _sharedCacheAPIOffset_;
	public static final int _sharedClassConfigOffset_;
	public static final int _sharedClassPreinitConfigOffset_;
	public static final int _sharedInvariantInternTableOffset_;
	public static final int _shortArrayClassOffset_;
	public static final int _shortReflectClassOffset_;
	public static final int _sidecarClearInterruptFunctionOffset_;
	public static final int _sidecarExitFunctionsOffset_;
	public static final int _sidecarExitHookOffset_;
	public static final int _sidecarInterruptFunctionOffset_;
	public static final int _sigFlagsOffset_;
	public static final int _sigquitToFileDirOffset_;
	public static final int _srConstructorAccessorOffset_;
	public static final int _srMethodAccessorOffset_;
	public static final int _stackSizeOffset_;
	public static final int _stackSizeIncrementOffset_;
	public static final int _stackWalkCountOffset_;
	public static final int _stackWalkVerboseLevelOffset_;
	public static final int _statisticsMutexOffset_;
	public static final int _strCompEnabledOffset_;
	public static final int _sun_nio_ch_DirectBufferOffset_;
	public static final int _systemClassLoaderOffset_;
	public static final int _systemPropertiesOffset_;
	public static final int _systemPropertiesMutexOffset_;
	public static final int _systemThreadGroupRefOffset_;
	public static final int _t1CacheHitOffset_;
	public static final int _t2CacheHitOffset_;
	public static final int _t2storeOffset_;
	public static final int _tenureAgeOffset_;
	public static final int _thrDeflationPolicyOffset_;
	public static final int _thrMaxSpins1BeforeBlockingOffset_;
	public static final int _thrMaxSpins2BeforeBlockingOffset_;
	public static final int _thrMaxTryEnterSpins1BeforeBlockingOffset_;
	public static final int _thrMaxTryEnterSpins2BeforeBlockingOffset_;
	public static final int _thrMaxTryEnterYieldsBeforeBlockingOffset_;
	public static final int _thrMaxYieldsBeforeBlockingOffset_;
	public static final int _thrNestedSpinningOffset_;
	public static final int _thrStaggerOffset_;
	public static final int _thrStaggerMaxOffset_;
	public static final int _thrStaggerStepOffset_;
	public static final int _thrTryEnterNestedSpinningOffset_;
	public static final int _threadDllHandleOffset_;
	public static final int _thunkHeapHeadOffset_;
	public static final int _thunkHeapListMutexOffset_;
	public static final int _tlsFinalizersOffset_;
	public static final int _tlsFinalizersMutexOffset_;
	public static final int _tlsOffsetOffset_;
	public static final int _tlsPoolOffset_;
	public static final int _tlsPoolMutexOffset_;
	public static final int _totalContinuationStackSizeOffset_;
	public static final int _totalThreadCountOffset_;
	public static final int _unblockerWaitTimeOffset_;
	public static final int _unhookVMEventOffset_;
	public static final int _unnamedModuleForSystemLoaderOffset_;
	public static final int _unsafeIndexableHeaderSizeOffset_;
	public static final int _unsafeMemoryListHeadOffset_;
	public static final int _unsafeMemoryTrackingMutexOffset_;
	public static final int _vTableScratchOffset_;
	public static final int _vTableScratchSizeOffset_;
	public static final int _vThreadInterruptOffset_;
	public static final int _verboseLevelOffset_;
	public static final int _verboseStackDumpOffset_;
	public static final int _verboseStateMutexOffset_;
	public static final int _verboseStructOffset_;
	public static final int _virtualThreadInspectorCountOffsetOffset_;
	public static final int _vmArgsArrayOffset_;
	public static final int _vmInterfaceOffset_;
	public static final int _vmLocalStorageOffset_;
	public static final int _vmLocalStorageFunctionsOffset_;
	public static final int _vmRuntimeStateListenerOffset_;
	public static final int _vmThreadListMutexOffset_;
	public static final int _vmThreadSizeOffset_;
	public static final int _vmindexOffsetOffset_;
	public static final int _vmtargetOffsetOffset_;
	public static final int _voidReflectClassOffset_;
	public static final int _vthreadGroupOffset_;
	public static final int _walkFrameOffset_;
	public static final int _walkStackFramesOffset_;
	public static final int _whackedPointerCounterOffset_;
	public static final int _zeroOptionsOffset_;
	public static final int _zipCachePoolOffset_;
	public static final int _zombieThreadCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9VM_DEBUG_ATTRIBUTE_ALLOW_RETRANSFORM = 0;
		J9VM_DEBUG_ATTRIBUTE_ALLOW_USER_HEAP_WALK = 0;
		J9VM_DEBUG_ATTRIBUTE_CAN_ACCESS_LOCALS = 0;
		J9VM_DEBUG_ATTRIBUTE_CAN_POP_FRAMES = 0;
		J9VM_DEBUG_ATTRIBUTE_CAN_REDEFINE_CLASSES = 0;
		J9VM_DEBUG_ATTRIBUTE_LINE_NUMBER_TABLE = 0;
		J9VM_DEBUG_ATTRIBUTE_LOCAL_VARIABLE_TABLE = 0;
		J9VM_DEBUG_ATTRIBUTE_MAINTAIN_FULL_INLINE_MAP = 0;
		J9VM_DEBUG_ATTRIBUTE_MAINTAIN_ORIGINAL_METHOD_ORDER = 0;
		J9VM_DEBUG_ATTRIBUTE_RECORD_ALL = 0;
		J9VM_DEBUG_ATTRIBUTE_SOURCE_DEBUG_EXTENSION = 0;
		J9VM_DEBUG_ATTRIBUTE_SOURCE_FILE = 0;
		J9VM_DEFLATION_POLICY_ASAP = 0;
		J9VM_DEFLATION_POLICY_NEVER = 0;
		J9VM_DEFLATION_POLICY_SMART = 0;
		J9VM_IDENTIFIER = 0;
		J9VM_PHASE_EARLY_STARTUP = 0;
		J9VM_PHASE_NOT_STARTUP = 0;
		J9VM_PHASE_STARTUP = 0;
		J9VM_ZERO_DEFAULT_OPTIONS = 0;
		J9VM_ZERO_SHAREBOOTZIPCACHE = 0;
		_EsJNIFunctionsOffset_ = 0;
		_J9SigQuitShutdownOffset_ = 0;
		_abortHookOffset_ = 0;
		_accumulatedThreadCountOffset_ = 0;
		_addExportsOffset_ = 0;
		_addModulesCountOffset_ = 0;
		_addOpensOffset_ = 0;
		_addProvidesOffset_ = 0;
		_addReadsOffset_ = 0;
		_addUsesOffset_ = 0;
		_alreadyHaveExclusiveOffset_ = 0;
		_alternateJitDirOffset_ = 0;
		_anonClassCountOffset_ = 0;
		_anonClassLoaderOffset_ = 0;
		_aotFindAndInitializeMethodEntryPointOffset_ = 0;
		_aotInitializeJxeEntryPointOffset_ = 0;
		_aotRuntimeInitMutexOffset_ = 0;
		_applicationClassLoaderOffset_ = 0;
		_arrayROMClassesOffset_ = 0;
		_arrayletLeafLogSizeOffset_ = 0;
		_arrayletLeafSizeOffset_ = 0;
		_asyncEventHandlersOffset_ = 0;
		_asyncEventMutexOffset_ = 0;
		_attachContextOffset_ = 0;
		_bindNativeMutexOffset_ = 0;
		_blockedContinuationsOffset_ = 0;
		_blockedVirtualThreadsMutexOffset_ = 0;
		_booleanArrayClassOffset_ = 0;
		_booleanReflectClassOffset_ = 0;
		_bootstrapClassPathOffset_ = 0;
		_byteArrayClassOffset_ = 0;
		_byteReflectClassOffset_ = 0;
		_bytecodeLoopOffset_ = 0;
		_bytecodeVerificationDataOffset_ = 0;
		_cInterpreterOffset_ = 0;
		_cacheFreeOffset_ = 0;
		_cacheMissOffset_ = 0;
		_callInReturnPCOffset_ = 0;
		_cancelAbsoluteThresholdOffset_ = 0;
		_charArrayClassOffset_ = 0;
		_charReflectClassOffset_ = 0;
		_checkJNIDataOffset_ = 0;
		_cifArgumentTypesCacheOffset_ = 0;
		_cifArgumentTypesCacheMutexOffset_ = 0;
		_cifNativeCalloutDataCacheOffset_ = 0;
		_cifNativeCalloutDataCacheMutexOffset_ = 0;
		_classLoaderAllocationCountOffset_ = 0;
		_classLoaderBlocksOffset_ = 0;
		_classLoaderBlocksMutexOffset_ = 0;
		_classLoaderModuleAndLocationMutexOffset_ = 0;
		_classLoadingConstraintsOffset_ = 0;
		_classLoadingMaxStackOffset_ = 0;
		_classLoadingStackPoolOffset_ = 0;
		_classMemorySegmentsOffset_ = 0;
		_classTableMutexOffset_ = 0;
		_classUnloadMutexOffset_ = 0;
		_closeScopeMutexOffset_ = 0;
		_closeScopeNotifyCountOffset_ = 0;
		_codertOldAboutToBootstrapOffset_ = 0;
		_codertOldVMShutdownOffset_ = 0;
		_collectJitPrivateThreadDataOffset_ = 0;
		_compatibilityFlagsOffset_ = 0;
		_compressedPointersShiftOffset_ = 0;
		_constantDynamicMutexOffset_ = 0;
		_contendedLoadTableOffset_ = 0;
		_contiguousIndexableHeaderSizeOffset_ = 0;
		_continuationT1SizeOffset_ = 0;
		_continuationT2CacheOffset_ = 0;
		_continuationT2SizeOffset_ = 0;
		_cpuCacheWritebackCapabilitiesOffset_ = 0;
		_cudaGlobalsOffset_ = 0;
		_customSpinOptionsOffset_ = 0;
		_dCacheLineSizeOffset_ = 0;
		_daemonThreadCountOffset_ = 0;
		_deadThreadListOffset_ = 0;
		_debugField1Offset_ = 0;
		_decompileNameOffset_ = 0;
		_defaultMemorySpaceOffset_ = 0;
		_defaultOSStackSizeOffset_ = 0;
		_destroyVMStateOffset_ = 0;
		_directByteBufferMemoryMaxOffset_ = 0;
		_disclaimableRAMSegmentCountOffset_ = 0;
		_disclaimableROMSegmentCountOffset_ = 0;
		_discontiguousIndexableHeaderSizeOffset_ = 0;
		_dllLoadTableOffset_ = 0;
		_doubleArrayClassOffset_ = 0;
		_doubleJITExitInterpreterOffset_ = 0;
		_doubleReflectClassOffset_ = 0;
		_dynamicLoadBuffersOffset_ = 0;
		_dynamicLoadClassAllocationIncrementOffset_ = 0;
		_enableGlobalLockReservationOffset_ = 0;
		_ensureHashedClassesOffset_ = 0;
		_exclusiveAccessMutexOffset_ = 0;
		_exclusiveAccessResponseCountOffset_ = 0;
		_exclusiveAccessStateOffset_ = 0;
		_exclusiveVMAccessQueueHeadOffset_ = 0;
		_exclusiveVMAccessQueueTailOffset_ = 0;
		_exitHookOffset_ = 0;
		_extendedMethodFlagsMutexOffset_ = 0;
		_extendedRuntimeFlagsOffset_ = 0;
		_extendedRuntimeFlags2Offset_ = 0;
		_extendedRuntimeFlags3Offset_ = 0;
		_extensionClassLoaderOffset_ = 0;
		_fieldIndexMutexOffset_ = 0;
		_fieldIndexTableOffset_ = 0;
		_fieldIndexThresholdOffset_ = 0;
		_finalizeFlagsOffset_ = 0;
		_finalizeForceClassLoaderUnloadCountOffset_ = 0;
		_finalizeMainFlagsOffset_ = 0;
		_finalizeMainMonitorOffset_ = 0;
		_finalizeMainThreadOffset_ = 0;
		_finalizeRunFinalizationCountOffset_ = 0;
		_finalizeRunFinalizationMutexOffset_ = 0;
		_finalizeWorkerDataOffset_ = 0;
		_floatArrayClassOffset_ = 0;
		_floatJITExitInterpreterOffset_ = 0;
		_floatReflectClassOffset_ = 0;
		_flushFunctionOffset_ = 0;
		_freeAotRuntimeInfoOffset_ = 0;
		_freePreviousClassLoadersOffset_ = 0;
		_gcAllocationTypeOffset_ = 0;
		_gcExtensionsOffset_ = 0;
		_gcOptionsOffset_ = 0;
		_gcPolicyOffset_ = 0;
		_gcReadBarrierTypeOffset_ = 0;
		_gcWriteBarrierTypeOffset_ = 0;
		_globalEventFlagsOffset_ = 0;
		_globalHotFieldPoolMutexOffset_ = 0;
		_heapBaseOffset_ = 0;
		_heapOOMStringRefOffset_ = 0;
		_heapTopOffset_ = 0;
		_hiddenFinalizeLinkFieldShapeOffset_ = 0;
		_hiddenInstanceFieldsOffset_ = 0;
		_hiddenInstanceFieldsMutexOffset_ = 0;
		_hiddenLockwordFieldShapeOffset_ = 0;
		_hookInterfaceOffset_ = 0;
		_hookVMEventOffset_ = 0;
		_hotFieldClassInfoPoolOffset_ = 0;
		_hotFieldClassInfoPoolMutexOffset_ = 0;
		_hotSwapCountOffset_ = 0;
		_identityHashDataOffset_ = 0;
		_impdep1PCOffset_ = 0;
		_indexableObjectLayoutOffset_ = 0;
		_initialMethodsOffset_ = 0;
		_initialStackSizeOffset_ = 0;
		_initializeSlotsOnTLHAllocateOffset_ = 0;
		_intArrayClassOffset_ = 0;
		_intReflectClassOffset_ = 0;
		_internalSuspendStateOffsetOffset_ = 0;
		_internalVMFunctionsOffset_ = 0;
		_internalVMLabelsOffset_ = 0;
		_isAgentLibraryLoadedOffset_ = 0;
		_isClassUnloadMutexHeldForRedefinitionOffset_ = 0;
		_isIndexableDataAddrPresentOffset_ = 0;
		_isIndexableDualHeaderShapeEnabledOffset_ = 0;
		_j2seRootDirectoryOffset_ = 0;
		_j2seVersionOffset_ = 0;
		_j9Thread2JavaPriorityMapOffset_ = 0;
		_j9libvmDirectoryOffset_ = 0;
		_j9rasOffset_ = 0;
		_j9rasDumpFunctionsOffset_ = 0;
		_j9rasGlobalStorageOffset_ = 0;
		_j9rasdumpGlobalStorageOffset_ = 0;
		_java2J9ThreadPriorityMapOffset_ = 0;
		_javaBaseModuleOffset_ = 0;
		_javaHomeOffset_ = 0;
		_javaVMOffset_ = 0;
		_java_nio_BufferOffset_ = 0;
		_java_nio_Buffer_addressOffset_ = 0;
		_java_nio_Buffer_capacityOffset_ = 0;
		_java_nio_DirectByteBufferOffset_ = 0;
		_java_nio_DirectByteBuffer_initOffset_ = 0;
		_jclCacheMutexOffset_ = 0;
		_jclConstantPoolOffset_ = 0;
		_jclFlagsOffset_ = 0;
		_jclSysPropBufferOffset_ = 0;
		_jfrAsyncKeyOffset_ = 0;
		_jfrBufferOffset_ = 0;
		_jfrBufferMutexOffset_ = 0;
		_jfrSamplerMutexOffset_ = 0;
		_jfrSamplerStateOffset_ = 0;
		_jfrSamplerThreadOffset_ = 0;
		_jfrStateOffset_ = 0;
		_jfrThreadCPULoadAsyncKeyOffset_ = 0;
		_jimModulesOffset_ = 0;
		_jimageIntfOffset_ = 0;
		_jitConfigOffset_ = 0;
		_jitExceptionHandlerSearchOffset_ = 0;
		_jitGetOwnedObjectMonitorsOffset_ = 0;
		_jitOldAboutToBootstrapOffset_ = 0;
		_jitOldVMShutdownOffset_ = 0;
		_jitVMEntryKeepAliveOffsetOffset_ = 0;
		_jitWalkStackFramesOffset_ = 0;
		_jliArgumentHelperOffset_ = 0;
		_jliMethodHandleInvokeWithArgsOffset_ = 0;
		_jliMethodHandleInvokeWithArgsListOffset_ = 0;
		_jlrMethodInvokeOffset_ = 0;
		_jlrMethodInvokeMHOffset_ = 0;
		_jniArrayCacheMaxSizeOffset_ = 0;
		_jniCriticalLockOffset_ = 0;
		_jniCriticalResponseCountOffset_ = 0;
		_jniFrameMutexOffset_ = 0;
		_jniFunctionTableOffset_ = 0;
		_jniGlobalReferencesOffset_ = 0;
		_jniSendTargetOffset_ = 0;
		_jniWeakGlobalReferencesOffset_ = 0;
		_jvmExtensionInterfaceOffset_ = 0;
		_jvmtiDataOffset_ = 0;
		_layoutStrFFITypeTableOffset_ = 0;
		_linkNextOffset_ = 0;
		_linkPreviousOffset_ = 0;
		_loadAgentLibraryOnAttachOffset_ = 0;
		_loadedClassCountOffset_ = 0;
		_localMapFunctionOffset_ = 0;
		_lockwordExceptionsOffset_ = 0;
		_lockwordModeOffset_ = 0;
		_longArrayClassOffset_ = 0;
		_longReflectClassOffset_ = 0;
		_mainThreadOffset_ = 0;
		_managementDataOffset_ = 0;
		_mapMemoryBufferOffset_ = 0;
		_mapMemoryBufferMutexOffset_ = 0;
		_mapMemoryBufferSizeOffset_ = 0;
		_mapMemoryResultsBufferOffset_ = 0;
		_maxCStackUseOffset_ = 0;
		_maxInvariantLocalTableNodeCountOffset_ = 0;
		_maxStackUseOffset_ = 0;
		_memberNameListNodePoolOffset_ = 0;
		_memberNameListsMutexOffset_ = 0;
		_memoryManagerFunctionsOffset_ = 0;
		_memoryMaxOffset_ = 0;
		_memorySegmentsOffset_ = 0;
		_methodHandleCompileCountOffset_ = 0;
		_minimumLearningRatioOffset_ = 0;
		_minimumReservedRatioOffset_ = 0;
		_minimumSuperclassArraySizeOffset_ = 0;
		_modularityPoolOffset_ = 0;
		_modulePointerOffsetOffset_ = 0;
		_modulesPathEntryOffset_ = 0;
		_monitorTableCountOffset_ = 0;
		_monitorTableListOffset_ = 0;
		_monitorTableListPoolOffset_ = 0;
		_monitorTableMutexOffset_ = 0;
		_monitorTablesOffset_ = 0;
		_mutableCallSiteInvalidationCookieOffsetOffset_ = 0;
		_nativeLibrariesLoadMethodIDOffset_ = 0;
		_nativeLibraryMonitorOffset_ = 0;
		_nativeMethodBindTableOffset_ = 0;
		_nextStatisticOffset_ = 0;
		_nextTIDOffset_ = 0;
		_objectAlignmentInBytesOffset_ = 0;
		_objectAlignmentShiftOffset_ = 0;
		_objectMemorySegmentsOffset_ = 0;
		_omrRuntimeOffset_ = 0;
		_omrVMOffset_ = 0;
		_originalSIGPIPESignalActionOffset_ = 0;
		_osrGlobalBufferOffset_ = 0;
		_osrGlobalBufferLockOffset_ = 0;
		_osrGlobalBufferSizeOffset_ = 0;
		_pathSeparatorOffset_ = 0;
		_peakThreadCountOffset_ = 0;
		_pendingBlockedVirtualThreadsNotifyOffset_ = 0;
		_phaseOffset_ = 0;
		_portLibraryOffset_ = 0;
		_priorityAsyncEventDispatchOffset_ = 0;
		_priorityAsyncEventDispatchNHOffset_ = 0;
		_priorityJitCompileOffset_ = 0;
		_priorityJitSampleOffset_ = 0;
		_priorityMetronomeAlarmOffset_ = 0;
		_priorityMetronomeTraceOffset_ = 0;
		_priorityPosixSignalDispatchOffset_ = 0;
		_priorityPosixSignalDispatchNHOffset_ = 0;
		_priorityRealtimePriorityShiftOffset_ = 0;
		_priorityTimerDispatchOffset_ = 0;
		_priorityTimerDispatchNHOffset_ = 0;
		_processReferenceActiveOffset_ = 0;
		_processReferenceMonitorOffset_ = 0;
		_ramClassAllocationIncrementOffset_ = 0;
		_ramClassSub4GAllocationIncrementOffset_ = 0;
		_realtimeHeapMapBasePageRoundedOffset_ = 0;
		_realtimeHeapMapBitsOffset_ = 0;
		_realtimeSizeClassesOffset_ = 0;
		_reflectFunctionsOffset_ = 0;
		_requiredDebugAttributesOffset_ = 0;
		_reserved1_identifierOffset_ = 0;
		_reserved2_libraryOffset_ = 0;
		_reservedAbsoluteThresholdOffset_ = 0;
		_reservedTransitionThresholdOffset_ = 0;
		_romClassAllocationIncrementOffset_ = 0;
		_romMethodSortThresholdOffset_ = 0;
		_rsOverflowOffset_ = 0;
		_runtimeFlagsOffset_ = 0;
		_runtimeFlagsMutexOffset_ = 0;
		_safePointResponseCountOffset_ = 0;
		_safePointStateOffset_ = 0;
		_scvTenureRatioHighOffset_ = 0;
		_scvTenureRatioLowOffset_ = 0;
		_segmentMutexOffset_ = 0;
		_segregatedAllocationCacheSizeOffset_ = 0;
		_selectorHashTableOffset_ = 0;
		_setVerboseStateOffset_ = 0;
		_sharedCacheAPIOffset_ = 0;
		_sharedClassConfigOffset_ = 0;
		_sharedClassPreinitConfigOffset_ = 0;
		_sharedInvariantInternTableOffset_ = 0;
		_shortArrayClassOffset_ = 0;
		_shortReflectClassOffset_ = 0;
		_sidecarClearInterruptFunctionOffset_ = 0;
		_sidecarExitFunctionsOffset_ = 0;
		_sidecarExitHookOffset_ = 0;
		_sidecarInterruptFunctionOffset_ = 0;
		_sigFlagsOffset_ = 0;
		_sigquitToFileDirOffset_ = 0;
		_srConstructorAccessorOffset_ = 0;
		_srMethodAccessorOffset_ = 0;
		_stackSizeOffset_ = 0;
		_stackSizeIncrementOffset_ = 0;
		_stackWalkCountOffset_ = 0;
		_stackWalkVerboseLevelOffset_ = 0;
		_statisticsMutexOffset_ = 0;
		_strCompEnabledOffset_ = 0;
		_sun_nio_ch_DirectBufferOffset_ = 0;
		_systemClassLoaderOffset_ = 0;
		_systemPropertiesOffset_ = 0;
		_systemPropertiesMutexOffset_ = 0;
		_systemThreadGroupRefOffset_ = 0;
		_t1CacheHitOffset_ = 0;
		_t2CacheHitOffset_ = 0;
		_t2storeOffset_ = 0;
		_tenureAgeOffset_ = 0;
		_thrDeflationPolicyOffset_ = 0;
		_thrMaxSpins1BeforeBlockingOffset_ = 0;
		_thrMaxSpins2BeforeBlockingOffset_ = 0;
		_thrMaxTryEnterSpins1BeforeBlockingOffset_ = 0;
		_thrMaxTryEnterSpins2BeforeBlockingOffset_ = 0;
		_thrMaxTryEnterYieldsBeforeBlockingOffset_ = 0;
		_thrMaxYieldsBeforeBlockingOffset_ = 0;
		_thrNestedSpinningOffset_ = 0;
		_thrStaggerOffset_ = 0;
		_thrStaggerMaxOffset_ = 0;
		_thrStaggerStepOffset_ = 0;
		_thrTryEnterNestedSpinningOffset_ = 0;
		_threadDllHandleOffset_ = 0;
		_thunkHeapHeadOffset_ = 0;
		_thunkHeapListMutexOffset_ = 0;
		_tlsFinalizersOffset_ = 0;
		_tlsFinalizersMutexOffset_ = 0;
		_tlsOffsetOffset_ = 0;
		_tlsPoolOffset_ = 0;
		_tlsPoolMutexOffset_ = 0;
		_totalContinuationStackSizeOffset_ = 0;
		_totalThreadCountOffset_ = 0;
		_unblockerWaitTimeOffset_ = 0;
		_unhookVMEventOffset_ = 0;
		_unnamedModuleForSystemLoaderOffset_ = 0;
		_unsafeIndexableHeaderSizeOffset_ = 0;
		_unsafeMemoryListHeadOffset_ = 0;
		_unsafeMemoryTrackingMutexOffset_ = 0;
		_vTableScratchOffset_ = 0;
		_vTableScratchSizeOffset_ = 0;
		_vThreadInterruptOffset_ = 0;
		_verboseLevelOffset_ = 0;
		_verboseStackDumpOffset_ = 0;
		_verboseStateMutexOffset_ = 0;
		_verboseStructOffset_ = 0;
		_virtualThreadInspectorCountOffsetOffset_ = 0;
		_vmArgsArrayOffset_ = 0;
		_vmInterfaceOffset_ = 0;
		_vmLocalStorageOffset_ = 0;
		_vmLocalStorageFunctionsOffset_ = 0;
		_vmRuntimeStateListenerOffset_ = 0;
		_vmThreadListMutexOffset_ = 0;
		_vmThreadSizeOffset_ = 0;
		_vmindexOffsetOffset_ = 0;
		_vmtargetOffsetOffset_ = 0;
		_voidReflectClassOffset_ = 0;
		_vthreadGroupOffset_ = 0;
		_walkFrameOffset_ = 0;
		_walkStackFramesOffset_ = 0;
		_whackedPointerCounterOffset_ = 0;
		_zeroOptionsOffset_ = 0;
		_zipCachePoolOffset_ = 0;
		_zombieThreadCountOffset_ = 0;
	}

}
